/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.memorycontainer.memory;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.memorycontainer.MLMemoryContainer;
import org.opensearch.ml.common.memorycontainer.MemoryType;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLGetMemoryRequest;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLGetMemoryResponse;
import org.opensearch.ml.helper.MemoryContainerHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportGetMemoryAction
extends HandledTransportAction<ActionRequest, MLGetMemoryResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportGetMemoryAction.class);
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final MemoryContainerHelper memoryContainerHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportGetMemoryAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry, MemoryContainerHelper memoryContainerHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/memory_containers/memory/get", transportService, actionFilters, MLGetMemoryRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.memoryContainerHelper = memoryContainerHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLGetMemoryResponse> actionListener) {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            actionListener.onFailure((Exception)new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        MLGetMemoryRequest getRequest = MLGetMemoryRequest.fromActionRequest((ActionRequest)request);
        String memoryContainerId = getRequest.getMemoryContainerId();
        MemoryType memoryType = getRequest.getMemoryType();
        String memoryId = getRequest.getMemoryId();
        String tenantId = getRequest.getTenantId();
        this.memoryContainerHelper.getMemoryContainer(memoryContainerId, tenantId, (ActionListener<MLMemoryContainer>)ActionListener.wrap(container -> {
            User user = RestActionUtils.getUserContext(this.client);
            if (!this.memoryContainerHelper.checkMemoryContainerAccess(user, (MLMemoryContainer)container)) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have permissions to get memories in this container", RestStatus.FORBIDDEN, new Object[0]));
                return;
            }
            String memoryIndexName = this.memoryContainerHelper.getMemoryIndexName((MLMemoryContainer)container, memoryType);
            if (memoryIndexName == null) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("Memory index not found", RestStatus.NOT_FOUND, new Object[0]));
                return;
            }
            ActionListener getResponseActionListener = ActionListener.wrap(getResponse -> {
                if (!getResponse.isExists()) {
                    actionListener.onFailure((Exception)new OpenSearchStatusException("Memory not found", RestStatus.NOT_FOUND, new Object[0]));
                    return;
                }
                String ownerId = (String)getResponse.getSourceAsMap().get("owner_id");
                if (!this.memoryContainerHelper.checkMemoryAccess(user, ownerId)) {
                    actionListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have permissions to update this memory", RestStatus.FORBIDDEN, new Object[0]));
                    return;
                }
                actionListener.onResponse((Object)MLGetMemoryResponse.fromGetResponse((GetResponse)getResponse, (MemoryType)memoryType));
            }, arg_0 -> ((ActionListener)actionListener).onFailure(arg_0));
            GetRequest getMemoryRequest = new GetRequest(memoryIndexName, memoryId);
            this.memoryContainerHelper.getData(container.getConfiguration(), getMemoryRequest, (ActionListener<GetResponse>)getResponseActionListener);
        }, arg_0 -> actionListener.onFailure(arg_0)));
    }
}

