/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util.tokens.universal;

import org.tribuo.util.tokens.Token;

public final class Range
implements CharSequence {
    public char[] buff = new char[16];
    public int len;
    public int start;
    public int end;
    public int incr;
    public Token.TokenType type;

    Range() {
    }

    public void set(char c1, char c2, int start) {
        this.buff[0] = c1;
        this.buff[1] = c2;
        this.start = start;
        this.end = start + 2;
        this.len = 2;
        this.incr = 0;
        this.type = Token.TokenType.NGRAM;
    }

    public void set(char c, int start) {
        this.buff[0] = c;
        this.start = start;
        this.end = start + 1;
        this.len = 1;
        this.incr = 1;
        this.type = Token.TokenType.WORD;
    }

    public void set(char[] buff, int len, int start) {
        if (this.buff.length < buff.length) {
            this.buff = new char[buff.length + 1];
        }
        System.arraycopy(buff, 0, this.buff, 0, len);
        this.len = len;
        this.start = start;
        this.end = start + len;
        this.incr = 1;
        this.type = Token.TokenType.WORD;
    }

    public void punct(char p, int start) {
        this.buff[0] = p;
        this.len = 1;
        this.start = Math.max(start, 0);
        this.end = this.start + 1;
        this.incr = 0;
        this.type = Token.TokenType.PUNCTUATION;
    }

    public void setType(Token.TokenType type) {
        this.type = type;
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public char charAt(int index) {
        if (index < this.len) {
            return this.buff[index];
        }
        throw new IndexOutOfBoundsException(String.format("index %d exceeds length %d", index, this.len));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        Range r = new Range();
        System.arraycopy(this.buff, start, r.buff, 0, end - start);
        r.start = 0;
        r.end = r.len = end - start;
        return r;
    }

    @Override
    public String toString() {
        return new String(this.buff, 0, this.len) + " " + (Object)((Object)this.type) + " " + this.start + " " + this.end;
    }
}

