/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input.execute.agent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.input.execute.agent.ContentBlock;
import org.opensearch.ml.common.input.execute.agent.ContentType;
import org.opensearch.ml.common.input.execute.agent.DocumentContent;
import org.opensearch.ml.common.input.execute.agent.ImageContent;
import org.opensearch.ml.common.input.execute.agent.InputType;
import org.opensearch.ml.common.input.execute.agent.Message;
import org.opensearch.ml.common.input.execute.agent.SourceType;
import org.opensearch.ml.common.input.execute.agent.ToolCall;
import org.opensearch.ml.common.input.execute.agent.VideoContent;

public class AgentInput
implements Writeable {
    private Object input;

    public AgentInput(StreamInput in) throws IOException {
        InputType inputType;
        String inputTypeStr = in.readString();
        try {
            inputType = InputType.valueOf(inputTypeStr);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Invalid input type. Supported types: TEXT, CONTENT_BLOCKS, MESSAGES", e);
        }
        switch (inputType) {
            case TEXT: {
                this.input = in.readString();
                break;
            }
            case CONTENT_BLOCKS: {
                this.input = this.readContentBlocksList(in);
                break;
            }
            case MESSAGES: {
                this.input = this.readMessagesList(in);
                break;
            }
            default: {
                throw new IOException("Unsupported input type. Supported types: TEXT, CONTENT_BLOCKS, MESSAGES");
            }
        }
    }

    private List<ContentBlock> readContentBlocksList(StreamInput in) throws IOException {
        int size = in.readInt();
        ArrayList<ContentBlock> contentBlocks = new ArrayList<ContentBlock>(size);
        for (int i = 0; i < size; ++i) {
            ContentBlock block = this.readContentBlock(in);
            contentBlocks.add(block);
        }
        return contentBlocks;
    }

    private ContentBlock readContentBlock(StreamInput in) throws IOException {
        ContentType type = ContentType.valueOf(in.readString());
        ContentBlock block = new ContentBlock();
        block.setType(type);
        switch (type) {
            case TEXT: {
                block.setText(in.readString());
                break;
            }
            case IMAGE: {
                block.setImage(this.readImageContent(in));
                break;
            }
            case VIDEO: {
                block.setVideo(this.readVideoContent(in));
                break;
            }
            case DOCUMENT: {
                block.setDocument(this.readDocumentContent(in));
            }
        }
        return block;
    }

    private ImageContent readImageContent(StreamInput in) throws IOException {
        SourceType sourceType = SourceType.valueOf(in.readString());
        String format = in.readString();
        String data = in.readString();
        return new ImageContent(sourceType, format, data);
    }

    private VideoContent readVideoContent(StreamInput in) throws IOException {
        SourceType sourceType = SourceType.valueOf(in.readString());
        String format = in.readString();
        String data = in.readString();
        return new VideoContent(sourceType, format, data);
    }

    private DocumentContent readDocumentContent(StreamInput in) throws IOException {
        SourceType sourceType = SourceType.valueOf(in.readString());
        String format = in.readString();
        String data = in.readString();
        return new DocumentContent(sourceType, format, data);
    }

    private List<Message> readMessagesList(StreamInput in) throws IOException {
        int size = in.readInt();
        ArrayList<Message> messages = new ArrayList<Message>(size);
        for (int i = 0; i < size; ++i) {
            Message message = this.readMessage(in);
            messages.add(message);
        }
        return messages;
    }

    private Message readMessage(StreamInput in) throws IOException {
        boolean hasToolCallId;
        String role = in.readString();
        List<ContentBlock> content = this.readContentBlocksList(in);
        Message message = new Message();
        message.setRole(role);
        message.setContent(content);
        boolean hasToolCalls = in.readBoolean();
        if (hasToolCalls) {
            message.setToolCalls(this.readToolCallsList(in));
        }
        if (hasToolCallId = in.readBoolean()) {
            message.setToolCallId(in.readString());
        }
        return message;
    }

    private List<ToolCall> readToolCallsList(StreamInput in) throws IOException {
        int size = in.readInt();
        ArrayList<ToolCall> toolCalls = new ArrayList<ToolCall>(size);
        for (int i = 0; i < size; ++i) {
            ToolCall toolCall = this.readToolCall(in);
            toolCalls.add(toolCall);
        }
        return toolCalls;
    }

    private ToolCall readToolCall(StreamInput in) throws IOException {
        String id = in.readString();
        String type = in.readString();
        ToolCall.ToolFunction function = this.readToolFunction(in);
        ToolCall toolCall = new ToolCall();
        toolCall.setId(id);
        toolCall.setType(type);
        toolCall.setFunction(function);
        return toolCall;
    }

    private ToolCall.ToolFunction readToolFunction(StreamInput in) throws IOException {
        String name = in.readString();
        String arguments = in.readString();
        ToolCall.ToolFunction function = new ToolCall.ToolFunction();
        function.setName(name);
        function.setArguments(arguments);
        return function;
    }

    public AgentInput(XContentParser parser) throws IOException {
        XContentParser.Token currentToken = parser.currentToken();
        if (currentToken == XContentParser.Token.VALUE_STRING) {
            this.input = parser.text();
        } else if (currentToken == XContentParser.Token.START_ARRAY) {
            this.input = this.parseInputArray(parser);
        } else {
            throw new IllegalArgumentException("Invalid input format. Expected string or array.");
        }
    }

    private Object parseInputArray(XContentParser parser) throws IOException {
        ArrayList<Object> items = new ArrayList<Object>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            Object item = this.parseArrayItem(parser);
            items.add(item);
        }
        if (!items.isEmpty()) {
            Object firstItem = items.getFirst();
            if (firstItem instanceof Message) {
                for (int i = 0; i < items.size(); ++i) {
                    Object item = items.get(i);
                    if (item instanceof Message) continue;
                    throw new IllegalArgumentException("Mixed array types detected. Expected all items to be Messages, but item at index " + i + " is of type " + item.getClass().getSimpleName());
                }
                ArrayList<Message> messages = new ArrayList<Message>();
                for (Object e : items) {
                    messages.add((Message)e);
                }
                return messages;
            }
            if (firstItem instanceof ContentBlock) {
                for (int i = 0; i < items.size(); ++i) {
                    Object item = items.get(i);
                    if (item instanceof ContentBlock) continue;
                    throw new IllegalArgumentException("Mixed array types detected. Expected all items to be ContentBlocks, but item at index " + i + " is of type " + item.getClass().getSimpleName());
                }
                ArrayList<ContentBlock> contentBlocks = new ArrayList<ContentBlock>();
                for (Object e : items) {
                    contentBlocks.add((ContentBlock)e);
                }
                return contentBlocks;
            }
        }
        return items;
    }

    private Object parseArrayItem(XContentParser parser) throws IOException {
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "role": {
                    itemMap.put("role", parser.text());
                    continue block18;
                }
                case "content": {
                    itemMap.put("content", this.parseContentArray(parser));
                    continue block18;
                }
                case "toolCalls": {
                    itemMap.put("toolCalls", this.parseToolCallsArray(parser));
                    continue block18;
                }
                case "toolCallId": {
                    itemMap.put("toolCallId", parser.text());
                    continue block18;
                }
                case "type": {
                    itemMap.put("type", parser.text());
                    continue block18;
                }
                case "text": {
                    itemMap.put("text", parser.text());
                    continue block18;
                }
                case "source": {
                    itemMap.put("source", this.parseSource(parser));
                    continue block18;
                }
            }
            itemMap.put(fieldName, this.parseValue(parser));
        }
        if (itemMap.containsKey("role")) {
            return this.createMessage(itemMap);
        }
        if (itemMap.containsKey("type")) {
            return this.createContentBlock(itemMap);
        }
        throw new IllegalArgumentException("Invalid item format. Must have 'role' (for messages) or 'type' (for content blocks).");
    }

    private List<ContentBlock> parseContentArray(XContentParser parser) throws IOException {
        ArrayList<ContentBlock> contentBlocks = new ArrayList<ContentBlock>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        int index = 0;
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            Object item = this.parseArrayItem(parser);
            if (!(item instanceof ContentBlock)) {
                throw new IllegalArgumentException("Invalid content array. Expected ContentBlock at index " + index + " but found " + item.getClass().getSimpleName());
            }
            contentBlocks.add((ContentBlock)item);
            ++index;
        }
        return contentBlocks;
    }

    private List<ToolCall> parseToolCallsArray(XContentParser parser) throws IOException {
        ArrayList<ToolCall> toolCalls = new ArrayList<ToolCall>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            ToolCall toolCall = this.parseToolCallFromXContent(parser);
            toolCalls.add(toolCall);
        }
        return toolCalls;
    }

    private ToolCall parseToolCallFromXContent(XContentParser parser) throws IOException {
        String id = null;
        String type = null;
        ToolCall.ToolFunction function = null;
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "id": {
                    id = parser.text();
                    continue block10;
                }
                case "type": {
                    type = parser.text();
                    continue block10;
                }
                case "function": {
                    function = this.parseToolFunctionFromXContent(parser);
                    continue block10;
                }
            }
            parser.skipChildren();
        }
        if (id == null || function == null) {
            throw new IllegalArgumentException("ToolCall must have 'id' and 'function' fields");
        }
        return new ToolCall(id, type != null ? type : "function", function);
    }

    private ToolCall.ToolFunction parseToolFunctionFromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        String name = null;
        String arguments = null;
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block8;
                }
                case "arguments": {
                    arguments = parser.text();
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        if (name == null || arguments == null) {
            throw new IllegalArgumentException("ToolFunction must have 'name' and 'arguments' fields");
        }
        return new ToolCall.ToolFunction(name, arguments);
    }

    private Map<String, Object> parseSource(XContentParser parser) throws IOException {
        HashMap<String, Object> source = new HashMap<String, Object>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            source.put(fieldName, this.parseValue(parser));
        }
        return source;
    }

    private Object parseValue(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        switch (token) {
            case VALUE_STRING: {
                return parser.text();
            }
            case VALUE_NUMBER: {
                return parser.numberValue();
            }
            case VALUE_BOOLEAN: {
                return parser.booleanValue();
            }
            case VALUE_NULL: {
                return null;
            }
            case START_OBJECT: {
                HashMap<String, Object> map = new HashMap<String, Object>();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    String fieldName = parser.currentName();
                    parser.nextToken();
                    map.put(fieldName, this.parseValue(parser));
                }
                return map;
            }
            case START_ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    list.add(this.parseValue(parser));
                }
                return list;
            }
        }
        throw new IllegalArgumentException("Unexpected token. Expected: VALUE_STRING, VALUE_NUMBER, VALUE_BOOLEAN, VALUE_NULL, START_OBJECT, or START_ARRAY");
    }

    private Message createMessage(Map<String, Object> itemMap) {
        String role = (String)itemMap.get("role");
        List content = (List)itemMap.get("content");
        Message message = new Message();
        message.setRole(role);
        message.setContent(content);
        if (itemMap.containsKey("toolCalls")) {
            message.setToolCalls((List)itemMap.get("toolCalls"));
        }
        if (itemMap.containsKey("toolCallId")) {
            message.setToolCallId((String)itemMap.get("toolCallId"));
        }
        return message;
    }

    private ContentBlock createContentBlock(Map<String, Object> itemMap) {
        String type = (String)itemMap.get("type");
        ContentType contentType = ContentType.valueOf(type.toUpperCase());
        ContentBlock contentBlock = new ContentBlock();
        contentBlock.setType(contentType);
        switch (contentType) {
            case TEXT: {
                contentBlock.setText((String)itemMap.get("text"));
                break;
            }
            case IMAGE: {
                Map source = (Map)itemMap.get("source");
                ImageContent imageContent = this.createImageContent(source);
                contentBlock.setImage(imageContent);
                break;
            }
            case VIDEO: {
                Map videoSource = (Map)itemMap.get("source");
                VideoContent videoContent = this.createVideoContent(videoSource);
                contentBlock.setVideo(videoContent);
                break;
            }
            case DOCUMENT: {
                Map docSource = (Map)itemMap.get("source");
                DocumentContent documentContent = this.createDocumentContent(docSource);
                contentBlock.setDocument(documentContent);
            }
        }
        return contentBlock;
    }

    private ImageContent createImageContent(Map<String, Object> source) {
        SourceType sourceType;
        if (source == null) {
            throw new IllegalArgumentException("Image source cannot be null");
        }
        String format = (String)source.get("format");
        if (format == null || format.trim().isEmpty()) {
            throw new IllegalArgumentException("Image format is required");
        }
        String type = (String)source.get("type");
        if (type == null || type.trim().isEmpty()) {
            throw new IllegalArgumentException("Image source type is required");
        }
        String data = (String)source.get("data");
        if (data == null || data.trim().isEmpty()) {
            throw new IllegalArgumentException("Image data is required");
        }
        try {
            sourceType = SourceType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid source type. Supported types: BYTES, URL", e);
        }
        ImageContent imageContent = new ImageContent();
        imageContent.setFormat(format);
        imageContent.setType(sourceType);
        imageContent.setData(data);
        return imageContent;
    }

    private VideoContent createVideoContent(Map<String, Object> source) {
        SourceType sourceType;
        if (source == null) {
            throw new IllegalArgumentException("Video source cannot be null");
        }
        String format = (String)source.get("format");
        if (format == null || format.trim().isEmpty()) {
            throw new IllegalArgumentException("Video format is required");
        }
        String type = (String)source.get("type");
        if (type == null || type.trim().isEmpty()) {
            throw new IllegalArgumentException("Video source type is required");
        }
        String data = (String)source.get("data");
        if (data == null || data.trim().isEmpty()) {
            throw new IllegalArgumentException("Video data is required");
        }
        try {
            sourceType = SourceType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid source type. Supported types: BYTES, URL", e);
        }
        VideoContent videoContent = new VideoContent();
        videoContent.setFormat(format);
        videoContent.setType(sourceType);
        videoContent.setData(data);
        return videoContent;
    }

    private DocumentContent createDocumentContent(Map<String, Object> source) {
        SourceType sourceType;
        if (source == null) {
            throw new IllegalArgumentException("Document source cannot be null");
        }
        String format = (String)source.get("format");
        if (format == null || format.trim().isEmpty()) {
            throw new IllegalArgumentException("Document format is required");
        }
        String type = (String)source.get("type");
        if (type == null || type.trim().isEmpty()) {
            throw new IllegalArgumentException("Document source type is required");
        }
        String data = (String)source.get("data");
        if (data == null || data.trim().isEmpty()) {
            throw new IllegalArgumentException("Document data is required");
        }
        try {
            sourceType = SourceType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid source type. Supported types: BYTES, URL", e);
        }
        DocumentContent documentContent = new DocumentContent();
        documentContent.setFormat(format);
        documentContent.setType(sourceType);
        documentContent.setData(data);
        return documentContent;
    }

    public void writeTo(StreamOutput out) throws IllegalArgumentException, IOException {
        InputType inputType = this.getInputType();
        out.writeString(inputType.name());
        switch (inputType) {
            case TEXT: {
                out.writeString((String)this.input);
                break;
            }
            case CONTENT_BLOCKS: {
                List contentBlocks = (List)this.input;
                this.writeContentBlocksList(out, contentBlocks);
                break;
            }
            case MESSAGES: {
                List messages = (List)this.input;
                this.writeMessagesList(out, messages);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported input type: " + String.valueOf((Object)inputType));
            }
        }
    }

    private void writeContentBlocksList(StreamOutput out, List<ContentBlock> contentBlocks) throws IOException {
        out.writeInt(contentBlocks.size());
        for (ContentBlock block : contentBlocks) {
            this.writeContentBlock(out, block);
        }
    }

    private void writeContentBlock(StreamOutput out, ContentBlock block) throws IOException {
        out.writeString(block.getType().name());
        switch (block.getType()) {
            case TEXT: {
                out.writeString(block.getText());
                break;
            }
            case IMAGE: {
                this.writeImageContent(out, block.getImage());
                break;
            }
            case VIDEO: {
                this.writeVideoContent(out, block.getVideo());
                break;
            }
            case DOCUMENT: {
                this.writeDocumentContent(out, block.getDocument());
            }
        }
    }

    private void writeImageContent(StreamOutput out, ImageContent image) throws IOException {
        out.writeString(image.getType().name());
        out.writeString(image.getFormat());
        out.writeString(image.getData());
    }

    private void writeVideoContent(StreamOutput out, VideoContent video) throws IOException {
        out.writeString(video.getType().name());
        out.writeString(video.getFormat());
        out.writeString(video.getData());
    }

    private void writeDocumentContent(StreamOutput out, DocumentContent document) throws IOException {
        out.writeString(document.getType().name());
        out.writeString(document.getFormat());
        out.writeString(document.getData());
    }

    private void writeMessagesList(StreamOutput out, List<Message> messages) throws IOException {
        out.writeInt(messages.size());
        for (Message message : messages) {
            this.writeMessage(out, message);
        }
    }

    private void writeMessage(StreamOutput out, Message message) throws IOException {
        out.writeString(message.getRole());
        this.writeContentBlocksList(out, message.getContent());
        boolean hasToolCalls = message.getToolCalls() != null && !message.getToolCalls().isEmpty();
        out.writeBoolean(hasToolCalls);
        if (hasToolCalls) {
            this.writeToolCallsList(out, message.getToolCalls());
        }
        boolean hasToolCallId = message.getToolCallId() != null;
        out.writeBoolean(hasToolCallId);
        if (hasToolCallId) {
            out.writeString(message.getToolCallId());
        }
    }

    private void writeToolCallsList(StreamOutput out, List<ToolCall> toolCalls) throws IOException {
        out.writeInt(toolCalls.size());
        for (ToolCall toolCall : toolCalls) {
            this.writeToolCall(out, toolCall);
        }
    }

    private void writeToolCall(StreamOutput out, ToolCall toolCall) throws IOException {
        out.writeString(toolCall.getId());
        out.writeString(toolCall.getType());
        this.writeToolFunction(out, toolCall.getFunction());
    }

    private void writeToolFunction(StreamOutput out, ToolCall.ToolFunction function) throws IOException {
        out.writeString(function.getName());
        out.writeString(function.getArguments());
    }

    public InputType getInputType() throws IllegalArgumentException {
        List list;
        if (this.input instanceof String) {
            return InputType.TEXT;
        }
        Object object = this.input;
        if (object instanceof List && !(list = (List)object).isEmpty()) {
            Object firstElement = list.getFirst();
            if (firstElement instanceof ContentBlock) {
                return InputType.CONTENT_BLOCKS;
            }
            if (firstElement instanceof Message) {
                return InputType.MESSAGES;
            }
        }
        throw new IllegalArgumentException("Input type not supported. Expected String, List<ContentBlock>, or List<Message>");
    }

    @Generated
    public Object getInput() {
        return this.input;
    }

    @Generated
    public void setInput(Object input) {
        this.input = input;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentInput)) {
            return false;
        }
        AgentInput other = (AgentInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$input = this.getInput();
        Object other$input = other.getInput();
        return !(this$input == null ? other$input != null : !this$input.equals(other$input));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AgentInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AgentInput(input=" + String.valueOf(this.getInput()) + ")";
    }

    @Generated
    public AgentInput() {
    }

    @Generated
    public AgentInput(Object input) {
        this.input = input;
    }
}

