/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.functions.response;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opensearch.sql.data.model.ExprCollectionValue;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.prometheus.functions.response.PrometheusFunctionResponseHandle;

public class QueryExemplarsFunctionResponseHandle
implements PrometheusFunctionResponseHandle {
    private Iterator<ExprValue> responseIterator;
    private ExecutionEngine.Schema schema;

    public QueryExemplarsFunctionResponseHandle(JSONArray responseArray) {
        this.constructIteratorAndSchema(responseArray);
    }

    private void constructIteratorAndSchema(JSONArray responseArray) {
        ArrayList<ExecutionEngine.Schema.Column> columnList = new ArrayList<ExecutionEngine.Schema.Column>();
        columnList.add(new ExecutionEngine.Schema.Column("seriesLabels", "seriesLabels", (ExprType)ExprCoreType.STRUCT));
        columnList.add(new ExecutionEngine.Schema.Column("exemplars", "exemplars", (ExprType)ExprCoreType.ARRAY));
        this.schema = new ExecutionEngine.Schema(columnList);
        ArrayList<ExprTupleValue> result = new ArrayList<ExprTupleValue>();
        for (int i = 0; i < responseArray.length(); ++i) {
            JSONObject rowObject = responseArray.getJSONObject(i);
            LinkedHashMap<String, ExprValue> rowMap = new LinkedHashMap<String, ExprValue>();
            JSONObject seriesLabels = rowObject.getJSONObject("seriesLabels");
            rowMap.put("seriesLabels", this.constructSeriesLabels(seriesLabels));
            JSONArray exemplars = rowObject.getJSONArray("exemplars");
            rowMap.put("exemplars", this.constructExemplarList(exemplars));
            result.add(new ExprTupleValue(rowMap));
        }
        this.responseIterator = result.iterator();
    }

    private ExprValue constructSeriesLabels(JSONObject seriesLabels) {
        LinkedHashMap seriesLabelsMap = new LinkedHashMap();
        seriesLabels.keySet().forEach(key -> seriesLabelsMap.put(key, new ExprStringValue(seriesLabels.getString(key))));
        return new ExprTupleValue(seriesLabelsMap);
    }

    private ExprValue constructExemplarList(JSONArray exemplars) {
        ArrayList<ExprValue> exemplarsList = new ArrayList<ExprValue>();
        for (int i = 0; i < exemplars.length(); ++i) {
            JSONObject exemplarsJSONObject = exemplars.getJSONObject(i);
            exemplarsList.add(this.constructExemplar(exemplarsJSONObject));
        }
        return new ExprCollectionValue(exemplarsList);
    }

    private ExprValue constructExemplar(JSONObject exemplarsJSONObject) {
        LinkedHashMap<String, Object> exemplarHashMap = new LinkedHashMap<String, Object>();
        exemplarHashMap.put("labels", this.constructLabelsInExemplar(exemplarsJSONObject.getJSONObject("labels")));
        exemplarHashMap.put("timestamp", new ExprTimestampValue(Instant.ofEpochMilli((long)(exemplarsJSONObject.getDouble("timestamp") * 1000.0))));
        exemplarHashMap.put("value", new ExprDoubleValue((Number)exemplarsJSONObject.getDouble("value")));
        return new ExprTupleValue(exemplarHashMap);
    }

    private ExprValue constructLabelsInExemplar(JSONObject labelsObject) {
        LinkedHashMap<String, ExprStringValue> labelsMap = new LinkedHashMap<String, ExprStringValue>();
        for (String key : labelsObject.keySet()) {
            labelsMap.put(key, new ExprStringValue(labelsObject.getString(key)));
        }
        return new ExprTupleValue(labelsMap);
    }

    @Override
    public boolean hasNext() {
        return this.responseIterator.hasNext();
    }

    @Override
    public ExprValue next() {
        return this.responseIterator.next();
    }

    @Override
    public ExecutionEngine.Schema schema() {
        return this.schema;
    }
}

