/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.atomic.AtomicReference;

public final class NativeAllocation
extends PhantomReference<Object> {
    private static final Queue globalQueue = new Queue();
    private static final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private final Destructor destructor;
    private NativeAllocation prev;
    private NativeAllocation next;
    private final Queue queue;
    private static final AtomicReference<Thread> gcThread = new AtomicReference<Object>(null);

    public static Queue getGlobalQueue() {
        return globalQueue;
    }

    private NativeAllocation(Queue queue) {
        super(null, null);
        this.destructor = null;
        this.prev = this;
        this.next = this;
        this.queue = queue;
    }

    private NativeAllocation(Object referent, Destructor destructor, Queue queue) {
        super(referent, refQueue);
        this.destructor = destructor;
        this.queue = queue;
    }

    static void ensureGCThreadRunning() {
        Thread thread = gcThread.get();
        if (thread == null) {
            thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            NativeAllocation alloc = (NativeAllocation)refQueue.remove();
                            alloc.queue.remove(alloc);
                            alloc.destructor.destroy();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }, "nfi-gc");
            if (gcThread.compareAndSet(null, thread)) {
                thread.setDaemon(true);
                thread.start();
            } else {
                Thread other = gcThread.get();
                assert (other != null && other != thread);
            }
        }
    }

    private static native void free(long var0);

    public static final class Queue {
        private final NativeAllocation first = new NativeAllocation(this);

        public void registerNativeAllocation(Object javaObject, Destructor destructor) {
            this.add(new NativeAllocation(javaObject, destructor, this));
        }

        private synchronized void add(NativeAllocation allocation) {
            assert (allocation.prev == null && allocation.next == null);
            NativeAllocation second = this.first.next;
            allocation.prev = this.first;
            allocation.next = second;
            this.first.next = allocation;
            second.prev = allocation;
        }

        private synchronized void remove(NativeAllocation allocation) {
            assert (allocation.queue == this);
            allocation.prev.next = allocation.next;
            allocation.next.prev = allocation.prev;
            allocation.next = null;
            allocation.prev = null;
        }
    }

    public static abstract class Destructor {
        protected abstract void destroy();
    }

    public static class FreeDestructor
    extends Destructor {
        private final long address;

        FreeDestructor(long address) {
            this.address = address;
        }

        @Override
        protected void destroy() {
            NativeAllocation.free(this.address);
        }
    }
}

