/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird;

import java.util.ResourceBundle;

public final class Version {
    public static final String JAYBIRD_SIMPLE_VERSION;
    public static final String JAYBIRD_DISPLAY_VERSION;
    public static final int JAYBIRD_MAJOR_VERSION;
    public static final int JAYBIRD_MINOR_VERSION;

    private Version() {
    }

    private static int tryParseInt(String stringValue) {
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            System.getLogger(Version.class.getName()).log(System.Logger.Level.ERROR, "org.firebirdsql.jaybird.Version: Unable to parse number {0}; defaulting to 0: {1}", stringValue, e);
            return 0;
        }
    }

    static {
        int jaybirdMinorVersion;
        int jaybirdMajorVersion;
        String jaybirdDisplayVersion;
        String jaybirdSimpleVersion;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("org.firebirdsql.jaybird.version");
            jaybirdSimpleVersion = resourceBundle.getString("jaybird.version.simple");
            jaybirdDisplayVersion = resourceBundle.getString("jaybird.version.display");
            jaybirdMajorVersion = Version.tryParseInt(resourceBundle.getString("jaybird.version.major"));
            jaybirdMinorVersion = Version.tryParseInt(resourceBundle.getString("jaybird.version.minor"));
        }
        catch (Exception e) {
            System.getLogger(Version.class.getName()).log(System.Logger.Level.ERROR, "org.firebirdsql.jaybird.Version: Unable to load version information: {0}", new Object[]{e});
            jaybirdSimpleVersion = "version unknown";
            jaybirdDisplayVersion = "Jaybird (version unknown)";
            jaybirdMajorVersion = 0;
            jaybirdMinorVersion = 0;
        }
        JAYBIRD_SIMPLE_VERSION = jaybirdSimpleVersion;
        JAYBIRD_DISPLAY_VERSION = jaybirdDisplayVersion;
        JAYBIRD_MAJOR_VERSION = jaybirdMajorVersion;
        JAYBIRD_MINOR_VERSION = jaybirdMinorVersion;
    }
}

