/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.escape;

import org.firebirdsql.jdbc.escape.CharacterLengthFunction;
import org.firebirdsql.jdbc.escape.FBSQLParseException;
import org.firebirdsql.jdbc.escape.PatternSQLFunction;
import org.firebirdsql.jdbc.escape.SQLFunction;

final class LengthFunction
implements SQLFunction {
    private static final SQLFunction TRIM_TRAILING = new PatternSQLFunction("TRIM(TRAILING FROM {0})");
    private static final SQLFunction CHARACTER_LENGTH = new CharacterLengthFunction();

    LengthFunction() {
    }

    @Override
    public String apply(String ... parameters) throws FBSQLParseException {
        if (parameters.length < 1 || parameters.length > 2) {
            throw new FBSQLParseException("Expected 1 or 2 parameters for LENGTH, received " + parameters.length);
        }
        String[] clonedParameters = (String[])parameters.clone();
        clonedParameters[0] = TRIM_TRAILING.apply(parameters);
        return CHARACTER_LENGTH.apply(clonedParameters);
    }
}

