/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
abstract class OracleInputStream
extends OracleBufferedStream {
    int columnIndex;
    Accessor accessor;
    OracleInputStream nextStream;
    boolean hasBeenOpen;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    protected OracleInputStream(OracleStatement stmt, int index, Accessor a2) {
        super(stmt, stmt.connection.getDefaultStreamChunkSize());
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleInputStream.class, $$$methodRef$$$4, null, stmt, index, a2);
            }
            this.hasBeenOpen = false;
            this.closed = true;
            this.statement = stmt;
            this.columnIndex = index;
            this.accessor = a2;
            this.nextStream = null;
            OracleInputStream s2 = this.statement.streamList;
            if (s2 == null || this.columnIndex < s2.columnIndex) {
                this.nextStream = this.statement.streamList;
                this.statement.streamList = this;
            } else if (this.columnIndex == s2.columnIndex) {
                this.nextStream = s2.nextStream;
                s2.nextStream = null;
                this.statement.streamList = this;
            } else {
                while (s2.nextStream != null && this.columnIndex > s2.nextStream.columnIndex) {
                    s2 = s2.nextStream;
                }
                if (s2.nextStream != null && this.columnIndex == s2.nextStream.columnIndex) {
                    this.nextStream = s2.nextStream.nextStream;
                    s2.nextStream.nextStream = null;
                    s2.nextStream = this;
                } else {
                    this.nextStream = s2.nextStream;
                    s2.nextStream = this;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleInputStream.class, $$$methodRef$$$4, null);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleInputStream.class, $$$methodRef$$$4, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleInputStream.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public String toString() {
        return "OIS@" + Integer.toHexString(this.hashCode()) + "{statement = " + this.statement + ", accessor = " + this.accessor + ", nextStream = " + this.nextStream + ", columnIndex = " + this.columnIndex + ", hasBeenOpen = " + this.hasBeenOpen + "}";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean needBytes(int n2) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            block13: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleInputStream.class, $$$methodRef$$$0, this, n2);
                }
                if (this.closed) {
                    boolean bl2 = false;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleInputStream.class, $$$methodRef$$$0, this, bl2);
                        ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleInputStream.class, $$$methodRef$$$0, this, null);
                    }
                    return false;
                }
                if (this.pos >= this.count) {
                    boolean bl3;
                    block14: {
                        boolean bl4;
                        void howMany;
                        if (howMany > this.currentBufferSize) {
                            this.currentBufferSize = Math.max((int)howMany, this.initialBufferSize);
                            this.resizableBuffer = new byte[this.currentBufferSize];
                        }
                        try {
                            int readLength = this.getBytes(this.currentBufferSize);
                            this.pos = 0;
                            this.count = readLength;
                            if (this.count != -1) break block13;
                            if (this.nextStream == null) {
                                this.statement.connection.releaseLine();
                            }
                            this.closed = true;
                            this.accessor.fetchNextColumns();
                            bl3 = bl4 = false;
                            if (!bl) break block14;
                        }
                        catch (SQLException e2) {
                            IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleInputStream.class, $$$methodRef$$$0, this, iOException);
                            }
                            throw iOException;
                        }
                        ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleInputStream.class, $$$methodRef$$$0, this, bl4);
                        ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleInputStream.class, $$$methodRef$$$0, this, null);
                    }
                    return bl3;
                }
            }
            boolean bl5 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleInputStream.class, $$$methodRef$$$0, this, bl5);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleInputStream.class, $$$methodRef$$$0, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleInputStream.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isNull() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleInputStream.class, $$$methodRef$$$1, this, new Object[0]);
            }
            boolean result = false;
            try {
                result = this.accessor.isNull(0);
            }
            catch (SQLException e2) {
                IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleInputStream.class, $$$methodRef$$$1, this, iOException);
                }
                throw iOException;
            }
            boolean bl2 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleInputStream.class, $$$methodRef$$$1, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleInputStream.class, $$$methodRef$$$1, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleInputStream.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isClosed() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleInputStream.class, $$$methodRef$$$2, this, new Object[0]);
            }
            boolean bl2 = this.closed;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleInputStream.class, $$$methodRef$$$2, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleInputStream.class, $$$methodRef$$$2, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleInputStream.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleInputStream.class, $$$methodRef$$$3, this, new Object[0]);
            }
            Monitor.CloseableLock lock = this.statement.connection.acquireCloseableLock();
            try {
                if (!this.closed && this.hasBeenOpen) {
                    while (this.statement.nextStream != this) {
                        this.statement.nextStream.close();
                        this.statement.nextStream = this.statement.nextStream.nextStream;
                    }
                    if (!this.isNull()) {
                        while (this.needBytes(Math.max(this.initialBufferSize, this.currentBufferSize))) {
                            this.pos = this.count;
                        }
                    }
                    this.closed = true;
                    this.resizableBuffer = null;
                    this.currentBufferSize = 0;
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleInputStream.class, $$$methodRef$$$3, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleInputStream.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleInputStream.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleInputStream.class, $$$methodRef$$$3, this, throwable4);
            }
            throw throwable;
        }
    }

    public abstract int getBytes(int var1) throws IOException;

    static {
        try {
            $$$methodRef$$$4 = OracleInputStream.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Accessor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleInputStream.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleInputStream.class.getDeclaredMethod("isClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleInputStream.class.getDeclaredMethod("isNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleInputStream.class.getDeclaredMethod("needBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

