/* contacts-io-vcard-parser.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from contacts-io-vcard-parser.vala, do not modify */

/*
 * Copyright (C) 2021 Niels De Graef <nielsdegraef@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <glib-object.h>
#include <gio/gio.h>
#include "contactscore.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libebook-contacts/libebook-contacts.h>
#include <folks/folks.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_IO_TYPE_PARSER (contacts_io_parser_get_type ())
#define CONTACTS_IO_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_IO_TYPE_PARSER, ContactsIoParser))
#define CONTACTS_IO_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_IO_TYPE_PARSER, ContactsIoParserClass))
#define CONTACTS_IO_IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_IO_TYPE_PARSER))
#define CONTACTS_IO_IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_IO_TYPE_PARSER))
#define CONTACTS_IO_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_IO_TYPE_PARSER, ContactsIoParserClass))

typedef struct _ContactsIoParser ContactsIoParser;
typedef struct _ContactsIoParserClass ContactsIoParserClass;
typedef struct _ContactsIoParserPrivate ContactsIoParserPrivate;

#define CONTACTS_IO_TYPE_VCARD_PARSER (contacts_io_vcard_parser_get_type ())
#define CONTACTS_IO_VCARD_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_IO_TYPE_VCARD_PARSER, ContactsIoVCardParser))
#define CONTACTS_IO_VCARD_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_IO_TYPE_VCARD_PARSER, ContactsIoVCardParserClass))
#define CONTACTS_IO_IS_VCARD_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_IO_TYPE_VCARD_PARSER))
#define CONTACTS_IO_IS_VCARD_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_IO_TYPE_VCARD_PARSER))
#define CONTACTS_IO_VCARD_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_IO_TYPE_VCARD_PARSER, ContactsIoVCardParserClass))

typedef struct _ContactsIoVCardParser ContactsIoVCardParser;
typedef struct _ContactsIoVCardParserClass ContactsIoVCardParserClass;
typedef struct _ContactsIoVCardParserPrivate ContactsIoVCardParserPrivate;
enum  {
	CONTACTS_IO_VCARD_PARSER_0_PROPERTY,
	CONTACTS_IO_VCARD_PARSER_NUM_PROPERTIES
};
static GParamSpec* contacts_io_vcard_parser_properties[CONTACTS_IO_VCARD_PARSER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define __vala_EContactDate_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactDate_free (var), NULL)))

struct _ContactsIoParser {
	GObject parent_instance;
	ContactsIoParserPrivate * priv;
};

struct _ContactsIoParserClass {
	GObjectClass parent_class;
	ContactsContact** (*parse) (ContactsIoParser* self, GInputStream* input, gint* result_length1, GError** error);
};

struct _ContactsIoVCardParser {
	ContactsIoParser parent_instance;
	ContactsIoVCardParserPrivate * priv;
};

struct _ContactsIoVCardParserClass {
	ContactsIoParserClass parent_class;
};

static gpointer contacts_io_vcard_parser_parent_class = NULL;

VALA_EXTERN GType contacts_io_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsIoParser, g_object_unref)
VALA_EXTERN GType contacts_io_vcard_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsIoVCardParser, g_object_unref)
VALA_EXTERN ContactsContact** contacts_io_parser_parse (ContactsIoParser* self,
                                            GInputStream* input,
                                            gint* result_length1,
                                            GError** error);
VALA_EXTERN ContactsIoVCardParser* contacts_io_vcard_parser_new (void);
VALA_EXTERN ContactsIoVCardParser* contacts_io_vcard_parser_construct (GType object_type);
VALA_EXTERN ContactsIoParser* contacts_io_parser_construct (GType object_type);
static ContactsContact** contacts_io_vcard_parser_real_parse (ContactsIoParser* base,
                                                       GInputStream* input,
                                                       gint* result_length1,
                                                       GError** error);
static void _g_object_unref0_ (gpointer var);
static void contacts_io_vcard_parser_handle_fn (ContactsIoVCardParser* self,
                                         ContactsContact* contact,
                                         EVCardAttribute* attr);
static void contacts_io_vcard_parser_handle_n (ContactsIoVCardParser* self,
                                        ContactsContact* contact,
                                        EVCardAttribute* attr);
static void contacts_io_vcard_parser_handle_nickname (ContactsIoVCardParser* self,
                                               ContactsContact* contact,
                                               EVCardAttribute* attr);
static void contacts_io_vcard_parser_handle_bday (ContactsIoVCardParser* self,
                                           ContactsContact* contact,
                                           EVCardAttribute* attr);
static void contacts_io_vcard_parser_handle_adr (ContactsIoVCardParser* self,
                                          ContactsContact* contact,
                                          EVCardAttribute* attr);
static void contacts_io_vcard_parser_handle_tel (ContactsIoVCardParser* self,
                                          ContactsContact* contact,
                                          EVCardAttribute* attr);
static void contacts_io_vcard_parser_handle_email (ContactsIoVCardParser* self,
                                            ContactsContact* contact,
                                            EVCardAttribute* attr);
static void contacts_io_vcard_parser_handle_title (ContactsIoVCardParser* self,
                                            ContactsContact* contact,
                                            EVCardAttribute* attr);
static void contacts_io_vcard_parser_handle_org (ContactsIoVCardParser* self,
                                          ContactsContact* contact,
                                          EVCardAttribute* attr);
static void contacts_io_vcard_parser_handle_note (ContactsIoVCardParser* self,
                                           ContactsContact* contact,
                                           EVCardAttribute* attr);
static void contacts_io_vcard_parser_handle_url (ContactsIoVCardParser* self,
                                          ContactsContact* contact,
                                          EVCardAttribute* attr);
static void _vala_EContactDate_free (EContactDate* self);
static ContactsBinChunkChild* contacts_io_vcard_parser_add_chunk_child_for_property (ContactsIoVCardParser* self,
                                                                              ContactsContact* contact,
                                                                              const gchar* property_name);
static void contacts_io_vcard_parser_add_params (ContactsIoVCardParser* self,
                                          ContactsBinChunkChild* chunk_child,
                                          EVCardAttribute* attr);
static GType contacts_io_vcard_parser_get_type_once (void);

ContactsIoVCardParser*
contacts_io_vcard_parser_construct (GType object_type)
{
	ContactsIoVCardParser * self = NULL;
	self = (ContactsIoVCardParser*) contacts_io_parser_construct (object_type);
	return self;
}

ContactsIoVCardParser*
contacts_io_vcard_parser_new (void)
{
	return contacts_io_vcard_parser_construct (CONTACTS_IO_TYPE_VCARD_PARSER);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static ContactsContact**
contacts_io_vcard_parser_real_parse (ContactsIoParser* base,
                                     GInputStream* input,
                                     gint* result_length1,
                                     GError** error)
{
	ContactsIoVCardParser * self;
	GMemoryOutputStream* memory_stream = NULL;
	GMemoryOutputStream* _tmp0_;
	GMemoryOutputStream* _tmp1_;
	GMemoryOutputStream* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_ = 0;
	guint8* _tmp5_;
	gint _tmp5__length1;
	GMemoryOutputStream* _tmp6_;
	gchar* input_str = NULL;
	GMemoryOutputStream* _tmp7_;
	guint8* _tmp8_;
	gchar* _tmp9_;
	GPtrArray* _result_ = NULL;
	GPtrArray* _tmp10_;
	gint begin_index = 0;
	const gchar* _tmp11_;
	GPtrArray* _tmp57_;
	gsize _tmp58_ = 0;
	gpointer* _tmp59_;
	ContactsContact** _tmp60_;
	gint _tmp60__length1;
	GError* _inner_error0_ = NULL;
	ContactsContact** result;
	self = (ContactsIoVCardParser*) base;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = (GMemoryOutputStream*) g_memory_output_stream_new_resizable ();
	memory_stream = _tmp0_;
	_tmp1_ = memory_stream;
	g_output_stream_splice ((GOutputStream*) _tmp1_, input, 0, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (memory_stream);
		return NULL;
	}
	_tmp2_ = memory_stream;
	_tmp3_ = string_get_data ("\0", &_tmp4_);
	_tmp3__length1 = _tmp4_;
	_tmp5_ = _tmp3_;
	_tmp5__length1 = _tmp3__length1;
	g_output_stream_write ((GOutputStream*) _tmp2_, _tmp5_, (gsize) _tmp5__length1, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (memory_stream);
		return NULL;
	}
	_tmp6_ = memory_stream;
	g_output_stream_close ((GOutputStream*) _tmp6_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (memory_stream);
		return NULL;
	}
	_tmp7_ = memory_stream;
	_tmp8_ = g_memory_output_stream_get_data (_tmp7_);
	_tmp9_ = g_strdup ((const gchar*) _tmp8_);
	input_str = _tmp9_;
	_tmp10_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_result_ = _tmp10_;
	_tmp11_ = input_str;
	begin_index = string_index_of (_tmp11_, "BEGIN:VCARD", 0);
	while (TRUE) {
		gint end_vcard_index = 0;
		const gchar* _tmp12_;
		gint end_index = 0;
		gint _tmp13_;
		gint _tmp14_;
		gchar* vcard_str = NULL;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		EVCard* vcard = NULL;
		const gchar* _tmp17_;
		EVCard* _tmp18_;
		GList* vcard_attrs = NULL;
		EVCard* _tmp19_;
		GList* _tmp20_;
		GList* _tmp21_;
		ContactsContact* contact = NULL;
		ContactsContact* _tmp22_;
		GList* _tmp23_;
		GPtrArray* _tmp53_;
		ContactsContact* _tmp54_;
		ContactsContact* _tmp55_;
		const gchar* _tmp56_;
		if (!(begin_index != -1)) {
			break;
		}
		_tmp12_ = input_str;
		end_vcard_index = string_index_of (_tmp12_, "END:VCARD", begin_index + 1);
		_tmp13_ = strlen ("END:VCARD");
		_tmp14_ = _tmp13_;
		end_index = end_vcard_index + _tmp14_;
		_tmp15_ = input_str;
		_tmp16_ = string_slice (_tmp15_, (glong) begin_index, (glong) end_index);
		vcard_str = _tmp16_;
		_tmp17_ = vcard_str;
		_tmp18_ = e_vcard_new_from_string (_tmp17_);
		vcard = _tmp18_;
		_tmp19_ = vcard;
		_tmp20_ = e_vcard_get_attributes (_tmp19_);
		vcard_attrs = _tmp20_;
		_tmp21_ = vcard_attrs;
		g_debug ("contacts-io-vcard-parser.vala:41: Got %u attributes in this vcard", g_list_length (_tmp21_));
		_tmp22_ = contacts_contact_new_empty ();
		contact = _tmp22_;
		_tmp23_ = vcard_attrs;
		{
			GList* attr_collection = NULL;
			GList* attr_it = NULL;
			attr_collection = _tmp23_;
			for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
				EVCardAttribute* attr = NULL;
				attr = (EVCardAttribute*) attr_it->data;
				{
					EVCardAttribute* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					GQuark _tmp28_ = 0U;
					static GQuark _tmp27_label0 = 0;
					static GQuark _tmp27_label1 = 0;
					static GQuark _tmp27_label2 = 0;
					static GQuark _tmp27_label3 = 0;
					static GQuark _tmp27_label4 = 0;
					static GQuark _tmp27_label5 = 0;
					static GQuark _tmp27_label6 = 0;
					static GQuark _tmp27_label7 = 0;
					static GQuark _tmp27_label8 = 0;
					static GQuark _tmp27_label9 = 0;
					static GQuark _tmp27_label10 = 0;
					_tmp24_ = attr;
					_tmp25_ = e_vcard_attribute_get_name (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp28_ = (NULL == _tmp26_) ? 0 : g_quark_from_string (_tmp26_);
					if (_tmp28_ == ((0 != _tmp27_label0) ? _tmp27_label0 : (_tmp27_label0 = g_quark_from_static_string (EVC_FN)))) {
						switch (0) {
							default:
							{
								ContactsContact* _tmp29_;
								EVCardAttribute* _tmp30_;
								_tmp29_ = contact;
								_tmp30_ = attr;
								contacts_io_vcard_parser_handle_fn (self, _tmp29_, _tmp30_);
								break;
							}
						}
					} else if (_tmp28_ == ((0 != _tmp27_label1) ? _tmp27_label1 : (_tmp27_label1 = g_quark_from_static_string (EVC_N)))) {
						switch (0) {
							default:
							{
								ContactsContact* _tmp31_;
								EVCardAttribute* _tmp32_;
								_tmp31_ = contact;
								_tmp32_ = attr;
								contacts_io_vcard_parser_handle_n (self, _tmp31_, _tmp32_);
								break;
							}
						}
					} else if (_tmp28_ == ((0 != _tmp27_label2) ? _tmp27_label2 : (_tmp27_label2 = g_quark_from_static_string (EVC_NICKNAME)))) {
						switch (0) {
							default:
							{
								ContactsContact* _tmp33_;
								EVCardAttribute* _tmp34_;
								_tmp33_ = contact;
								_tmp34_ = attr;
								contacts_io_vcard_parser_handle_nickname (self, _tmp33_, _tmp34_);
								break;
							}
						}
					} else if (_tmp28_ == ((0 != _tmp27_label3) ? _tmp27_label3 : (_tmp27_label3 = g_quark_from_static_string (EVC_BDAY)))) {
						switch (0) {
							default:
							{
								ContactsContact* _tmp35_;
								EVCardAttribute* _tmp36_;
								_tmp35_ = contact;
								_tmp36_ = attr;
								contacts_io_vcard_parser_handle_bday (self, _tmp35_, _tmp36_);
								break;
							}
						}
					} else if (_tmp28_ == ((0 != _tmp27_label4) ? _tmp27_label4 : (_tmp27_label4 = g_quark_from_static_string (EVC_ADR)))) {
						switch (0) {
							default:
							{
								ContactsContact* _tmp37_;
								EVCardAttribute* _tmp38_;
								_tmp37_ = contact;
								_tmp38_ = attr;
								contacts_io_vcard_parser_handle_adr (self, _tmp37_, _tmp38_);
								break;
							}
						}
					} else if (_tmp28_ == ((0 != _tmp27_label5) ? _tmp27_label5 : (_tmp27_label5 = g_quark_from_static_string (EVC_TEL)))) {
						switch (0) {
							default:
							{
								ContactsContact* _tmp39_;
								EVCardAttribute* _tmp40_;
								_tmp39_ = contact;
								_tmp40_ = attr;
								contacts_io_vcard_parser_handle_tel (self, _tmp39_, _tmp40_);
								break;
							}
						}
					} else if (_tmp28_ == ((0 != _tmp27_label6) ? _tmp27_label6 : (_tmp27_label6 = g_quark_from_static_string (EVC_EMAIL)))) {
						switch (0) {
							default:
							{
								ContactsContact* _tmp41_;
								EVCardAttribute* _tmp42_;
								_tmp41_ = contact;
								_tmp42_ = attr;
								contacts_io_vcard_parser_handle_email (self, _tmp41_, _tmp42_);
								break;
							}
						}
					} else if (_tmp28_ == ((0 != _tmp27_label7) ? _tmp27_label7 : (_tmp27_label7 = g_quark_from_static_string (EVC_TITLE)))) {
						switch (0) {
							default:
							{
								ContactsContact* _tmp43_;
								EVCardAttribute* _tmp44_;
								_tmp43_ = contact;
								_tmp44_ = attr;
								contacts_io_vcard_parser_handle_title (self, _tmp43_, _tmp44_);
								break;
							}
						}
					} else if (_tmp28_ == ((0 != _tmp27_label8) ? _tmp27_label8 : (_tmp27_label8 = g_quark_from_static_string (EVC_ORG)))) {
						switch (0) {
							default:
							{
								ContactsContact* _tmp45_;
								EVCardAttribute* _tmp46_;
								_tmp45_ = contact;
								_tmp46_ = attr;
								contacts_io_vcard_parser_handle_org (self, _tmp45_, _tmp46_);
								break;
							}
						}
					} else if (_tmp28_ == ((0 != _tmp27_label9) ? _tmp27_label9 : (_tmp27_label9 = g_quark_from_static_string (EVC_NOTE)))) {
						switch (0) {
							default:
							{
								ContactsContact* _tmp47_;
								EVCardAttribute* _tmp48_;
								_tmp47_ = contact;
								_tmp48_ = attr;
								contacts_io_vcard_parser_handle_note (self, _tmp47_, _tmp48_);
								break;
							}
						}
					} else if (_tmp28_ == ((0 != _tmp27_label10) ? _tmp27_label10 : (_tmp27_label10 = g_quark_from_static_string (EVC_URL)))) {
						switch (0) {
							default:
							{
								ContactsContact* _tmp49_;
								EVCardAttribute* _tmp50_;
								_tmp49_ = contact;
								_tmp50_ = attr;
								contacts_io_vcard_parser_handle_url (self, _tmp49_, _tmp50_);
								break;
							}
						}
					} else {
						switch (0) {
							default:
							{
								EVCardAttribute* _tmp51_;
								const gchar* _tmp52_;
								_tmp51_ = attr;
								_tmp52_ = e_vcard_attribute_get_name (_tmp51_);
								g_debug ("contacts-io-vcard-parser.vala:92: Unknown property name '%s'", _tmp52_);
								break;
							}
						}
					}
				}
			}
		}
		_tmp53_ = _result_;
		_tmp54_ = contact;
		_tmp55_ = _g_object_ref0 (_tmp54_);
		g_ptr_array_add (_tmp53_, _tmp55_);
		_tmp56_ = input_str;
		begin_index = string_index_of (_tmp56_, "BEGIN:VCARD", end_index);
		_g_object_unref0 (contact);
		_g_object_unref0 (vcard);
		_g_free0 (vcard_str);
	}
	_tmp57_ = _result_;
	_tmp59_ = g_ptr_array_steal (_tmp57_, &_tmp58_);
	_tmp60_ = _tmp59_;
	_tmp60__length1 = _tmp58_;
	if (result_length1) {
		*result_length1 = _tmp60__length1;
	}
	result = _tmp60_;
	_g_ptr_array_unref0 (_result_);
	_g_free0 (input_str);
	_g_object_unref0 (memory_stream);
	return result;
}

static void
contacts_io_vcard_parser_handle_fn (ContactsIoVCardParser* self,
                                    ContactsContact* contact,
                                    EVCardAttribute* attr)
{
	gchar* full_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	ContactsChunk* _tmp2_ = NULL;
	ContactsChunk* _tmp3_;
	ContactsChunk* chunk = NULL;
	ContactsChunk* _tmp5_;
	ContactsFullNameChunk* fn_chunk = NULL;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_value (attr);
	full_name = _tmp0_;
	_tmp1_ = full_name;
	g_debug ("contacts-io-vcard-parser.vala:108: Got FN '%s'", _tmp1_);
	_tmp3_ = contacts_contact_get_most_relevant_chunk (contact, "full-name", TRUE);
	_tmp2_ = _tmp3_;
	if (_tmp2_ == NULL) {
		ContactsChunk* _tmp4_;
		_tmp4_ = contacts_contact_create_chunk (contact, "full-name", NULL);
		_tmp2_ = _tmp4_;
	}
	_tmp5_ = _g_object_ref0 (_tmp2_);
	chunk = _tmp5_;
	fn_chunk = G_TYPE_CHECK_INSTANCE_CAST (chunk, CONTACTS_TYPE_FULL_NAME_CHUNK, ContactsFullNameChunk);
	_tmp6_ = full_name;
	contacts_full_name_chunk_set_full_name (fn_chunk, _tmp6_);
	_g_object_unref0 (chunk);
	_g_free0 (full_name);
}

static void
contacts_io_vcard_parser_handle_n (ContactsIoVCardParser* self,
                                   ContactsContact* contact,
                                   EVCardAttribute* attr)
{
	GList* values = NULL;
	GList* _tmp0_;
	ContactsStructuredNameChunk* sn_chunk = NULL;
	ContactsChunk* _tmp1_;
	ContactsStructuredNameChunk* _tmp2_;
	const gchar* _tmp3_ = NULL;
	GList* _tmp4_;
	gconstpointer _tmp5_;
	ContactsStructuredNameChunk* _tmp6_;
	FolksStructuredName* _tmp7_;
	FolksStructuredName* _tmp8_;
	const gchar* _tmp9_ = NULL;
	GList* _tmp10_;
	gconstpointer _tmp11_;
	ContactsStructuredNameChunk* _tmp12_;
	FolksStructuredName* _tmp13_;
	FolksStructuredName* _tmp14_;
	const gchar* _tmp15_ = NULL;
	GList* _tmp16_;
	gconstpointer _tmp17_;
	ContactsStructuredNameChunk* _tmp18_;
	FolksStructuredName* _tmp19_;
	FolksStructuredName* _tmp20_;
	const gchar* _tmp21_ = NULL;
	GList* _tmp22_;
	gconstpointer _tmp23_;
	ContactsStructuredNameChunk* _tmp24_;
	FolksStructuredName* _tmp25_;
	FolksStructuredName* _tmp26_;
	const gchar* _tmp27_ = NULL;
	GList* _tmp28_;
	gconstpointer _tmp29_;
	ContactsStructuredNameChunk* _tmp30_;
	FolksStructuredName* _tmp31_;
	FolksStructuredName* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_values (attr);
	values = _tmp0_;
	_tmp1_ = contacts_contact_create_chunk (contact, "structured-name", NULL);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CONTACTS_TYPE_STRUCTURED_NAME_CHUNK, ContactsStructuredNameChunk));
	sn_chunk = _tmp2_;
	_tmp4_ = values;
	_tmp5_ = g_list_nth_data (_tmp4_, (guint) 0);
	_tmp3_ = (const gchar*) _tmp5_;
	if (_tmp3_ == NULL) {
		_tmp3_ = "";
	}
	_tmp6_ = sn_chunk;
	_tmp7_ = contacts_structured_name_chunk_get_structured_name (_tmp6_);
	_tmp8_ = _tmp7_;
	folks_structured_name_set_family_name (_tmp8_, _tmp3_);
	_tmp10_ = values;
	_tmp11_ = g_list_nth_data (_tmp10_, (guint) 1);
	_tmp9_ = (const gchar*) _tmp11_;
	if (_tmp9_ == NULL) {
		_tmp9_ = "";
	}
	_tmp12_ = sn_chunk;
	_tmp13_ = contacts_structured_name_chunk_get_structured_name (_tmp12_);
	_tmp14_ = _tmp13_;
	folks_structured_name_set_given_name (_tmp14_, _tmp9_);
	_tmp16_ = values;
	_tmp17_ = g_list_nth_data (_tmp16_, (guint) 2);
	_tmp15_ = (const gchar*) _tmp17_;
	if (_tmp15_ == NULL) {
		_tmp15_ = "";
	}
	_tmp18_ = sn_chunk;
	_tmp19_ = contacts_structured_name_chunk_get_structured_name (_tmp18_);
	_tmp20_ = _tmp19_;
	folks_structured_name_set_additional_names (_tmp20_, _tmp15_);
	_tmp22_ = values;
	_tmp23_ = g_list_nth_data (_tmp22_, (guint) 3);
	_tmp21_ = (const gchar*) _tmp23_;
	if (_tmp21_ == NULL) {
		_tmp21_ = "";
	}
	_tmp24_ = sn_chunk;
	_tmp25_ = contacts_structured_name_chunk_get_structured_name (_tmp24_);
	_tmp26_ = _tmp25_;
	folks_structured_name_set_prefixes (_tmp26_, _tmp21_);
	_tmp28_ = values;
	_tmp29_ = g_list_nth_data (_tmp28_, (guint) 4);
	_tmp27_ = (const gchar*) _tmp29_;
	if (_tmp27_ == NULL) {
		_tmp27_ = "";
	}
	_tmp30_ = sn_chunk;
	_tmp31_ = contacts_structured_name_chunk_get_structured_name (_tmp30_);
	_tmp32_ = _tmp31_;
	folks_structured_name_set_suffixes (_tmp32_, _tmp27_);
	_g_object_unref0 (sn_chunk);
}

static void
contacts_io_vcard_parser_handle_nickname (ContactsIoVCardParser* self,
                                          ContactsContact* contact,
                                          EVCardAttribute* attr)
{
	gchar* nickname = NULL;
	gchar* _tmp0_;
	ContactsNicknameChunk* nick_chunk = NULL;
	ContactsChunk* _tmp1_;
	ContactsNicknameChunk* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_value (attr);
	nickname = _tmp0_;
	g_debug ("contacts-io-vcard-parser.vala:136: Got nickname '%s'", nickname);
	_tmp1_ = contacts_contact_create_chunk (contact, "nickname", NULL);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CONTACTS_TYPE_NICKNAME_CHUNK, ContactsNicknameChunk));
	nick_chunk = _tmp2_;
	contacts_nickname_chunk_set_nickname (nick_chunk, nickname);
	_g_object_unref0 (nick_chunk);
	_g_free0 (nickname);
}

static void
_vala_EContactDate_free (EContactDate* self)
{
	g_boxed_free (e_contact_date_get_type (), self);
}

static void
contacts_io_vcard_parser_handle_bday (ContactsIoVCardParser* self,
                                      ContactsContact* contact,
                                      EVCardAttribute* attr)
{
	gchar* bday = NULL;
	gchar* _tmp0_;
	EContactDate* e_date = NULL;
	EContactDate* _tmp1_;
	GDateTime* datetime = NULL;
	GDateTime* _tmp2_;
	ContactsBirthdayChunk* bd_chunk = NULL;
	ContactsChunk* _tmp3_;
	ContactsBirthdayChunk* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_value (attr);
	bday = _tmp0_;
	_tmp1_ = e_contact_date_from_string (bday);
	e_date = _tmp1_;
	_tmp2_ = g_date_time_new_utc ((gint) e_date->year, (gint) e_date->month, (gint) e_date->day, 0, 0, 0.0);
	datetime = _tmp2_;
	_tmp3_ = contacts_contact_create_chunk (contact, "birthday", NULL);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CONTACTS_TYPE_BIRTHDAY_CHUNK, ContactsBirthdayChunk));
	bd_chunk = _tmp4_;
	contacts_birthday_chunk_set_birthday (bd_chunk, datetime);
	_g_object_unref0 (bd_chunk);
	_g_date_time_unref0 (datetime);
	__vala_EContactDate_free0 (e_date);
	_g_free0 (bday);
}

static void
contacts_io_vcard_parser_handle_email (ContactsIoVCardParser* self,
                                       ContactsContact* contact,
                                       EVCardAttribute* attr)
{
	gchar* email = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	ContactsBinChunkChild* child = NULL;
	ContactsBinChunkChild* _tmp4_;
	ContactsBinChunkChild* _tmp5_;
	const gchar* _tmp6_;
	ContactsBinChunkChild* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_value (attr);
	email = _tmp0_;
	_tmp2_ = email;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = email;
		_tmp1_ = g_strcmp0 (_tmp3_, "") == 0;
	}
	if (_tmp1_) {
		_g_free0 (email);
		return;
	}
	_tmp4_ = contacts_io_vcard_parser_add_chunk_child_for_property (self, contact, "email-addresses");
	child = _tmp4_;
	_tmp5_ = child;
	_tmp6_ = email;
	contacts_email_address_set_raw_address (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, CONTACTS_TYPE_EMAIL_ADDRESS, ContactsEmailAddress), _tmp6_);
	_tmp7_ = child;
	contacts_io_vcard_parser_add_params (self, _tmp7_, attr);
	_g_object_unref0 (child);
	_g_free0 (email);
}

static void
contacts_io_vcard_parser_handle_tel (ContactsIoVCardParser* self,
                                     ContactsContact* contact,
                                     EVCardAttribute* attr)
{
	gchar* phone_nr = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	ContactsBinChunkChild* child = NULL;
	ContactsBinChunkChild* _tmp4_;
	ContactsBinChunkChild* _tmp5_;
	const gchar* _tmp6_;
	ContactsBinChunkChild* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_value (attr);
	phone_nr = _tmp0_;
	_tmp2_ = phone_nr;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = phone_nr;
		_tmp1_ = g_strcmp0 (_tmp3_, "") == 0;
	}
	if (_tmp1_) {
		_g_free0 (phone_nr);
		return;
	}
	_tmp4_ = contacts_io_vcard_parser_add_chunk_child_for_property (self, contact, "phone-numbers");
	child = _tmp4_;
	_tmp5_ = child;
	_tmp6_ = phone_nr;
	contacts_phone_set_raw_number (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, CONTACTS_TYPE_PHONE, ContactsPhone), _tmp6_);
	_tmp7_ = child;
	contacts_io_vcard_parser_add_params (self, _tmp7_, attr);
	_g_object_unref0 (child);
	_g_free0 (phone_nr);
}

static void
contacts_io_vcard_parser_handle_adr (ContactsIoVCardParser* self,
                                     ContactsContact* contact,
                                     EVCardAttribute* attr)
{
	GList* values = NULL;
	GList* _tmp0_;
	ContactsBinChunkChild* child = NULL;
	ContactsBinChunkChild* _tmp1_;
	FolksPostalAddress* address = NULL;
	ContactsBinChunkChild* _tmp2_;
	FolksPostalAddress* _tmp3_;
	FolksPostalAddress* _tmp4_;
	const gchar* _tmp5_ = NULL;
	GList* _tmp6_;
	gconstpointer _tmp7_;
	FolksPostalAddress* _tmp8_;
	const gchar* _tmp9_ = NULL;
	GList* _tmp10_;
	gconstpointer _tmp11_;
	FolksPostalAddress* _tmp12_;
	const gchar* _tmp13_ = NULL;
	GList* _tmp14_;
	gconstpointer _tmp15_;
	FolksPostalAddress* _tmp16_;
	const gchar* _tmp17_ = NULL;
	GList* _tmp18_;
	gconstpointer _tmp19_;
	FolksPostalAddress* _tmp20_;
	const gchar* _tmp21_ = NULL;
	GList* _tmp22_;
	gconstpointer _tmp23_;
	FolksPostalAddress* _tmp24_;
	const gchar* _tmp25_ = NULL;
	GList* _tmp26_;
	gconstpointer _tmp27_;
	FolksPostalAddress* _tmp28_;
	const gchar* _tmp29_ = NULL;
	GList* _tmp30_;
	gconstpointer _tmp31_;
	FolksPostalAddress* _tmp32_;
	ContactsBinChunkChild* _tmp33_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_values (attr);
	values = _tmp0_;
	_tmp1_ = contacts_io_vcard_parser_add_chunk_child_for_property (self, contact, "postal-addresses");
	child = _tmp1_;
	_tmp2_ = child;
	_tmp3_ = contacts_address_get_address (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CONTACTS_TYPE_ADDRESS, ContactsAddress));
	_tmp4_ = _tmp3_;
	address = _tmp4_;
	_tmp6_ = values;
	_tmp7_ = g_list_nth_data (_tmp6_, (guint) 0);
	_tmp5_ = (const gchar*) _tmp7_;
	if (_tmp5_ == NULL) {
		_tmp5_ = "";
	}
	_tmp8_ = address;
	folks_postal_address_set_po_box (_tmp8_, _tmp5_);
	_tmp10_ = values;
	_tmp11_ = g_list_nth_data (_tmp10_, (guint) 1);
	_tmp9_ = (const gchar*) _tmp11_;
	if (_tmp9_ == NULL) {
		_tmp9_ = "";
	}
	_tmp12_ = address;
	folks_postal_address_set_extension (_tmp12_, _tmp9_);
	_tmp14_ = values;
	_tmp15_ = g_list_nth_data (_tmp14_, (guint) 2);
	_tmp13_ = (const gchar*) _tmp15_;
	if (_tmp13_ == NULL) {
		_tmp13_ = "";
	}
	_tmp16_ = address;
	folks_postal_address_set_street (_tmp16_, _tmp13_);
	_tmp18_ = values;
	_tmp19_ = g_list_nth_data (_tmp18_, (guint) 3);
	_tmp17_ = (const gchar*) _tmp19_;
	if (_tmp17_ == NULL) {
		_tmp17_ = "";
	}
	_tmp20_ = address;
	folks_postal_address_set_locality (_tmp20_, _tmp17_);
	_tmp22_ = values;
	_tmp23_ = g_list_nth_data (_tmp22_, (guint) 4);
	_tmp21_ = (const gchar*) _tmp23_;
	if (_tmp21_ == NULL) {
		_tmp21_ = "";
	}
	_tmp24_ = address;
	folks_postal_address_set_region (_tmp24_, _tmp21_);
	_tmp26_ = values;
	_tmp27_ = g_list_nth_data (_tmp26_, (guint) 5);
	_tmp25_ = (const gchar*) _tmp27_;
	if (_tmp25_ == NULL) {
		_tmp25_ = "";
	}
	_tmp28_ = address;
	folks_postal_address_set_postal_code (_tmp28_, _tmp25_);
	_tmp30_ = values;
	_tmp31_ = g_list_nth_data (_tmp30_, (guint) 6);
	_tmp29_ = (const gchar*) _tmp31_;
	if (_tmp29_ == NULL) {
		_tmp29_ = "";
	}
	_tmp32_ = address;
	folks_postal_address_set_country (_tmp32_, _tmp29_);
	_tmp33_ = child;
	contacts_io_vcard_parser_add_params (self, _tmp33_, attr);
	_g_object_unref0 (child);
}

static void
contacts_io_vcard_parser_handle_url (ContactsIoVCardParser* self,
                                     ContactsContact* contact,
                                     EVCardAttribute* attr)
{
	gchar* url = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	ContactsBinChunkChild* child = NULL;
	ContactsBinChunkChild* _tmp4_;
	ContactsBinChunkChild* _tmp5_;
	const gchar* _tmp6_;
	ContactsBinChunkChild* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_value (attr);
	url = _tmp0_;
	_tmp2_ = url;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = url;
		_tmp1_ = g_strcmp0 (_tmp3_, "") == 0;
	}
	if (_tmp1_) {
		_g_free0 (url);
		return;
	}
	_tmp4_ = contacts_io_vcard_parser_add_chunk_child_for_property (self, contact, "urls");
	child = _tmp4_;
	_tmp5_ = child;
	_tmp6_ = url;
	contacts_url_set_raw_url (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, CONTACTS_TYPE_URL, ContactsUrl), _tmp6_);
	_tmp7_ = child;
	contacts_io_vcard_parser_add_params (self, _tmp7_, attr);
	_g_object_unref0 (child);
	_g_free0 (url);
}

static void
contacts_io_vcard_parser_handle_title (ContactsIoVCardParser* self,
                                       ContactsContact* contact,
                                       EVCardAttribute* attr)
{
	gchar* title = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	ContactsBinChunk* chunk = NULL;
	ContactsChunk* _tmp4_;
	ContactsBinChunk* _tmp5_;
	ContactsBinChunk* _tmp6_;
	ContactsBinChunkChild* child = NULL;
	ContactsBinChunkChild* _tmp18_;
	ContactsBinChunkChild* _tmp19_;
	FolksRole* _tmp20_;
	FolksRole* _tmp21_;
	const gchar* _tmp22_;
	ContactsBinChunkChild* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_value (attr);
	title = _tmp0_;
	_tmp2_ = title;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = title;
		_tmp1_ = g_strcmp0 (_tmp3_, "") == 0;
	}
	if (_tmp1_) {
		_g_free0 (title);
		return;
	}
	_tmp4_ = contacts_contact_get_most_relevant_chunk (contact, "roles", TRUE);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CONTACTS_TYPE_BIN_CHUNK, ContactsBinChunk));
	chunk = _tmp5_;
	_tmp6_ = chunk;
	if (_tmp6_ != NULL) {
		ContactsOrgRole* orgrole = NULL;
		ContactsBinChunk* _tmp7_;
		GObject* _tmp8_;
		ContactsOrgRole* _tmp9_;
		FolksRole* _tmp10_;
		FolksRole* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp7_ = chunk;
		_tmp8_ = g_list_model_get_item ((GListModel*) _tmp7_, (guint) 0);
		orgrole = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, CONTACTS_TYPE_ORG_ROLE, ContactsOrgRole);
		_tmp9_ = orgrole;
		_tmp10_ = contacts_org_role_get_role (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = folks_role_get_title (_tmp11_);
		_tmp13_ = _tmp12_;
		if (g_strcmp0 (_tmp13_, "") == 0) {
			ContactsOrgRole* _tmp14_;
			FolksRole* _tmp15_;
			FolksRole* _tmp16_;
			const gchar* _tmp17_;
			_tmp14_ = orgrole;
			_tmp15_ = contacts_org_role_get_role (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = title;
			folks_role_set_title (_tmp16_, _tmp17_);
		}
		_g_object_unref0 (orgrole);
		_g_object_unref0 (chunk);
		_g_free0 (title);
		return;
	}
	_tmp18_ = contacts_io_vcard_parser_add_chunk_child_for_property (self, contact, "roles");
	child = _tmp18_;
	_tmp19_ = child;
	_tmp20_ = contacts_org_role_get_role (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, CONTACTS_TYPE_ORG_ROLE, ContactsOrgRole));
	_tmp21_ = _tmp20_;
	_tmp22_ = title;
	folks_role_set_title (_tmp21_, _tmp22_);
	_tmp23_ = child;
	contacts_io_vcard_parser_add_params (self, _tmp23_, attr);
	_g_object_unref0 (child);
	_g_object_unref0 (chunk);
	_g_free0 (title);
}

static void
contacts_io_vcard_parser_handle_org (ContactsIoVCardParser* self,
                                     ContactsContact* contact,
                                     EVCardAttribute* attr)
{
	GList* values = NULL;
	GList* _tmp0_;
	const gchar* org = NULL;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	ContactsBinChunk* chunk = NULL;
	ContactsChunk* _tmp6_;
	ContactsBinChunk* _tmp7_;
	ContactsBinChunk* _tmp8_;
	ContactsBinChunkChild* child = NULL;
	ContactsBinChunkChild* _tmp20_;
	ContactsBinChunkChild* _tmp21_;
	FolksRole* _tmp22_;
	FolksRole* _tmp23_;
	const gchar* _tmp24_;
	ContactsBinChunkChild* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_values (attr);
	values = _tmp0_;
	_tmp1_ = values;
	_tmp2_ = _tmp1_->data;
	org = (const gchar*) _tmp2_;
	_tmp4_ = org;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = org;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
	}
	if (_tmp3_) {
		return;
	}
	_tmp6_ = contacts_contact_get_most_relevant_chunk (contact, "roles", TRUE);
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, CONTACTS_TYPE_BIN_CHUNK, ContactsBinChunk));
	chunk = _tmp7_;
	_tmp8_ = chunk;
	if (_tmp8_ != NULL) {
		ContactsOrgRole* orgrole = NULL;
		ContactsBinChunk* _tmp9_;
		GObject* _tmp10_;
		ContactsOrgRole* _tmp11_;
		FolksRole* _tmp12_;
		FolksRole* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp9_ = chunk;
		_tmp10_ = g_list_model_get_item ((GListModel*) _tmp9_, (guint) 0);
		orgrole = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, CONTACTS_TYPE_ORG_ROLE, ContactsOrgRole);
		_tmp11_ = orgrole;
		_tmp12_ = contacts_org_role_get_role (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = folks_role_get_organisation_name (_tmp13_);
		_tmp15_ = _tmp14_;
		if (g_strcmp0 (_tmp15_, "") == 0) {
			ContactsOrgRole* _tmp16_;
			FolksRole* _tmp17_;
			FolksRole* _tmp18_;
			const gchar* _tmp19_;
			_tmp16_ = orgrole;
			_tmp17_ = contacts_org_role_get_role (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = org;
			folks_role_set_organisation_name (_tmp18_, _tmp19_);
		}
		_g_object_unref0 (orgrole);
		_g_object_unref0 (chunk);
		return;
	}
	_tmp20_ = contacts_io_vcard_parser_add_chunk_child_for_property (self, contact, "roles");
	child = _tmp20_;
	_tmp21_ = child;
	_tmp22_ = contacts_org_role_get_role (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, CONTACTS_TYPE_ORG_ROLE, ContactsOrgRole));
	_tmp23_ = _tmp22_;
	_tmp24_ = org;
	folks_role_set_organisation_name (_tmp23_, _tmp24_);
	_tmp25_ = child;
	contacts_io_vcard_parser_add_params (self, _tmp25_, attr);
	_g_object_unref0 (child);
	_g_object_unref0 (chunk);
}

static void
contacts_io_vcard_parser_handle_note (ContactsIoVCardParser* self,
                                      ContactsContact* contact,
                                      EVCardAttribute* attr)
{
	gchar* note = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	ContactsBinChunkChild* child = NULL;
	ContactsBinChunkChild* _tmp4_;
	ContactsBinChunkChild* _tmp5_;
	const gchar* _tmp6_;
	ContactsBinChunkChild* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_value (attr);
	note = _tmp0_;
	_tmp2_ = note;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = note;
		_tmp1_ = g_strcmp0 (_tmp3_, "") == 0;
	}
	if (_tmp1_) {
		_g_free0 (note);
		return;
	}
	_tmp4_ = contacts_io_vcard_parser_add_chunk_child_for_property (self, contact, "notes");
	child = _tmp4_;
	_tmp5_ = child;
	_tmp6_ = note;
	contacts_note_set_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, CONTACTS_TYPE_NOTE, ContactsNote), _tmp6_);
	_tmp7_ = child;
	contacts_io_vcard_parser_add_params (self, _tmp7_, attr);
	_g_object_unref0 (child);
	_g_free0 (note);
}

static ContactsBinChunkChild*
contacts_io_vcard_parser_add_chunk_child_for_property (ContactsIoVCardParser* self,
                                                       ContactsContact* contact,
                                                       const gchar* property_name)
{
	ContactsBinChunk* chunk = NULL;
	ContactsChunk* _tmp0_;
	ContactsBinChunk* _tmp1_;
	ContactsBinChunk* _tmp2_;
	ContactsBinChunkChild* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	g_return_val_if_fail (property_name != NULL, NULL);
	_tmp0_ = contacts_contact_get_most_relevant_chunk (contact, property_name, TRUE);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CONTACTS_TYPE_BIN_CHUNK, ContactsBinChunk));
	chunk = _tmp1_;
	_tmp2_ = chunk;
	if (_tmp2_ == NULL) {
		ContactsChunk* _tmp3_;
		ContactsBinChunk* _tmp4_;
		_tmp3_ = contacts_contact_create_chunk (contact, property_name, NULL);
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CONTACTS_TYPE_BIN_CHUNK, ContactsBinChunk));
		_g_object_unref0 (chunk);
		chunk = _tmp4_;
	}
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				ContactsBinChunk* _tmp7_;
				ContactsBinChunkChild* child = NULL;
				ContactsBinChunk* _tmp8_;
				GObject* _tmp9_;
				ContactsBinChunkChild* _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				if (!_tmp5_) {
					guint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = chunk;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp7_))) {
					break;
				}
				_tmp8_ = chunk;
				_tmp9_ = g_list_model_get_item ((GListModel*) _tmp8_, i);
				child = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CONTACTS_TYPE_BIN_CHUNK_CHILD, ContactsBinChunkChild);
				_tmp10_ = child;
				_tmp11_ = contacts_bin_chunk_child_get_is_empty (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_) {
					result = child;
					_g_object_unref0 (chunk);
					return result;
				}
				_g_object_unref0 (child);
			}
		}
	}
	g_return_val_if_reached (NULL);
}

static void
contacts_io_vcard_parser_add_params (ContactsIoVCardParser* self,
                                     ContactsBinChunkChild* chunk_child,
                                     EVCardAttribute* attr)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (chunk_child != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_params (attr);
	{
		GList* param_collection = NULL;
		GList* param_it = NULL;
		param_collection = _tmp0_;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			EVCardAttributeParam* param = NULL;
			param = (EVCardAttributeParam*) param_it->data;
			{
				gchar* param_name = NULL;
				EVCardAttributeParam* _tmp1_;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				EVCardAttributeParam* _tmp4_;
				GList* _tmp5_;
				_tmp1_ = param;
				_tmp2_ = e_vcard_attribute_param_get_name (_tmp1_);
				_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) -1);
				param_name = _tmp3_;
				_tmp4_ = param;
				_tmp5_ = e_vcard_attribute_param_get_values (_tmp4_);
				{
					GList* param_value_collection = NULL;
					GList* param_value_it = NULL;
					param_value_collection = _tmp5_;
					for (param_value_it = param_value_collection; param_value_it != NULL; param_value_it = param_value_it->next) {
						const gchar* param_value = NULL;
						param_value = (const gchar*) param_value_it->data;
						{
							const gchar* _tmp6_;
							_tmp6_ = param_name;
							if (g_strcmp0 (_tmp6_, "type") == 0) {
								const gchar* _tmp7_;
								const gchar* _tmp8_;
								gchar* _tmp9_;
								gchar* _tmp10_;
								_tmp7_ = param_name;
								_tmp8_ = param_value;
								_tmp9_ = g_utf8_strdown (_tmp8_, (gssize) -1);
								_tmp10_ = _tmp9_;
								contacts_bin_chunk_child_add_parameter (chunk_child, _tmp7_, _tmp10_);
								_g_free0 (_tmp10_);
							} else {
								const gchar* _tmp11_;
								const gchar* _tmp12_;
								_tmp11_ = param_name;
								_tmp12_ = param_value;
								contacts_bin_chunk_child_add_parameter (chunk_child, _tmp11_, _tmp12_);
							}
						}
					}
				}
				_g_free0 (param_name);
			}
		}
	}
}

static void
contacts_io_vcard_parser_class_init (ContactsIoVCardParserClass * klass,
                                     gpointer klass_data)
{
	contacts_io_vcard_parser_parent_class = g_type_class_peek_parent (klass);
	((ContactsIoParserClass *) klass)->parse = (ContactsContact** (*) (ContactsIoParser*, GInputStream*, gint*, GError**)) contacts_io_vcard_parser_real_parse;
}

static void
contacts_io_vcard_parser_instance_init (ContactsIoVCardParser * self,
                                        gpointer klass)
{
}

/**
 * A {@link Contacts.Io.Parser} that specifically deals with parsing VCard
 */
 G_GNUC_NO_INLINE static GType
contacts_io_vcard_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsIoVCardParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_io_vcard_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsIoVCardParser), 0, (GInstanceInitFunc) contacts_io_vcard_parser_instance_init, NULL };
	GType contacts_io_vcard_parser_type_id;
	contacts_io_vcard_parser_type_id = g_type_register_static (CONTACTS_IO_TYPE_PARSER, "ContactsIoVCardParser", &g_define_type_info, 0);
	return contacts_io_vcard_parser_type_id;
}

GType
contacts_io_vcard_parser_get_type (void)
{
	static volatile gsize contacts_io_vcard_parser_type_id__once = 0;
	if (g_once_init_enter (&contacts_io_vcard_parser_type_id__once)) {
		GType contacts_io_vcard_parser_type_id;
		contacts_io_vcard_parser_type_id = contacts_io_vcard_parser_get_type_once ();
		g_once_init_leave (&contacts_io_vcard_parser_type_id__once, contacts_io_vcard_parser_type_id);
	}
	return contacts_io_vcard_parser_type_id__once;
}

