// components/content_settings/common/content_settings_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_CONTENT_SETTINGS_COMMON_CONTENT_SETTINGS_MANAGER_MOJOM_H_
#define COMPONENTS_CONTENT_SETTINGS_COMMON_CONTENT_SETTINGS_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/content_settings/common/content_settings_manager.mojom-features.h"  // IWYU pragma: export
#include "components/content_settings/common/content_settings_manager.mojom-shared.h"  // IWYU pragma: export
#include "components/content_settings/common/content_settings_manager.mojom-forward.h"  // IWYU pragma: export
#include "components/content_settings/core/common/content_settings_types.mojom-forward.h"
#include "components/content_settings/core/common/content_settings.mojom-forward.h"
#include "services/network/public/mojom/site_for_cookies.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace content_settings::mojom {

class ContentSettingsManagerProxy;

template <typename ImplRefTraits>
class ContentSettingsManagerStub;

class ContentSettingsManagerRequestValidator;
class ContentSettingsManagerResponseValidator;


class ContentSettingsManager
    : public ContentSettingsManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content_settings.mojom.ContentSettingsManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    974666435
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ContentSettingsManagerInterfaceBase;
  using Proxy_ = ContentSettingsManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ContentSettingsManagerStub<ImplRefTraits>;

  using RequestValidator_ = ContentSettingsManagerRequestValidator;
  using ResponseValidator_ = ContentSettingsManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCloneMinVersion = 0,
    kAllowStorageAccessMinVersion = 0,
    kOnContentBlockedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AllowStorageAccess_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnContentBlocked_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  using StorageType = ContentSettingsManager_StorageType;
  virtual ~ContentSettingsManager() = default;

  virtual void Clone(::mojo::PendingReceiver<ContentSettingsManager> clone) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool AllowStorageAccess(const ::blink::LocalFrameToken& frame_token, ContentSettingsManager::StorageType storage_type, const ::url::Origin& origin, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, bool* out_allowed);
  using AllowStorageAccessCallback = base::OnceCallback<void(bool)>;
  using AllowStorageAccessMojoCallback = base::OnceCallback<void(bool)>;

  virtual void AllowStorageAccess(const ::blink::LocalFrameToken& frame_token, ContentSettingsManager::StorageType storage_type, const ::url::Origin& origin, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, AllowStorageAccessCallback callback) = 0;

  virtual void OnContentBlocked(const ::blink::LocalFrameToken& frame_token, ::content_settings::mojom::ContentSettingsType type) = 0;
};



class  ContentSettingsManagerProxy
    : public ContentSettingsManager {
 public:
  using InterfaceType = ContentSettingsManager;

  explicit ContentSettingsManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Clone(::mojo::PendingReceiver<ContentSettingsManager> clone) final;
  
  bool AllowStorageAccess(const ::blink::LocalFrameToken& frame_token, ContentSettingsManager::StorageType storage_type, const ::url::Origin& origin, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, bool* out_allowed) final;
  
  void AllowStorageAccess(const ::blink::LocalFrameToken& frame_token, ContentSettingsManager::StorageType storage_type, const ::url::Origin& origin, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, AllowStorageAccessCallback callback) final;
  
  void OnContentBlocked(const ::blink::LocalFrameToken& frame_token, ::content_settings::mojom::ContentSettingsType type) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ContentSettingsManagerStubDispatch {
 public:
  static bool Accept(ContentSettingsManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ContentSettingsManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ContentSettingsManager>>
class ContentSettingsManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ContentSettingsManagerStub() = default;
  ~ContentSettingsManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContentSettingsManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContentSettingsManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ContentSettingsManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ContentSettingsManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // content_settings::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_CONTENT_SETTINGS_COMMON_CONTENT_SETTINGS_MANAGER_MOJOM_H_