// components/paint_preview/common/mojom/paint_preview_recorder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-params-data.h"
#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-shared-message-ids.h"

#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-import-headers.h"
#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-test-utils.h"


namespace paint_preview::mojom {
PaintPreviewCaptureParams::PaintPreviewCaptureParams()
    : persistence(),
      guid(),
      clip_rect(),
      clip_rect_is_hint(),
      is_main_frame(),
      capture_links(),
      file(),
      max_capture_size(),
      max_decoded_image_size_bytes(),
      skip_accelerated_content() {}

PaintPreviewCaptureParams::PaintPreviewCaptureParams(
    ::paint_preview::RecordingPersistence persistence_in,
    const ::base::UnguessableToken& guid_in,
    const ::gfx::Rect& clip_rect_in,
    bool clip_rect_is_hint_in,
    bool is_main_frame_in,
    bool capture_links_in,
    ::base::File file_in,
    uint64_t max_capture_size_in,
    uint64_t max_decoded_image_size_bytes_in,
    bool skip_accelerated_content_in)
    : persistence(std::move(persistence_in)),
      guid(std::move(guid_in)),
      clip_rect(std::move(clip_rect_in)),
      clip_rect_is_hint(std::move(clip_rect_is_hint_in)),
      is_main_frame(std::move(is_main_frame_in)),
      capture_links(std::move(capture_links_in)),
      file(std::move(file_in)),
      max_capture_size(std::move(max_capture_size_in)),
      max_decoded_image_size_bytes(std::move(max_decoded_image_size_bytes_in)),
      skip_accelerated_content(std::move(skip_accelerated_content_in)) {}

PaintPreviewCaptureParams::~PaintPreviewCaptureParams() = default;

void PaintPreviewCaptureParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "persistence"), this->persistence,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::paint_preview::RecordingPersistence>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "guid"), this->guid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clip_rect"), this->clip_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clip_rect_is_hint"), this->clip_rect_is_hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_main_frame"), this->is_main_frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_links"), this->capture_links,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file"), this->file,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_capture_size"), this->max_capture_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_decoded_image_size_bytes"), this->max_decoded_image_size_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "skip_accelerated_content"), this->skip_accelerated_content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaintPreviewCaptureParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LinkData::LinkData()
    : url(),
      rect() {}

LinkData::LinkData(
    const ::GURL& url_in,
    const ::gfx::Rect& rect_in)
    : url(std::move(url_in)),
      rect(std::move(rect_in)) {}

LinkData::~LinkData() = default;

void LinkData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rect"), this->rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LinkData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaintPreviewCaptureResponse::PaintPreviewCaptureResponse()
    : embedding_token(),
      content_id_to_embedding_token(),
      links(),
      blink_recording_time(),
      serialized_size(),
      scroll_offsets(),
      frame_offsets(),
      skp() {}

PaintPreviewCaptureResponse::PaintPreviewCaptureResponse(
    const std::optional<::base::UnguessableToken>& embedding_token_in,
    const base::flat_map<uint32_t, ::base::UnguessableToken>& content_id_to_embedding_token_in,
    std::vector<LinkDataPtr> links_in,
    ::base::TimeDelta blink_recording_time_in,
    uint64_t serialized_size_in,
    const ::gfx::Point& scroll_offsets_in,
    const ::gfx::Point& frame_offsets_in,
    std::optional<::mojo_base::BigBuffer> skp_in)
    : embedding_token(std::move(embedding_token_in)),
      content_id_to_embedding_token(std::move(content_id_to_embedding_token_in)),
      links(std::move(links_in)),
      blink_recording_time(std::move(blink_recording_time_in)),
      serialized_size(std::move(serialized_size_in)),
      scroll_offsets(std::move(scroll_offsets_in)),
      frame_offsets(std::move(frame_offsets_in)),
      skp(std::move(skp_in)) {}

PaintPreviewCaptureResponse::~PaintPreviewCaptureResponse() = default;

void PaintPreviewCaptureResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "embedding_token"), this->embedding_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_id_to_embedding_token"), this->content_id_to_embedding_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<uint32_t, ::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "links"), this->links,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<LinkDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blink_recording_time"), this->blink_recording_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "serialized_size"), this->serialized_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_offsets"), this->scroll_offsets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_offsets"), this->frame_offsets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "skp"), this->skp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::mojo_base::BigBuffer>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaintPreviewCaptureResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PaintPreviewRecorder::IPCStableHashFunction PaintPreviewRecorder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PaintPreviewRecorder>(message.name())) {
    case messages::PaintPreviewRecorder::kCapturePaintPreview: {
      return &PaintPreviewRecorder::CapturePaintPreview_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PaintPreviewRecorder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PaintPreviewRecorder>(message.name())) {
      case messages::PaintPreviewRecorder::kCapturePaintPreview:
            return "Receive paint_preview::mojom::PaintPreviewRecorder::CapturePaintPreview";
    }
  } else {
    switch (static_cast<messages::PaintPreviewRecorder>(message.name())) {
      case messages::PaintPreviewRecorder::kCapturePaintPreview:
            return "Receive reply paint_preview::mojom::PaintPreviewRecorder::CapturePaintPreview";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PaintPreviewRecorder::CapturePaintPreview_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb3243f8a;  // IPCStableHash for paint_preview::mojom::PaintPreviewRecorder::CapturePaintPreview
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PaintPreviewRecorder_CapturePaintPreview_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaintPreviewRecorder_CapturePaintPreview_ForwardToCallback(
      PaintPreviewRecorder::CapturePaintPreviewCallback callback
      ) : callback_(std::move(callback)) {
  }

  PaintPreviewRecorder_CapturePaintPreview_ForwardToCallback(const PaintPreviewRecorder_CapturePaintPreview_ForwardToCallback&) = delete;
  PaintPreviewRecorder_CapturePaintPreview_ForwardToCallback& operator=(const PaintPreviewRecorder_CapturePaintPreview_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PaintPreviewRecorder::CapturePaintPreviewCallback callback_;
};

PaintPreviewRecorderProxy::PaintPreviewRecorderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PaintPreviewRecorderProxy::CapturePaintPreview(
    PaintPreviewCaptureParamsPtr in_params, CapturePaintPreviewCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send paint_preview::mojom::PaintPreviewRecorder::CapturePaintPreview", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type PaintPreviewCaptureParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaintPreviewRecorder::kCapturePaintPreview), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewRecorder_CapturePaintPreview_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::paint_preview::mojom::PaintPreviewCaptureParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in PaintPreviewRecorder.CapturePaintPreview request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewRecorder::Name_);
  message.set_method_name("CapturePaintPreview");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaintPreviewRecorder_CapturePaintPreview_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PaintPreviewRecorder::CapturePaintPreviewCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder> proxy(
        new PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaintPreviewRecorder::CapturePaintPreviewCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaintPreviewStatus in_status, PaintPreviewCaptureResponsePtr in_response);
};

bool PaintPreviewRecorder_CapturePaintPreview_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PaintPreviewRecorder.0
  bool success = true;
  PaintPreviewStatus p_status{};
  PaintPreviewCaptureResponsePtr p_response{};
  PaintPreviewRecorder_CapturePaintPreview_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResponse(&p_response))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaintPreviewRecorder::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_response));
  }
  return true;
}

void PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder::Run(
    PaintPreviewStatus in_status, PaintPreviewCaptureResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply paint_preview::mojom::PaintPreviewRecorder::CapturePaintPreview", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PaintPreviewStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type PaintPreviewCaptureResponsePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaintPreviewRecorder::kCapturePaintPreview), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::paint_preview::mojom::PaintPreviewStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  
  mojo::internal::Serialize<::paint_preview::mojom::PaintPreviewCaptureResponseDataView>(
    in_response,
    response_fragment);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewRecorder::Name_);
  message.set_method_name("CapturePaintPreview");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PaintPreviewRecorderStubDispatch::Accept(
    PaintPreviewRecorder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PaintPreviewRecorder>(message->header()->name)) {
    case messages::PaintPreviewRecorder::kCapturePaintPreview: {
      break;
    }
  }
  return false;
}

// static
bool PaintPreviewRecorderStubDispatch::AcceptWithResponder(
    PaintPreviewRecorder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PaintPreviewRecorder>(message->header()->name)) {
    case messages::PaintPreviewRecorder::kCapturePaintPreview: {
      internal::PaintPreviewRecorder_CapturePaintPreview_Params_Data* params =
          reinterpret_cast<
              internal::PaintPreviewRecorder_CapturePaintPreview_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PaintPreviewRecorder.0
      bool success = true;
      PaintPreviewCaptureParamsPtr p_params{};
      PaintPreviewRecorder_CapturePaintPreview_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaintPreviewRecorder::Name_, 0, false);
        return false;
      }
      auto callback =
          PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CapturePaintPreview(        
        std::move(p_params), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPaintPreviewRecorderValidationInfo[] = {
    {base::to_underlying(messages::PaintPreviewRecorder::kCapturePaintPreview),
     { &internal::PaintPreviewRecorder_CapturePaintPreview_Params_Data::Validate,
      &internal::PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data::Validate}},
};

bool PaintPreviewRecorderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::paint_preview::mojom::PaintPreviewRecorder::Name_,
    kPaintPreviewRecorderValidationInfo);
}

bool PaintPreviewRecorderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::paint_preview::mojom::PaintPreviewRecorder::Name_,
    kPaintPreviewRecorderValidationInfo);

}


}  // paint_preview::mojom


namespace mojo {


// static
bool StructTraits<::paint_preview::mojom::PaintPreviewCaptureParams::DataView, ::paint_preview::mojom::PaintPreviewCaptureParamsPtr>::Read(
    ::paint_preview::mojom::PaintPreviewCaptureParams::DataView input,
    ::paint_preview::mojom::PaintPreviewCaptureParamsPtr* output) {
  bool success = true;
  ::paint_preview::mojom::PaintPreviewCaptureParamsPtr result(::paint_preview::mojom::PaintPreviewCaptureParams::New());
  
      if (success && !input.ReadPersistence(&result->persistence))
        success = false;
      if (success && !input.ReadGuid(&result->guid))
        success = false;
      if (success && !input.ReadClipRect(&result->clip_rect))
        success = false;
      if (success)
        result->clip_rect_is_hint = input.clip_rect_is_hint();
      if (success)
        result->is_main_frame = input.is_main_frame();
      if (success)
        result->capture_links = input.capture_links();
      if (success && !input.ReadFile(&result->file))
        success = false;
      if (success)
        result->max_capture_size = input.max_capture_size();
      if (success)
        result->max_decoded_image_size_bytes = input.max_decoded_image_size_bytes();
      if (success)
        result->skip_accelerated_content = input.skip_accelerated_content();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::paint_preview::mojom::LinkData::DataView, ::paint_preview::mojom::LinkDataPtr>::Read(
    ::paint_preview::mojom::LinkData::DataView input,
    ::paint_preview::mojom::LinkDataPtr* output) {
  bool success = true;
  ::paint_preview::mojom::LinkDataPtr result(::paint_preview::mojom::LinkData::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadRect(&result->rect))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::paint_preview::mojom::PaintPreviewCaptureResponse::DataView, ::paint_preview::mojom::PaintPreviewCaptureResponsePtr>::Read(
    ::paint_preview::mojom::PaintPreviewCaptureResponse::DataView input,
    ::paint_preview::mojom::PaintPreviewCaptureResponsePtr* output) {
  bool success = true;
  ::paint_preview::mojom::PaintPreviewCaptureResponsePtr result(::paint_preview::mojom::PaintPreviewCaptureResponse::New());
  
      if (success && !input.ReadEmbeddingToken(&result->embedding_token))
        success = false;
      if (success && !input.ReadContentIdToEmbeddingToken(&result->content_id_to_embedding_token))
        success = false;
      if (success && !input.ReadLinks(&result->links))
        success = false;
      if (success && !input.ReadBlinkRecordingTime(&result->blink_recording_time))
        success = false;
      if (success)
        result->serialized_size = input.serialized_size();
      if (success && !input.ReadScrollOffsets(&result->scroll_offsets))
        success = false;
      if (success && !input.ReadFrameOffsets(&result->frame_offsets))
        success = false;
      if (success && !input.ReadSkp(&result->skp))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace paint_preview::mojom {


void PaintPreviewRecorderInterceptorForTesting::CapturePaintPreview(PaintPreviewCaptureParamsPtr params, CapturePaintPreviewCallback callback) {
  GetForwardingInterface()->CapturePaintPreview(
    std::move(params)
    , std::move(callback));
}
PaintPreviewRecorderAsyncWaiter::PaintPreviewRecorderAsyncWaiter(
    PaintPreviewRecorder* proxy) : proxy_(proxy) {}

PaintPreviewRecorderAsyncWaiter::~PaintPreviewRecorderAsyncWaiter() = default;


void PaintPreviewRecorderAsyncWaiter::CapturePaintPreview(
    PaintPreviewCaptureParamsPtr params, PaintPreviewStatus* out_status, PaintPreviewCaptureResponsePtr* out_response) {
  base::RunLoop loop;
  proxy_->CapturePaintPreview(
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             PaintPreviewStatus* out_status
,
             PaintPreviewCaptureResponsePtr* out_response
,
             PaintPreviewStatus status,
             PaintPreviewCaptureResponsePtr response) {*out_status = std::move(status);*out_response = std::move(response);
            loop->Quit();
          },
          &loop,
          out_status,
          out_response));
  loop.Run();
}








}  // paint_preview::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif