// content/browser/attribution_reporting/attribution_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_ATTRIBUTION_REPORTING_ATTRIBUTION_INTERNALS_MOJOM_DATA_VIEW_H_
#define CONTENT_BROWSER_ATTRIBUTION_REPORTING_ATTRIBUTION_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "content/browser/attribution_reporting/attribution_internals.mojom-shared-internal.h"
#include "components/attribution_reporting/registration.mojom-shared.h"
#include "components/attribution_reporting/source_type.mojom-shared.h"
#include "components/attribution_reporting/trigger_data_matching.mojom-shared.h"
#include "content/browser/attribution_reporting/aggregatable_result.mojom-shared.h"
#include "content/browser/attribution_reporting/process_aggregatable_debug_report_result.mojom-shared.h"
#include "content/browser/attribution_reporting/attribution_reporting.mojom-shared.h"
#include "content/browser/attribution_reporting/event_level_result.mojom-shared.h"
#include "content/browser/attribution_reporting/store_source_result.mojom-shared.h"
#include "services/network/public/mojom/attribution.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace attribution_internals::mojom {
class ReportIDDataView;

class WebUIReportEventLevelDataDataView;

class AggregatableHistogramContributionDataView;

class WebUIReportAggregatableAttributionDataDataView;

class EmptyDataView;

class WebUIReportDataView;

class WebUIDebugReportDataView;

class WebUIAggregatableDebugReportDataView;

class WebUISourceDataView;

class WebUIRegistrationDataView;

class WebUITriggerDataView;

class WebUISourceRegistrationDataView;

class WebUIOsRegistrationDataView;

class WebUIReportDataDataView;
class NetworkStatusDataView;
class ReportStatusDataView;
class SendAggregatableDebugReportResultDataView;


}  // attribution_internals::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::attribution_internals::mojom::ReportIDDataView> {
  using Data = ::attribution_internals::mojom::internal::ReportID_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_internals::mojom::WebUIReportEventLevelDataDataView> {
  using Data = ::attribution_internals::mojom::internal::WebUIReportEventLevelData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_internals::mojom::AggregatableHistogramContributionDataView> {
  using Data = ::attribution_internals::mojom::internal::AggregatableHistogramContribution_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_internals::mojom::WebUIReportAggregatableAttributionDataDataView> {
  using Data = ::attribution_internals::mojom::internal::WebUIReportAggregatableAttributionData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_internals::mojom::EmptyDataView> {
  using Data = ::attribution_internals::mojom::internal::Empty_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_internals::mojom::WebUIReportDataView> {
  using Data = ::attribution_internals::mojom::internal::WebUIReport_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_internals::mojom::WebUIDebugReportDataView> {
  using Data = ::attribution_internals::mojom::internal::WebUIDebugReport_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_internals::mojom::WebUIAggregatableDebugReportDataView> {
  using Data = ::attribution_internals::mojom::internal::WebUIAggregatableDebugReport_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_internals::mojom::WebUISourceDataView> {
  using Data = ::attribution_internals::mojom::internal::WebUISource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_internals::mojom::WebUIRegistrationDataView> {
  using Data = ::attribution_internals::mojom::internal::WebUIRegistration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_internals::mojom::WebUITriggerDataView> {
  using Data = ::attribution_internals::mojom::internal::WebUITrigger_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_internals::mojom::WebUISourceRegistrationDataView> {
  using Data = ::attribution_internals::mojom::internal::WebUISourceRegistration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_internals::mojom::WebUIOsRegistrationDataView> {
  using Data = ::attribution_internals::mojom::internal::WebUIOsRegistration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_internals::mojom::WebUIReportDataDataView> {
  using Data = ::attribution_internals::mojom::internal::WebUIReportData_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::attribution_internals::mojom::NetworkStatusDataView> {
  using Data = ::attribution_internals::mojom::internal::NetworkStatus_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::attribution_internals::mojom::ReportStatusDataView> {
  using Data = ::attribution_internals::mojom::internal::ReportStatus_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::attribution_internals::mojom::SendAggregatableDebugReportResultDataView> {
  using Data = ::attribution_internals::mojom::internal::SendAggregatableDebugReportResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace attribution_internals::mojom {


enum class WebUISource_Attributability : int32_t {
  
  kAttributable = 0,
  
  kNoisedNever = 1,
  
  kNoisedFalsely = 2,
  
  kReachedEventLevelAttributionLimit = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, WebUISource_Attributability value);
inline bool IsKnownEnumValue(WebUISource_Attributability value) {
  return internal::WebUISource_Attributability_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ObserverInterfaceBase {};

using ObserverPtrDataView =
    mojo::InterfacePtrDataView<ObserverInterfaceBase>;
using ObserverRequestDataView =
    mojo::InterfaceRequestDataView<ObserverInterfaceBase>;
using ObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ObserverInterfaceBase>;
using ObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ObserverInterfaceBase>;
class HandlerInterfaceBase {};

using HandlerPtrDataView =
    mojo::InterfacePtrDataView<HandlerInterfaceBase>;
using HandlerRequestDataView =
    mojo::InterfaceRequestDataView<HandlerInterfaceBase>;
using HandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HandlerInterfaceBase>;
using HandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HandlerInterfaceBase>;
class FactoryInterfaceBase {};

using FactoryPtrDataView =
    mojo::InterfacePtrDataView<FactoryInterfaceBase>;
using FactoryRequestDataView =
    mojo::InterfaceRequestDataView<FactoryInterfaceBase>;
using FactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FactoryInterfaceBase>;
using FactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FactoryInterfaceBase>;


class ReportIDDataView {
 public:
  ReportIDDataView() = default;

  ReportIDDataView(
      internal::ReportID_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t value() const {
    return data_->value;
  }
 private:
  internal::ReportID_Data* data_ = nullptr;
};


class WebUIReportEventLevelDataDataView {
 public:
  WebUIReportEventLevelDataDataView() = default;

  WebUIReportEventLevelDataDataView(
      internal::WebUIReportEventLevelData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t priority() const {
    return data_->priority;
  }
  bool attributed_truthfully() const {
    return data_->attributed_truthfully;
  }
 private:
  internal::WebUIReportEventLevelData_Data* data_ = nullptr;
};


class AggregatableHistogramContributionDataView {
 public:
  AggregatableHistogramContributionDataView() = default;

  AggregatableHistogramContributionDataView(
      internal::AggregatableHistogramContribution_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t value() const {
    return data_->value;
  }
  uint64_t filtering_id() const {
    return data_->filtering_id;
  }
 private:
  internal::AggregatableHistogramContribution_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebUIReportAggregatableAttributionDataDataView {
 public:
  WebUIReportAggregatableAttributionDataDataView() = default;

  WebUIReportAggregatableAttributionDataDataView(
      internal::WebUIReportAggregatableAttributionData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetContributionsDataView(
      mojo::ArrayDataView<AggregatableHistogramContributionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContributions(UserType* output) {
    
    auto* pointer = data_->contributions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::attribution_internals::mojom::AggregatableHistogramContributionDataView>>(
        pointer, output, message_);
  }
  inline void GetAggregationCoordinatorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregationCoordinator(UserType* output) {
    
    auto* pointer = data_->aggregation_coordinator.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_null_report() const {
    return data_->is_null_report;
  }
 private:
  internal::WebUIReportAggregatableAttributionData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EmptyDataView {
 public:
  EmptyDataView() = default;

  EmptyDataView(
      internal::Empty_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Empty_Data* data_ = nullptr;
};


class WebUIReportDataView {
 public:
  WebUIReportDataView() = default;

  WebUIReportDataView(
      internal::WebUIReport_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ReportIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::attribution_internals::mojom::ReportIDDataView>(
        pointer, output, message_);
  }
  inline void GetReportUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportUrl(UserType* output) {
    
    auto* pointer = data_->report_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  double trigger_time() const {
    return data_->trigger_time;
  }
  double report_time() const {
    return data_->report_time;
  }
  inline void GetReportBodyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportBody(UserType* output) {
    
    auto* pointer = data_->report_body.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStatusDataView(
      ReportStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = !data_->status.is_null() ? &data_->status : nullptr;
    return mojo::internal::Deserialize<::attribution_internals::mojom::ReportStatusDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      WebUIReportDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::attribution_internals::mojom::WebUIReportDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebUIReport_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebUIDebugReportDataView {
 public:
  WebUIDebugReportDataView() = default;

  WebUIDebugReportDataView(
      internal::WebUIDebugReport_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  double time() const {
    return data_->time;
  }
  inline void GetBodyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBody(UserType* output) {
    
    auto* pointer = data_->body.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStatusDataView(
      NetworkStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = !data_->status.is_null() ? &data_->status : nullptr;
    return mojo::internal::Deserialize<::attribution_internals::mojom::NetworkStatusDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebUIDebugReport_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebUIAggregatableDebugReportDataView {
 public:
  WebUIAggregatableDebugReportDataView() = default;

  WebUIAggregatableDebugReportDataView(
      internal::WebUIAggregatableDebugReport_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  double time() const {
    return data_->time;
  }
  inline void GetBodyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBody(UserType* output) {
    
    auto* pointer = data_->body.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadProcessResult(UserType* output) const {
    auto data_value = data_->process_result;
    return mojo::internal::Deserialize<::attribution_reporting::mojom::ProcessAggregatableDebugReportResult>(
        data_value, output);
  }
  ::attribution_reporting::mojom::ProcessAggregatableDebugReportResult process_result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::attribution_reporting::mojom::ProcessAggregatableDebugReportResult>(data_->process_result));
  }
  inline void GetSendResultDataView(
      SendAggregatableDebugReportResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSendResult(UserType* output) {
    
    auto* pointer = !data_->send_result.is_null() ? &data_->send_result : nullptr;
    return mojo::internal::Deserialize<::attribution_internals::mojom::SendAggregatableDebugReportResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebUIAggregatableDebugReport_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebUISourceDataView {
 public:
  WebUISourceDataView() = default;

  WebUISourceDataView(
      internal::WebUISource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t id() const {
    return data_->id;
  }
  uint64_t source_event_id() const {
    return data_->source_event_id;
  }
  inline void GetSourceOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceOrigin(UserType* output) {
    
    auto* pointer = data_->source_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetDestinationsDataView(
      ::attribution_reporting::mojom::DestinationSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDestinations(UserType* output) {
    
    auto* pointer = data_->destinations.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::DestinationSetDataView>(
        pointer, output, message_);
  }
  inline void GetReportingOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportingOrigin(UserType* output) {
    
    auto* pointer = data_->reporting_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  double source_time() const {
    return data_->source_time;
  }
  double expiry_time() const {
    return data_->expiry_time;
  }
  inline void GetEventReportWindowsDataView(
      ::attribution_reporting::mojom::EventReportWindowsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventReportWindows(UserType* output) {
    
    auto* pointer = data_->event_report_windows.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::EventReportWindowsDataView>(
        pointer, output, message_);
  }
  inline void GetTriggerDataDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTriggerData(UserType* output) {
    
    auto* pointer = data_->trigger_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  int32_t max_event_level_reports() const {
    return data_->max_event_level_reports;
  }
  double aggregatable_report_window_time() const {
    return data_->aggregatable_report_window_time;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSourceType(UserType* output) const {
    auto data_value = data_->source_type;
    return mojo::internal::Deserialize<::attribution_reporting::mojom::SourceType>(
        data_value, output);
  }
  ::attribution_reporting::mojom::SourceType source_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::attribution_reporting::mojom::SourceType>(data_->source_type));
  }
  int64_t priority() const {
    return data_->priority;
  }
  std::optional<uint64_t> debug_key() const {

    return data_->debug_key_$flag
        ? std::make_optional(data_->debug_key_$value)
        : std::nullopt;
  }
  inline void GetDedupKeysDataView(
      mojo::ArrayDataView<uint64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDedupKeys(UserType* output) {
    
    auto* pointer = data_->dedup_keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint64_t>>(
        pointer, output, message_);
  }
  inline void GetFilterDataDataView(
      ::attribution_reporting::mojom::FilterDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilterData(UserType* output) {
    
    auto* pointer = data_->filter_data.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::FilterDataDataView>(
        pointer, output, message_);
  }
  inline void GetAggregationKeysDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregationKeys(UserType* output) {
    
    auto* pointer = data_->aggregation_keys.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
  int32_t remaining_aggregatable_attribution_budget() const {
    return data_->remaining_aggregatable_attribution_budget;
  }
  inline void GetAggregatableDedupKeysDataView(
      mojo::ArrayDataView<uint64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregatableDedupKeys(UserType* output) {
    
    auto* pointer = data_->aggregatable_dedup_keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint64_t>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTriggerDataMatching(UserType* output) const {
    auto data_value = data_->trigger_data_matching;
    return mojo::internal::Deserialize<::attribution_reporting::mojom::TriggerDataMatching>(
        data_value, output);
  }
  ::attribution_reporting::mojom::TriggerDataMatching trigger_data_matching() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::attribution_reporting::mojom::TriggerDataMatching>(data_->trigger_data_matching));
  }
  double event_level_epsilon() const {
    return data_->event_level_epsilon;
  }
  bool cookie_based_debug_allowed() const {
    return data_->cookie_based_debug_allowed;
  }
  int32_t remaining_aggregatable_debug_budget() const {
    return data_->remaining_aggregatable_debug_budget;
  }
  inline void GetAggregatableDebugKeyPieceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregatableDebugKeyPiece(UserType* output) {
    
    auto* pointer = data_->aggregatable_debug_key_piece.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAttributionScopesDataJsonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttributionScopesDataJson(UserType* output) {
    
    auto* pointer = data_->attribution_scopes_data_json.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAggregatableNamedBudgetsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregatableNamedBudgets(UserType* output) {
    
    auto* pointer = data_->aggregatable_named_budgets.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAttributability(UserType* output) const {
    auto data_value = data_->attributability;
    return mojo::internal::Deserialize<::attribution_internals::mojom::WebUISource_Attributability>(
        data_value, output);
  }
  WebUISource_Attributability attributability() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::attribution_internals::mojom::WebUISource_Attributability>(data_->attributability));
  }
 private:
  internal::WebUISource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebUIRegistrationDataView {
 public:
  WebUIRegistrationDataView() = default;

  WebUIRegistrationDataView(
      internal::WebUIRegistration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  double time() const {
    return data_->time;
  }
  inline void GetContextOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContextOrigin(UserType* output) {
    
    auto* pointer = data_->context_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetReportingOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportingOrigin(UserType* output) {
    
    auto* pointer = data_->reporting_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetRegistrationJsonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegistrationJson(UserType* output) {
    
    auto* pointer = data_->registration_json.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  std::optional<uint64_t> cleared_debug_key() const {

    return data_->cleared_debug_key_$flag
        ? std::make_optional(data_->cleared_debug_key_$value)
        : std::nullopt;
  }
 private:
  internal::WebUIRegistration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebUITriggerDataView {
 public:
  WebUITriggerDataView() = default;

  WebUITriggerDataView(
      internal::WebUITrigger_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRegistrationDataView(
      WebUIRegistrationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegistration(UserType* output) {
    
    auto* pointer = data_->registration.Get();
    return mojo::internal::Deserialize<::attribution_internals::mojom::WebUIRegistrationDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEventLevelResult(UserType* output) const {
    auto data_value = data_->event_level_result;
    return mojo::internal::Deserialize<::attribution_reporting::mojom::EventLevelResult>(
        data_value, output);
  }
  ::attribution_reporting::mojom::EventLevelResult event_level_result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::attribution_reporting::mojom::EventLevelResult>(data_->event_level_result));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAggregatableResult(UserType* output) const {
    auto data_value = data_->aggregatable_result;
    return mojo::internal::Deserialize<::attribution_reporting::mojom::AggregatableResult>(
        data_value, output);
  }
  ::attribution_reporting::mojom::AggregatableResult aggregatable_result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::attribution_reporting::mojom::AggregatableResult>(data_->aggregatable_result));
  }
 private:
  internal::WebUITrigger_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebUISourceRegistrationDataView {
 public:
  WebUISourceRegistrationDataView() = default;

  WebUISourceRegistrationDataView(
      internal::WebUISourceRegistration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRegistrationDataView(
      WebUIRegistrationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegistration(UserType* output) {
    
    auto* pointer = data_->registration.Get();
    return mojo::internal::Deserialize<::attribution_internals::mojom::WebUIRegistrationDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::attribution_reporting::mojom::SourceType>(
        data_value, output);
  }
  ::attribution_reporting::mojom::SourceType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::attribution_reporting::mojom::SourceType>(data_->type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::attribution_reporting::mojom::StoreSourceResult>(
        data_value, output);
  }
  ::attribution_reporting::mojom::StoreSourceResult status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::attribution_reporting::mojom::StoreSourceResult>(data_->status));
  }
 private:
  internal::WebUISourceRegistration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebUIOsRegistrationDataView {
 public:
  WebUIOsRegistrationDataView() = default;

  WebUIOsRegistrationDataView(
      internal::WebUIOsRegistration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  double time() const {
    return data_->time;
  }
  inline void GetRegistrationUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegistrationUrl(UserType* output) {
    
    auto* pointer = data_->registration_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTopLevelOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopLevelOrigin(UserType* output) {
    
    auto* pointer = data_->top_level_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  bool is_debug_key_allowed() const {
    return data_->is_debug_key_allowed;
  }
  bool debug_reporting() const {
    return data_->debug_reporting;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::attribution_reporting::mojom::RegistrationType>(
        data_value, output);
  }
  ::attribution_reporting::mojom::RegistrationType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::attribution_reporting::mojom::RegistrationType>(data_->type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::attribution_reporting::mojom::OsRegistrationResult>(
        data_value, output);
  }
  ::attribution_reporting::mojom::OsRegistrationResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::attribution_reporting::mojom::OsRegistrationResult>(data_->result));
  }
 private:
  internal::WebUIOsRegistration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebUIReportDataDataView {
 public:
  using Tag = internal::WebUIReportData_Data::WebUIReportData_Tag;

  WebUIReportDataDataView() = default;

  WebUIReportDataDataView(
      internal::WebUIReportData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_event_level_data() const { return data_->tag == Tag::kEventLevelData; }
  inline void GetEventLevelDataDataView(
      WebUIReportEventLevelDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadEventLevelData(UserType* output) const {
    
    CHECK(is_event_level_data());
    return mojo::internal::Deserialize<::attribution_internals::mojom::WebUIReportEventLevelDataDataView>(
        data_->data.f_event_level_data.Get(), output, message_);
  }
  bool is_aggregatable_attribution_data() const { return data_->tag == Tag::kAggregatableAttributionData; }
  inline void GetAggregatableAttributionDataDataView(
      WebUIReportAggregatableAttributionDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadAggregatableAttributionData(UserType* output) const {
    
    CHECK(is_aggregatable_attribution_data());
    return mojo::internal::Deserialize<::attribution_internals::mojom::WebUIReportAggregatableAttributionDataDataView>(
        data_->data.f_aggregatable_attribution_data.Get(), output, message_);
  }

 private:
  internal::WebUIReportData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class NetworkStatusDataView {
 public:
  using Tag = internal::NetworkStatus_Data::NetworkStatus_Tag;

  NetworkStatusDataView() = default;

  NetworkStatusDataView(
      internal::NetworkStatus_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_http_response_code() const { return data_->tag == Tag::kHttpResponseCode; }
  int32_t http_response_code() const {
    CHECK(is_http_response_code());
    return data_->data.f_http_response_code;
  }
  bool is_network_error() const { return data_->tag == Tag::kNetworkError; }
  inline void GetNetworkErrorDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNetworkError(UserType* output) const {
    
    CHECK(is_network_error());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_network_error.Get(), output, message_);
  }

 private:
  internal::NetworkStatus_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class ReportStatusDataView {
 public:
  using Tag = internal::ReportStatus_Data::ReportStatus_Tag;

  ReportStatusDataView() = default;

  ReportStatusDataView(
      internal::ReportStatus_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_pending() const { return data_->tag == Tag::kPending; }
  inline void GetPendingDataView(
      EmptyDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPending(UserType* output) const {
    
    CHECK(is_pending());
    return mojo::internal::Deserialize<::attribution_internals::mojom::EmptyDataView>(
        data_->data.f_pending.Get(), output, message_);
  }
  bool is_replaced_by_higher_priority_report() const { return data_->tag == Tag::kReplacedByHigherPriorityReport; }
  inline void GetReplacedByHigherPriorityReportDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadReplacedByHigherPriorityReport(UserType* output) const {
    
    CHECK(is_replaced_by_higher_priority_report());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_replaced_by_higher_priority_report.Get(), output, message_);
  }
  bool is_prohibited_by_browser_policy() const { return data_->tag == Tag::kProhibitedByBrowserPolicy; }
  inline void GetProhibitedByBrowserPolicyDataView(
      EmptyDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadProhibitedByBrowserPolicy(UserType* output) const {
    
    CHECK(is_prohibited_by_browser_policy());
    return mojo::internal::Deserialize<::attribution_internals::mojom::EmptyDataView>(
        data_->data.f_prohibited_by_browser_policy.Get(), output, message_);
  }
  bool is_expired() const { return data_->tag == Tag::kExpired; }
  inline void GetExpiredDataView(
      EmptyDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadExpired(UserType* output) const {
    
    CHECK(is_expired());
    return mojo::internal::Deserialize<::attribution_internals::mojom::EmptyDataView>(
        data_->data.f_expired.Get(), output, message_);
  }
  bool is_network_status() const { return data_->tag == Tag::kNetworkStatus; }
  inline void GetNetworkStatusDataView(
      NetworkStatusDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNetworkStatus(UserType* output) const {
    
    CHECK(is_network_status());
    return mojo::internal::Deserialize<::attribution_internals::mojom::NetworkStatusDataView>(
        data_->data.f_network_status.Get(), output, message_);
  }
  bool is_failed_to_assemble() const { return data_->tag == Tag::kFailedToAssemble; }
  inline void GetFailedToAssembleDataView(
      EmptyDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFailedToAssemble(UserType* output) const {
    
    CHECK(is_failed_to_assemble());
    return mojo::internal::Deserialize<::attribution_internals::mojom::EmptyDataView>(
        data_->data.f_failed_to_assemble.Get(), output, message_);
  }

 private:
  internal::ReportStatus_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class SendAggregatableDebugReportResultDataView {
 public:
  using Tag = internal::SendAggregatableDebugReportResult_Data::SendAggregatableDebugReportResult_Tag;

  SendAggregatableDebugReportResultDataView() = default;

  SendAggregatableDebugReportResultDataView(
      internal::SendAggregatableDebugReportResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_assembly_failed() const { return data_->tag == Tag::kAssemblyFailed; }
  inline void GetAssemblyFailedDataView(
      EmptyDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadAssemblyFailed(UserType* output) const {
    
    CHECK(is_assembly_failed());
    return mojo::internal::Deserialize<::attribution_internals::mojom::EmptyDataView>(
        data_->data.f_assembly_failed.Get(), output, message_);
  }
  bool is_network_status() const { return data_->tag == Tag::kNetworkStatus; }
  inline void GetNetworkStatusDataView(
      NetworkStatusDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNetworkStatus(UserType* output) const {
    
    CHECK(is_network_status());
    return mojo::internal::Deserialize<::attribution_internals::mojom::NetworkStatusDataView>(
        data_->data.f_network_status.Get(), output, message_);
  }

 private:
  internal::SendAggregatableDebugReportResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // attribution_internals::mojom

#endif  // CONTENT_BROWSER_ATTRIBUTION_REPORTING_ATTRIBUTION_INTERNALS_MOJOM_DATA_VIEW_H_