// content/browser/tracing/traces_internals/traces_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_TRACING_TRACES_INTERNALS_TRACES_INTERNALS_MOJOM_DATA_VIEW_H_
#define CONTENT_BROWSER_TRACING_TRACES_INTERNALS_TRACES_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "content/browser/tracing/traces_internals/traces_internals.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"


namespace traces_internals::mojom {
class ClientTraceReportDataView;

class ScenarioDataView;

class TraceCategoryDataView;



}  // traces_internals::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::traces_internals::mojom::ClientTraceReportDataView> {
  using Data = ::traces_internals::mojom::internal::ClientTraceReport_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::traces_internals::mojom::ScenarioDataView> {
  using Data = ::traces_internals::mojom::internal::Scenario_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::traces_internals::mojom::TraceCategoryDataView> {
  using Data = ::traces_internals::mojom::internal::TraceCategory_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace traces_internals::mojom {


enum class ReportUploadState : int32_t {
  
  kNotUploaded = 0,
  
  kPending = 1,
  
  kPending_UserRequested = 2,
  
  kUploaded = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, ReportUploadState value);
inline bool IsKnownEnumValue(ReportUploadState value) {
  return internal::ReportUploadState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SkipUploadReason : int32_t {
  
  kNoSkip = 0,
  
  kSizeLimitExceeded = 1,
  
  kNotAnonymized = 2,
  
  kScenarioQuotaExceeded = 3,
  
  kUploadTimedOut = 4,
  
  kLocalScenario = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, SkipUploadReason value);
inline bool IsKnownEnumValue(SkipUploadReason value) {
  return internal::SkipUploadReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TracingScenarioState : int32_t {
  
  kDisabled = 0,
  
  kEnabled = 1,
  
  kSetup = 2,
  
  kStarting = 3,
  
  kRecording = 4,
  
  kStopping = 5,
  
  kFinalizing = 6,
  
  kCloning = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

 std::ostream& operator<<(std::ostream& os, TracingScenarioState value);
inline bool IsKnownEnumValue(TracingScenarioState value) {
  return internal::TracingScenarioState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class TracesInternalsHandlerFactoryInterfaceBase {};

using TracesInternalsHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<TracesInternalsHandlerFactoryInterfaceBase>;
using TracesInternalsHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<TracesInternalsHandlerFactoryInterfaceBase>;
using TracesInternalsHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TracesInternalsHandlerFactoryInterfaceBase>;
using TracesInternalsHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TracesInternalsHandlerFactoryInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class ClientTraceReportDataView {
 public:
  ClientTraceReportDataView() = default;

  ClientTraceReportDataView(
      internal::ClientTraceReport_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUuidDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUuid(UserType* output) {
    
    auto* pointer = data_->uuid.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
  inline void GetCreationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCreationTime(UserType* output) {
    
    auto* pointer = data_->creation_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetScenarioNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScenarioName(UserType* output) {
    
    auto* pointer = data_->scenario_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUploadRuleNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUploadRuleName(UserType* output) {
    
    auto* pointer = data_->upload_rule_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  std::optional<int32_t> upload_rule_value() const {

    return data_->upload_rule_value_$flag
        ? std::make_optional(data_->upload_rule_value_$value)
        : std::nullopt;
  }
  int64_t total_size() const {
    return data_->total_size;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUploadState(UserType* output) const {
    auto data_value = data_->upload_state;
    return mojo::internal::Deserialize<::traces_internals::mojom::ReportUploadState>(
        data_value, output);
  }
  ReportUploadState upload_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::traces_internals::mojom::ReportUploadState>(data_->upload_state));
  }
  inline void GetUploadTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUploadTime(UserType* output) {
    
    auto* pointer = data_->upload_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSkipReason(UserType* output) const {
    auto data_value = data_->skip_reason;
    return mojo::internal::Deserialize<::traces_internals::mojom::SkipUploadReason>(
        data_value, output);
  }
  SkipUploadReason skip_reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::traces_internals::mojom::SkipUploadReason>(data_->skip_reason));
  }
  bool has_trace_content() const {
    return data_->has_trace_content;
  }
 private:
  internal::ClientTraceReport_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScenarioDataView {
 public:
  ScenarioDataView() = default;

  ScenarioDataView(
      internal::Scenario_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScenarioNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScenarioName(UserType* output) {
    
    auto* pointer = data_->scenario_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_local_scenario() const {
    return data_->is_local_scenario;
  }
  bool is_enabled() const {
    return data_->is_enabled;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCurrentState(UserType* output) const {
    auto data_value = data_->current_state;
    return mojo::internal::Deserialize<::traces_internals::mojom::TracingScenarioState>(
        data_value, output);
  }
  TracingScenarioState current_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::traces_internals::mojom::TracingScenarioState>(data_->current_state));
  }
 private:
  internal::Scenario_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TraceCategoryDataView {
 public:
  TraceCategoryDataView() = default;

  TraceCategoryDataView(
      internal::TraceCategory_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_group() const {
    return data_->is_group;
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTagsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTags(UserType* output) {
    
    auto* pointer = data_->tags.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TraceCategory_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // traces_internals::mojom

#endif  // CONTENT_BROWSER_TRACING_TRACES_INTERNALS_TRACES_INTERNALS_MOJOM_DATA_VIEW_H_