// content/browser/tracing/traces_internals/traces_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_TRACING_TRACES_INTERNALS_TRACES_INTERNALS_MOJOM_SHARED_H_
#define CONTENT_BROWSER_TRACING_TRACES_INTERNALS_TRACES_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/browser/tracing/traces_internals/traces_internals.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "content/browser/tracing/traces_internals/traces_internals.mojom-data-view.h"




namespace std {

template <>
struct hash<::traces_internals::mojom::ReportUploadState>
    : public mojo::internal::EnumHashImpl<::traces_internals::mojom::ReportUploadState> {};

template <>
struct hash<::traces_internals::mojom::SkipUploadReason>
    : public mojo::internal::EnumHashImpl<::traces_internals::mojom::SkipUploadReason> {};

template <>
struct hash<::traces_internals::mojom::TracingScenarioState>
    : public mojo::internal::EnumHashImpl<::traces_internals::mojom::TracingScenarioState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::traces_internals::mojom::ReportUploadState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::traces_internals::mojom::ReportUploadState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::traces_internals::mojom::ReportUploadState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::traces_internals::mojom::SkipUploadReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::traces_internals::mojom::SkipUploadReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::traces_internals::mojom::SkipUploadReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::traces_internals::mojom::TracingScenarioState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::traces_internals::mojom::TracingScenarioState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::traces_internals::mojom::TracingScenarioState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::traces_internals::mojom::ClientTraceReportDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::traces_internals::mojom::ClientTraceReportDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::traces_internals::mojom::internal::ClientTraceReport_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::uuid(input)) in_uuid = Traits::uuid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->uuid)::BaseType> uuid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
      in_uuid,
      uuid_fragment);

    fragment->uuid.Set(
        uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->uuid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuid in ClientTraceReport struct");

    decltype(Traits::creation_time(input)) in_creation_time = Traits::creation_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->creation_time)::BaseType> creation_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_creation_time,
      creation_time_fragment);

    fragment->creation_time.Set(
        creation_time_fragment.is_null() ? nullptr : creation_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->creation_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null creation_time in ClientTraceReport struct");

    decltype(Traits::scenario_name(input)) in_scenario_name = Traits::scenario_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scenario_name)::BaseType> scenario_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_scenario_name,
      scenario_name_fragment);

    fragment->scenario_name.Set(
        scenario_name_fragment.is_null() ? nullptr : scenario_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scenario_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scenario_name in ClientTraceReport struct");

    decltype(Traits::upload_rule_name(input)) in_upload_rule_name = Traits::upload_rule_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->upload_rule_name)::BaseType> upload_rule_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_upload_rule_name,
      upload_rule_name_fragment);

    fragment->upload_rule_name.Set(
        upload_rule_name_fragment.is_null() ? nullptr : upload_rule_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->upload_rule_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null upload_rule_name in ClientTraceReport struct");
    fragment->upload_rule_value_$flag = Traits::upload_rule_value(input).has_value();
    if (Traits::upload_rule_value(input).has_value()) {
      fragment->upload_rule_value_$value = Traits::upload_rule_value(input).value();
    }

    fragment->total_size = Traits::total_size(input);

    
    mojo::internal::Serialize<::traces_internals::mojom::ReportUploadState>(
      Traits::upload_state(input),
      &fragment->upload_state);

    decltype(Traits::upload_time(input)) in_upload_time = Traits::upload_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->upload_time)::BaseType> upload_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_upload_time,
      upload_time_fragment);

    fragment->upload_time.Set(
        upload_time_fragment.is_null() ? nullptr : upload_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->upload_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null upload_time in ClientTraceReport struct");

    
    mojo::internal::Serialize<::traces_internals::mojom::SkipUploadReason>(
      Traits::skip_reason(input),
      &fragment->skip_reason);

    fragment->has_trace_content = Traits::has_trace_content(input);
  }

  static bool Deserialize(::traces_internals::mojom::internal::ClientTraceReport_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::traces_internals::mojom::ClientTraceReportDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::traces_internals::mojom::ScenarioDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::traces_internals::mojom::ScenarioDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::traces_internals::mojom::internal::Scenario_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::scenario_name(input)) in_scenario_name = Traits::scenario_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scenario_name)::BaseType> scenario_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_scenario_name,
      scenario_name_fragment);

    fragment->scenario_name.Set(
        scenario_name_fragment.is_null() ? nullptr : scenario_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scenario_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scenario_name in Scenario struct");

    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_description,
      description_fragment);

    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->description.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description in Scenario struct");

    fragment->is_local_scenario = Traits::is_local_scenario(input);

    fragment->is_enabled = Traits::is_enabled(input);

    
    mojo::internal::Serialize<::traces_internals::mojom::TracingScenarioState>(
      Traits::current_state(input),
      &fragment->current_state);
  }

  static bool Deserialize(::traces_internals::mojom::internal::Scenario_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::traces_internals::mojom::ScenarioDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::traces_internals::mojom::TraceCategoryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::traces_internals::mojom::TraceCategoryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::traces_internals::mojom::internal::TraceCategory_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in TraceCategory struct");

    fragment->is_group = Traits::is_group(input);

    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_description,
      description_fragment);

    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->description.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description in TraceCategory struct");

    decltype(Traits::tags(input)) in_tags = Traits::tags(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tags)::BaseType>
        tags_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tags_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_tags,
      tags_fragment,
      &tags_validate_params);

    fragment->tags.Set(
        tags_fragment.is_null() ? nullptr : tags_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tags.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tags in TraceCategory struct");
  }

  static bool Deserialize(::traces_internals::mojom::internal::TraceCategory_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::traces_internals::mojom::TraceCategoryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace traces_internals::mojom {

inline void ClientTraceReportDataView::GetUuidDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->uuid.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}
inline void ClientTraceReportDataView::GetCreationTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->creation_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void ClientTraceReportDataView::GetScenarioNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->scenario_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ClientTraceReportDataView::GetUploadRuleNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->upload_rule_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ClientTraceReportDataView::GetUploadTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->upload_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void ScenarioDataView::GetScenarioNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->scenario_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ScenarioDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void TraceCategoryDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TraceCategoryDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TraceCategoryDataView::GetTagsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->tags.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}



}  // traces_internals::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::traces_internals::mojom::ReportUploadState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::traces_internals::mojom::ReportUploadState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::traces_internals::mojom::SkipUploadReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::traces_internals::mojom::SkipUploadReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::traces_internals::mojom::TracingScenarioState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::traces_internals::mojom::TracingScenarioState value);
};

} // namespace perfetto

#endif  // CONTENT_BROWSER_TRACING_TRACES_INTERNALS_TRACES_INTERNALS_MOJOM_SHARED_H_