// content/common/agent_scheduling_group.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/agent_scheduling_group.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/agent_scheduling_group.mojom-params-data.h"
#include "content/common/agent_scheduling_group.mojom-shared-message-ids.h"

#include "content/common/agent_scheduling_group.mojom-import-headers.h"
#include "content/common/agent_scheduling_group.mojom-test-utils.h"
#include "components/content_settings/core/common/content_settings_param_traits.h"


namespace content::mojom {
// The declaration includes the definition on other builds.

AgentSchedulingGroupHost::IPCStableHashFunction AgentSchedulingGroupHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AgentSchedulingGroupHost>(message.name())) {
    case messages::AgentSchedulingGroupHost::kDidUnloadRenderFrame: {
      return &AgentSchedulingGroupHost::DidUnloadRenderFrame_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AgentSchedulingGroupHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AgentSchedulingGroupHost>(message.name())) {
      case messages::AgentSchedulingGroupHost::kDidUnloadRenderFrame:
            return "Receive content::mojom::AgentSchedulingGroupHost::DidUnloadRenderFrame";
    }
  } else {
    switch (static_cast<messages::AgentSchedulingGroupHost>(message.name())) {
      case messages::AgentSchedulingGroupHost::kDidUnloadRenderFrame:
            return "Receive reply content::mojom::AgentSchedulingGroupHost::DidUnloadRenderFrame";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AgentSchedulingGroupHost::DidUnloadRenderFrame_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x539ffb16;  // IPCStableHash for content::mojom::AgentSchedulingGroupHost::DidUnloadRenderFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AgentSchedulingGroupHostProxy::AgentSchedulingGroupHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AgentSchedulingGroupHostProxy::DidUnloadRenderFrame(
    const ::blink::LocalFrameToken& in_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::AgentSchedulingGroupHost::DidUnloadRenderFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), in_frame_token,
                        "<value of type const ::blink::LocalFrameToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AgentSchedulingGroupHost::kDidUnloadRenderFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::AgentSchedulingGroupHost_DidUnloadRenderFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_token)::BaseType> frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
    in_frame_token,
    frame_token_fragment);

  params->frame_token.Set(
      frame_token_fragment.is_null() ? nullptr : frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_token in AgentSchedulingGroupHost.DidUnloadRenderFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AgentSchedulingGroupHost::Name_);
  message.set_method_name("DidUnloadRenderFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AgentSchedulingGroupHostStubDispatch::Accept(
    AgentSchedulingGroupHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AgentSchedulingGroupHost>(message->header()->name)) {
    case messages::AgentSchedulingGroupHost::kDidUnloadRenderFrame: {
      DCHECK(message->is_serialized());
      internal::AgentSchedulingGroupHost_DidUnloadRenderFrame_Params_Data* params =
          reinterpret_cast<internal::AgentSchedulingGroupHost_DidUnloadRenderFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AgentSchedulingGroupHost.0
      bool success = true;
      ::blink::LocalFrameToken p_frame_token{};
      AgentSchedulingGroupHost_DidUnloadRenderFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameToken(&p_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AgentSchedulingGroupHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidUnloadRenderFrame(        
        std::move(p_frame_token));
      return true;
    }
  }
  return false;
}

// static
bool AgentSchedulingGroupHostStubDispatch::AcceptWithResponder(
    AgentSchedulingGroupHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AgentSchedulingGroupHost>(message->header()->name)) {
    case messages::AgentSchedulingGroupHost::kDidUnloadRenderFrame: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAgentSchedulingGroupHostValidationInfo[] = {
    {base::to_underlying(messages::AgentSchedulingGroupHost::kDidUnloadRenderFrame),
     { &internal::AgentSchedulingGroupHost_DidUnloadRenderFrame_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AgentSchedulingGroupHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::content::mojom::AgentSchedulingGroupHost::Name_,
    kAgentSchedulingGroupHostValidationInfo);
}

// The declaration includes the definition on other builds.

AgentSchedulingGroup::IPCStableHashFunction AgentSchedulingGroup::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AgentSchedulingGroup>(message.name())) {
    case messages::AgentSchedulingGroup::kBindAssociatedInterfaces: {
      return &AgentSchedulingGroup::BindAssociatedInterfaces_Sym::IPCStableHash;
    }
    case messages::AgentSchedulingGroup::kCreateView: {
      return &AgentSchedulingGroup::CreateView_Sym::IPCStableHash;
    }
    case messages::AgentSchedulingGroup::kCreateFrame: {
      return &AgentSchedulingGroup::CreateFrame_Sym::IPCStableHash;
    }
    case messages::AgentSchedulingGroup::kCreateSharedStorageWorkletService: {
      return &AgentSchedulingGroup::CreateSharedStorageWorkletService_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AgentSchedulingGroup::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AgentSchedulingGroup>(message.name())) {
      case messages::AgentSchedulingGroup::kBindAssociatedInterfaces:
            return "Receive content::mojom::AgentSchedulingGroup::BindAssociatedInterfaces";
      case messages::AgentSchedulingGroup::kCreateView:
            return "Receive content::mojom::AgentSchedulingGroup::CreateView";
      case messages::AgentSchedulingGroup::kCreateFrame:
            return "Receive content::mojom::AgentSchedulingGroup::CreateFrame";
      case messages::AgentSchedulingGroup::kCreateSharedStorageWorkletService:
            return "Receive content::mojom::AgentSchedulingGroup::CreateSharedStorageWorkletService";
    }
  } else {
    switch (static_cast<messages::AgentSchedulingGroup>(message.name())) {
      case messages::AgentSchedulingGroup::kBindAssociatedInterfaces:
            return "Receive reply content::mojom::AgentSchedulingGroup::BindAssociatedInterfaces";
      case messages::AgentSchedulingGroup::kCreateView:
            return "Receive reply content::mojom::AgentSchedulingGroup::CreateView";
      case messages::AgentSchedulingGroup::kCreateFrame:
            return "Receive reply content::mojom::AgentSchedulingGroup::CreateFrame";
      case messages::AgentSchedulingGroup::kCreateSharedStorageWorkletService:
            return "Receive reply content::mojom::AgentSchedulingGroup::CreateSharedStorageWorkletService";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AgentSchedulingGroup::BindAssociatedInterfaces_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6908ef01;  // IPCStableHash for content::mojom::AgentSchedulingGroup::BindAssociatedInterfaces
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AgentSchedulingGroup::CreateView_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe071be24;  // IPCStableHash for content::mojom::AgentSchedulingGroup::CreateView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AgentSchedulingGroup::CreateFrame_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0d3453e7;  // IPCStableHash for content::mojom::AgentSchedulingGroup::CreateFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AgentSchedulingGroup::CreateSharedStorageWorkletService_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5495adfe;  // IPCStableHash for content::mojom::AgentSchedulingGroup::CreateSharedStorageWorkletService
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AgentSchedulingGroupProxy::AgentSchedulingGroupProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AgentSchedulingGroupProxy::BindAssociatedInterfaces(
    ::mojo::PendingAssociatedRemote<AgentSchedulingGroupHost> in_remote_host, ::mojo::PendingAssociatedReceiver<::content::mojom::RouteProvider> in_route_provider_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::AgentSchedulingGroup::BindAssociatedInterfaces", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_host"), in_remote_host,
                        "<value of type ::mojo::PendingAssociatedRemote<AgentSchedulingGroupHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("route_provider_receiver"), in_route_provider_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::content::mojom::RouteProvider>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AgentSchedulingGroup::kBindAssociatedInterfaces), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::AgentSchedulingGroup_BindAssociatedInterfaces_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::content::mojom::AgentSchedulingGroupHostAssociatedPtrInfoDataView>(
    in_remote_host,
    &params->remote_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->remote_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid remote_host in AgentSchedulingGroup.BindAssociatedInterfaces request");

  
  mojo::internal::Serialize<::content::mojom::RouteProviderAssociatedRequestDataView>(
    in_route_provider_receiver,
    &params->route_provider_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->route_provider_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid route_provider_receiver in AgentSchedulingGroup.BindAssociatedInterfaces request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AgentSchedulingGroup::Name_);
  message.set_method_name("BindAssociatedInterfaces");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AgentSchedulingGroupProxy::CreateView(
    ::content::mojom::CreateViewParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::AgentSchedulingGroup::CreateView", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::content::mojom::CreateViewParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AgentSchedulingGroup::kCreateView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::AgentSchedulingGroup_CreateView_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::CreateViewParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in AgentSchedulingGroup.CreateView request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AgentSchedulingGroup::Name_);
  message.set_method_name("CreateView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AgentSchedulingGroupProxy::CreateFrame(
    ::content::mojom::CreateFrameParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::AgentSchedulingGroup::CreateFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::content::mojom::CreateFrameParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AgentSchedulingGroup::kCreateFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::AgentSchedulingGroup_CreateFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::CreateFrameParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in AgentSchedulingGroup.CreateFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AgentSchedulingGroup::Name_);
  message.set_method_name("CreateFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AgentSchedulingGroupProxy::CreateSharedStorageWorkletService(
    ::mojo::PendingReceiver<::blink::mojom::SharedStorageWorkletService> in_receiver, ::blink::mojom::WorkletGlobalScopeCreationParamsPtr in_global_scope_creation_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::AgentSchedulingGroup::CreateSharedStorageWorkletService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::SharedStorageWorkletService>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("global_scope_creation_params"), in_global_scope_creation_params,
                        "<value of type ::blink::mojom::WorkletGlobalScopeCreationParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AgentSchedulingGroup::kCreateSharedStorageWorkletService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::AgentSchedulingGroup_CreateSharedStorageWorkletService_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::SharedStorageWorkletServiceInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in AgentSchedulingGroup.CreateSharedStorageWorkletService request");
  mojo::internal::MessageFragment<
      typename decltype(params->global_scope_creation_params)::BaseType> global_scope_creation_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WorkletGlobalScopeCreationParamsDataView>(
    in_global_scope_creation_params,
    global_scope_creation_params_fragment);

  params->global_scope_creation_params.Set(
      global_scope_creation_params_fragment.is_null() ? nullptr : global_scope_creation_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->global_scope_creation_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null global_scope_creation_params in AgentSchedulingGroup.CreateSharedStorageWorkletService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AgentSchedulingGroup::Name_);
  message.set_method_name("CreateSharedStorageWorkletService");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AgentSchedulingGroupStubDispatch::Accept(
    AgentSchedulingGroup* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AgentSchedulingGroup>(message->header()->name)) {
    case messages::AgentSchedulingGroup::kBindAssociatedInterfaces: {
      DCHECK(message->is_serialized());
      internal::AgentSchedulingGroup_BindAssociatedInterfaces_Params_Data* params =
          reinterpret_cast<internal::AgentSchedulingGroup_BindAssociatedInterfaces_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AgentSchedulingGroup.0
      bool success = true;
      ::mojo::PendingAssociatedRemote<AgentSchedulingGroupHost> p_remote_host{};
      ::mojo::PendingAssociatedReceiver<::content::mojom::RouteProvider> p_route_provider_receiver{};
      AgentSchedulingGroup_BindAssociatedInterfaces_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_remote_host =
            input_data_view.TakeRemoteHost<decltype(p_remote_host)>();
      }
      if (success) {
        p_route_provider_receiver =
            input_data_view.TakeRouteProviderReceiver<decltype(p_route_provider_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AgentSchedulingGroup::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindAssociatedInterfaces(        
        std::move(p_remote_host), 
        std::move(p_route_provider_receiver));
      return true;
    }
    case messages::AgentSchedulingGroup::kCreateView: {
      DCHECK(message->is_serialized());
      internal::AgentSchedulingGroup_CreateView_Params_Data* params =
          reinterpret_cast<internal::AgentSchedulingGroup_CreateView_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AgentSchedulingGroup.1
      bool success = true;
      ::content::mojom::CreateViewParamsPtr p_params{};
      AgentSchedulingGroup_CreateView_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AgentSchedulingGroup::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateView(        
        std::move(p_params));
      return true;
    }
    case messages::AgentSchedulingGroup::kCreateFrame: {
      DCHECK(message->is_serialized());
      internal::AgentSchedulingGroup_CreateFrame_Params_Data* params =
          reinterpret_cast<internal::AgentSchedulingGroup_CreateFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AgentSchedulingGroup.2
      bool success = true;
      ::content::mojom::CreateFrameParamsPtr p_params{};
      AgentSchedulingGroup_CreateFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AgentSchedulingGroup::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFrame(        
        std::move(p_params));
      return true;
    }
    case messages::AgentSchedulingGroup::kCreateSharedStorageWorkletService: {
      DCHECK(message->is_serialized());
      internal::AgentSchedulingGroup_CreateSharedStorageWorkletService_Params_Data* params =
          reinterpret_cast<internal::AgentSchedulingGroup_CreateSharedStorageWorkletService_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AgentSchedulingGroup.3
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::SharedStorageWorkletService> p_receiver{};
      ::blink::mojom::WorkletGlobalScopeCreationParamsPtr p_global_scope_creation_params{};
      AgentSchedulingGroup_CreateSharedStorageWorkletService_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success && !input_data_view.ReadGlobalScopeCreationParams(&p_global_scope_creation_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AgentSchedulingGroup::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateSharedStorageWorkletService(        
        std::move(p_receiver), 
        std::move(p_global_scope_creation_params));
      return true;
    }
  }
  return false;
}

// static
bool AgentSchedulingGroupStubDispatch::AcceptWithResponder(
    AgentSchedulingGroup* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AgentSchedulingGroup>(message->header()->name)) {
    case messages::AgentSchedulingGroup::kBindAssociatedInterfaces: {
      break;
    }
    case messages::AgentSchedulingGroup::kCreateView: {
      break;
    }
    case messages::AgentSchedulingGroup::kCreateFrame: {
      break;
    }
    case messages::AgentSchedulingGroup::kCreateSharedStorageWorkletService: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAgentSchedulingGroupValidationInfo[] = {
    {base::to_underlying(messages::AgentSchedulingGroup::kBindAssociatedInterfaces),
     { &internal::AgentSchedulingGroup_BindAssociatedInterfaces_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AgentSchedulingGroup::kCreateView),
     { &internal::AgentSchedulingGroup_CreateView_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AgentSchedulingGroup::kCreateFrame),
     { &internal::AgentSchedulingGroup_CreateFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AgentSchedulingGroup::kCreateSharedStorageWorkletService),
     { &internal::AgentSchedulingGroup_CreateSharedStorageWorkletService_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AgentSchedulingGroupRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::content::mojom::AgentSchedulingGroup::Name_,
    kAgentSchedulingGroupValidationInfo);
}



}  // content::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content::mojom {


void AgentSchedulingGroupHostInterceptorForTesting::DidUnloadRenderFrame(const ::blink::LocalFrameToken& frame_token) {
  GetForwardingInterface()->DidUnloadRenderFrame(
    std::move(frame_token)
    );
}
AgentSchedulingGroupHostAsyncWaiter::AgentSchedulingGroupHostAsyncWaiter(
    AgentSchedulingGroupHost* proxy) : proxy_(proxy) {}

AgentSchedulingGroupHostAsyncWaiter::~AgentSchedulingGroupHostAsyncWaiter() = default;





void AgentSchedulingGroupInterceptorForTesting::BindAssociatedInterfaces(::mojo::PendingAssociatedRemote<AgentSchedulingGroupHost> remote_host, ::mojo::PendingAssociatedReceiver<::content::mojom::RouteProvider> route_provider_receiver) {
  GetForwardingInterface()->BindAssociatedInterfaces(
    std::move(remote_host)
    , 
    std::move(route_provider_receiver)
    );
}
void AgentSchedulingGroupInterceptorForTesting::CreateView(::content::mojom::CreateViewParamsPtr params) {
  GetForwardingInterface()->CreateView(
    std::move(params)
    );
}
void AgentSchedulingGroupInterceptorForTesting::CreateFrame(::content::mojom::CreateFrameParamsPtr params) {
  GetForwardingInterface()->CreateFrame(
    std::move(params)
    );
}
void AgentSchedulingGroupInterceptorForTesting::CreateSharedStorageWorkletService(::mojo::PendingReceiver<::blink::mojom::SharedStorageWorkletService> receiver, ::blink::mojom::WorkletGlobalScopeCreationParamsPtr global_scope_creation_params) {
  GetForwardingInterface()->CreateSharedStorageWorkletService(
    std::move(receiver)
    , 
    std::move(global_scope_creation_params)
    );
}
AgentSchedulingGroupAsyncWaiter::AgentSchedulingGroupAsyncWaiter(
    AgentSchedulingGroup* proxy) : proxy_(proxy) {}

AgentSchedulingGroupAsyncWaiter::~AgentSchedulingGroupAsyncWaiter() = default;







}  // content::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif