// content/common/memory_coordinator/mojom/memory_coordinator.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_MEMORY_COORDINATOR_MOJOM_MEMORY_COORDINATOR_MOJOM_SHARED_H_
#define CONTENT_COMMON_MEMORY_COORDINATOR_MOJOM_MEMORY_COORDINATOR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/memory_coordinator/mojom/memory_coordinator.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "content/common/memory_coordinator/mojom/memory_coordinator.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::MemoryConsumerTraitsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::MemoryConsumerTraitsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::MemoryConsumerTraits_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->supports_memory_limit = Traits::supports_memory_limit(input);

    fragment->in_process = Traits::in_process(input);

    fragment->estimated_memory_usage = Traits::estimated_memory_usage(input);

    fragment->release_memory_cost = Traits::release_memory_cost(input);

    fragment->recreate_memory_cost = Traits::recreate_memory_cost(input);

    fragment->information_retention = Traits::information_retention(input);

    fragment->memory_release_behavior = Traits::memory_release_behavior(input);

    fragment->execution_type = Traits::execution_type(input);

    fragment->release_gc_references = Traits::release_gc_references(input);

    fragment->garbage_collects_v8_heap = Traits::garbage_collects_v8_heap(input);
  }

  static bool Deserialize(::content::mojom::internal::MemoryConsumerTraits_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::MemoryConsumerTraitsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content::mojom {




}  // content::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CONTENT_COMMON_MEMORY_COORDINATOR_MOJOM_MEMORY_COORDINATOR_MOJOM_SHARED_H_