// extensions/common/mojom/extra_response_data.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_EXTRA_RESPONSE_DATA_MOJOM_H_
#define EXTENSIONS_COMMON_MOJOM_EXTRA_RESPONSE_DATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/extra_response_data.mojom-features.h"  // IWYU pragma: export
#include "extensions/common/mojom/extra_response_data.mojom-shared.h"  // IWYU pragma: export
#include "extensions/common/mojom/extra_response_data.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace extensions::mojom {








class  ExtraResponseData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExtraResponseData, T>::value>;
  using DataView = ExtraResponseDataDataView;
  using Data_ = internal::ExtraResponseData_Data;

  template <typename... Args>
  static ExtraResponseDataPtr New(Args&&... args) {
    return ExtraResponseDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExtraResponseDataPtr From(const U& u) {
    return mojo::TypeConverter<ExtraResponseDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExtraResponseData>::Convert(*this);
  }


  ExtraResponseData();

  explicit ExtraResponseData(
      std::vector<::blink::mojom::SerializedBlobPtr> blobs);

ExtraResponseData(const ExtraResponseData&) = delete;
ExtraResponseData& operator=(const ExtraResponseData&) = delete;

  ~ExtraResponseData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExtraResponseDataPtr>
  ExtraResponseDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExtraResponseData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ExtraResponseData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ExtraResponseData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExtraResponseData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExtraResponseData_UnserializedMessageContext<
            UserType, ExtraResponseData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ExtraResponseData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ExtraResponseData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExtraResponseData_UnserializedMessageContext<
            UserType, ExtraResponseData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExtraResponseData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::blink::mojom::SerializedBlobPtr> blobs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExtraResponseData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExtraResponseData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExtraResponseData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExtraResponseData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ExtraResponseDataPtr ExtraResponseData::Clone() const {
  return New(
      mojo::Clone(blobs)
  );
}

template <typename T, ExtraResponseData::EnableIfSame<T>*>
bool ExtraResponseData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->blobs, other_struct.blobs))
    return false;
  return true;
}

template <typename T, ExtraResponseData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.blobs < rhs.blobs)
    return true;
  if (rhs.blobs < lhs.blobs)
    return false;
  return false;
}


}  // extensions::mojom

namespace mojo {


template <>
struct  StructTraits<::extensions::mojom::ExtraResponseData::DataView,
                                         ::extensions::mojom::ExtraResponseDataPtr> {
  static bool IsNull(const ::extensions::mojom::ExtraResponseDataPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::ExtraResponseDataPtr* output) { output->reset(); }

  static  decltype(::extensions::mojom::ExtraResponseData::blobs)& blobs(
       ::extensions::mojom::ExtraResponseDataPtr& input) {
    return input->blobs;
  }

  static bool Read(::extensions::mojom::ExtraResponseData::DataView input, ::extensions::mojom::ExtraResponseDataPtr* output);
};

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_MOJOM_EXTRA_RESPONSE_DATA_MOJOM_H_