// ipc/ipc.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ipc/ipc.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ipc/ipc.mojom-params-data.h"
#include "ipc/ipc.mojom-shared-message-ids.h"

#include "ipc/ipc.mojom-import-headers.h"
#include "ipc/ipc.mojom-test-utils.h"


namespace IPC::mojom {
Message::Message()
    : bytes(),
      handles() {}

Message::Message(
    std::vector<uint8_t> bytes_in,
    std::optional<std::vector<::mojo::native::SerializedHandlePtr>> handles_in)
    : bytes(std::move(bytes_in)),
      handles(std::move(handles_in)) {}

Message::~Message() = default;

void Message::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bytes"), this->bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "handles"), this->handles,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<std::vector<::mojo::native::SerializedHandlePtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Message::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

Channel::IPCStableHashFunction Channel::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Channel>(message.name())) {
    case messages::Channel::kSetPeerPid: {
      return &Channel::SetPeerPid_Sym::IPCStableHash;
    }
    case messages::Channel::kReceive: {
      return &Channel::Receive_Sym::IPCStableHash;
    }
    case messages::Channel::kGetAssociatedInterface: {
      return &Channel::GetAssociatedInterface_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Channel::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Channel>(message.name())) {
      case messages::Channel::kSetPeerPid:
            return "Receive IPC::mojom::Channel::SetPeerPid";
      case messages::Channel::kReceive:
            return "Receive IPC::mojom::Channel::Receive";
      case messages::Channel::kGetAssociatedInterface:
            return "Receive IPC::mojom::Channel::GetAssociatedInterface";
    }
  } else {
    switch (static_cast<messages::Channel>(message.name())) {
      case messages::Channel::kSetPeerPid:
            return "Receive reply IPC::mojom::Channel::SetPeerPid";
      case messages::Channel::kReceive:
            return "Receive reply IPC::mojom::Channel::Receive";
      case messages::Channel::kGetAssociatedInterface:
            return "Receive reply IPC::mojom::Channel::GetAssociatedInterface";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Channel::SetPeerPid_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x47045795;  // IPCStableHash for IPC::mojom::Channel::SetPeerPid
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Channel::Receive_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcbc31ea2;  // IPCStableHash for IPC::mojom::Channel::Receive
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Channel::GetAssociatedInterface_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1fc932e0;  // IPCStableHash for IPC::mojom::Channel::GetAssociatedInterface
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ChannelProxy::ChannelProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ChannelProxy::SetPeerPid(
    int32_t in_pid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send IPC::mojom::Channel::SetPeerPid", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pid"), in_pid,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Channel::kSetPeerPid), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::IPC::mojom::internal::Channel_SetPeerPid_Params_Data> params(
          message);
  params.Allocate();

  params->pid = in_pid;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Channel::Name_);
  message.set_method_name("SetPeerPid");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChannelProxy::Receive(
    ::IPC::MessageView in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send IPC::mojom::Channel::Receive", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type ::IPC::MessageView>");
   });
#endif

  CHECK(base::FeatureList::IsEnabled(::IPC::mojom::kMojoIpcChannelReceive));
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Channel::kReceive), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::IPC::mojom::internal::Channel_Receive_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::IPC::mojom::MessageDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in Channel.Receive request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Channel::Name_);
  message.set_method_name("Receive");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChannelProxy::GetAssociatedInterface(
    ::mojo::GenericPendingAssociatedReceiver in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send IPC::mojom::Channel::GetAssociatedInterface", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::GenericPendingAssociatedReceiver>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Channel::kGetAssociatedInterface), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::IPC::mojom::internal::Channel_GetAssociatedInterface_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->receiver)::BaseType> receiver_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::GenericPendingAssociatedReceiverDataView>(
    in_receiver,
    receiver_fragment);

  params->receiver.Set(
      receiver_fragment.is_null() ? nullptr : receiver_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->receiver.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null receiver in Channel.GetAssociatedInterface request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Channel::Name_);
  message.set_method_name("GetAssociatedInterface");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ChannelStubDispatch::Accept(
    Channel* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Channel>(message->header()->name)) {
    case messages::Channel::kSetPeerPid: {
      DCHECK(message->is_serialized());
      internal::Channel_SetPeerPid_Params_Data* params =
          reinterpret_cast<internal::Channel_SetPeerPid_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Channel.0
      bool success = true;
      int32_t p_pid{};
      Channel_SetPeerPid_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_pid = input_data_view.pid();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Channel::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPeerPid(        
        std::move(p_pid));
      return true;
    }
    case messages::Channel::kReceive: {
      DCHECK(message->is_serialized());
      internal::Channel_Receive_Params_Data* params =
          reinterpret_cast<internal::Channel_Receive_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Channel.1
      bool success = true;
      ::IPC::MessageView p_message{};
      Channel_Receive_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Channel::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Receive(        
        std::move(p_message));
      return true;
    }
    case messages::Channel::kGetAssociatedInterface: {
      DCHECK(message->is_serialized());
      internal::Channel_GetAssociatedInterface_Params_Data* params =
          reinterpret_cast<internal::Channel_GetAssociatedInterface_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Channel.2
      bool success = true;
      ::mojo::GenericPendingAssociatedReceiver p_receiver{};
      Channel_GetAssociatedInterface_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReceiver(&p_receiver))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Channel::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAssociatedInterface(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool ChannelStubDispatch::AcceptWithResponder(
    Channel* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Channel>(message->header()->name)) {
    case messages::Channel::kSetPeerPid: {
      break;
    }
    case messages::Channel::kReceive: {
      break;
    }
    case messages::Channel::kGetAssociatedInterface: {
      break;
    }
  }
  return false;
}
namespace {

bool ValidateWithRuntimeFeature_Channel_Receive(
  const void* data, mojo::internal::ValidationContext* validation_context) {
  if (!base::FeatureList::IsEnabled(::IPC::mojom::kMojoIpcChannelReceive)) {
    return false;
  }
  return internal::Channel_Receive_Params_Data::Validate(
    data, validation_context);
}
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kChannelValidationInfo[] = {
    {base::to_underlying(messages::Channel::kSetPeerPid),
     { &internal::Channel_SetPeerPid_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Channel::kReceive),
     { &ValidateWithRuntimeFeature_Channel_Receive,
      nullptr /* no response */}},
    {base::to_underlying(messages::Channel::kGetAssociatedInterface),
     { &internal::Channel_GetAssociatedInterface_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ChannelRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::IPC::mojom::Channel::Name_,
    kChannelValidationInfo);
}

// The declaration includes the definition on other builds.

ChannelBootstrap::IPCStableHashFunction ChannelBootstrap::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ChannelBootstrap::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

ChannelBootstrapProxy::ChannelBootstrapProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool ChannelBootstrapStubDispatch::Accept(
    ChannelBootstrap* impl,
    mojo::Message* message) {
  return false;
}

// static
bool ChannelBootstrapStubDispatch::AcceptWithResponder(
    ChannelBootstrap* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool ChannelBootstrapRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::IPC::mojom::ChannelBootstrap::Name_,
    {});
}



}  // IPC::mojom


namespace mojo {


// static
bool StructTraits<::IPC::mojom::Message::DataView, ::IPC::mojom::MessagePtr>::Read(
    ::IPC::mojom::Message::DataView input,
    ::IPC::mojom::MessagePtr* output) {
  bool success = true;
  ::IPC::mojom::MessagePtr result(::IPC::mojom::Message::New());
  
      if (success && !input.ReadBytes(&result->bytes))
        success = false;
      if (success && !input.ReadHandles(&result->handles))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace IPC::mojom {


void ChannelInterceptorForTesting::SetPeerPid(int32_t pid) {
  GetForwardingInterface()->SetPeerPid(
    std::move(pid)
    );
}
void ChannelInterceptorForTesting::Receive(::IPC::MessageView message) {
  GetForwardingInterface()->Receive(
    std::move(message)
    );
}
void ChannelInterceptorForTesting::GetAssociatedInterface(::mojo::GenericPendingAssociatedReceiver receiver) {
  GetForwardingInterface()->GetAssociatedInterface(
    std::move(receiver)
    );
}
ChannelAsyncWaiter::ChannelAsyncWaiter(
    Channel* proxy) : proxy_(proxy) {}

ChannelAsyncWaiter::~ChannelAsyncWaiter() = default;





ChannelBootstrapAsyncWaiter::ChannelBootstrapAsyncWaiter(
    ChannelBootstrap* proxy) : proxy_(proxy) {}

ChannelBootstrapAsyncWaiter::~ChannelBootstrapAsyncWaiter() = default;







}  // IPC::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif