// media/mojo/mojom/cdm_context_for_oopvd.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/cdm_context_for_oopvd.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/cdm_context_for_oopvd.mojom-params-data.h"
namespace media {
namespace mojom {

NOINLINE static const char* DecryptStatusToStringHelper(DecryptStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DecryptStatus::kSuccess:
      return "kSuccess";
    case DecryptStatus::kNoKey:
      return "kNoKey";
    case DecryptStatus::kFailure:
      return "kFailure";
    default:
      return nullptr;
  }
}

std::string DecryptStatusToString(DecryptStatus value) {
  const char *str = DecryptStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DecryptStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DecryptStatus value) {
  return os << DecryptStatusToString(value);
}

NOINLINE static const char* CdmContextEventToStringHelper(CdmContextEvent value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CdmContextEvent::kHasAdditionalUsableKey:
      return "kHasAdditionalUsableKey";
    case CdmContextEvent::kHardwareContextReset:
      return "kHardwareContextReset";
    default:
      return nullptr;
  }
}

std::string CdmContextEventToString(CdmContextEvent value) {
  const char *str = CdmContextEventToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CdmContextEvent value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CdmContextEvent value) {
  return os << CdmContextEventToString(value);
}

namespace internal {


// static
bool CdmContextEventCallback_EventCallback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmContextEventCallback_EventCallback_Params_Data* object =
      static_cast<const CdmContextEventCallback_EventCallback_Params_Data*>(data);


  if (!::media::mojom::internal::CdmContextEvent_Data
        ::Validate(object->event, validation_context))
    return false;

  return true;
}

CdmContextEventCallback_EventCallback_Params_Data::CdmContextEventCallback_EventCallback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmContextForOOPVD_GetHwKeyData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmContextForOOPVD_GetHwKeyData_Params_Data* object =
      static_cast<const CdmContextForOOPVD_GetHwKeyData_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->decrypt_config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->decrypt_config, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hw_identifier, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hw_identifier_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->hw_identifier, validation_context,
                                         &hw_identifier_validate_params)) {
    return false;
  }

  return true;
}

CdmContextForOOPVD_GetHwKeyData_Params_Data::CdmContextForOOPVD_GetHwKeyData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmContextForOOPVD_GetHwKeyData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmContextForOOPVD_GetHwKeyData_ResponseParams_Data* object =
      static_cast<const CdmContextForOOPVD_GetHwKeyData_ResponseParams_Data*>(data);


  if (!::media::mojom::internal::DecryptStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key_data, validation_context,
                                         &key_data_validate_params)) {
    return false;
  }

  return true;
}

CdmContextForOOPVD_GetHwKeyData_ResponseParams_Data::CdmContextForOOPVD_GetHwKeyData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmContextForOOPVD_RegisterEventCallback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmContextForOOPVD_RegisterEventCallback_Params_Data* object =
      static_cast<const CdmContextForOOPVD_RegisterEventCallback_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->callback, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->callback,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CdmContextForOOPVD_RegisterEventCallback_Params_Data::CdmContextForOOPVD_RegisterEventCallback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmContextForOOPVD_GetHwConfigData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmContextForOOPVD_GetHwConfigData_Params_Data* object =
      static_cast<const CdmContextForOOPVD_GetHwConfigData_Params_Data*>(data);

  return true;
}

CdmContextForOOPVD_GetHwConfigData_Params_Data::CdmContextForOOPVD_GetHwConfigData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmContextForOOPVD_GetHwConfigData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmContextForOOPVD_GetHwConfigData_ResponseParams_Data* object =
      static_cast<const CdmContextForOOPVD_GetHwConfigData_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& config_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->config_data, validation_context,
                                         &config_data_validate_params)) {
    return false;
  }

  return true;
}

CdmContextForOOPVD_GetHwConfigData_ResponseParams_Data::CdmContextForOOPVD_GetHwConfigData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmContextForOOPVD_GetScreenResolutions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmContextForOOPVD_GetScreenResolutions_Params_Data* object =
      static_cast<const CdmContextForOOPVD_GetScreenResolutions_Params_Data*>(data);

  return true;
}

CdmContextForOOPVD_GetScreenResolutions_Params_Data::CdmContextForOOPVD_GetScreenResolutions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmContextForOOPVD_GetScreenResolutions_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmContextForOOPVD_GetScreenResolutions_ResponseParams_Data* object =
      static_cast<const CdmContextForOOPVD_GetScreenResolutions_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resolutions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& resolutions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->resolutions, validation_context,
                                         &resolutions_validate_params)) {
    return false;
  }

  return true;
}

CdmContextForOOPVD_GetScreenResolutions_ResponseParams_Data::CdmContextForOOPVD_GetScreenResolutions_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmContextForOOPVD_AllocateSecureBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmContextForOOPVD_AllocateSecureBuffer_Params_Data* object =
      static_cast<const CdmContextForOOPVD_AllocateSecureBuffer_Params_Data*>(data);

  return true;
}

CdmContextForOOPVD_AllocateSecureBuffer_Params_Data::CdmContextForOOPVD_AllocateSecureBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams_Data* object =
      static_cast<const CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->secure_buffer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams_Data::CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmContextForOOPVD_ParseEncryptedSliceHeader_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmContextForOOPVD_ParseEncryptedSliceHeader_Params_Data* object =
      static_cast<const CdmContextForOOPVD_ParseEncryptedSliceHeader_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stream_data, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& stream_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->stream_data, validation_context,
                                         &stream_data_validate_params)) {
    return false;
  }

  return true;
}

CdmContextForOOPVD_ParseEncryptedSliceHeader_Params_Data::CdmContextForOOPVD_ParseEncryptedSliceHeader_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams_Data* object =
      static_cast<const CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->slice_header, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& slice_header_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->slice_header, validation_context,
                                         &slice_header_validate_params)) {
    return false;
  }

  return true;
}

CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams_Data::CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmContextForOOPVD_DecryptVideoBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmContextForOOPVD_DecryptVideoBuffer_Params_Data* object =
      static_cast<const CdmContextForOOPVD_DecryptVideoBuffer_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->buffer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->buffer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bytes, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->bytes, validation_context,
                                         &bytes_validate_params)) {
    return false;
  }

  return true;
}

CdmContextForOOPVD_DecryptVideoBuffer_Params_Data::CdmContextForOOPVD_DecryptVideoBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams_Data* object =
      static_cast<const CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams_Data*>(data);


  if (!::media::mojom::internal::DecryptStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->decoder_buffer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bytes, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->bytes, validation_context,
                                         &bytes_validate_params)) {
    return false;
  }

  return true;
}

CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams_Data::CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::DecryptStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::DecryptStatus value) {
  return std::move(context).WriteString(::media::mojom::DecryptStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::CdmContextEvent>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::CdmContextEvent value) {
  return std::move(context).WriteString(::media::mojom::CdmContextEventToString(value));
}

} // namespace perfetto