// qtwebengine/common/media/webrtc_logging.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef QTWEBENGINE_COMMON_MEDIA_WEBRTC_LOGGING_MOJOM_H_
#define QTWEBENGINE_COMMON_MEDIA_WEBRTC_LOGGING_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "qtwebengine/common/media/webrtc_logging.mojom-features.h"  // IWYU pragma: export
#include "qtwebengine/common/media/webrtc_logging.mojom-shared.h"  // IWYU pragma: export
#include "qtwebengine/common/media/webrtc_logging.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace chrome::mojom {

class WebRtcLoggingClientProxy;

template <typename ImplRefTraits>
class WebRtcLoggingClientStub;

class WebRtcLoggingClientRequestValidator;


class WebRtcLoggingClient
    : public WebRtcLoggingClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.WebRtcLoggingClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebRtcLoggingClientInterfaceBase;
  using Proxy_ = WebRtcLoggingClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebRtcLoggingClientStub<ImplRefTraits>;

  using RequestValidator_ = WebRtcLoggingClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnAddMessagesMinVersion = 0,
    kOnStoppedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnAddMessages_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnStopped_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebRtcLoggingClient() = default;

  virtual void OnAddMessages(std::vector<WebRtcLoggingMessagePtr> messages) = 0;

  virtual void OnStopped() = 0;
};

class WebRtcLoggingAgentProxy;

template <typename ImplRefTraits>
class WebRtcLoggingAgentStub;

class WebRtcLoggingAgentRequestValidator;


class WebRtcLoggingAgent
    : public WebRtcLoggingAgentInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.WebRtcLoggingAgent";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebRtcLoggingAgentInterfaceBase;
  using Proxy_ = WebRtcLoggingAgentProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebRtcLoggingAgentStub<ImplRefTraits>;

  using RequestValidator_ = WebRtcLoggingAgentRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStartMinVersion = 0,
    kStopMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Start_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Stop_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebRtcLoggingAgent() = default;

  virtual void Start(::mojo::PendingRemote<WebRtcLoggingClient> client) = 0;

  virtual void Stop() = 0;
};



class  WebRtcLoggingClientProxy
    : public WebRtcLoggingClient {
 public:
  using InterfaceType = WebRtcLoggingClient;

  explicit WebRtcLoggingClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnAddMessages(std::vector<WebRtcLoggingMessagePtr> messages) final;
  
  void OnStopped() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WebRtcLoggingAgentProxy
    : public WebRtcLoggingAgent {
 public:
  using InterfaceType = WebRtcLoggingAgent;

  explicit WebRtcLoggingAgentProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Start(::mojo::PendingRemote<WebRtcLoggingClient> client) final;
  
  void Stop() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WebRtcLoggingClientStubDispatch {
 public:
  static bool Accept(WebRtcLoggingClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebRtcLoggingClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebRtcLoggingClient>>
class WebRtcLoggingClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebRtcLoggingClientStub() = default;
  ~WebRtcLoggingClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebRtcLoggingClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebRtcLoggingClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebRtcLoggingAgentStubDispatch {
 public:
  static bool Accept(WebRtcLoggingAgent* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebRtcLoggingAgent* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebRtcLoggingAgent>>
class WebRtcLoggingAgentStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebRtcLoggingAgentStub() = default;
  ~WebRtcLoggingAgentStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebRtcLoggingAgentStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebRtcLoggingAgentStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebRtcLoggingClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebRtcLoggingAgentRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  WebRtcLoggingMessage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebRtcLoggingMessage, T>::value>;
  using DataView = WebRtcLoggingMessageDataView;
  using Data_ = internal::WebRtcLoggingMessage_Data;

  template <typename... Args>
  static WebRtcLoggingMessagePtr New(Args&&... args) {
    return WebRtcLoggingMessagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebRtcLoggingMessagePtr From(const U& u) {
    return mojo::TypeConverter<WebRtcLoggingMessagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebRtcLoggingMessage>::Convert(*this);
  }


  WebRtcLoggingMessage();

  WebRtcLoggingMessage(
      ::base::Time timestamp,
      const std::string& data);


  ~WebRtcLoggingMessage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebRtcLoggingMessagePtr>
  WebRtcLoggingMessagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebRtcLoggingMessage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebRtcLoggingMessage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebRtcLoggingMessage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebRtcLoggingMessage::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebRtcLoggingMessage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebRtcLoggingMessage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebRtcLoggingMessage_UnserializedMessageContext<
            UserType, WebRtcLoggingMessage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebRtcLoggingMessage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebRtcLoggingMessage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebRtcLoggingMessage_UnserializedMessageContext<
            UserType, WebRtcLoggingMessage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebRtcLoggingMessage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Time timestamp;
  
  std::string data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebRtcLoggingMessage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebRtcLoggingMessage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebRtcLoggingMessage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebRtcLoggingMessage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WebRtcLoggingMessagePtr WebRtcLoggingMessage::Clone() const {
  return New(
      mojo::Clone(timestamp),
      mojo::Clone(data)
  );
}

template <typename T, WebRtcLoggingMessage::EnableIfSame<T>*>
bool WebRtcLoggingMessage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, WebRtcLoggingMessage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}


}  // chrome::mojom

namespace mojo {


template <>
struct  StructTraits<::chrome::mojom::WebRtcLoggingMessage::DataView,
                                         ::chrome::mojom::WebRtcLoggingMessagePtr> {
  static bool IsNull(const ::chrome::mojom::WebRtcLoggingMessagePtr& input) { return !input; }
  static void SetToNull(::chrome::mojom::WebRtcLoggingMessagePtr* output) { output->reset(); }

  static const decltype(::chrome::mojom::WebRtcLoggingMessage::timestamp)& timestamp(
      const ::chrome::mojom::WebRtcLoggingMessagePtr& input) {
    return input->timestamp;
  }

  static const decltype(::chrome::mojom::WebRtcLoggingMessage::data)& data(
      const ::chrome::mojom::WebRtcLoggingMessagePtr& input) {
    return input->data;
  }

  static bool Read(::chrome::mojom::WebRtcLoggingMessage::DataView input, ::chrome::mojom::WebRtcLoggingMessagePtr* output);
};

}  // namespace mojo

#endif  // QTWEBENGINE_COMMON_MEDIA_WEBRTC_LOGGING_MOJOM_H_