// qtwebengine/userscript/userscript.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef QTWEBENGINE_USERSCRIPT_USERSCRIPT_MOJOM_DATA_VIEW_H_
#define QTWEBENGINE_USERSCRIPT_USERSCRIPT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "qtwebengine/userscript/userscript.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"


namespace qtwebengine::mojom {
class UserScriptDataDataView;



}  // qtwebengine::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::qtwebengine::mojom::UserScriptDataDataView> {
  using Data = ::qtwebengine::mojom::internal::UserScriptData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace qtwebengine::mojom {


enum class InjectionPoint : int32_t {
  
  AfterLoad = 0,
  
  DocumentLoadFinished = 1,
  
  DocumentElementCreation = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, InjectionPoint value);
inline bool IsKnownEnumValue(InjectionPoint value) {
  return internal::InjectionPoint_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class UserResourceControllerRenderFrameInterfaceBase {};

using UserResourceControllerRenderFramePtrDataView =
    mojo::InterfacePtrDataView<UserResourceControllerRenderFrameInterfaceBase>;
using UserResourceControllerRenderFrameRequestDataView =
    mojo::InterfaceRequestDataView<UserResourceControllerRenderFrameInterfaceBase>;
using UserResourceControllerRenderFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UserResourceControllerRenderFrameInterfaceBase>;
using UserResourceControllerRenderFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UserResourceControllerRenderFrameInterfaceBase>;
class UserResourceControllerInterfaceBase {};

using UserResourceControllerPtrDataView =
    mojo::InterfacePtrDataView<UserResourceControllerInterfaceBase>;
using UserResourceControllerRequestDataView =
    mojo::InterfaceRequestDataView<UserResourceControllerInterfaceBase>;
using UserResourceControllerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UserResourceControllerInterfaceBase>;
using UserResourceControllerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UserResourceControllerInterfaceBase>;


class UserScriptDataDataView {
 public:
  UserScriptDataDataView() = default;

  UserScriptDataDataView(
      internal::UserScriptData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSourceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSource(UserType* output) {
    
    auto* pointer = data_->source.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  uint8_t injectionPoint() const {
    return data_->injectionPoint;
  }
  bool injectForSubframes() const {
    return data_->injectForSubframes;
  }
  uint8_t worldId() const {
    return data_->worldId;
  }
  uint64_t scriptId() const {
    return data_->scriptId;
  }
  inline void GetGlobsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGlobs(UserType* output) {
    
    auto* pointer = data_->globs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetExcludeGlobsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExcludeGlobs(UserType* output) {
    
    auto* pointer = data_->excludeGlobs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetUrlPatternsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrlPatterns(UserType* output) {
    
    auto* pointer = data_->urlPatterns.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::UserScriptData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // qtwebengine::mojom

#endif  // QTWEBENGINE_USERSCRIPT_USERSCRIPT_MOJOM_DATA_VIEW_H_