// services/device/public/mojom/usb_manager.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/usb_manager.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/usb_manager.mojom-params-data.h"
#include "services/device/public/mojom/usb_manager.mojom-shared-message-ids.h"

#include "services/device/public/mojom/usb_manager.mojom-blink-import-headers.h"
#include "services/device/public/mojom/usb_manager.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace device::mojom::blink {
// The declaration includes the definition on other builds.

UsbDeviceManager::IPCStableHashFunction UsbDeviceManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UsbDeviceManager>(message.name())) {
    case messages::UsbDeviceManager::kEnumerateDevicesAndSetClient: {
      return &UsbDeviceManager::EnumerateDevicesAndSetClient_Sym::IPCStableHash;
    }
    case messages::UsbDeviceManager::kGetDevices: {
      return &UsbDeviceManager::GetDevices_Sym::IPCStableHash;
    }
    case messages::UsbDeviceManager::kGetDevice: {
      return &UsbDeviceManager::GetDevice_Sym::IPCStableHash;
    }
    case messages::UsbDeviceManager::kGetSecurityKeyDevice: {
      return &UsbDeviceManager::GetSecurityKeyDevice_Sym::IPCStableHash;
    }
    case messages::UsbDeviceManager::kSetClient: {
      return &UsbDeviceManager::SetClient_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UsbDeviceManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UsbDeviceManager>(message.name())) {
      case messages::UsbDeviceManager::kEnumerateDevicesAndSetClient:
            return "Receive device::mojom::UsbDeviceManager::EnumerateDevicesAndSetClient";
      case messages::UsbDeviceManager::kGetDevices:
            return "Receive device::mojom::UsbDeviceManager::GetDevices";
      case messages::UsbDeviceManager::kGetDevice:
            return "Receive device::mojom::UsbDeviceManager::GetDevice";
      case messages::UsbDeviceManager::kGetSecurityKeyDevice:
            return "Receive device::mojom::UsbDeviceManager::GetSecurityKeyDevice";
      case messages::UsbDeviceManager::kSetClient:
            return "Receive device::mojom::UsbDeviceManager::SetClient";
    }
  } else {
    switch (static_cast<messages::UsbDeviceManager>(message.name())) {
      case messages::UsbDeviceManager::kEnumerateDevicesAndSetClient:
            return "Receive reply device::mojom::UsbDeviceManager::EnumerateDevicesAndSetClient";
      case messages::UsbDeviceManager::kGetDevices:
            return "Receive reply device::mojom::UsbDeviceManager::GetDevices";
      case messages::UsbDeviceManager::kGetDevice:
            return "Receive reply device::mojom::UsbDeviceManager::GetDevice";
      case messages::UsbDeviceManager::kGetSecurityKeyDevice:
            return "Receive reply device::mojom::UsbDeviceManager::GetSecurityKeyDevice";
      case messages::UsbDeviceManager::kSetClient:
            return "Receive reply device::mojom::UsbDeviceManager::SetClient";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UsbDeviceManager::EnumerateDevicesAndSetClient_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x677156a9;  // IPCStableHash for device::mojom::UsbDeviceManager::EnumerateDevicesAndSetClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UsbDeviceManager::GetDevices_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf2be670f;  // IPCStableHash for device::mojom::UsbDeviceManager::GetDevices
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UsbDeviceManager::GetDevice_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x33e789eb;  // IPCStableHash for device::mojom::UsbDeviceManager::GetDevice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UsbDeviceManager::GetSecurityKeyDevice_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0d2fb9da;  // IPCStableHash for device::mojom::UsbDeviceManager::GetSecurityKeyDevice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UsbDeviceManager::SetClient_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x62e15206;  // IPCStableHash for device::mojom::UsbDeviceManager::SetClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class UsbDeviceManager_EnumerateDevicesAndSetClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UsbDeviceManager_EnumerateDevicesAndSetClient_ForwardToCallback(
      UsbDeviceManager::EnumerateDevicesAndSetClientCallback callback
      ) : callback_(std::move(callback)) {
  }

  UsbDeviceManager_EnumerateDevicesAndSetClient_ForwardToCallback(const UsbDeviceManager_EnumerateDevicesAndSetClient_ForwardToCallback&) = delete;
  UsbDeviceManager_EnumerateDevicesAndSetClient_ForwardToCallback& operator=(const UsbDeviceManager_EnumerateDevicesAndSetClient_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UsbDeviceManager::EnumerateDevicesAndSetClientCallback callback_;
};

class UsbDeviceManager_GetDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UsbDeviceManager_GetDevices_ForwardToCallback(
      UsbDeviceManager::GetDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }

  UsbDeviceManager_GetDevices_ForwardToCallback(const UsbDeviceManager_GetDevices_ForwardToCallback&) = delete;
  UsbDeviceManager_GetDevices_ForwardToCallback& operator=(const UsbDeviceManager_GetDevices_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UsbDeviceManager::GetDevicesCallback callback_;
};

UsbDeviceManagerProxy::UsbDeviceManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UsbDeviceManagerProxy::EnumerateDevicesAndSetClient(
    ::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> in_client, EnumerateDevicesAndSetClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::UsbDeviceManager::EnumerateDevicesAndSetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UsbDeviceManager::kEnumerateDevicesAndSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManager_EnumerateDevicesAndSetClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::UsbDeviceManagerClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in UsbDeviceManager.EnumerateDevicesAndSetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManager::Name_);
  message.set_method_name("EnumerateDevicesAndSetClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UsbDeviceManager_EnumerateDevicesAndSetClient_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UsbDeviceManagerProxy::GetDevices(
    ::device::mojom::blink::UsbEnumerationOptionsPtr in_options, GetDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::UsbDeviceManager::GetDevices", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::device::mojom::blink::UsbEnumerationOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UsbDeviceManager::kGetDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManager_GetDevices_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::UsbEnumerationOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManager::Name_);
  message.set_method_name("GetDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UsbDeviceManager_GetDevices_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UsbDeviceManagerProxy::GetDevice(
    const ::blink::String& in_guid, const ::blink::Vector<uint8_t>& in_blocked_interface_classes, ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice> in_device_receiver, ::mojo::PendingRemote<::device::mojom::blink::UsbDeviceClient> in_device_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::UsbDeviceManager::GetDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guid"), in_guid,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blocked_interface_classes"), in_blocked_interface_classes,
                        "<value of type const ::blink::Vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_receiver"), in_device_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_client"), in_device_client,
                        "<value of type ::mojo::PendingRemote<::device::mojom::blink::UsbDeviceClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UsbDeviceManager::kGetDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManager_GetDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->guid)::BaseType> guid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_guid,
    guid_fragment);

  params->guid.Set(
      guid_fragment.is_null() ? nullptr : guid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->guid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null guid in UsbDeviceManager.GetDevice request");
  mojo::internal::MessageFragment<
      typename decltype(params->blocked_interface_classes)::BaseType>
      blocked_interface_classes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& blocked_interface_classes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_blocked_interface_classes,
    blocked_interface_classes_fragment,
    &blocked_interface_classes_validate_params);

  params->blocked_interface_classes.Set(
      blocked_interface_classes_fragment.is_null() ? nullptr : blocked_interface_classes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->blocked_interface_classes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null blocked_interface_classes in UsbDeviceManager.GetDevice request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::UsbDeviceInterfaceBase>>(
    in_device_receiver,
    &params->device_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->device_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid device_receiver in UsbDeviceManager.GetDevice request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::UsbDeviceClientInterfaceBase>>(
    in_device_client,
    &params->device_client,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManager::Name_);
  message.set_method_name("GetDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UsbDeviceManagerProxy::GetSecurityKeyDevice(
    const ::blink::String& in_guid, ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice> in_device_receiver, ::mojo::PendingRemote<::device::mojom::blink::UsbDeviceClient> in_device_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::UsbDeviceManager::GetSecurityKeyDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guid"), in_guid,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_receiver"), in_device_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_client"), in_device_client,
                        "<value of type ::mojo::PendingRemote<::device::mojom::blink::UsbDeviceClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UsbDeviceManager::kGetSecurityKeyDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManager_GetSecurityKeyDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->guid)::BaseType> guid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_guid,
    guid_fragment);

  params->guid.Set(
      guid_fragment.is_null() ? nullptr : guid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->guid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null guid in UsbDeviceManager.GetSecurityKeyDevice request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::UsbDeviceInterfaceBase>>(
    in_device_receiver,
    &params->device_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->device_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid device_receiver in UsbDeviceManager.GetSecurityKeyDevice request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::UsbDeviceClientInterfaceBase>>(
    in_device_client,
    &params->device_client,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManager::Name_);
  message.set_method_name("GetSecurityKeyDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UsbDeviceManagerProxy::SetClient(
    ::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::UsbDeviceManager::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UsbDeviceManager::kSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManager_SetClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::UsbDeviceManagerClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in UsbDeviceManager.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManager::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class UsbDeviceManager_EnumerateDevicesAndSetClient_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UsbDeviceManager::EnumerateDevicesAndSetClientCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UsbDeviceManager_EnumerateDevicesAndSetClient_ProxyToResponder> proxy(
        new UsbDeviceManager_EnumerateDevicesAndSetClient_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UsbDeviceManager_EnumerateDevicesAndSetClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UsbDeviceManager_EnumerateDevicesAndSetClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UsbDeviceManager_EnumerateDevicesAndSetClient_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "UsbDeviceManager::EnumerateDevicesAndSetClientCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr> in_results);
};

bool UsbDeviceManager_EnumerateDevicesAndSetClient_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UsbDeviceManager.0
  bool success = true;
  ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr> p_results{};
  UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UsbDeviceManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_results));
  }
  return true;
}

void UsbDeviceManager_EnumerateDevicesAndSetClient_ProxyToResponder::Run(
    ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr> in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::UsbDeviceManager::EnumerateDevicesAndSetClient", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UsbDeviceManager::kEnumerateDevicesAndSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType>
      results_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::UsbDeviceInfoDataView>>(
    in_results,
    results_fragment,
    &results_validate_params);

  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->results.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null results in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManager::Name_);
  message.set_method_name("EnumerateDevicesAndSetClient");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UsbDeviceManager_GetDevices_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UsbDeviceManager::GetDevicesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UsbDeviceManager_GetDevices_ProxyToResponder> proxy(
        new UsbDeviceManager_GetDevices_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UsbDeviceManager_GetDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UsbDeviceManager_GetDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UsbDeviceManager_GetDevices_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "UsbDeviceManager::GetDevicesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr> in_results);
};

bool UsbDeviceManager_GetDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UsbDeviceManager_GetDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UsbDeviceManager_GetDevices_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UsbDeviceManager.1
  bool success = true;
  ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr> p_results{};
  UsbDeviceManager_GetDevices_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UsbDeviceManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_results));
  }
  return true;
}

void UsbDeviceManager_GetDevices_ProxyToResponder::Run(
    ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr> in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::UsbDeviceManager::GetDevices", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UsbDeviceManager::kGetDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManager_GetDevices_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType>
      results_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::UsbDeviceInfoDataView>>(
    in_results,
    results_fragment,
    &results_validate_params);

  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->results.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null results in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManager::Name_);
  message.set_method_name("GetDevices");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool UsbDeviceManagerStubDispatch::Accept(
    UsbDeviceManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UsbDeviceManager>(message->header()->name)) {
    case messages::UsbDeviceManager::kEnumerateDevicesAndSetClient: {
      break;
    }
    case messages::UsbDeviceManager::kGetDevices: {
      break;
    }
    case messages::UsbDeviceManager::kGetDevice: {
      DCHECK(message->is_serialized());
      internal::UsbDeviceManager_GetDevice_Params_Data* params =
          reinterpret_cast<internal::UsbDeviceManager_GetDevice_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UsbDeviceManager.2
      bool success = true;
      ::blink::String p_guid{};
      ::blink::Vector<uint8_t> p_blocked_interface_classes{};
      ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice> p_device_receiver{};
      ::mojo::PendingRemote<::device::mojom::blink::UsbDeviceClient> p_device_client{};
      UsbDeviceManager_GetDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGuid(&p_guid))
        success = false;
      if (success && !input_data_view.ReadBlockedInterfaceClasses(&p_blocked_interface_classes))
        success = false;
      if (success) {
        p_device_receiver =
            input_data_view.TakeDeviceReceiver<decltype(p_device_receiver)>();
      }
      if (success) {
        p_device_client =
            input_data_view.TakeDeviceClient<decltype(p_device_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDevice(        
        std::move(p_guid), 
        std::move(p_blocked_interface_classes), 
        std::move(p_device_receiver), 
        std::move(p_device_client));
      return true;
    }
    case messages::UsbDeviceManager::kGetSecurityKeyDevice: {
      DCHECK(message->is_serialized());
      internal::UsbDeviceManager_GetSecurityKeyDevice_Params_Data* params =
          reinterpret_cast<internal::UsbDeviceManager_GetSecurityKeyDevice_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UsbDeviceManager.3
      bool success = true;
      ::blink::String p_guid{};
      ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice> p_device_receiver{};
      ::mojo::PendingRemote<::device::mojom::blink::UsbDeviceClient> p_device_client{};
      UsbDeviceManager_GetSecurityKeyDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGuid(&p_guid))
        success = false;
      if (success) {
        p_device_receiver =
            input_data_view.TakeDeviceReceiver<decltype(p_device_receiver)>();
      }
      if (success) {
        p_device_client =
            input_data_view.TakeDeviceClient<decltype(p_device_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManager::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSecurityKeyDevice(        
        std::move(p_guid), 
        std::move(p_device_receiver), 
        std::move(p_device_client));
      return true;
    }
    case messages::UsbDeviceManager::kSetClient: {
      DCHECK(message->is_serialized());
      internal::UsbDeviceManager_SetClient_Params_Data* params =
          reinterpret_cast<internal::UsbDeviceManager_SetClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UsbDeviceManager.4
      bool success = true;
      ::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> p_client{};
      UsbDeviceManager_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManager::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(        
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool UsbDeviceManagerStubDispatch::AcceptWithResponder(
    UsbDeviceManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UsbDeviceManager>(message->header()->name)) {
    case messages::UsbDeviceManager::kEnumerateDevicesAndSetClient: {
      internal::UsbDeviceManager_EnumerateDevicesAndSetClient_Params_Data* params =
          reinterpret_cast<
              internal::UsbDeviceManager_EnumerateDevicesAndSetClient_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UsbDeviceManager.0
      bool success = true;
      ::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> p_client{};
      UsbDeviceManager_EnumerateDevicesAndSetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManager::Name_, 0, false);
        return false;
      }
      auto callback =
          UsbDeviceManager_EnumerateDevicesAndSetClient_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnumerateDevicesAndSetClient(        
        std::move(p_client), std::move(callback));
      return true;
    }
    case messages::UsbDeviceManager::kGetDevices: {
      internal::UsbDeviceManager_GetDevices_Params_Data* params =
          reinterpret_cast<
              internal::UsbDeviceManager_GetDevices_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UsbDeviceManager.1
      bool success = true;
      ::device::mojom::blink::UsbEnumerationOptionsPtr p_options{};
      UsbDeviceManager_GetDevices_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManager::Name_, 1, false);
        return false;
      }
      auto callback =
          UsbDeviceManager_GetDevices_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDevices(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::UsbDeviceManager::kGetDevice: {
      break;
    }
    case messages::UsbDeviceManager::kGetSecurityKeyDevice: {
      break;
    }
    case messages::UsbDeviceManager::kSetClient: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kUsbDeviceManagerValidationInfo[] = {
    { &internal::UsbDeviceManager_EnumerateDevicesAndSetClient_Params_Data::Validate,
     &internal::UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParams_Data::Validate},
    { &internal::UsbDeviceManager_GetDevices_Params_Data::Validate,
     &internal::UsbDeviceManager_GetDevices_ResponseParams_Data::Validate},
    { &internal::UsbDeviceManager_GetDevice_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UsbDeviceManager_GetSecurityKeyDevice_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UsbDeviceManager_SetClient_Params_Data::Validate,
     nullptr /* no response */},
};

bool UsbDeviceManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::UsbDeviceManager::Name_,
    kUsbDeviceManagerValidationInfo);
}

bool UsbDeviceManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device::mojom::blink::UsbDeviceManager::Name_,
    kUsbDeviceManagerValidationInfo);
}


}  // device::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom::blink {


void UsbDeviceManagerInterceptorForTesting::EnumerateDevicesAndSetClient(::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> client, EnumerateDevicesAndSetClientCallback callback) {
  GetForwardingInterface()->EnumerateDevicesAndSetClient(
    std::move(client)
    , std::move(callback));
}
void UsbDeviceManagerInterceptorForTesting::GetDevices(::device::mojom::blink::UsbEnumerationOptionsPtr options, GetDevicesCallback callback) {
  GetForwardingInterface()->GetDevices(
    std::move(options)
    , std::move(callback));
}
void UsbDeviceManagerInterceptorForTesting::GetDevice(const ::blink::String& guid, const ::blink::Vector<uint8_t>& blocked_interface_classes, ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice> device_receiver, ::mojo::PendingRemote<::device::mojom::blink::UsbDeviceClient> device_client) {
  GetForwardingInterface()->GetDevice(
    std::move(guid)
    , 
    std::move(blocked_interface_classes)
    , 
    std::move(device_receiver)
    , 
    std::move(device_client)
    );
}
void UsbDeviceManagerInterceptorForTesting::GetSecurityKeyDevice(const ::blink::String& guid, ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice> device_receiver, ::mojo::PendingRemote<::device::mojom::blink::UsbDeviceClient> device_client) {
  GetForwardingInterface()->GetSecurityKeyDevice(
    std::move(guid)
    , 
    std::move(device_receiver)
    , 
    std::move(device_client)
    );
}
void UsbDeviceManagerInterceptorForTesting::SetClient(::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> client) {
  GetForwardingInterface()->SetClient(
    std::move(client)
    );
}
UsbDeviceManagerAsyncWaiter::UsbDeviceManagerAsyncWaiter(
    UsbDeviceManager* proxy) : proxy_(proxy) {}

UsbDeviceManagerAsyncWaiter::~UsbDeviceManagerAsyncWaiter() = default;


void UsbDeviceManagerAsyncWaiter::EnumerateDevicesAndSetClient(
    ::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> client, ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr>* out_results) {
  base::RunLoop loop;
  proxy_->EnumerateDevicesAndSetClient(
      std::move(client),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr>* out_results
,
             ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr> results) {*out_results = std::move(results);
            loop->Quit();
          },
          &loop,
          out_results));
  loop.Run();
}

::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr> UsbDeviceManagerAsyncWaiter::EnumerateDevicesAndSetClient(
    ::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> client) {
  ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr> async_wait_result;
  EnumerateDevicesAndSetClient(std::move(client),&async_wait_result);
  return async_wait_result;
}

void UsbDeviceManagerAsyncWaiter::GetDevices(
    ::device::mojom::blink::UsbEnumerationOptionsPtr options, ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr>* out_results) {
  base::RunLoop loop;
  proxy_->GetDevices(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr>* out_results
,
             ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr> results) {*out_results = std::move(results);
            loop->Quit();
          },
          &loop,
          out_results));
  loop.Run();
}

::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr> UsbDeviceManagerAsyncWaiter::GetDevices(
    ::device::mojom::blink::UsbEnumerationOptionsPtr options) {
  ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr> async_wait_result;
  GetDevices(std::move(options),&async_wait_result);
  return async_wait_result;
}






}  // device::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif