// services/network/public/mojom/cert_verifier_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/cert_verifier_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cert_verifier_service.mojom-params-data.h"
namespace cert_verifier {
namespace mojom {

namespace internal {


// static
bool RequestParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RequestParams_Data* object =
      static_cast<const RequestParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->certificate, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->certificate, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hostname, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hostname_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->hostname, validation_context,
                                         &hostname_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ocsp_response, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ocsp_response, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sct_list, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sct_list, validation_context))
    return false;

  return true;
}

RequestParams_Data::RequestParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierConfig_Data* object =
      static_cast<const CertVerifierConfig_Data*>(data);

  return true;
}

CertVerifierConfig_Data::CertVerifierConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderFactoryConnector_CreateURLLoaderFactory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URLLoaderFactoryConnector_CreateURLLoaderFactory_Params_Data* object =
      static_cast<const URLLoaderFactoryConnector_CreateURLLoaderFactory_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->url_loader_factory, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->url_loader_factory,
                                                 validation_context)) {
    return false;
  }

  return true;
}

URLLoaderFactoryConnector_CreateURLLoaderFactory_Params_Data::URLLoaderFactoryConnector_CreateURLLoaderFactory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierService_EnableNetworkAccess_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierService_EnableNetworkAccess_Params_Data* object =
      static_cast<const CertVerifierService_EnableNetworkAccess_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->url_loader_factory, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->url_loader_factory,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->reconnector,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CertVerifierService_EnableNetworkAccess_Params_Data::CertVerifierService_EnableNetworkAccess_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierService_Verify_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierService_Verify_Params_Data* object =
      static_cast<const CertVerifierService_Verify_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->net_log_source, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->net_log_source, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->cert_verifier_request, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->cert_verifier_request,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CertVerifierService_Verify_Params_Data::CertVerifierService_Verify_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierService_Verify2QwacBinding_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierService_Verify2QwacBinding_Params_Data* object =
      static_cast<const CertVerifierService_Verify2QwacBinding_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->binding, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& binding_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->binding, validation_context,
                                         &binding_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hostname, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hostname_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->hostname, validation_context,
                                         &hostname_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tls_certificate, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tls_certificate, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->net_log_source, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->net_log_source, validation_context))
    return false;

  return true;
}

CertVerifierService_Verify2QwacBinding_Params_Data::CertVerifierService_Verify2QwacBinding_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierService_Verify2QwacBinding_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierService_Verify2QwacBinding_ResponseParams_Data* object =
      static_cast<const CertVerifierService_Verify2QwacBinding_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->verified_cert, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->verified_cert, validation_context))
    return false;

  return true;
}

CertVerifierService_Verify2QwacBinding_ResponseParams_Data::CertVerifierService_Verify2QwacBinding_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierService_SetConfig_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierService_SetConfig_Params_Data* object =
      static_cast<const CertVerifierService_SetConfig_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  return true;
}

CertVerifierService_SetConfig_Params_Data::CertVerifierService_SetConfig_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceClient_OnCertVerifierChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceClient_OnCertVerifierChanged_Params_Data* object =
      static_cast<const CertVerifierServiceClient_OnCertVerifierChanged_Params_Data*>(data);

  return true;
}

CertVerifierServiceClient_OnCertVerifierChanged_Params_Data::CertVerifierServiceClient_OnCertVerifierChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierRequest_Complete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierRequest_Complete_Params_Data* object =
      static_cast<const CertVerifierRequest_Complete_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

CertVerifierRequest_Complete_Params_Data::CertVerifierRequest_Complete_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace cert_verifier