// services/network/public/mojom/p2p.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/p2p.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/p2p.mojom-params-data.h"
#include "services/network/public/mojom/p2p.mojom-shared-message-ids.h"

#include "services/network/public/mojom/p2p.mojom-import-headers.h"
#include "services/network/public/mojom/p2p.mojom-test-utils.h"


namespace network::mojom {
P2PReceivedPacket::P2PReceivedPacket()
    : data(),
      socket_address(),
      timestamp(),
      ecn() {}

P2PReceivedPacket::P2PReceivedPacket(
    ::base::span<const ::uint8_t> data_in,
    const ::net::IPEndPoint& socket_address_in,
    ::base::TimeTicks timestamp_in,
    ::webrtc::EcnMarking ecn_in)
    : data(std::move(data_in)),
      socket_address(std::move(socket_address_in)),
      timestamp(std::move(timestamp_in)),
      ecn(std::move(ecn_in)) {}

P2PReceivedPacket::~P2PReceivedPacket() = default;

void P2PReceivedPacket::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::span<const ::uint8_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "socket_address"), this->socket_address,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::IPEndPoint&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ecn"), this->ecn,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::webrtc::EcnMarking>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool P2PReceivedPacket::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
P2PSendPacket::P2PSendPacket()
    : data(),
      packet_info() {}

P2PSendPacket::P2PSendPacket(
    ::base::span<const ::uint8_t> data_in,
    const ::network::P2PPacketInfo& packet_info_in)
    : data(std::move(data_in)),
      packet_info(std::move(packet_info_in)) {}

P2PSendPacket::~P2PSendPacket() = default;

void P2PSendPacket::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::span<const ::uint8_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "packet_info"), this->packet_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::network::P2PPacketInfo&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool P2PSendPacket::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

P2PNetworkNotificationClient::IPCStableHashFunction P2PNetworkNotificationClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::P2PNetworkNotificationClient>(message.name())) {
    case messages::P2PNetworkNotificationClient::kNetworkListChanged: {
      return &P2PNetworkNotificationClient::NetworkListChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* P2PNetworkNotificationClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::P2PNetworkNotificationClient>(message.name())) {
      case messages::P2PNetworkNotificationClient::kNetworkListChanged:
            return "Receive network::mojom::P2PNetworkNotificationClient::NetworkListChanged";
    }
  } else {
    switch (static_cast<messages::P2PNetworkNotificationClient>(message.name())) {
      case messages::P2PNetworkNotificationClient::kNetworkListChanged:
            return "Receive reply network::mojom::P2PNetworkNotificationClient::NetworkListChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t P2PNetworkNotificationClient::NetworkListChanged_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x93dde2c5;  // IPCStableHash for network::mojom::P2PNetworkNotificationClient::NetworkListChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

P2PNetworkNotificationClientProxy::P2PNetworkNotificationClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void P2PNetworkNotificationClientProxy::NetworkListChanged(
    const std::vector<::net::NetworkInterface>& in_networks, const ::net::IPAddress& in_default_ipv4_local_address, const ::net::IPAddress& in_default_ipv6_local_address) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::P2PNetworkNotificationClient::NetworkListChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("networks"), in_networks,
                        "<value of type const std::vector<::net::NetworkInterface>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_ipv4_local_address"), in_default_ipv4_local_address,
                        "<value of type const ::net::IPAddress&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_ipv6_local_address"), in_default_ipv6_local_address,
                        "<value of type const ::net::IPAddress&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::P2PNetworkNotificationClient::kNetworkListChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PNetworkNotificationClient_NetworkListChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->networks)::BaseType>
      networks_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& networks_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::NetworkInterfaceDataView>>(
    in_networks,
    networks_fragment,
    &networks_validate_params);

  params->networks.Set(
      networks_fragment.is_null() ? nullptr : networks_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->networks.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null networks in P2PNetworkNotificationClient.NetworkListChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->default_ipv4_local_address)::BaseType> default_ipv4_local_address_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPAddressDataView>(
    in_default_ipv4_local_address,
    default_ipv4_local_address_fragment);

  params->default_ipv4_local_address.Set(
      default_ipv4_local_address_fragment.is_null() ? nullptr : default_ipv4_local_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->default_ipv4_local_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null default_ipv4_local_address in P2PNetworkNotificationClient.NetworkListChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->default_ipv6_local_address)::BaseType> default_ipv6_local_address_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPAddressDataView>(
    in_default_ipv6_local_address,
    default_ipv6_local_address_fragment);

  params->default_ipv6_local_address.Set(
      default_ipv6_local_address_fragment.is_null() ? nullptr : default_ipv6_local_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->default_ipv6_local_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null default_ipv6_local_address in P2PNetworkNotificationClient.NetworkListChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PNetworkNotificationClient::Name_);
  message.set_method_name("NetworkListChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool P2PNetworkNotificationClientStubDispatch::Accept(
    P2PNetworkNotificationClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::P2PNetworkNotificationClient>(message->header()->name)) {
    case messages::P2PNetworkNotificationClient::kNetworkListChanged: {
      DCHECK(message->is_serialized());
      internal::P2PNetworkNotificationClient_NetworkListChanged_Params_Data* params =
          reinterpret_cast<internal::P2PNetworkNotificationClient_NetworkListChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for P2PNetworkNotificationClient.0
      bool success = true;
      std::vector<::net::NetworkInterface> p_networks{};
      ::net::IPAddress p_default_ipv4_local_address{};
      ::net::IPAddress p_default_ipv6_local_address{};
      P2PNetworkNotificationClient_NetworkListChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNetworks(&p_networks))
        success = false;
      if (success && !input_data_view.ReadDefaultIpv4LocalAddress(&p_default_ipv4_local_address))
        success = false;
      if (success && !input_data_view.ReadDefaultIpv6LocalAddress(&p_default_ipv6_local_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PNetworkNotificationClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NetworkListChanged(        
        std::move(p_networks), 
        std::move(p_default_ipv4_local_address), 
        std::move(p_default_ipv6_local_address));
      return true;
    }
  }
  return false;
}

// static
bool P2PNetworkNotificationClientStubDispatch::AcceptWithResponder(
    P2PNetworkNotificationClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::P2PNetworkNotificationClient>(message->header()->name)) {
    case messages::P2PNetworkNotificationClient::kNetworkListChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kP2PNetworkNotificationClientValidationInfo[] = {
    {base::to_underlying(messages::P2PNetworkNotificationClient::kNetworkListChanged),
     { &internal::P2PNetworkNotificationClient_NetworkListChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool P2PNetworkNotificationClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::P2PNetworkNotificationClient::Name_,
    kP2PNetworkNotificationClientValidationInfo);
}

// The declaration includes the definition on other builds.

P2PSocketManager::IPCStableHashFunction P2PSocketManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::P2PSocketManager>(message.name())) {
    case messages::P2PSocketManager::kStartNetworkNotifications: {
      return &P2PSocketManager::StartNetworkNotifications_Sym::IPCStableHash;
    }
    case messages::P2PSocketManager::kGetHostAddress: {
      return &P2PSocketManager::GetHostAddress_Sym::IPCStableHash;
    }
    case messages::P2PSocketManager::kCreateSocket: {
      return &P2PSocketManager::CreateSocket_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* P2PSocketManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::P2PSocketManager>(message.name())) {
      case messages::P2PSocketManager::kStartNetworkNotifications:
            return "Receive network::mojom::P2PSocketManager::StartNetworkNotifications";
      case messages::P2PSocketManager::kGetHostAddress:
            return "Receive network::mojom::P2PSocketManager::GetHostAddress";
      case messages::P2PSocketManager::kCreateSocket:
            return "Receive network::mojom::P2PSocketManager::CreateSocket";
    }
  } else {
    switch (static_cast<messages::P2PSocketManager>(message.name())) {
      case messages::P2PSocketManager::kStartNetworkNotifications:
            return "Receive reply network::mojom::P2PSocketManager::StartNetworkNotifications";
      case messages::P2PSocketManager::kGetHostAddress:
            return "Receive reply network::mojom::P2PSocketManager::GetHostAddress";
      case messages::P2PSocketManager::kCreateSocket:
            return "Receive reply network::mojom::P2PSocketManager::CreateSocket";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t P2PSocketManager::StartNetworkNotifications_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd50acea;  // IPCStableHash for network::mojom::P2PSocketManager::StartNetworkNotifications
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t P2PSocketManager::GetHostAddress_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcac9c1b8;  // IPCStableHash for network::mojom::P2PSocketManager::GetHostAddress
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t P2PSocketManager::CreateSocket_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x608b3797;  // IPCStableHash for network::mojom::P2PSocketManager::CreateSocket
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class P2PSocketManager_GetHostAddress_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  P2PSocketManager_GetHostAddress_ForwardToCallback(
      P2PSocketManager::GetHostAddressCallback callback
      ) : callback_(std::move(callback)) {
  }

  P2PSocketManager_GetHostAddress_ForwardToCallback(const P2PSocketManager_GetHostAddress_ForwardToCallback&) = delete;
  P2PSocketManager_GetHostAddress_ForwardToCallback& operator=(const P2PSocketManager_GetHostAddress_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  P2PSocketManager::GetHostAddressCallback callback_;
};

P2PSocketManagerProxy::P2PSocketManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void P2PSocketManagerProxy::StartNetworkNotifications(
    ::mojo::PendingRemote<P2PNetworkNotificationClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::P2PSocketManager::StartNetworkNotifications", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<P2PNetworkNotificationClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::P2PSocketManager::kStartNetworkNotifications), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocketManager_StartNetworkNotifications_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::P2PNetworkNotificationClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in P2PSocketManager.StartNetworkNotifications request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocketManager::Name_);
  message.set_method_name("StartNetworkNotifications");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void P2PSocketManagerProxy::GetHostAddress(
    const std::string& in_host_name, std::optional<::net::AddressFamily> in_address_family, bool in_enable_mdns, GetHostAddressCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::P2PSocketManager::GetHostAddress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_name"), in_host_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("address_family"), in_address_family,
                        "<value of type std::optional<::net::AddressFamily>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable_mdns"), in_enable_mdns,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::P2PSocketManager::kGetHostAddress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocketManager_GetHostAddress_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host_name)::BaseType> host_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_host_name,
    host_name_fragment);

  params->host_name.Set(
      host_name_fragment.is_null() ? nullptr : host_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->host_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null host_name in P2PSocketManager.GetHostAddress request");
  params->address_family_$flag = in_address_family.has_value();
  if (in_address_family.has_value()) {
    
    mojo::internal::Serialize<::network::mojom::AddressFamily>(
      in_address_family.value(),
      &params->address_family_$value);
  } else {
    params->address_family_$value =
        static_cast<int32_t>(::network::mojom::AddressFamily::kMinValue);
  }

  params->enable_mdns = in_enable_mdns;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocketManager::Name_);
  message.set_method_name("GetHostAddress");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new P2PSocketManager_GetHostAddress_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void P2PSocketManagerProxy::CreateSocket(
    ::network::P2PSocketType in_type, const ::net::IPEndPoint& in_local_address, const ::network::P2PPortRange& in_port_range, const ::network::P2PHostAndIPEndPoint& in_remote_address, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, const std::optional<::base::UnguessableToken>& in_devtools_token, ::mojo::PendingRemote<P2PSocketClient> in_client, ::mojo::PendingReceiver<P2PSocket> in_socket) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::P2PSocketManager::CreateSocket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::network::P2PSocketType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_address"), in_local_address,
                        "<value of type const ::net::IPEndPoint&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_range"), in_port_range,
                        "<value of type const ::network::P2PPortRange&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_address"), in_remote_address,
                        "<value of type const ::network::P2PHostAndIPEndPoint&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation,
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_token"), in_devtools_token,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<P2PSocketClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("socket"), in_socket,
                        "<value of type ::mojo::PendingReceiver<P2PSocket>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::P2PSocketManager::kCreateSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocketManager_CreateSocket_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::P2PSocketType>(
    in_type,
    &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->local_address)::BaseType> local_address_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_local_address,
    local_address_fragment);

  params->local_address.Set(
      local_address_fragment.is_null() ? nullptr : local_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->local_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null local_address in P2PSocketManager.CreateSocket request");
  mojo::internal::MessageFragment<
      typename decltype(params->port_range)::BaseType> port_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::P2PPortRangeDataView>(
    in_port_range,
    port_range_fragment);

  params->port_range.Set(
      port_range_fragment.is_null() ? nullptr : port_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->port_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null port_range in P2PSocketManager.CreateSocket request");
  mojo::internal::MessageFragment<
      typename decltype(params->remote_address)::BaseType> remote_address_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::P2PHostAndIPEndPointDataView>(
    in_remote_address,
    remote_address_fragment);

  params->remote_address.Set(
      remote_address_fragment.is_null() ? nullptr : remote_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->remote_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null remote_address in P2PSocketManager.CreateSocket request");
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
    in_traffic_annotation,
    traffic_annotation_fragment);

  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->traffic_annotation.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null traffic_annotation in P2PSocketManager.CreateSocket request");
  mojo::internal::MessageFragment<
      typename decltype(params->devtools_token)::BaseType> devtools_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_devtools_token,
    devtools_token_fragment);

  params->devtools_token.Set(
      devtools_token_fragment.is_null() ? nullptr : devtools_token_fragment.data());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::P2PSocketClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in P2PSocketManager.CreateSocket request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::P2PSocketInterfaceBase>>(
    in_socket,
    &params->socket,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->socket)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid socket in P2PSocketManager.CreateSocket request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocketManager::Name_);
  message.set_method_name("CreateSocket");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class P2PSocketManager_GetHostAddress_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static P2PSocketManager::GetHostAddressCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<P2PSocketManager_GetHostAddress_ProxyToResponder> proxy(
        new P2PSocketManager_GetHostAddress_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&P2PSocketManager_GetHostAddress_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~P2PSocketManager_GetHostAddress_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  P2PSocketManager_GetHostAddress_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "P2PSocketManager::GetHostAddressCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::net::IPAddress>& in_addresses);
};

bool P2PSocketManager_GetHostAddress_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::P2PSocketManager_GetHostAddress_ResponseParams_Data* params =
      reinterpret_cast<
          internal::P2PSocketManager_GetHostAddress_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for P2PSocketManager.1
  bool success = true;
  std::vector<::net::IPAddress> p_addresses{};
  P2PSocketManager_GetHostAddress_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAddresses(&p_addresses))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        P2PSocketManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_addresses));
  }
  return true;
}

void P2PSocketManager_GetHostAddress_ProxyToResponder::Run(
    const std::vector<::net::IPAddress>& in_addresses) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::P2PSocketManager::GetHostAddress", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("addresses"), in_addresses,
                        "<value of type const std::vector<::net::IPAddress>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::P2PSocketManager::kGetHostAddress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocketManager_GetHostAddress_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->addresses)::BaseType>
      addresses_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& addresses_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::IPAddressDataView>>(
    in_addresses,
    addresses_fragment,
    &addresses_validate_params);

  params->addresses.Set(
      addresses_fragment.is_null() ? nullptr : addresses_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->addresses.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null addresses in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocketManager::Name_);
  message.set_method_name("GetHostAddress");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool P2PSocketManagerStubDispatch::Accept(
    P2PSocketManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::P2PSocketManager>(message->header()->name)) {
    case messages::P2PSocketManager::kStartNetworkNotifications: {
      DCHECK(message->is_serialized());
      internal::P2PSocketManager_StartNetworkNotifications_Params_Data* params =
          reinterpret_cast<internal::P2PSocketManager_StartNetworkNotifications_Params_Data*>(
              message->mutable_payload());
      

      // Validation for P2PSocketManager.0
      bool success = true;
      ::mojo::PendingRemote<P2PNetworkNotificationClient> p_client{};
      P2PSocketManager_StartNetworkNotifications_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocketManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartNetworkNotifications(        
        std::move(p_client));
      return true;
    }
    case messages::P2PSocketManager::kGetHostAddress: {
      break;
    }
    case messages::P2PSocketManager::kCreateSocket: {
      DCHECK(message->is_serialized());
      internal::P2PSocketManager_CreateSocket_Params_Data* params =
          reinterpret_cast<internal::P2PSocketManager_CreateSocket_Params_Data*>(
              message->mutable_payload());
      

      // Validation for P2PSocketManager.2
      bool success = true;
      ::network::P2PSocketType p_type{};
      ::net::IPEndPoint p_local_address{};
      ::network::P2PPortRange p_port_range{};
      ::network::P2PHostAndIPEndPoint p_remote_address{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      std::optional<::base::UnguessableToken> p_devtools_token{};
      ::mojo::PendingRemote<P2PSocketClient> p_client{};
      ::mojo::PendingReceiver<P2PSocket> p_socket{};
      P2PSocketManager_CreateSocket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadLocalAddress(&p_local_address))
        success = false;
      if (success && !input_data_view.ReadPortRange(&p_port_range))
        success = false;
      if (success && !input_data_view.ReadRemoteAddress(&p_remote_address))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (success && !input_data_view.ReadDevtoolsToken(&p_devtools_token))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_socket =
            input_data_view.TakeSocket<decltype(p_socket)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocketManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateSocket(        
        std::move(p_type), 
        std::move(p_local_address), 
        std::move(p_port_range), 
        std::move(p_remote_address), 
        std::move(p_traffic_annotation), 
        std::move(p_devtools_token), 
        std::move(p_client), 
        std::move(p_socket));
      return true;
    }
  }
  return false;
}

// static
bool P2PSocketManagerStubDispatch::AcceptWithResponder(
    P2PSocketManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::P2PSocketManager>(message->header()->name)) {
    case messages::P2PSocketManager::kStartNetworkNotifications: {
      break;
    }
    case messages::P2PSocketManager::kGetHostAddress: {
      internal::P2PSocketManager_GetHostAddress_Params_Data* params =
          reinterpret_cast<
              internal::P2PSocketManager_GetHostAddress_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for P2PSocketManager.1
      bool success = true;
      std::string p_host_name{};
      std::optional<::net::AddressFamily> p_address_family{};
      bool p_enable_mdns{};
      P2PSocketManager_GetHostAddress_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHostName(&p_host_name))
        success = false;
      if (success && !input_data_view.ReadAddressFamily(&p_address_family)) {
        success = false;
      }
      if (success)
        p_enable_mdns = input_data_view.enable_mdns();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocketManager::Name_, 1, false);
        return false;
      }
      auto callback =
          P2PSocketManager_GetHostAddress_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetHostAddress(        
        std::move(p_host_name), 
        std::move(p_address_family), 
        std::move(p_enable_mdns), std::move(callback));
      return true;
    }
    case messages::P2PSocketManager::kCreateSocket: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kP2PSocketManagerValidationInfo[] = {
    {base::to_underlying(messages::P2PSocketManager::kStartNetworkNotifications),
     { &internal::P2PSocketManager_StartNetworkNotifications_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::P2PSocketManager::kGetHostAddress),
     { &internal::P2PSocketManager_GetHostAddress_Params_Data::Validate,
      &internal::P2PSocketManager_GetHostAddress_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::P2PSocketManager::kCreateSocket),
     { &internal::P2PSocketManager_CreateSocket_Params_Data::Validate,
      nullptr /* no response */}},
};

bool P2PSocketManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::P2PSocketManager::Name_,
    kP2PSocketManagerValidationInfo);
}

bool P2PSocketManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::network::mojom::P2PSocketManager::Name_,
    kP2PSocketManagerValidationInfo);

}
// The declaration includes the definition on other builds.

P2PSocket::IPCStableHashFunction P2PSocket::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::P2PSocket>(message.name())) {
    case messages::P2PSocket::kSend: {
      return &P2PSocket::Send_Sym::IPCStableHash;
    }
    case messages::P2PSocket::kSendBatch: {
      return &P2PSocket::SendBatch_Sym::IPCStableHash;
    }
    case messages::P2PSocket::kSetOption: {
      return &P2PSocket::SetOption_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* P2PSocket::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::P2PSocket>(message.name())) {
      case messages::P2PSocket::kSend:
            return "Receive network::mojom::P2PSocket::Send";
      case messages::P2PSocket::kSendBatch:
            return "Receive network::mojom::P2PSocket::SendBatch";
      case messages::P2PSocket::kSetOption:
            return "Receive network::mojom::P2PSocket::SetOption";
    }
  } else {
    switch (static_cast<messages::P2PSocket>(message.name())) {
      case messages::P2PSocket::kSend:
            return "Receive reply network::mojom::P2PSocket::Send";
      case messages::P2PSocket::kSendBatch:
            return "Receive reply network::mojom::P2PSocket::SendBatch";
      case messages::P2PSocket::kSetOption:
            return "Receive reply network::mojom::P2PSocket::SetOption";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t P2PSocket::Send_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xee5e0289;  // IPCStableHash for network::mojom::P2PSocket::Send
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t P2PSocket::SendBatch_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x09224ab2;  // IPCStableHash for network::mojom::P2PSocket::SendBatch
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t P2PSocket::SetOption_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf7cdd061;  // IPCStableHash for network::mojom::P2PSocket::SetOption
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

P2PSocketProxy::P2PSocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void P2PSocketProxy::Send(
    ::base::span<const ::uint8_t> in_data, const ::network::P2PPacketInfo& in_packet_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::P2PSocket::Send", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::base::span<const ::uint8_t>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("packet_info"), in_packet_info,
                        "<value of type const ::network::P2PPacketInfo&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::P2PSocket::kSend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocket_Send_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in P2PSocket.Send request");
  mojo::internal::MessageFragment<
      typename decltype(params->packet_info)::BaseType> packet_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::P2PPacketInfoDataView>(
    in_packet_info,
    packet_info_fragment);

  params->packet_info.Set(
      packet_info_fragment.is_null() ? nullptr : packet_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->packet_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null packet_info in P2PSocket.Send request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocket::Name_);
  message.set_method_name("Send");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void P2PSocketProxy::SendBatch(
    std::vector<P2PSendPacketPtr> in_packet_batch) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::P2PSocket::SendBatch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("packet_batch"), in_packet_batch,
                        "<value of type std::vector<P2PSendPacketPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::P2PSocket::kSendBatch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocket_SendBatch_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->packet_batch)::BaseType>
      packet_batch_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& packet_batch_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::P2PSendPacketDataView>>(
    in_packet_batch,
    packet_batch_fragment,
    &packet_batch_validate_params);

  params->packet_batch.Set(
      packet_batch_fragment.is_null() ? nullptr : packet_batch_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->packet_batch.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null packet_batch in P2PSocket.SendBatch request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocket::Name_);
  message.set_method_name("SendBatch");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void P2PSocketProxy::SetOption(
    ::network::P2PSocketOption in_option, int32_t in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::P2PSocket::SetOption", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("option"), in_option,
                        "<value of type ::network::P2PSocketOption>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::P2PSocket::kSetOption), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocket_SetOption_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::P2PSocketOption>(
    in_option,
    &params->option);

  params->value = in_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocket::Name_);
  message.set_method_name("SetOption");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool P2PSocketStubDispatch::Accept(
    P2PSocket* impl,
    mojo::Message* message) {
  switch (static_cast<messages::P2PSocket>(message->header()->name)) {
    case messages::P2PSocket::kSend: {
      DCHECK(message->is_serialized());
      internal::P2PSocket_Send_Params_Data* params =
          reinterpret_cast<internal::P2PSocket_Send_Params_Data*>(
              message->mutable_payload());
      

      // Validation for P2PSocket.0
      bool success = true;
      ::base::span<const ::uint8_t> p_data{};
      ::network::P2PPacketInfo p_packet_info{};
      P2PSocket_Send_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success && !input_data_view.ReadPacketInfo(&p_packet_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocket::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Send(        
        std::move(p_data), 
        std::move(p_packet_info));
      return true;
    }
    case messages::P2PSocket::kSendBatch: {
      DCHECK(message->is_serialized());
      internal::P2PSocket_SendBatch_Params_Data* params =
          reinterpret_cast<internal::P2PSocket_SendBatch_Params_Data*>(
              message->mutable_payload());
      

      // Validation for P2PSocket.1
      bool success = true;
      std::vector<P2PSendPacketPtr> p_packet_batch{};
      P2PSocket_SendBatch_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPacketBatch(&p_packet_batch))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocket::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendBatch(        
        std::move(p_packet_batch));
      return true;
    }
    case messages::P2PSocket::kSetOption: {
      DCHECK(message->is_serialized());
      internal::P2PSocket_SetOption_Params_Data* params =
          reinterpret_cast<internal::P2PSocket_SetOption_Params_Data*>(
              message->mutable_payload());
      

      // Validation for P2PSocket.2
      bool success = true;
      ::network::P2PSocketOption p_option{};
      int32_t p_value{};
      P2PSocket_SetOption_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOption(&p_option))
        success = false;
      if (success)
        p_value = input_data_view.value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocket::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOption(        
        std::move(p_option), 
        std::move(p_value));
      return true;
    }
  }
  return false;
}

// static
bool P2PSocketStubDispatch::AcceptWithResponder(
    P2PSocket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::P2PSocket>(message->header()->name)) {
    case messages::P2PSocket::kSend: {
      break;
    }
    case messages::P2PSocket::kSendBatch: {
      break;
    }
    case messages::P2PSocket::kSetOption: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kP2PSocketValidationInfo[] = {
    {base::to_underlying(messages::P2PSocket::kSend),
     { &internal::P2PSocket_Send_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::P2PSocket::kSendBatch),
     { &internal::P2PSocket_SendBatch_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::P2PSocket::kSetOption),
     { &internal::P2PSocket_SetOption_Params_Data::Validate,
      nullptr /* no response */}},
};

bool P2PSocketRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::P2PSocket::Name_,
    kP2PSocketValidationInfo);
}

// The declaration includes the definition on other builds.

P2PSocketClient::IPCStableHashFunction P2PSocketClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::P2PSocketClient>(message.name())) {
    case messages::P2PSocketClient::kSocketCreated: {
      return &P2PSocketClient::SocketCreated_Sym::IPCStableHash;
    }
    case messages::P2PSocketClient::kSendComplete: {
      return &P2PSocketClient::SendComplete_Sym::IPCStableHash;
    }
    case messages::P2PSocketClient::kSendBatchComplete: {
      return &P2PSocketClient::SendBatchComplete_Sym::IPCStableHash;
    }
    case messages::P2PSocketClient::kDataReceived: {
      return &P2PSocketClient::DataReceived_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* P2PSocketClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::P2PSocketClient>(message.name())) {
      case messages::P2PSocketClient::kSocketCreated:
            return "Receive network::mojom::P2PSocketClient::SocketCreated";
      case messages::P2PSocketClient::kSendComplete:
            return "Receive network::mojom::P2PSocketClient::SendComplete";
      case messages::P2PSocketClient::kSendBatchComplete:
            return "Receive network::mojom::P2PSocketClient::SendBatchComplete";
      case messages::P2PSocketClient::kDataReceived:
            return "Receive network::mojom::P2PSocketClient::DataReceived";
    }
  } else {
    switch (static_cast<messages::P2PSocketClient>(message.name())) {
      case messages::P2PSocketClient::kSocketCreated:
            return "Receive reply network::mojom::P2PSocketClient::SocketCreated";
      case messages::P2PSocketClient::kSendComplete:
            return "Receive reply network::mojom::P2PSocketClient::SendComplete";
      case messages::P2PSocketClient::kSendBatchComplete:
            return "Receive reply network::mojom::P2PSocketClient::SendBatchComplete";
      case messages::P2PSocketClient::kDataReceived:
            return "Receive reply network::mojom::P2PSocketClient::DataReceived";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t P2PSocketClient::SocketCreated_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9609dad3;  // IPCStableHash for network::mojom::P2PSocketClient::SocketCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t P2PSocketClient::SendComplete_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7424c217;  // IPCStableHash for network::mojom::P2PSocketClient::SendComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t P2PSocketClient::SendBatchComplete_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xabdbdf03;  // IPCStableHash for network::mojom::P2PSocketClient::SendBatchComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t P2PSocketClient::DataReceived_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x565d0c33;  // IPCStableHash for network::mojom::P2PSocketClient::DataReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

P2PSocketClientProxy::P2PSocketClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void P2PSocketClientProxy::SocketCreated(
    const ::net::IPEndPoint& in_local_address, const ::net::IPEndPoint& in_remote_address) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::P2PSocketClient::SocketCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_address"), in_local_address,
                        "<value of type const ::net::IPEndPoint&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_address"), in_remote_address,
                        "<value of type const ::net::IPEndPoint&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::P2PSocketClient::kSocketCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocketClient_SocketCreated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->local_address)::BaseType> local_address_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_local_address,
    local_address_fragment);

  params->local_address.Set(
      local_address_fragment.is_null() ? nullptr : local_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->local_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null local_address in P2PSocketClient.SocketCreated request");
  mojo::internal::MessageFragment<
      typename decltype(params->remote_address)::BaseType> remote_address_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_remote_address,
    remote_address_fragment);

  params->remote_address.Set(
      remote_address_fragment.is_null() ? nullptr : remote_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->remote_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null remote_address in P2PSocketClient.SocketCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocketClient::Name_);
  message.set_method_name("SocketCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void P2PSocketClientProxy::SendComplete(
    const ::network::P2PSendPacketMetrics& in_send_metrics) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::P2PSocketClient::SendComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_metrics"), in_send_metrics,
                        "<value of type const ::network::P2PSendPacketMetrics&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::P2PSocketClient::kSendComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocketClient_SendComplete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->send_metrics)::BaseType> send_metrics_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::P2PSendPacketMetricsDataView>(
    in_send_metrics,
    send_metrics_fragment);

  params->send_metrics.Set(
      send_metrics_fragment.is_null() ? nullptr : send_metrics_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->send_metrics.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null send_metrics in P2PSocketClient.SendComplete request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocketClient::Name_);
  message.set_method_name("SendComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void P2PSocketClientProxy::SendBatchComplete(
    const std::vector<::network::P2PSendPacketMetrics>& in_send_metrics_batch) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::P2PSocketClient::SendBatchComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_metrics_batch"), in_send_metrics_batch,
                        "<value of type const std::vector<::network::P2PSendPacketMetrics>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::P2PSocketClient::kSendBatchComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocketClient_SendBatchComplete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->send_metrics_batch)::BaseType>
      send_metrics_batch_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& send_metrics_batch_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::P2PSendPacketMetricsDataView>>(
    in_send_metrics_batch,
    send_metrics_batch_fragment,
    &send_metrics_batch_validate_params);

  params->send_metrics_batch.Set(
      send_metrics_batch_fragment.is_null() ? nullptr : send_metrics_batch_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->send_metrics_batch.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null send_metrics_batch in P2PSocketClient.SendBatchComplete request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocketClient::Name_);
  message.set_method_name("SendBatchComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void P2PSocketClientProxy::DataReceived(
    std::vector<P2PReceivedPacketPtr> in_packets) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::P2PSocketClient::DataReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("packets"), in_packets,
                        "<value of type std::vector<P2PReceivedPacketPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::P2PSocketClient::kDataReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocketClient_DataReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->packets)::BaseType>
      packets_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& packets_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::P2PReceivedPacketDataView>>(
    in_packets,
    packets_fragment,
    &packets_validate_params);

  params->packets.Set(
      packets_fragment.is_null() ? nullptr : packets_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->packets.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null packets in P2PSocketClient.DataReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocketClient::Name_);
  message.set_method_name("DataReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool P2PSocketClientStubDispatch::Accept(
    P2PSocketClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::P2PSocketClient>(message->header()->name)) {
    case messages::P2PSocketClient::kSocketCreated: {
      DCHECK(message->is_serialized());
      internal::P2PSocketClient_SocketCreated_Params_Data* params =
          reinterpret_cast<internal::P2PSocketClient_SocketCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for P2PSocketClient.0
      bool success = true;
      ::net::IPEndPoint p_local_address{};
      ::net::IPEndPoint p_remote_address{};
      P2PSocketClient_SocketCreated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocalAddress(&p_local_address))
        success = false;
      if (success && !input_data_view.ReadRemoteAddress(&p_remote_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocketClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SocketCreated(        
        std::move(p_local_address), 
        std::move(p_remote_address));
      return true;
    }
    case messages::P2PSocketClient::kSendComplete: {
      DCHECK(message->is_serialized());
      internal::P2PSocketClient_SendComplete_Params_Data* params =
          reinterpret_cast<internal::P2PSocketClient_SendComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for P2PSocketClient.1
      bool success = true;
      ::network::P2PSendPacketMetrics p_send_metrics{};
      P2PSocketClient_SendComplete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSendMetrics(&p_send_metrics))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocketClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendComplete(        
        std::move(p_send_metrics));
      return true;
    }
    case messages::P2PSocketClient::kSendBatchComplete: {
      DCHECK(message->is_serialized());
      internal::P2PSocketClient_SendBatchComplete_Params_Data* params =
          reinterpret_cast<internal::P2PSocketClient_SendBatchComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for P2PSocketClient.2
      bool success = true;
      std::vector<::network::P2PSendPacketMetrics> p_send_metrics_batch{};
      P2PSocketClient_SendBatchComplete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSendMetricsBatch(&p_send_metrics_batch))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocketClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendBatchComplete(        
        std::move(p_send_metrics_batch));
      return true;
    }
    case messages::P2PSocketClient::kDataReceived: {
      DCHECK(message->is_serialized());
      internal::P2PSocketClient_DataReceived_Params_Data* params =
          reinterpret_cast<internal::P2PSocketClient_DataReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for P2PSocketClient.3
      bool success = true;
      std::vector<P2PReceivedPacketPtr> p_packets{};
      P2PSocketClient_DataReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPackets(&p_packets))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocketClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DataReceived(        
        std::move(p_packets));
      return true;
    }
  }
  return false;
}

// static
bool P2PSocketClientStubDispatch::AcceptWithResponder(
    P2PSocketClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::P2PSocketClient>(message->header()->name)) {
    case messages::P2PSocketClient::kSocketCreated: {
      break;
    }
    case messages::P2PSocketClient::kSendComplete: {
      break;
    }
    case messages::P2PSocketClient::kSendBatchComplete: {
      break;
    }
    case messages::P2PSocketClient::kDataReceived: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kP2PSocketClientValidationInfo[] = {
    {base::to_underlying(messages::P2PSocketClient::kSocketCreated),
     { &internal::P2PSocketClient_SocketCreated_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::P2PSocketClient::kSendComplete),
     { &internal::P2PSocketClient_SendComplete_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::P2PSocketClient::kSendBatchComplete),
     { &internal::P2PSocketClient_SendBatchComplete_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::P2PSocketClient::kDataReceived),
     { &internal::P2PSocketClient_DataReceived_Params_Data::Validate,
      nullptr /* no response */}},
};

bool P2PSocketClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::P2PSocketClient::Name_,
    kP2PSocketClientValidationInfo);
}



}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::P2PReceivedPacket::DataView, ::network::mojom::P2PReceivedPacketPtr>::Read(
    ::network::mojom::P2PReceivedPacket::DataView input,
    ::network::mojom::P2PReceivedPacketPtr* output) {
  bool success = true;
  ::network::mojom::P2PReceivedPacketPtr result(::network::mojom::P2PReceivedPacket::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
      if (success && !input.ReadSocketAddress(&result->socket_address))
        success = false;
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadEcn(&result->ecn))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::P2PSendPacket::DataView, ::network::mojom::P2PSendPacketPtr>::Read(
    ::network::mojom::P2PSendPacket::DataView input,
    ::network::mojom::P2PSendPacketPtr* output) {
  bool success = true;
  ::network::mojom::P2PSendPacketPtr result(::network::mojom::P2PSendPacket::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
      if (success && !input.ReadPacketInfo(&result->packet_info))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void P2PNetworkNotificationClientInterceptorForTesting::NetworkListChanged(const std::vector<::net::NetworkInterface>& networks, const ::net::IPAddress& default_ipv4_local_address, const ::net::IPAddress& default_ipv6_local_address) {
  GetForwardingInterface()->NetworkListChanged(
    std::move(networks)
    , 
    std::move(default_ipv4_local_address)
    , 
    std::move(default_ipv6_local_address)
    );
}
P2PNetworkNotificationClientAsyncWaiter::P2PNetworkNotificationClientAsyncWaiter(
    P2PNetworkNotificationClient* proxy) : proxy_(proxy) {}

P2PNetworkNotificationClientAsyncWaiter::~P2PNetworkNotificationClientAsyncWaiter() = default;





void P2PSocketManagerInterceptorForTesting::StartNetworkNotifications(::mojo::PendingRemote<P2PNetworkNotificationClient> client) {
  GetForwardingInterface()->StartNetworkNotifications(
    std::move(client)
    );
}
void P2PSocketManagerInterceptorForTesting::GetHostAddress(const std::string& host_name, std::optional<::net::AddressFamily> address_family, bool enable_mdns, GetHostAddressCallback callback) {
  GetForwardingInterface()->GetHostAddress(
    std::move(host_name)
    , 
    std::move(address_family)
    , 
    std::move(enable_mdns)
    , std::move(callback));
}
void P2PSocketManagerInterceptorForTesting::CreateSocket(::network::P2PSocketType type, const ::net::IPEndPoint& local_address, const ::network::P2PPortRange& port_range, const ::network::P2PHostAndIPEndPoint& remote_address, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, const std::optional<::base::UnguessableToken>& devtools_token, ::mojo::PendingRemote<P2PSocketClient> client, ::mojo::PendingReceiver<P2PSocket> socket) {
  GetForwardingInterface()->CreateSocket(
    std::move(type)
    , 
    std::move(local_address)
    , 
    std::move(port_range)
    , 
    std::move(remote_address)
    , 
    std::move(traffic_annotation)
    , 
    std::move(devtools_token)
    , 
    std::move(client)
    , 
    std::move(socket)
    );
}
P2PSocketManagerAsyncWaiter::P2PSocketManagerAsyncWaiter(
    P2PSocketManager* proxy) : proxy_(proxy) {}

P2PSocketManagerAsyncWaiter::~P2PSocketManagerAsyncWaiter() = default;


void P2PSocketManagerAsyncWaiter::GetHostAddress(
    const std::string& host_name, std::optional<::net::AddressFamily> address_family, bool enable_mdns, std::vector<::net::IPAddress>* out_addresses) {
  base::RunLoop loop;
  proxy_->GetHostAddress(
      std::move(host_name),
      std::move(address_family),
      std::move(enable_mdns),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::net::IPAddress>* out_addresses
,
             const std::vector<::net::IPAddress>& addresses) {*out_addresses = std::move(addresses);
            loop->Quit();
          },
          &loop,
          out_addresses));
  loop.Run();
}

std::vector<::net::IPAddress> P2PSocketManagerAsyncWaiter::GetHostAddress(
    const std::string& host_name, std::optional<::net::AddressFamily> address_family, bool enable_mdns) {
  std::vector<::net::IPAddress> async_wait_result;
  GetHostAddress(std::move(host_name),std::move(address_family),std::move(enable_mdns),&async_wait_result);
  return async_wait_result;
}




void P2PSocketInterceptorForTesting::Send(::base::span<const ::uint8_t> data, const ::network::P2PPacketInfo& packet_info) {
  GetForwardingInterface()->Send(
    std::move(data)
    , 
    std::move(packet_info)
    );
}
void P2PSocketInterceptorForTesting::SendBatch(std::vector<P2PSendPacketPtr> packet_batch) {
  GetForwardingInterface()->SendBatch(
    std::move(packet_batch)
    );
}
void P2PSocketInterceptorForTesting::SetOption(::network::P2PSocketOption option, int32_t value) {
  GetForwardingInterface()->SetOption(
    std::move(option)
    , 
    std::move(value)
    );
}
P2PSocketAsyncWaiter::P2PSocketAsyncWaiter(
    P2PSocket* proxy) : proxy_(proxy) {}

P2PSocketAsyncWaiter::~P2PSocketAsyncWaiter() = default;





void P2PSocketClientInterceptorForTesting::SocketCreated(const ::net::IPEndPoint& local_address, const ::net::IPEndPoint& remote_address) {
  GetForwardingInterface()->SocketCreated(
    std::move(local_address)
    , 
    std::move(remote_address)
    );
}
void P2PSocketClientInterceptorForTesting::SendComplete(const ::network::P2PSendPacketMetrics& send_metrics) {
  GetForwardingInterface()->SendComplete(
    std::move(send_metrics)
    );
}
void P2PSocketClientInterceptorForTesting::SendBatchComplete(const std::vector<::network::P2PSendPacketMetrics>& send_metrics_batch) {
  GetForwardingInterface()->SendBatchComplete(
    std::move(send_metrics_batch)
    );
}
void P2PSocketClientInterceptorForTesting::DataReceived(std::vector<P2PReceivedPacketPtr> packets) {
  GetForwardingInterface()->DataReceived(
    std::move(packets)
    );
}
P2PSocketClientAsyncWaiter::P2PSocketClientAsyncWaiter(
    P2PSocketClient* proxy) : proxy_(proxy) {}

P2PSocketClientAsyncWaiter::~P2PSocketClientAsyncWaiter() = default;







}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif