// services/network/public/mojom/parsed_headers.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/parsed_headers.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/parsed_headers.mojom-params-data.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared-message-ids.h"

#include "services/network/public/mojom/parsed_headers.mojom-blink-import-headers.h"
#include "services/network/public/mojom/parsed_headers.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
ParsedHeaders::ParsedHeaders()
    : content_security_policy(),
      allow_csp_from(),
      cross_origin_embedder_policy(),
      cross_origin_opener_policy(),
      document_isolation_policy(),
      integrity_policy(),
      integrity_policy_report_only(),
      origin_agent_cluster(),
      accept_ch(),
      critical_ch(),
      client_hints_ignored_due_to_clear_site_data_header(),
      xfo(::network::mojom::blink::XFrameOptionsValue::kNone),
      link_headers(),
      timing_allow_origin(),
      supports_loading_mode(),
      reporting_endpoints(),
      cookie_indices(),
      avail_language(),
      content_language(),
      no_vary_search_with_parse_error(),
      observe_browsing_topics(),
      allow_cross_origin_event_reporting() {}

ParsedHeaders::ParsedHeaders(
    ::blink::Vector<::network::mojom::blink::ContentSecurityPolicyPtr> content_security_policy_in,
    ::network::mojom::blink::AllowCSPFromHeaderValuePtr allow_csp_from_in,
    const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy_in,
    const ::network::CrossOriginOpenerPolicy& cross_origin_opener_policy_in,
    const ::network::DocumentIsolationPolicy& document_isolation_policy_in,
    const ::network::IntegrityPolicy& integrity_policy_in,
    const ::network::IntegrityPolicy& integrity_policy_report_only_in,
    OriginAgentClusterValue origin_agent_cluster_in,
    std::optional<::blink::Vector<::network::mojom::blink::WebClientHintsType>> accept_ch_in,
    std::optional<::blink::Vector<::network::mojom::blink::WebClientHintsType>> critical_ch_in,
    bool client_hints_ignored_due_to_clear_site_data_header_in,
    ::network::mojom::blink::XFrameOptionsValue xfo_in,
    ::blink::Vector<::network::mojom::blink::LinkHeaderPtr> link_headers_in,
    ::network::mojom::blink::TimingAllowOriginPtr timing_allow_origin_in,
    ::blink::Vector<::network::mojom::blink::LoadingMode> supports_loading_mode_in,
    const std::optional<::blink::HashMap<::blink::String, ::blink::String>>& reporting_endpoints_in,
    std::optional<::blink::Vector<::blink::String>> cookie_indices_in,
    std::optional<::blink::Vector<::blink::String>> avail_language_in,
    std::optional<::blink::Vector<::blink::String>> content_language_in,
    ::network::mojom::blink::NoVarySearchWithParseErrorPtr no_vary_search_with_parse_error_in,
    bool observe_browsing_topics_in,
    bool allow_cross_origin_event_reporting_in)
    : content_security_policy(std::move(content_security_policy_in)),
      allow_csp_from(std::move(allow_csp_from_in)),
      cross_origin_embedder_policy(std::move(cross_origin_embedder_policy_in)),
      cross_origin_opener_policy(std::move(cross_origin_opener_policy_in)),
      document_isolation_policy(std::move(document_isolation_policy_in)),
      integrity_policy(std::move(integrity_policy_in)),
      integrity_policy_report_only(std::move(integrity_policy_report_only_in)),
      origin_agent_cluster(std::move(origin_agent_cluster_in)),
      accept_ch(std::move(accept_ch_in)),
      critical_ch(std::move(critical_ch_in)),
      client_hints_ignored_due_to_clear_site_data_header(std::move(client_hints_ignored_due_to_clear_site_data_header_in)),
      xfo(std::move(xfo_in)),
      link_headers(std::move(link_headers_in)),
      timing_allow_origin(std::move(timing_allow_origin_in)),
      supports_loading_mode(std::move(supports_loading_mode_in)),
      reporting_endpoints(std::move(reporting_endpoints_in)),
      cookie_indices(std::move(cookie_indices_in)),
      avail_language(std::move(avail_language_in)),
      content_language(std::move(content_language_in)),
      no_vary_search_with_parse_error(std::move(no_vary_search_with_parse_error_in)),
      observe_browsing_topics(std::move(observe_browsing_topics_in)),
      allow_cross_origin_event_reporting(std::move(allow_cross_origin_event_reporting_in)) {}

ParsedHeaders::~ParsedHeaders() = default;

void ParsedHeaders::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_security_policy"), this->content_security_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::network::mojom::blink::ContentSecurityPolicyPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_csp_from"), this->allow_csp_from,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::AllowCSPFromHeaderValuePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cross_origin_embedder_policy"), this->cross_origin_embedder_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::network::CrossOriginEmbedderPolicy&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cross_origin_opener_policy"), this->cross_origin_opener_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::network::CrossOriginOpenerPolicy&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_isolation_policy"), this->document_isolation_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::network::DocumentIsolationPolicy&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "integrity_policy"), this->integrity_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::network::IntegrityPolicy&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "integrity_policy_report_only"), this->integrity_policy_report_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::network::IntegrityPolicy&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin_agent_cluster"), this->origin_agent_cluster,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OriginAgentClusterValue>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accept_ch"), this->accept_ch,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<::network::mojom::blink::WebClientHintsType>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "critical_ch"), this->critical_ch,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<::network::mojom::blink::WebClientHintsType>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_hints_ignored_due_to_clear_site_data_header"), this->client_hints_ignored_due_to_clear_site_data_header,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "xfo"), this->xfo,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::XFrameOptionsValue>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "link_headers"), this->link_headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::network::mojom::blink::LinkHeaderPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timing_allow_origin"), this->timing_allow_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::TimingAllowOriginPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_loading_mode"), this->supports_loading_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::network::mojom::blink::LoadingMode>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_endpoints"), this->reporting_endpoints,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::HashMap<::blink::String, ::blink::String>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_indices"), this->cookie_indices,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<::blink::String>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "avail_language"), this->avail_language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<::blink::String>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_language"), this->content_language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<::blink::String>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "no_vary_search_with_parse_error"), this->no_vary_search_with_parse_error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::NoVarySearchWithParseErrorPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "observe_browsing_topics"), this->observe_browsing_topics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_cross_origin_event_reporting"), this->allow_cross_origin_event_reporting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ParsedHeaders::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::ParsedHeaders::DataView, ::network::mojom::blink::ParsedHeadersPtr>::Read(
    ::network::mojom::blink::ParsedHeaders::DataView input,
    ::network::mojom::blink::ParsedHeadersPtr* output) {
  bool success = true;
  ::network::mojom::blink::ParsedHeadersPtr result(::network::mojom::blink::ParsedHeaders::New());
  
      if (success && !input.ReadContentSecurityPolicy(&result->content_security_policy))
        success = false;
      if (success && !input.ReadAllowCspFrom(&result->allow_csp_from))
        success = false;
      if (success && !input.ReadCrossOriginEmbedderPolicy(&result->cross_origin_embedder_policy))
        success = false;
      if (success && !input.ReadCrossOriginOpenerPolicy(&result->cross_origin_opener_policy))
        success = false;
      if (success && !input.ReadDocumentIsolationPolicy(&result->document_isolation_policy))
        success = false;
      if (success && !input.ReadIntegrityPolicy(&result->integrity_policy))
        success = false;
      if (success && !input.ReadIntegrityPolicyReportOnly(&result->integrity_policy_report_only))
        success = false;
      if (success && !input.ReadOriginAgentCluster(&result->origin_agent_cluster))
        success = false;
      if (success && !input.ReadAcceptCh(&result->accept_ch))
        success = false;
      if (success && !input.ReadCriticalCh(&result->critical_ch))
        success = false;
      if (success)
        result->client_hints_ignored_due_to_clear_site_data_header = input.client_hints_ignored_due_to_clear_site_data_header();
      if (success && !input.ReadXfo(&result->xfo))
        success = false;
      if (success && !input.ReadLinkHeaders(&result->link_headers))
        success = false;
      if (success && !input.ReadTimingAllowOrigin(&result->timing_allow_origin))
        success = false;
      if (success && !input.ReadSupportsLoadingMode(&result->supports_loading_mode))
        success = false;
      if (success && !input.ReadReportingEndpoints(&result->reporting_endpoints))
        success = false;
      if (success && !input.ReadCookieIndices(&result->cookie_indices))
        success = false;
      if (success && !input.ReadAvailLanguage(&result->avail_language))
        success = false;
      if (success && !input.ReadContentLanguage(&result->content_language))
        success = false;
      if (success && !input.ReadNoVarySearchWithParseError(&result->no_vary_search_with_parse_error))
        success = false;
      if (success)
        result->observe_browsing_topics = input.observe_browsing_topics();
      if (success)
        result->allow_cross_origin_event_reporting = input.allow_cross_origin_event_reporting();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {




}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif