// services/network/public/mojom/shared_storage.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/shared_storage.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/shared_storage.mojom-params-data.h"
#include "services/network/public/mojom/shared_storage.mojom-shared-message-ids.h"

#include "services/network/public/mojom/shared_storage.mojom-import-headers.h"
#include "services/network/public/mojom/shared_storage.mojom-test-utils.h"


namespace network::mojom {
SharedStorageKeyArgument::SharedStorageKeyArgument()
    : data() {}

SharedStorageKeyArgument::SharedStorageKeyArgument(
    const ::std::u16string& data_in)
    : data(std::move(data_in)) {}

SharedStorageKeyArgument::~SharedStorageKeyArgument() = default;

void SharedStorageKeyArgument::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedStorageKeyArgument::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedStorageValueArgument::SharedStorageValueArgument()
    : data() {}

SharedStorageValueArgument::SharedStorageValueArgument(
    const ::std::u16string& data_in)
    : data(std::move(data_in)) {}

SharedStorageValueArgument::~SharedStorageValueArgument() = default;

void SharedStorageValueArgument::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedStorageValueArgument::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LockName::LockName()
    : data() {}

LockName::LockName(
    const std::string& data_in)
    : data(std::move(data_in)) {}

LockName::~LockName() = default;

void LockName::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LockName::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedStorageSetMethod::SharedStorageSetMethod()
    : key(),
      value(),
      ignore_if_present() {}

SharedStorageSetMethod::SharedStorageSetMethod(
    const ::std::u16string& key_in,
    const ::std::u16string& value_in,
    bool ignore_if_present_in)
    : key(std::move(key_in)),
      value(std::move(value_in)),
      ignore_if_present(std::move(ignore_if_present_in)) {}

SharedStorageSetMethod::~SharedStorageSetMethod() = default;

void SharedStorageSetMethod::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ignore_if_present"), this->ignore_if_present,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedStorageSetMethod::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedStorageAppendMethod::SharedStorageAppendMethod()
    : key(),
      value() {}

SharedStorageAppendMethod::SharedStorageAppendMethod(
    const ::std::u16string& key_in,
    const ::std::u16string& value_in)
    : key(std::move(key_in)),
      value(std::move(value_in)) {}

SharedStorageAppendMethod::~SharedStorageAppendMethod() = default;

void SharedStorageAppendMethod::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedStorageAppendMethod::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedStorageDeleteMethod::SharedStorageDeleteMethod()
    : key() {}

SharedStorageDeleteMethod::SharedStorageDeleteMethod(
    const ::std::u16string& key_in)
    : key(std::move(key_in)) {}

SharedStorageDeleteMethod::~SharedStorageDeleteMethod() = default;

void SharedStorageDeleteMethod::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedStorageDeleteMethod::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedStorageClearMethod::SharedStorageClearMethod() {}

SharedStorageClearMethod::~SharedStorageClearMethod() = default;
size_t SharedStorageClearMethod::Hash(size_t seed) const {
  return seed;
}

void SharedStorageClearMethod::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool SharedStorageClearMethod::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedStorageModifierMethodWithOptions::SharedStorageModifierMethodWithOptions()
    : method(),
      with_lock() {}

SharedStorageModifierMethodWithOptions::SharedStorageModifierMethodWithOptions(
    SharedStorageModifierMethodPtr method_in,
    const std::optional<::std::string>& with_lock_in)
    : method(std::move(method_in)),
      with_lock(std::move(with_lock_in)) {}

SharedStorageModifierMethodWithOptions::~SharedStorageModifierMethodWithOptions() = default;

void SharedStorageModifierMethodWithOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method"), this->method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SharedStorageModifierMethodPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "with_lock"), this->with_lock,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedStorageModifierMethodWithOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedStorageBatchUpdateMethodsArgument::SharedStorageBatchUpdateMethodsArgument()
    : data() {}

SharedStorageBatchUpdateMethodsArgument::SharedStorageBatchUpdateMethodsArgument(
    std::vector<SharedStorageModifierMethodWithOptionsPtr> data_in)
    : data(std::move(data_in)) {}

SharedStorageBatchUpdateMethodsArgument::~SharedStorageBatchUpdateMethodsArgument() = default;

void SharedStorageBatchUpdateMethodsArgument::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<SharedStorageModifierMethodWithOptionsPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedStorageBatchUpdateMethodsArgument::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedStorageModifierMethodPtr
SharedStorageModifierMethod::NewSetMethod(
    SharedStorageSetMethodPtr value) {
  return SharedStorageModifierMethodPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSetMethod)>,
      std::move(value));
}

SharedStorageModifierMethodPtr
SharedStorageModifierMethod::NewAppendMethod(
    SharedStorageAppendMethodPtr value) {
  return SharedStorageModifierMethodPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kAppendMethod)>,
      std::move(value));
}

SharedStorageModifierMethodPtr
SharedStorageModifierMethod::NewDeleteMethod(
    SharedStorageDeleteMethodPtr value) {
  return SharedStorageModifierMethodPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDeleteMethod)>,
      std::move(value));
}

SharedStorageModifierMethodPtr
SharedStorageModifierMethod::NewClearMethod(
    SharedStorageClearMethodPtr value) {
  return SharedStorageModifierMethodPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kClearMethod)>,
      std::move(value));
}

SharedStorageModifierMethod::SharedStorageModifierMethod(
    std::in_place_index_t<static_cast<size_t>(Tag::kSetMethod)>,
    SharedStorageSetMethodPtr value)
    : tag_(Tag::kSetMethod),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSetMethod)>,
            std::move(value)) {}

SharedStorageModifierMethod::SharedStorageModifierMethod(
    std::in_place_index_t<static_cast<size_t>(Tag::kAppendMethod)>,
    SharedStorageAppendMethodPtr value)
    : tag_(Tag::kAppendMethod),
      data_(std::in_place_index<static_cast<size_t>(Tag::kAppendMethod)>,
            std::move(value)) {}

SharedStorageModifierMethod::SharedStorageModifierMethod(
    std::in_place_index_t<static_cast<size_t>(Tag::kDeleteMethod)>,
    SharedStorageDeleteMethodPtr value)
    : tag_(Tag::kDeleteMethod),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDeleteMethod)>,
            std::move(value)) {}

SharedStorageModifierMethod::SharedStorageModifierMethod(
    std::in_place_index_t<static_cast<size_t>(Tag::kClearMethod)>,
    SharedStorageClearMethodPtr value)
    : tag_(Tag::kClearMethod),
      data_(std::in_place_index<static_cast<size_t>(Tag::kClearMethod)>,
            std::move(value)) {}
SharedStorageModifierMethod::~SharedStorageModifierMethod() {
  DestroyActive();
}

void SharedStorageModifierMethod::set_set_method(SharedStorageSetMethodPtr set_method) {
  if (tag_ == Tag::kSetMethod) {
    data_.set_method = std::move(set_method);
  } else {
    DestroyActive();
    tag_ = Tag::kSetMethod;
    new (&data_.set_method) SharedStorageSetMethodPtr(
        std::move(set_method));
  }
}

void SharedStorageModifierMethod::set_append_method(SharedStorageAppendMethodPtr append_method) {
  if (tag_ == Tag::kAppendMethod) {
    data_.append_method = std::move(append_method);
  } else {
    DestroyActive();
    tag_ = Tag::kAppendMethod;
    new (&data_.append_method) SharedStorageAppendMethodPtr(
        std::move(append_method));
  }
}

void SharedStorageModifierMethod::set_delete_method(SharedStorageDeleteMethodPtr delete_method) {
  if (tag_ == Tag::kDeleteMethod) {
    data_.delete_method = std::move(delete_method);
  } else {
    DestroyActive();
    tag_ = Tag::kDeleteMethod;
    new (&data_.delete_method) SharedStorageDeleteMethodPtr(
        std::move(delete_method));
  }
}

void SharedStorageModifierMethod::set_clear_method(SharedStorageClearMethodPtr clear_method) {
  if (tag_ == Tag::kClearMethod) {
    data_.clear_method = std::move(clear_method);
  } else {
    DestroyActive();
    tag_ = Tag::kClearMethod;
    new (&data_.clear_method) SharedStorageClearMethodPtr(
        std::move(clear_method));
  }
}


SharedStorageModifierMethod::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSetMethod)>,
    SharedStorageSetMethodPtr value)
    : set_method(std::move(value)) {}

SharedStorageModifierMethod::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kAppendMethod)>,
    SharedStorageAppendMethodPtr value)
    : append_method(std::move(value)) {}

SharedStorageModifierMethod::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDeleteMethod)>,
    SharedStorageDeleteMethodPtr value)
    : delete_method(std::move(value)) {}

SharedStorageModifierMethod::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kClearMethod)>,
    SharedStorageClearMethodPtr value)
    : clear_method(std::move(value)) {}

void SharedStorageModifierMethod::DestroyActive() {
  switch (tag_) {

    case Tag::kSetMethod:
      std::destroy_at(&data_.set_method);
      break;
    case Tag::kAppendMethod:
      std::destroy_at(&data_.append_method);
      break;
    case Tag::kDeleteMethod:
      std::destroy_at(&data_.delete_method);
      break;
    case Tag::kClearMethod:
      std::destroy_at(&data_.clear_method);
      break;
  }
}

bool SharedStorageModifierMethod::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::SharedStorageKeyArgument::DataView, ::network::mojom::SharedStorageKeyArgumentPtr>::Read(
    ::network::mojom::SharedStorageKeyArgument::DataView input,
    ::network::mojom::SharedStorageKeyArgumentPtr* output) {
  bool success = true;
  ::network::mojom::SharedStorageKeyArgumentPtr result(::network::mojom::SharedStorageKeyArgument::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::SharedStorageValueArgument::DataView, ::network::mojom::SharedStorageValueArgumentPtr>::Read(
    ::network::mojom::SharedStorageValueArgument::DataView input,
    ::network::mojom::SharedStorageValueArgumentPtr* output) {
  bool success = true;
  ::network::mojom::SharedStorageValueArgumentPtr result(::network::mojom::SharedStorageValueArgument::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::LockName::DataView, ::network::mojom::LockNamePtr>::Read(
    ::network::mojom::LockName::DataView input,
    ::network::mojom::LockNamePtr* output) {
  bool success = true;
  ::network::mojom::LockNamePtr result(::network::mojom::LockName::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::SharedStorageSetMethod::DataView, ::network::mojom::SharedStorageSetMethodPtr>::Read(
    ::network::mojom::SharedStorageSetMethod::DataView input,
    ::network::mojom::SharedStorageSetMethodPtr* output) {
  bool success = true;
  ::network::mojom::SharedStorageSetMethodPtr result(::network::mojom::SharedStorageSetMethod::New());
  
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success)
        result->ignore_if_present = input.ignore_if_present();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::SharedStorageAppendMethod::DataView, ::network::mojom::SharedStorageAppendMethodPtr>::Read(
    ::network::mojom::SharedStorageAppendMethod::DataView input,
    ::network::mojom::SharedStorageAppendMethodPtr* output) {
  bool success = true;
  ::network::mojom::SharedStorageAppendMethodPtr result(::network::mojom::SharedStorageAppendMethod::New());
  
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::SharedStorageDeleteMethod::DataView, ::network::mojom::SharedStorageDeleteMethodPtr>::Read(
    ::network::mojom::SharedStorageDeleteMethod::DataView input,
    ::network::mojom::SharedStorageDeleteMethodPtr* output) {
  bool success = true;
  ::network::mojom::SharedStorageDeleteMethodPtr result(::network::mojom::SharedStorageDeleteMethod::New());
  
      if (success && !input.ReadKey(&result->key))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::SharedStorageClearMethod::DataView, ::network::mojom::SharedStorageClearMethodPtr>::Read(
    ::network::mojom::SharedStorageClearMethod::DataView input,
    ::network::mojom::SharedStorageClearMethodPtr* output) {
  bool success = true;
  ::network::mojom::SharedStorageClearMethodPtr result(::network::mojom::SharedStorageClearMethod::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::SharedStorageModifierMethodWithOptions::DataView, ::network::mojom::SharedStorageModifierMethodWithOptionsPtr>::Read(
    ::network::mojom::SharedStorageModifierMethodWithOptions::DataView input,
    ::network::mojom::SharedStorageModifierMethodWithOptionsPtr* output) {
  bool success = true;
  ::network::mojom::SharedStorageModifierMethodWithOptionsPtr result(::network::mojom::SharedStorageModifierMethodWithOptions::New());
  
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success && !input.ReadWithLock(&result->with_lock))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::SharedStorageBatchUpdateMethodsArgument::DataView, ::network::mojom::SharedStorageBatchUpdateMethodsArgumentPtr>::Read(
    ::network::mojom::SharedStorageBatchUpdateMethodsArgument::DataView input,
    ::network::mojom::SharedStorageBatchUpdateMethodsArgumentPtr* output) {
  bool success = true;
  ::network::mojom::SharedStorageBatchUpdateMethodsArgumentPtr result(::network::mojom::SharedStorageBatchUpdateMethodsArgument::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::network::mojom::SharedStorageModifierMethod::DataView, ::network::mojom::SharedStorageModifierMethodPtr>::Read(
    ::network::mojom::SharedStorageModifierMethod::DataView input,
    ::network::mojom::SharedStorageModifierMethodPtr* output) {
  using UnionType = ::network::mojom::SharedStorageModifierMethod;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSetMethod: {
      ::network::mojom::SharedStorageSetMethodPtr result_set_method{};
      if (!input.ReadSetMethod(&result_set_method))
        return false;

      *output = UnionType::NewSetMethod(
          std::move(result_set_method));
      break;
    }
    case Tag::kAppendMethod: {
      ::network::mojom::SharedStorageAppendMethodPtr result_append_method{};
      if (!input.ReadAppendMethod(&result_append_method))
        return false;

      *output = UnionType::NewAppendMethod(
          std::move(result_append_method));
      break;
    }
    case Tag::kDeleteMethod: {
      ::network::mojom::SharedStorageDeleteMethodPtr result_delete_method{};
      if (!input.ReadDeleteMethod(&result_delete_method))
        return false;

      *output = UnionType::NewDeleteMethod(
          std::move(result_delete_method));
      break;
    }
    case Tag::kClearMethod: {
      ::network::mojom::SharedStorageClearMethodPtr result_clear_method{};
      if (!input.ReadClearMethod(&result_clear_method))
        return false;

      *output = UnionType::NewClearMethod(
          std::move(result_clear_method));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {




}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif