// services/network/public/mojom/supports_loading_mode.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SUPPORTS_LOADING_MODE_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SUPPORTS_LOADING_MODE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/supports_loading_mode.mojom-shared-internal.h"




#include "services/network/public/mojom/supports_loading_mode.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::LoadingMode>
    : public mojo::internal::EnumHashImpl<::network::mojom::LoadingMode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::LoadingMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::LoadingMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::LoadingMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SupportsLoadingModeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SupportsLoadingModeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SupportsLoadingMode_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::supported_modes(input)) in_supported_modes = Traits::supported_modes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_modes)::BaseType>
        supported_modes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_modes_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::LoadingMode_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::LoadingMode>>(
      in_supported_modes,
      supported_modes_fragment,
      &supported_modes_validate_params);

    fragment->supported_modes.Set(
        supported_modes_fragment.is_null() ? nullptr : supported_modes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->supported_modes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null supported_modes in SupportsLoadingMode struct");
  }

  static bool Deserialize(::network::mojom::internal::SupportsLoadingMode_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SupportsLoadingModeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void SupportsLoadingModeDataView::GetSupportedModesDataView(
    mojo::ArrayDataView<LoadingMode>* output) {
  auto pointer = data_->supported_modes.Get();
  *output = mojo::ArrayDataView<LoadingMode>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::LoadingMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::LoadingMode value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SUPPORTS_LOADING_MODE_MOJOM_SHARED_H_