// services/network/public/mojom/tcp_socket.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TCP_SOCKET_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TCP_SOCKET_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/tcp_socket.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/tcp_socket.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/tcp_socket.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/address_list.mojom.h"
#include "services/network/public/mojom/ip_endpoint.mojom.h"
#include "services/network/public/mojom/ssl_config.mojom-forward.h"
#include "services/network/public/mojom/tls_socket.mojom-forward.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom.h"
#include "services/network/public/mojom/socket_connection_tracker.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace network::mojom {

class TCPBoundSocketProxy;

template <typename ImplRefTraits>
class TCPBoundSocketStub;

class TCPBoundSocketRequestValidator;
class TCPBoundSocketResponseValidator;


class TCPBoundSocket
    : public TCPBoundSocketInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.TCPBoundSocket";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TCPBoundSocketInterfaceBase;
  using Proxy_ = TCPBoundSocketProxy;

  template <typename ImplRefTraits>
  using Stub_ = TCPBoundSocketStub<ImplRefTraits>;

  using RequestValidator_ = TCPBoundSocketRequestValidator;
  using ResponseValidator_ = TCPBoundSocketResponseValidator;
  enum MethodMinVersions : uint32_t {
    kListenMinVersion = 0,
    kConnectMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Listen_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Connect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TCPBoundSocket() = default;

  using ListenCallback = base::OnceCallback<void(int32_t)>;
  using ListenMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void Listen(uint32_t backlog, ::mojo::PendingReceiver<TCPServerSocket> socket, ListenCallback callback) = 0;

  using ConnectCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&, const std::optional<::net::IPEndPoint>&, ::mojo::ScopedDataPipeConsumerHandle, ::mojo::ScopedDataPipeProducerHandle)>;
  using ConnectMojoCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&, const std::optional<::net::IPEndPoint>&, ::mojo::ScopedDataPipeConsumerHandle, ::mojo::ScopedDataPipeProducerHandle)>;

  virtual void Connect(const ::net::AddressList& remote_addr_list, TCPConnectedSocketOptionsPtr tcp_connected_socket_options, ::mojo::PendingReceiver<TCPConnectedSocket> socket, ::mojo::PendingRemote<SocketObserver> observer, ConnectCallback callback) = 0;
};

class TCPConnectedSocketProxy;

template <typename ImplRefTraits>
class TCPConnectedSocketStub;

class TCPConnectedSocketRequestValidator;
class TCPConnectedSocketResponseValidator;


class TCPConnectedSocket
    : public TCPConnectedSocketInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.TCPConnectedSocket";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TCPConnectedSocketInterfaceBase;
  using Proxy_ = TCPConnectedSocketProxy;

  template <typename ImplRefTraits>
  using Stub_ = TCPConnectedSocketStub<ImplRefTraits>;

  using RequestValidator_ = TCPConnectedSocketRequestValidator;
  using ResponseValidator_ = TCPConnectedSocketResponseValidator;
  enum MethodMinVersions : uint32_t {
    kUpgradeToTLSMinVersion = 0,
    kSetSendBufferSizeMinVersion = 0,
    kSetReceiveBufferSizeMinVersion = 0,
    kSetNoDelayMinVersion = 0,
    kSetKeepAliveMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpgradeToTLS_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSendBufferSize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetReceiveBufferSize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNoDelay_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetKeepAlive_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TCPConnectedSocket() = default;

  using UpgradeToTLSCallback = base::OnceCallback<void(int32_t, ::mojo::ScopedDataPipeConsumerHandle, ::mojo::ScopedDataPipeProducerHandle, const std::optional<::net::SSLInfo>&)>;
  using UpgradeToTLSMojoCallback = base::OnceCallback<void(int32_t, ::mojo::ScopedDataPipeConsumerHandle, ::mojo::ScopedDataPipeProducerHandle, const std::optional<::net::SSLInfo>&)>;

  virtual void UpgradeToTLS(const ::net::HostPortPair& host_port_pair, ::network::mojom::TLSClientSocketOptionsPtr options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TLSClientSocket> receiver, ::mojo::PendingRemote<SocketObserver> observer, UpgradeToTLSCallback callback) = 0;

  using SetSendBufferSizeCallback = base::OnceCallback<void(int32_t)>;
  using SetSendBufferSizeMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void SetSendBufferSize(int32_t send_buffer_size, SetSendBufferSizeCallback callback) = 0;

  using SetReceiveBufferSizeCallback = base::OnceCallback<void(int32_t)>;
  using SetReceiveBufferSizeMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void SetReceiveBufferSize(int32_t receive_buffer_size, SetReceiveBufferSizeCallback callback) = 0;

  using SetNoDelayCallback = base::OnceCallback<void(bool)>;
  using SetNoDelayMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetNoDelay(bool no_delay, SetNoDelayCallback callback) = 0;

  using SetKeepAliveCallback = base::OnceCallback<void(bool)>;
  using SetKeepAliveMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetKeepAlive(bool enable, int32_t delay_secs, SetKeepAliveCallback callback) = 0;
};

class SocketObserverProxy;

template <typename ImplRefTraits>
class SocketObserverStub;

class SocketObserverRequestValidator;


class SocketObserver
    : public SocketObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.SocketObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SocketObserverInterfaceBase;
  using Proxy_ = SocketObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = SocketObserverStub<ImplRefTraits>;

  using RequestValidator_ = SocketObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnReadErrorMinVersion = 0,
    kOnWriteErrorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnReadError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWriteError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SocketObserver() = default;

  virtual void OnReadError(int32_t net_error) = 0;

  virtual void OnWriteError(int32_t net_error) = 0;
};

class TCPServerSocketProxy;

template <typename ImplRefTraits>
class TCPServerSocketStub;

class TCPServerSocketRequestValidator;
class TCPServerSocketResponseValidator;


class TCPServerSocket
    : public TCPServerSocketInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.TCPServerSocket";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TCPServerSocketInterfaceBase;
  using Proxy_ = TCPServerSocketProxy;

  template <typename ImplRefTraits>
  using Stub_ = TCPServerSocketStub<ImplRefTraits>;

  using RequestValidator_ = TCPServerSocketRequestValidator;
  using ResponseValidator_ = TCPServerSocketResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAcceptMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Accept_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TCPServerSocket() = default;

  using AcceptCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&, ::mojo::PendingRemote<TCPConnectedSocket>, ::mojo::ScopedDataPipeConsumerHandle, ::mojo::ScopedDataPipeProducerHandle)>;
  using AcceptMojoCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&, ::mojo::PendingRemote<TCPConnectedSocket>, ::mojo::ScopedDataPipeConsumerHandle, ::mojo::ScopedDataPipeProducerHandle)>;

  virtual void Accept(::mojo::PendingRemote<SocketObserver> observer, AcceptCallback callback) = 0;
};



class  TCPBoundSocketProxy
    : public TCPBoundSocket {
 public:
  using InterfaceType = TCPBoundSocket;

  explicit TCPBoundSocketProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Listen(uint32_t backlog, ::mojo::PendingReceiver<TCPServerSocket> socket, ListenCallback callback) final;
  
  void Connect(const ::net::AddressList& remote_addr_list, TCPConnectedSocketOptionsPtr tcp_connected_socket_options, ::mojo::PendingReceiver<TCPConnectedSocket> socket, ::mojo::PendingRemote<SocketObserver> observer, ConnectCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  TCPConnectedSocketProxy
    : public TCPConnectedSocket {
 public:
  using InterfaceType = TCPConnectedSocket;

  explicit TCPConnectedSocketProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpgradeToTLS(const ::net::HostPortPair& host_port_pair, ::network::mojom::TLSClientSocketOptionsPtr options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TLSClientSocket> receiver, ::mojo::PendingRemote<SocketObserver> observer, UpgradeToTLSCallback callback) final;
  
  void SetSendBufferSize(int32_t send_buffer_size, SetSendBufferSizeCallback callback) final;
  
  void SetReceiveBufferSize(int32_t receive_buffer_size, SetReceiveBufferSizeCallback callback) final;
  
  void SetNoDelay(bool no_delay, SetNoDelayCallback callback) final;
  
  void SetKeepAlive(bool enable, int32_t delay_secs, SetKeepAliveCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SocketObserverProxy
    : public SocketObserver {
 public:
  using InterfaceType = SocketObserver;

  explicit SocketObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnReadError(int32_t net_error) final;
  
  void OnWriteError(int32_t net_error) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  TCPServerSocketProxy
    : public TCPServerSocket {
 public:
  using InterfaceType = TCPServerSocket;

  explicit TCPServerSocketProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Accept(::mojo::PendingRemote<SocketObserver> observer, AcceptCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  TCPBoundSocketStubDispatch {
 public:
  static bool Accept(TCPBoundSocket* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TCPBoundSocket* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TCPBoundSocket>>
class TCPBoundSocketStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TCPBoundSocketStub() = default;
  ~TCPBoundSocketStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TCPBoundSocketStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TCPBoundSocketStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TCPConnectedSocketStubDispatch {
 public:
  static bool Accept(TCPConnectedSocket* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TCPConnectedSocket* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TCPConnectedSocket>>
class TCPConnectedSocketStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TCPConnectedSocketStub() = default;
  ~TCPConnectedSocketStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TCPConnectedSocketStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TCPConnectedSocketStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SocketObserverStubDispatch {
 public:
  static bool Accept(SocketObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SocketObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SocketObserver>>
class SocketObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SocketObserverStub() = default;
  ~SocketObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SocketObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SocketObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TCPServerSocketStubDispatch {
 public:
  static bool Accept(TCPServerSocket* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TCPServerSocket* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TCPServerSocket>>
class TCPServerSocketStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TCPServerSocketStub() = default;
  ~TCPServerSocketStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TCPServerSocketStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TCPServerSocketStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TCPBoundSocketRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TCPConnectedSocketRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SocketObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TCPServerSocketRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TCPBoundSocketResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TCPConnectedSocketResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TCPServerSocketResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  TCPKeepAliveOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TCPKeepAliveOptions, T>::value>;
  using DataView = TCPKeepAliveOptionsDataView;
  using Data_ = internal::TCPKeepAliveOptions_Data;

  template <typename... Args>
  static TCPKeepAliveOptionsPtr New(Args&&... args) {
    return TCPKeepAliveOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TCPKeepAliveOptionsPtr From(const U& u) {
    return mojo::TypeConverter<TCPKeepAliveOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TCPKeepAliveOptions>::Convert(*this);
  }


  TCPKeepAliveOptions();

  TCPKeepAliveOptions(
      bool enable,
      uint16_t delay);


  ~TCPKeepAliveOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TCPKeepAliveOptionsPtr>
  TCPKeepAliveOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TCPKeepAliveOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TCPKeepAliveOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TCPKeepAliveOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TCPKeepAliveOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TCPKeepAliveOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TCPKeepAliveOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TCPKeepAliveOptions_UnserializedMessageContext<
            UserType, TCPKeepAliveOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TCPKeepAliveOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TCPKeepAliveOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TCPKeepAliveOptions_UnserializedMessageContext<
            UserType, TCPKeepAliveOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TCPKeepAliveOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool enable;
  
  uint16_t delay;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TCPKeepAliveOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TCPKeepAliveOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TCPKeepAliveOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TCPKeepAliveOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  TCPServerSocketOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TCPServerSocketOptions, T>::value>;
  using DataView = TCPServerSocketOptionsDataView;
  using Data_ = internal::TCPServerSocketOptions_Data;

  template <typename... Args>
  static TCPServerSocketOptionsPtr New(Args&&... args) {
    return TCPServerSocketOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TCPServerSocketOptionsPtr From(const U& u) {
    return mojo::TypeConverter<TCPServerSocketOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TCPServerSocketOptions>::Convert(*this);
  }


  TCPServerSocketOptions();

  TCPServerSocketOptions(
      uint32_t backlog,
      std::optional<bool> ipv6_only);


  ~TCPServerSocketOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TCPServerSocketOptionsPtr>
  TCPServerSocketOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TCPServerSocketOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TCPServerSocketOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TCPServerSocketOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TCPServerSocketOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TCPServerSocketOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TCPServerSocketOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TCPServerSocketOptions_UnserializedMessageContext<
            UserType, TCPServerSocketOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TCPServerSocketOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TCPServerSocketOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TCPServerSocketOptions_UnserializedMessageContext<
            UserType, TCPServerSocketOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TCPServerSocketOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t backlog;
  
  std::optional<bool> ipv6_only;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TCPServerSocketOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TCPServerSocketOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TCPServerSocketOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TCPServerSocketOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  TCPConnectedSocketOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TCPConnectedSocketOptions, T>::value>;
  using DataView = TCPConnectedSocketOptionsDataView;
  using Data_ = internal::TCPConnectedSocketOptions_Data;

  template <typename... Args>
  static TCPConnectedSocketOptionsPtr New(Args&&... args) {
    return TCPConnectedSocketOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TCPConnectedSocketOptionsPtr From(const U& u) {
    return mojo::TypeConverter<TCPConnectedSocketOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TCPConnectedSocketOptions>::Convert(*this);
  }


  TCPConnectedSocketOptions();

  TCPConnectedSocketOptions(
      int32_t send_buffer_size,
      int32_t receive_buffer_size,
      bool no_delay,
      TCPKeepAliveOptionsPtr keep_alive_options);

TCPConnectedSocketOptions(const TCPConnectedSocketOptions&) = delete;
TCPConnectedSocketOptions& operator=(const TCPConnectedSocketOptions&) = delete;

  ~TCPConnectedSocketOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TCPConnectedSocketOptionsPtr>
  TCPConnectedSocketOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TCPConnectedSocketOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TCPConnectedSocketOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TCPConnectedSocketOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TCPConnectedSocketOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TCPConnectedSocketOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TCPConnectedSocketOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TCPConnectedSocketOptions_UnserializedMessageContext<
            UserType, TCPConnectedSocketOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TCPConnectedSocketOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TCPConnectedSocketOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TCPConnectedSocketOptions_UnserializedMessageContext<
            UserType, TCPConnectedSocketOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TCPConnectedSocketOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t send_buffer_size;
  
  int32_t receive_buffer_size;
  
  bool no_delay;
  
  TCPKeepAliveOptionsPtr keep_alive_options;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TCPConnectedSocketOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TCPConnectedSocketOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TCPConnectedSocketOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TCPConnectedSocketOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
TCPKeepAliveOptionsPtr TCPKeepAliveOptions::Clone() const {
  return New(
      mojo::Clone(enable),
      mojo::Clone(delay)
  );
}

template <typename T, TCPKeepAliveOptions::EnableIfSame<T>*>
bool TCPKeepAliveOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->enable, other_struct.enable))
    return false;
  if (!mojo::Equals(this->delay, other_struct.delay))
    return false;
  return true;
}

template <typename T, TCPKeepAliveOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.enable < rhs.enable)
    return true;
  if (rhs.enable < lhs.enable)
    return false;
  if (lhs.delay < rhs.delay)
    return true;
  if (rhs.delay < lhs.delay)
    return false;
  return false;
}
template <typename StructPtrType>
TCPConnectedSocketOptionsPtr TCPConnectedSocketOptions::Clone() const {
  return New(
      mojo::Clone(send_buffer_size),
      mojo::Clone(receive_buffer_size),
      mojo::Clone(no_delay),
      mojo::Clone(keep_alive_options)
  );
}

template <typename T, TCPConnectedSocketOptions::EnableIfSame<T>*>
bool TCPConnectedSocketOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->send_buffer_size, other_struct.send_buffer_size))
    return false;
  if (!mojo::Equals(this->receive_buffer_size, other_struct.receive_buffer_size))
    return false;
  if (!mojo::Equals(this->no_delay, other_struct.no_delay))
    return false;
  if (!mojo::Equals(this->keep_alive_options, other_struct.keep_alive_options))
    return false;
  return true;
}

template <typename T, TCPConnectedSocketOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.send_buffer_size < rhs.send_buffer_size)
    return true;
  if (rhs.send_buffer_size < lhs.send_buffer_size)
    return false;
  if (lhs.receive_buffer_size < rhs.receive_buffer_size)
    return true;
  if (rhs.receive_buffer_size < lhs.receive_buffer_size)
    return false;
  if (lhs.no_delay < rhs.no_delay)
    return true;
  if (rhs.no_delay < lhs.no_delay)
    return false;
  if (lhs.keep_alive_options < rhs.keep_alive_options)
    return true;
  if (rhs.keep_alive_options < lhs.keep_alive_options)
    return false;
  return false;
}
template <typename StructPtrType>
TCPServerSocketOptionsPtr TCPServerSocketOptions::Clone() const {
  return New(
      mojo::Clone(backlog),
      mojo::Clone(ipv6_only)
  );
}

template <typename T, TCPServerSocketOptions::EnableIfSame<T>*>
bool TCPServerSocketOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->backlog, other_struct.backlog))
    return false;
  if (!mojo::Equals(this->ipv6_only, other_struct.ipv6_only))
    return false;
  return true;
}

template <typename T, TCPServerSocketOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.backlog < rhs.backlog)
    return true;
  if (rhs.backlog < lhs.backlog)
    return false;
  if (lhs.ipv6_only < rhs.ipv6_only)
    return true;
  if (rhs.ipv6_only < lhs.ipv6_only)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::TCPKeepAliveOptions::DataView,
                                         ::network::mojom::TCPKeepAliveOptionsPtr> {
  static bool IsNull(const ::network::mojom::TCPKeepAliveOptionsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::TCPKeepAliveOptionsPtr* output) { output->reset(); }

  static decltype(::network::mojom::TCPKeepAliveOptions::enable) enable(
      const ::network::mojom::TCPKeepAliveOptionsPtr& input) {
    return input->enable;
  }

  static decltype(::network::mojom::TCPKeepAliveOptions::delay) delay(
      const ::network::mojom::TCPKeepAliveOptionsPtr& input) {
    return input->delay;
  }

  static bool Read(::network::mojom::TCPKeepAliveOptions::DataView input, ::network::mojom::TCPKeepAliveOptionsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::TCPConnectedSocketOptions::DataView,
                                         ::network::mojom::TCPConnectedSocketOptionsPtr> {
  static bool IsNull(const ::network::mojom::TCPConnectedSocketOptionsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::TCPConnectedSocketOptionsPtr* output) { output->reset(); }

  static decltype(::network::mojom::TCPConnectedSocketOptions::send_buffer_size) send_buffer_size(
      const ::network::mojom::TCPConnectedSocketOptionsPtr& input) {
    return input->send_buffer_size;
  }

  static decltype(::network::mojom::TCPConnectedSocketOptions::receive_buffer_size) receive_buffer_size(
      const ::network::mojom::TCPConnectedSocketOptionsPtr& input) {
    return input->receive_buffer_size;
  }

  static decltype(::network::mojom::TCPConnectedSocketOptions::no_delay) no_delay(
      const ::network::mojom::TCPConnectedSocketOptionsPtr& input) {
    return input->no_delay;
  }

  static const decltype(::network::mojom::TCPConnectedSocketOptions::keep_alive_options)& keep_alive_options(
      const ::network::mojom::TCPConnectedSocketOptionsPtr& input) {
    return input->keep_alive_options;
  }

  static bool Read(::network::mojom::TCPConnectedSocketOptions::DataView input, ::network::mojom::TCPConnectedSocketOptionsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::TCPServerSocketOptions::DataView,
                                         ::network::mojom::TCPServerSocketOptionsPtr> {
  static bool IsNull(const ::network::mojom::TCPServerSocketOptionsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::TCPServerSocketOptionsPtr* output) { output->reset(); }

  static decltype(::network::mojom::TCPServerSocketOptions::backlog) backlog(
      const ::network::mojom::TCPServerSocketOptionsPtr& input) {
    return input->backlog;
  }

  static decltype(::network::mojom::TCPServerSocketOptions::ipv6_only) ipv6_only(
      const ::network::mojom::TCPServerSocketOptionsPtr& input) {
    return input->ipv6_only;
  }

  static bool Read(::network::mojom::TCPServerSocketOptions::DataView input, ::network::mojom::TCPServerSocketOptionsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TCP_SOCKET_MOJOM_H_