// services/network/public/mojom/trust_tokens.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/trust_tokens.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/trust_tokens.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::TrustTokenProtocolVersion>
    : public mojo::internal::EnumHashImpl<::network::mojom::TrustTokenProtocolVersion> {};

template <>
struct hash<::network::mojom::TrustTokenOperationStatus>
    : public mojo::internal::EnumHashImpl<::network::mojom::TrustTokenOperationStatus> {};

template <>
struct hash<::network::mojom::TrustTokenOperationType>
    : public mojo::internal::EnumHashImpl<::network::mojom::TrustTokenOperationType> {};

template <>
struct hash<::network::mojom::TrustTokenRefreshPolicy>
    : public mojo::internal::EnumHashImpl<::network::mojom::TrustTokenRefreshPolicy> {};

template <>
struct hash<::network::mojom::TrustTokenSignRequestData>
    : public mojo::internal::EnumHashImpl<::network::mojom::TrustTokenSignRequestData> {};

template <>
struct hash<::network::mojom::DeleteStoredTrustTokensStatus>
    : public mojo::internal::EnumHashImpl<::network::mojom::DeleteStoredTrustTokensStatus> {};

template <>
struct hash<::network::mojom::TrustTokenKeyCommitmentResult_Os>
    : public mojo::internal::EnumHashImpl<::network::mojom::TrustTokenKeyCommitmentResult_Os> {};

template <>
struct hash<::network::mojom::TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback>
    : public mojo::internal::EnumHashImpl<::network::mojom::TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback> {};

template <>
struct hash<::network::mojom::FulfillTrustTokenIssuanceAnswer_Status>
    : public mojo::internal::EnumHashImpl<::network::mojom::FulfillTrustTokenIssuanceAnswer_Status> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenProtocolVersion, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::TrustTokenProtocolVersion, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::TrustTokenProtocolVersion>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenOperationStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::TrustTokenOperationStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::TrustTokenOperationStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenOperationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::TrustTokenOperationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::TrustTokenOperationType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenRefreshPolicy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::TrustTokenRefreshPolicy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::TrustTokenRefreshPolicy>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenSignRequestData, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::TrustTokenSignRequestData, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::TrustTokenSignRequestData>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeleteStoredTrustTokensStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::DeleteStoredTrustTokensStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::DeleteStoredTrustTokensStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenKeyCommitmentResult_Os, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::TrustTokenKeyCommitmentResult_Os, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::TrustTokenKeyCommitmentResult_Os>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::FulfillTrustTokenIssuanceAnswer_Status, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::FulfillTrustTokenIssuanceAnswer_Status, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::FulfillTrustTokenIssuanceAnswer_Status>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustTokenParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::TrustTokenOperationType>(
      Traits::operation(input),
      &fragment->operation);

    
    mojo::internal::Serialize<::network::mojom::TrustTokenRefreshPolicy>(
      Traits::refresh_policy(input),
      &fragment->refresh_policy);

    decltype(Traits::custom_key_commitment(input)) in_custom_key_commitment = Traits::custom_key_commitment(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->custom_key_commitment)::BaseType> custom_key_commitment_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_custom_key_commitment,
      custom_key_commitment_fragment);

    fragment->custom_key_commitment.Set(
        custom_key_commitment_fragment.is_null() ? nullptr : custom_key_commitment_fragment.data());

    decltype(Traits::custom_issuer(input)) in_custom_issuer = Traits::custom_issuer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->custom_issuer)::BaseType> custom_issuer_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_custom_issuer,
      custom_issuer_fragment);

    fragment->custom_issuer.Set(
        custom_issuer_fragment.is_null() ? nullptr : custom_issuer_fragment.data());

    
    mojo::internal::Serialize<::network::mojom::TrustTokenSignRequestData>(
      Traits::sign_request_data(input),
      &fragment->sign_request_data);

    fragment->include_timestamp_header = Traits::include_timestamp_header(input);

    decltype(Traits::issuers(input)) in_issuers = Traits::issuers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->issuers)::BaseType>
        issuers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& issuers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
      in_issuers,
      issuers_fragment,
      &issuers_validate_params);

    fragment->issuers.Set(
        issuers_fragment.is_null() ? nullptr : issuers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->issuers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null issuers in TrustTokenParams struct");

    decltype(Traits::additional_signed_headers(input)) in_additional_signed_headers = Traits::additional_signed_headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->additional_signed_headers)::BaseType>
        additional_signed_headers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& additional_signed_headers_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_additional_signed_headers,
      additional_signed_headers_fragment,
      &additional_signed_headers_validate_params);

    fragment->additional_signed_headers.Set(
        additional_signed_headers_fragment.is_null() ? nullptr : additional_signed_headers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->additional_signed_headers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null additional_signed_headers in TrustTokenParams struct");

    decltype(Traits::possibly_unsafe_additional_signing_data(input)) in_possibly_unsafe_additional_signing_data = Traits::possibly_unsafe_additional_signing_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->possibly_unsafe_additional_signing_data)::BaseType> possibly_unsafe_additional_signing_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_possibly_unsafe_additional_signing_data,
      possibly_unsafe_additional_signing_data_fragment);

    fragment->possibly_unsafe_additional_signing_data.Set(
        possibly_unsafe_additional_signing_data_fragment.is_null() ? nullptr : possibly_unsafe_additional_signing_data_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::TrustTokenParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TrustTokenParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::HasTrustTokensResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::HasTrustTokensResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::HasTrustTokensResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::TrustTokenOperationStatus>(
      Traits::status(input),
      &fragment->status);

    fragment->has_trust_tokens = Traits::has_trust_tokens(input);
  }

  static bool Deserialize(::network::mojom::internal::HasTrustTokensResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::HasTrustTokensResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::HasRedemptionRecordResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::HasRedemptionRecordResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::HasRedemptionRecordResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::TrustTokenOperationStatus>(
      Traits::status(input),
      &fragment->status);

    fragment->has_redemption_record = Traits::has_redemption_record(input);
  }

  static bool Deserialize(::network::mojom::internal::HasRedemptionRecordResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::HasRedemptionRecordResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenVerificationKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenVerificationKeyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustTokenVerificationKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::body(input)) in_body = Traits::body(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->body)::BaseType> body_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_body,
      body_fragment);

    fragment->body.Set(
        body_fragment.is_null() ? nullptr : body_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->body.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null body in TrustTokenVerificationKey struct");

    decltype(Traits::expiry(input)) in_expiry = Traits::expiry(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expiry)::BaseType> expiry_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_expiry,
      expiry_fragment);

    fragment->expiry.Set(
        expiry_fragment.is_null() ? nullptr : expiry_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->expiry.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null expiry in TrustTokenVerificationKey struct");
  }

  static bool Deserialize(::network::mojom::internal::TrustTokenVerificationKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TrustTokenVerificationKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenKeyCommitmentResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenKeyCommitmentResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustTokenKeyCommitmentResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::TrustTokenProtocolVersion>(
      Traits::protocol_version(input),
      &fragment->protocol_version);

    fragment->id = Traits::id(input);

    fragment->batch_size = Traits::batch_size(input);

    decltype(Traits::keys(input)) in_keys = Traits::keys(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->keys)::BaseType>
        keys_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::TrustTokenVerificationKeyDataView>>(
      in_keys,
      keys_fragment,
      &keys_validate_params);

    fragment->keys.Set(
        keys_fragment.is_null() ? nullptr : keys_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->keys.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null keys in TrustTokenKeyCommitmentResult struct");

    decltype(Traits::request_issuance_locally_on(input)) in_request_issuance_locally_on = Traits::request_issuance_locally_on(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_issuance_locally_on)::BaseType>
        request_issuance_locally_on_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& request_issuance_locally_on_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::TrustTokenKeyCommitmentResult_Os_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::TrustTokenKeyCommitmentResult_Os>>(
      in_request_issuance_locally_on,
      request_issuance_locally_on_fragment,
      &request_issuance_locally_on_validate_params);

    fragment->request_issuance_locally_on.Set(
        request_issuance_locally_on_fragment.is_null() ? nullptr : request_issuance_locally_on_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->request_issuance_locally_on.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_issuance_locally_on in TrustTokenKeyCommitmentResult struct");

    
    mojo::internal::Serialize<::network::mojom::TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback>(
      Traits::unavailable_local_operation_fallback(input),
      &fragment->unavailable_local_operation_fallback);
  }

  static bool Deserialize(::network::mojom::internal::TrustTokenKeyCommitmentResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TrustTokenKeyCommitmentResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::FulfillTrustTokenIssuanceRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::FulfillTrustTokenIssuanceRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::FulfillTrustTokenIssuanceRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::issuer(input)) in_issuer = Traits::issuer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->issuer)::BaseType> issuer_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_issuer,
      issuer_fragment);

    fragment->issuer.Set(
        issuer_fragment.is_null() ? nullptr : issuer_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->issuer.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null issuer in FulfillTrustTokenIssuanceRequest struct");

    decltype(Traits::request(input)) in_request = Traits::request(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request)::BaseType> request_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_request,
      request_fragment);

    fragment->request.Set(
        request_fragment.is_null() ? nullptr : request_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->request.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request in FulfillTrustTokenIssuanceRequest struct");
  }

  static bool Deserialize(::network::mojom::internal::FulfillTrustTokenIssuanceRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::FulfillTrustTokenIssuanceRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::FulfillTrustTokenIssuanceAnswerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::FulfillTrustTokenIssuanceAnswerDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::FulfillTrustTokenIssuanceAnswer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::FulfillTrustTokenIssuanceAnswer_Status>(
      Traits::status(input),
      &fragment->status);

    decltype(Traits::response(input)) in_response = Traits::response(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->response)::BaseType> response_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_response,
      response_fragment);

    fragment->response.Set(
        response_fragment.is_null() ? nullptr : response_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->response.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response in FulfillTrustTokenIssuanceAnswer struct");
  }

  static bool Deserialize(::network::mojom::internal::FulfillTrustTokenIssuanceAnswer_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::FulfillTrustTokenIssuanceAnswerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenOperationResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenOperationResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustTokenOperationResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::TrustTokenOperationType>(
      Traits::operation(input),
      &fragment->operation);

    
    mojo::internal::Serialize<::network::mojom::TrustTokenOperationStatus>(
      Traits::status(input),
      &fragment->status);

    decltype(Traits::issuer(input)) in_issuer = Traits::issuer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->issuer)::BaseType> issuer_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_issuer,
      issuer_fragment);

    fragment->issuer.Set(
        issuer_fragment.is_null() ? nullptr : issuer_fragment.data());

    decltype(Traits::top_level_origin(input)) in_top_level_origin = Traits::top_level_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top_level_origin)::BaseType> top_level_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_top_level_origin,
      top_level_origin_fragment);

    fragment->top_level_origin.Set(
        top_level_origin_fragment.is_null() ? nullptr : top_level_origin_fragment.data());

    fragment->issued_token_count = Traits::issued_token_count(input);
  }

  static bool Deserialize(::network::mojom::internal::TrustTokenOperationResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TrustTokenOperationResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::StoredTrustTokensForIssuerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::StoredTrustTokensForIssuerDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::StoredTrustTokensForIssuer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::issuer(input)) in_issuer = Traits::issuer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->issuer)::BaseType> issuer_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_issuer,
      issuer_fragment);

    fragment->issuer.Set(
        issuer_fragment.is_null() ? nullptr : issuer_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->issuer.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null issuer in StoredTrustTokensForIssuer struct");

    fragment->count = Traits::count(input);
  }

  static bool Deserialize(::network::mojom::internal::StoredTrustTokensForIssuer_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::StoredTrustTokensForIssuerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ToplevelRedemptionRecordDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ToplevelRedemptionRecordDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ToplevelRedemptionRecord_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::toplevel_origin(input)) in_toplevel_origin = Traits::toplevel_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->toplevel_origin)::BaseType> toplevel_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_toplevel_origin,
      toplevel_origin_fragment);

    fragment->toplevel_origin.Set(
        toplevel_origin_fragment.is_null() ? nullptr : toplevel_origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->toplevel_origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null toplevel_origin in ToplevelRedemptionRecord struct");

    decltype(Traits::last_redemption(input)) in_last_redemption = Traits::last_redemption(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_redemption)::BaseType> last_redemption_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_redemption,
      last_redemption_fragment);

    fragment->last_redemption.Set(
        last_redemption_fragment.is_null() ? nullptr : last_redemption_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_redemption.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_redemption in ToplevelRedemptionRecord struct");
  }

  static bool Deserialize(::network::mojom::internal::ToplevelRedemptionRecord_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ToplevelRedemptionRecordDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void TrustTokenParamsDataView::GetCustomKeyCommitmentDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->custom_key_commitment.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TrustTokenParamsDataView::GetCustomIssuerDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->custom_issuer.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void TrustTokenParamsDataView::GetIssuersDataView(
    mojo::ArrayDataView<::url::mojom::OriginDataView>* output) {
  auto pointer = data_->issuers.Get();
  *output = mojo::ArrayDataView<::url::mojom::OriginDataView>(pointer, message_);
}
inline void TrustTokenParamsDataView::GetAdditionalSignedHeadersDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->additional_signed_headers.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void TrustTokenParamsDataView::GetPossiblyUnsafeAdditionalSigningDataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->possibly_unsafe_additional_signing_data.Get();
  *output = mojo::StringDataView(pointer, message_);
}






inline void TrustTokenVerificationKeyDataView::GetBodyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->body.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TrustTokenVerificationKeyDataView::GetExpiryDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->expiry.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void TrustTokenKeyCommitmentResultDataView::GetKeysDataView(
    mojo::ArrayDataView<TrustTokenVerificationKeyDataView>* output) {
  auto pointer = data_->keys.Get();
  *output = mojo::ArrayDataView<TrustTokenVerificationKeyDataView>(pointer, message_);
}
inline void TrustTokenKeyCommitmentResultDataView::GetRequestIssuanceLocallyOnDataView(
    mojo::ArrayDataView<TrustTokenKeyCommitmentResult_Os>* output) {
  auto pointer = data_->request_issuance_locally_on.Get();
  *output = mojo::ArrayDataView<TrustTokenKeyCommitmentResult_Os>(pointer, message_);
}


inline void FulfillTrustTokenIssuanceRequestDataView::GetIssuerDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->issuer.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void FulfillTrustTokenIssuanceRequestDataView::GetRequestDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->request.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void FulfillTrustTokenIssuanceAnswerDataView::GetResponseDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->response.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void TrustTokenOperationResultDataView::GetIssuerDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->issuer.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void TrustTokenOperationResultDataView::GetTopLevelOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->top_level_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void StoredTrustTokensForIssuerDataView::GetIssuerDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->issuer.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void ToplevelRedemptionRecordDataView::GetToplevelOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->toplevel_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void ToplevelRedemptionRecordDataView::GetLastRedemptionDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_redemption.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::TrustTokenProtocolVersion> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::TrustTokenProtocolVersion value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::TrustTokenOperationStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::TrustTokenOperationStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::TrustTokenOperationType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::TrustTokenOperationType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::TrustTokenRefreshPolicy> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::TrustTokenRefreshPolicy value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::TrustTokenSignRequestData> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::TrustTokenSignRequestData value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::DeleteStoredTrustTokensStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::DeleteStoredTrustTokensStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::TrustTokenKeyCommitmentResult_Os> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::TrustTokenKeyCommitmentResult_Os value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::FulfillTrustTokenIssuanceAnswer_Status> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::FulfillTrustTokenIssuanceAnswer_Status value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_SHARED_H_