// services/network/public/mojom/url_loader.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/url_loader.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/url_loader.mojom-params-data.h"
#include "services/network/public/mojom/url_loader.mojom-shared-message-ids.h"

#include "services/network/public/mojom/url_loader.mojom-import-headers.h"
#include "services/network/public/mojom/url_loader.mojom-test-utils.h"
#include "net/cert/cert_verify_result.h"


namespace network::mojom {
URLLoaderClientEndpoints::URLLoaderClientEndpoints()
    : url_loader(),
      url_loader_client() {}

URLLoaderClientEndpoints::URLLoaderClientEndpoints(
    ::mojo::PendingRemote<URLLoader> url_loader_in,
    ::mojo::PendingReceiver<URLLoaderClient> url_loader_client_in)
    : url_loader(std::move(url_loader_in)),
      url_loader_client(std::move(url_loader_client_in)) {}

URLLoaderClientEndpoints::~URLLoaderClientEndpoints() = default;

void URLLoaderClientEndpoints::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_loader"), this->url_loader,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<URLLoader>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_loader_client"), this->url_loader_client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<URLLoaderClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool URLLoaderClientEndpoints::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.
constexpr uint32_t URLLoader::kClientDisconnectReason;

URLLoader::IPCStableHashFunction URLLoader::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::URLLoader>(message.name())) {
    case messages::URLLoader::kFollowRedirect: {
      return &URLLoader::FollowRedirect_Sym::IPCStableHash;
    }
    case messages::URLLoader::kSetPriority: {
      return &URLLoader::SetPriority_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* URLLoader::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::URLLoader>(message.name())) {
      case messages::URLLoader::kFollowRedirect:
            return "Receive network::mojom::URLLoader::FollowRedirect";
      case messages::URLLoader::kSetPriority:
            return "Receive network::mojom::URLLoader::SetPriority";
    }
  } else {
    switch (static_cast<messages::URLLoader>(message.name())) {
      case messages::URLLoader::kFollowRedirect:
            return "Receive reply network::mojom::URLLoader::FollowRedirect";
      case messages::URLLoader::kSetPriority:
            return "Receive reply network::mojom::URLLoader::SetPriority";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t URLLoader::FollowRedirect_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x076f8b22;  // IPCStableHash for network::mojom::URLLoader::FollowRedirect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoader::SetPriority_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4f88b8f7;  // IPCStableHash for network::mojom::URLLoader::SetPriority
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

URLLoaderProxy::URLLoaderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void URLLoaderProxy::FollowRedirect(
    const std::vector<std::string>& in_removed_headers, const ::net::HttpRequestHeaders& in_modified_headers, const ::net::HttpRequestHeaders& in_modified_cors_exempt_headers, const std::optional<::GURL>& in_new_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoader::FollowRedirect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("removed_headers"), in_removed_headers,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("modified_headers"), in_modified_headers,
                        "<value of type const ::net::HttpRequestHeaders&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("modified_cors_exempt_headers"), in_modified_cors_exempt_headers,
                        "<value of type const ::net::HttpRequestHeaders&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_url"), in_new_url,
                        "<value of type const std::optional<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoader::kFollowRedirect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoader_FollowRedirect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->removed_headers)::BaseType>
      removed_headers_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& removed_headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_removed_headers,
    removed_headers_fragment,
    &removed_headers_validate_params);

  params->removed_headers.Set(
      removed_headers_fragment.is_null() ? nullptr : removed_headers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->removed_headers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null removed_headers in URLLoader.FollowRedirect request");
  mojo::internal::MessageFragment<
      typename decltype(params->modified_headers)::BaseType> modified_headers_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
    in_modified_headers,
    modified_headers_fragment);

  params->modified_headers.Set(
      modified_headers_fragment.is_null() ? nullptr : modified_headers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->modified_headers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null modified_headers in URLLoader.FollowRedirect request");
  mojo::internal::MessageFragment<
      typename decltype(params->modified_cors_exempt_headers)::BaseType> modified_cors_exempt_headers_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
    in_modified_cors_exempt_headers,
    modified_cors_exempt_headers_fragment);

  params->modified_cors_exempt_headers.Set(
      modified_cors_exempt_headers_fragment.is_null() ? nullptr : modified_cors_exempt_headers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->modified_cors_exempt_headers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null modified_cors_exempt_headers in URLLoader.FollowRedirect request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_url)::BaseType> new_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_new_url,
    new_url_fragment);

  params->new_url.Set(
      new_url_fragment.is_null() ? nullptr : new_url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoader::Name_);
  message.set_method_name("FollowRedirect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void URLLoaderProxy::SetPriority(
    ::net::RequestPriority in_priority, int32_t in_intra_priority_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoader::SetPriority", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority"), in_priority,
                        "<value of type ::net::RequestPriority>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("intra_priority_value"), in_intra_priority_value,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoader::kSetPriority), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoader_SetPriority_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::RequestPriority>(
    in_priority,
    &params->priority);

  params->intra_priority_value = in_intra_priority_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoader::Name_);
  message.set_method_name("SetPriority");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool URLLoaderStubDispatch::Accept(
    URLLoader* impl,
    mojo::Message* message) {
  switch (static_cast<messages::URLLoader>(message->header()->name)) {
    case messages::URLLoader::kFollowRedirect: {
      DCHECK(message->is_serialized());
      internal::URLLoader_FollowRedirect_Params_Data* params =
          reinterpret_cast<internal::URLLoader_FollowRedirect_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoader.0
      bool success = true;
      std::vector<std::string> p_removed_headers{};
      ::net::HttpRequestHeaders p_modified_headers{};
      ::net::HttpRequestHeaders p_modified_cors_exempt_headers{};
      std::optional<::GURL> p_new_url{};
      URLLoader_FollowRedirect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRemovedHeaders(&p_removed_headers))
        success = false;
      if (success && !input_data_view.ReadModifiedHeaders(&p_modified_headers))
        success = false;
      if (success && !input_data_view.ReadModifiedCorsExemptHeaders(&p_modified_cors_exempt_headers))
        success = false;
      if (success && !input_data_view.ReadNewUrl(&p_new_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoader::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FollowRedirect(        
        std::move(p_removed_headers), 
        std::move(p_modified_headers), 
        std::move(p_modified_cors_exempt_headers), 
        std::move(p_new_url));
      return true;
    }
    case messages::URLLoader::kSetPriority: {
      DCHECK(message->is_serialized());
      internal::URLLoader_SetPriority_Params_Data* params =
          reinterpret_cast<internal::URLLoader_SetPriority_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoader.1
      bool success = true;
      ::net::RequestPriority p_priority{};
      int32_t p_intra_priority_value{};
      URLLoader_SetPriority_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPriority(&p_priority))
        success = false;
      if (success)
        p_intra_priority_value = input_data_view.intra_priority_value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoader::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPriority(        
        std::move(p_priority), 
        std::move(p_intra_priority_value));
      return true;
    }
  }
  return false;
}

// static
bool URLLoaderStubDispatch::AcceptWithResponder(
    URLLoader* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::URLLoader>(message->header()->name)) {
    case messages::URLLoader::kFollowRedirect: {
      break;
    }
    case messages::URLLoader::kSetPriority: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kURLLoaderValidationInfo[] = {
    {base::to_underlying(messages::URLLoader::kFollowRedirect),
     { &internal::URLLoader_FollowRedirect_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::URLLoader::kSetPriority),
     { &internal::URLLoader_SetPriority_Params_Data::Validate,
      nullptr /* no response */}},
};

bool URLLoaderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::URLLoader::Name_,
    kURLLoaderValidationInfo);
}

// The declaration includes the definition on other builds.

URLLoaderClient::IPCStableHashFunction URLLoaderClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::URLLoaderClient>(message.name())) {
    case messages::URLLoaderClient::kOnReceiveEarlyHints: {
      return &URLLoaderClient::OnReceiveEarlyHints_Sym::IPCStableHash;
    }
    case messages::URLLoaderClient::kOnReceiveResponse: {
      return &URLLoaderClient::OnReceiveResponse_Sym::IPCStableHash;
    }
    case messages::URLLoaderClient::kOnReceiveRedirect: {
      return &URLLoaderClient::OnReceiveRedirect_Sym::IPCStableHash;
    }
    case messages::URLLoaderClient::kOnUploadProgress: {
      return &URLLoaderClient::OnUploadProgress_Sym::IPCStableHash;
    }
    case messages::URLLoaderClient::kOnTransferSizeUpdated: {
      return &URLLoaderClient::OnTransferSizeUpdated_Sym::IPCStableHash;
    }
    case messages::URLLoaderClient::kOnComplete: {
      return &URLLoaderClient::OnComplete_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* URLLoaderClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::URLLoaderClient>(message.name())) {
      case messages::URLLoaderClient::kOnReceiveEarlyHints:
            return "Receive network::mojom::URLLoaderClient::OnReceiveEarlyHints";
      case messages::URLLoaderClient::kOnReceiveResponse:
            return "Receive network::mojom::URLLoaderClient::OnReceiveResponse";
      case messages::URLLoaderClient::kOnReceiveRedirect:
            return "Receive network::mojom::URLLoaderClient::OnReceiveRedirect";
      case messages::URLLoaderClient::kOnUploadProgress:
            return "Receive network::mojom::URLLoaderClient::OnUploadProgress";
      case messages::URLLoaderClient::kOnTransferSizeUpdated:
            return "Receive network::mojom::URLLoaderClient::OnTransferSizeUpdated";
      case messages::URLLoaderClient::kOnComplete:
            return "Receive network::mojom::URLLoaderClient::OnComplete";
    }
  } else {
    switch (static_cast<messages::URLLoaderClient>(message.name())) {
      case messages::URLLoaderClient::kOnReceiveEarlyHints:
            return "Receive reply network::mojom::URLLoaderClient::OnReceiveEarlyHints";
      case messages::URLLoaderClient::kOnReceiveResponse:
            return "Receive reply network::mojom::URLLoaderClient::OnReceiveResponse";
      case messages::URLLoaderClient::kOnReceiveRedirect:
            return "Receive reply network::mojom::URLLoaderClient::OnReceiveRedirect";
      case messages::URLLoaderClient::kOnUploadProgress:
            return "Receive reply network::mojom::URLLoaderClient::OnUploadProgress";
      case messages::URLLoaderClient::kOnTransferSizeUpdated:
            return "Receive reply network::mojom::URLLoaderClient::OnTransferSizeUpdated";
      case messages::URLLoaderClient::kOnComplete:
            return "Receive reply network::mojom::URLLoaderClient::OnComplete";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t URLLoaderClient::OnReceiveEarlyHints_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x050f7ef8;  // IPCStableHash for network::mojom::URLLoaderClient::OnReceiveEarlyHints
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderClient::OnReceiveResponse_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc90ee12b;  // IPCStableHash for network::mojom::URLLoaderClient::OnReceiveResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderClient::OnReceiveRedirect_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x49210926;  // IPCStableHash for network::mojom::URLLoaderClient::OnReceiveRedirect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderClient::OnUploadProgress_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd045320f;  // IPCStableHash for network::mojom::URLLoaderClient::OnUploadProgress
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderClient::OnTransferSizeUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x01b7d581;  // IPCStableHash for network::mojom::URLLoaderClient::OnTransferSizeUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderClient::OnComplete_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa47ac602;  // IPCStableHash for network::mojom::URLLoaderClient::OnComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class URLLoaderClient_OnUploadProgress_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  URLLoaderClient_OnUploadProgress_ForwardToCallback(
      URLLoaderClient::OnUploadProgressCallback callback
      ) : callback_(std::move(callback)) {
  }

  URLLoaderClient_OnUploadProgress_ForwardToCallback(const URLLoaderClient_OnUploadProgress_ForwardToCallback&) = delete;
  URLLoaderClient_OnUploadProgress_ForwardToCallback& operator=(const URLLoaderClient_OnUploadProgress_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  URLLoaderClient::OnUploadProgressCallback callback_;
};

URLLoaderClientProxy::URLLoaderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void URLLoaderClientProxy::OnReceiveEarlyHints(
    ::network::mojom::EarlyHintsPtr in_early_hints) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderClient::OnReceiveEarlyHints", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("early_hints"), in_early_hints,
                        "<value of type ::network::mojom::EarlyHintsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderClient::kOnReceiveEarlyHints), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnReceiveEarlyHints_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->early_hints)::BaseType> early_hints_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::EarlyHintsDataView>(
    in_early_hints,
    early_hints_fragment);

  params->early_hints.Set(
      early_hints_fragment.is_null() ? nullptr : early_hints_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->early_hints.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null early_hints in URLLoaderClient.OnReceiveEarlyHints request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnReceiveEarlyHints");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void URLLoaderClientProxy::OnReceiveResponse(
    ::network::mojom::URLResponseHeadPtr in_head, ::mojo::ScopedDataPipeConsumerHandle in_body, std::optional<::mojo_base::BigBuffer> in_cached_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderClient::OnReceiveResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("head"), in_head,
                        "<value of type ::network::mojom::URLResponseHeadPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("body"), in_body,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cached_metadata"), in_cached_metadata,
                        "<value of type std::optional<::mojo_base::BigBuffer>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderClient::kOnReceiveResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnReceiveResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->head)::BaseType> head_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
    in_head,
    head_fragment);

  params->head.Set(
      head_fragment.is_null() ? nullptr : head_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->head.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null head in URLLoaderClient.OnReceiveResponse request");

  
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
    in_body,
    &params->body,
    &params.message());
  mojo::internal::MessageFragment<decltype(params->cached_metadata)>
      cached_metadata_fragment(params.message());
  cached_metadata_fragment.Claim(&params->cached_metadata);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_cached_metadata,
    cached_metadata_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnReceiveResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void URLLoaderClientProxy::OnReceiveRedirect(
    const ::net::RedirectInfo& in_redirect_info, ::network::mojom::URLResponseHeadPtr in_head) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderClient::OnReceiveRedirect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("redirect_info"), in_redirect_info,
                        "<value of type const ::net::RedirectInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("head"), in_head,
                        "<value of type ::network::mojom::URLResponseHeadPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderClient::kOnReceiveRedirect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnReceiveRedirect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->redirect_info)::BaseType> redirect_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLRequestRedirectInfoDataView>(
    in_redirect_info,
    redirect_info_fragment);

  params->redirect_info.Set(
      redirect_info_fragment.is_null() ? nullptr : redirect_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->redirect_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null redirect_info in URLLoaderClient.OnReceiveRedirect request");
  mojo::internal::MessageFragment<
      typename decltype(params->head)::BaseType> head_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
    in_head,
    head_fragment);

  params->head.Set(
      head_fragment.is_null() ? nullptr : head_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->head.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null head in URLLoaderClient.OnReceiveRedirect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnReceiveRedirect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void URLLoaderClientProxy::OnUploadProgress(
    int64_t in_current_position, int64_t in_total_size, OnUploadProgressCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderClient::OnUploadProgress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_position"), in_current_position,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_size"), in_total_size,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderClient::kOnUploadProgress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnUploadProgress_Params_Data> params(
          message);
  params.Allocate();

  params->current_position = in_current_position;

  params->total_size = in_total_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnUploadProgress");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new URLLoaderClient_OnUploadProgress_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void URLLoaderClientProxy::OnTransferSizeUpdated(
    int32_t in_transfer_size_diff) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderClient::OnTransferSizeUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transfer_size_diff"), in_transfer_size_diff,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderClient::kOnTransferSizeUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnTransferSizeUpdated_Params_Data> params(
          message);
  params.Allocate();

  params->transfer_size_diff = in_transfer_size_diff;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnTransferSizeUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void URLLoaderClientProxy::OnComplete(
    const ::network::URLLoaderCompletionStatus& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderClient::OnComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::network::URLLoaderCompletionStatus&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderClient::kOnComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnComplete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLLoaderCompletionStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in URLLoaderClient.OnComplete request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class URLLoaderClient_OnUploadProgress_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static URLLoaderClient::OnUploadProgressCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<URLLoaderClient_OnUploadProgress_ProxyToResponder> proxy(
        new URLLoaderClient_OnUploadProgress_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&URLLoaderClient_OnUploadProgress_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~URLLoaderClient_OnUploadProgress_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  URLLoaderClient_OnUploadProgress_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "URLLoaderClient::OnUploadProgressCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool URLLoaderClient_OnUploadProgress_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::URLLoaderClient_OnUploadProgress_ResponseParams_Data* params =
      reinterpret_cast<
          internal::URLLoaderClient_OnUploadProgress_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for URLLoaderClient.3
  bool success = true;
  URLLoaderClient_OnUploadProgress_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        URLLoaderClient::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void URLLoaderClient_OnUploadProgress_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::URLLoaderClient::OnUploadProgress");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderClient::kOnUploadProgress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnUploadProgress_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnUploadProgress");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool URLLoaderClientStubDispatch::Accept(
    URLLoaderClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::URLLoaderClient>(message->header()->name)) {
    case messages::URLLoaderClient::kOnReceiveEarlyHints: {
      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnReceiveEarlyHints_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnReceiveEarlyHints_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderClient.0
      bool success = true;
      ::network::mojom::EarlyHintsPtr p_early_hints{};
      URLLoaderClient_OnReceiveEarlyHints_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEarlyHints(&p_early_hints))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReceiveEarlyHints(        
        std::move(p_early_hints));
      return true;
    }
    case messages::URLLoaderClient::kOnReceiveResponse: {
      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnReceiveResponse_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnReceiveResponse_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderClient.1
      bool success = true;
      ::network::mojom::URLResponseHeadPtr p_head{};
      ::mojo::ScopedDataPipeConsumerHandle p_body{};
      std::optional<::mojo_base::BigBuffer> p_cached_metadata{};
      URLLoaderClient_OnReceiveResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHead(&p_head))
        success = false;
      if (success)
        p_body = input_data_view.TakeBody();
      if (success && !input_data_view.ReadCachedMetadata(&p_cached_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReceiveResponse(        
        std::move(p_head), 
        std::move(p_body), 
        std::move(p_cached_metadata));
      return true;
    }
    case messages::URLLoaderClient::kOnReceiveRedirect: {
      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnReceiveRedirect_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnReceiveRedirect_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderClient.2
      bool success = true;
      ::net::RedirectInfo p_redirect_info{};
      ::network::mojom::URLResponseHeadPtr p_head{};
      URLLoaderClient_OnReceiveRedirect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRedirectInfo(&p_redirect_info))
        success = false;
      if (success && !input_data_view.ReadHead(&p_head))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReceiveRedirect(        
        std::move(p_redirect_info), 
        std::move(p_head));
      return true;
    }
    case messages::URLLoaderClient::kOnUploadProgress: {
      break;
    }
    case messages::URLLoaderClient::kOnTransferSizeUpdated: {
      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnTransferSizeUpdated_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnTransferSizeUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderClient.4
      bool success = true;
      int32_t p_transfer_size_diff{};
      URLLoaderClient_OnTransferSizeUpdated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_transfer_size_diff = input_data_view.transfer_size_diff();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTransferSizeUpdated(        
        std::move(p_transfer_size_diff));
      return true;
    }
    case messages::URLLoaderClient::kOnComplete: {
      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnComplete_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderClient.5
      bool success = true;
      ::network::URLLoaderCompletionStatus p_status{};
      URLLoaderClient_OnComplete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnComplete(        
        std::move(p_status));
      return true;
    }
  }
  return false;
}

// static
bool URLLoaderClientStubDispatch::AcceptWithResponder(
    URLLoaderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::URLLoaderClient>(message->header()->name)) {
    case messages::URLLoaderClient::kOnReceiveEarlyHints: {
      break;
    }
    case messages::URLLoaderClient::kOnReceiveResponse: {
      break;
    }
    case messages::URLLoaderClient::kOnReceiveRedirect: {
      break;
    }
    case messages::URLLoaderClient::kOnUploadProgress: {
      internal::URLLoaderClient_OnUploadProgress_Params_Data* params =
          reinterpret_cast<
              internal::URLLoaderClient_OnUploadProgress_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for URLLoaderClient.3
      bool success = true;
      int64_t p_current_position{};
      int64_t p_total_size{};
      URLLoaderClient_OnUploadProgress_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_current_position = input_data_view.current_position();
      if (success)
        p_total_size = input_data_view.total_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 3, false);
        return false;
      }
      auto callback =
          URLLoaderClient_OnUploadProgress_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnUploadProgress(        
        std::move(p_current_position), 
        std::move(p_total_size), std::move(callback));
      return true;
    }
    case messages::URLLoaderClient::kOnTransferSizeUpdated: {
      break;
    }
    case messages::URLLoaderClient::kOnComplete: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kURLLoaderClientValidationInfo[] = {
    {base::to_underlying(messages::URLLoaderClient::kOnReceiveEarlyHints),
     { &internal::URLLoaderClient_OnReceiveEarlyHints_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::URLLoaderClient::kOnReceiveResponse),
     { &internal::URLLoaderClient_OnReceiveResponse_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::URLLoaderClient::kOnReceiveRedirect),
     { &internal::URLLoaderClient_OnReceiveRedirect_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::URLLoaderClient::kOnUploadProgress),
     { &internal::URLLoaderClient_OnUploadProgress_Params_Data::Validate,
      &internal::URLLoaderClient_OnUploadProgress_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::URLLoaderClient::kOnTransferSizeUpdated),
     { &internal::URLLoaderClient_OnTransferSizeUpdated_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::URLLoaderClient::kOnComplete),
     { &internal::URLLoaderClient_OnComplete_Params_Data::Validate,
      nullptr /* no response */}},
};

bool URLLoaderClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::URLLoaderClient::Name_,
    kURLLoaderClientValidationInfo);
}

bool URLLoaderClientResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::network::mojom::URLLoaderClient::Name_,
    kURLLoaderClientValidationInfo);

}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::URLLoaderClientEndpoints::DataView, ::network::mojom::URLLoaderClientEndpointsPtr>::Read(
    ::network::mojom::URLLoaderClientEndpoints::DataView input,
    ::network::mojom::URLLoaderClientEndpointsPtr* output) {
  bool success = true;
  ::network::mojom::URLLoaderClientEndpointsPtr result(::network::mojom::URLLoaderClientEndpoints::New());
  
      if (success) {
        result->url_loader =
            input.TakeUrlLoader<decltype(result->url_loader)>();
      }
      if (success) {
        result->url_loader_client =
            input.TakeUrlLoaderClient<decltype(result->url_loader_client)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void URLLoaderInterceptorForTesting::FollowRedirect(const std::vector<std::string>& removed_headers, const ::net::HttpRequestHeaders& modified_headers, const ::net::HttpRequestHeaders& modified_cors_exempt_headers, const std::optional<::GURL>& new_url) {
  GetForwardingInterface()->FollowRedirect(
    std::move(removed_headers)
    , 
    std::move(modified_headers)
    , 
    std::move(modified_cors_exempt_headers)
    , 
    std::move(new_url)
    );
}
void URLLoaderInterceptorForTesting::SetPriority(::net::RequestPriority priority, int32_t intra_priority_value) {
  GetForwardingInterface()->SetPriority(
    std::move(priority)
    , 
    std::move(intra_priority_value)
    );
}
URLLoaderAsyncWaiter::URLLoaderAsyncWaiter(
    URLLoader* proxy) : proxy_(proxy) {}

URLLoaderAsyncWaiter::~URLLoaderAsyncWaiter() = default;





void URLLoaderClientInterceptorForTesting::OnReceiveEarlyHints(::network::mojom::EarlyHintsPtr early_hints) {
  GetForwardingInterface()->OnReceiveEarlyHints(
    std::move(early_hints)
    );
}
void URLLoaderClientInterceptorForTesting::OnReceiveResponse(::network::mojom::URLResponseHeadPtr head, ::mojo::ScopedDataPipeConsumerHandle body, std::optional<::mojo_base::BigBuffer> cached_metadata) {
  GetForwardingInterface()->OnReceiveResponse(
    std::move(head)
    , 
    std::move(body)
    , 
    std::move(cached_metadata)
    );
}
void URLLoaderClientInterceptorForTesting::OnReceiveRedirect(const ::net::RedirectInfo& redirect_info, ::network::mojom::URLResponseHeadPtr head) {
  GetForwardingInterface()->OnReceiveRedirect(
    std::move(redirect_info)
    , 
    std::move(head)
    );
}
void URLLoaderClientInterceptorForTesting::OnUploadProgress(int64_t current_position, int64_t total_size, OnUploadProgressCallback callback) {
  GetForwardingInterface()->OnUploadProgress(
    std::move(current_position)
    , 
    std::move(total_size)
    , std::move(callback));
}
void URLLoaderClientInterceptorForTesting::OnTransferSizeUpdated(int32_t transfer_size_diff) {
  GetForwardingInterface()->OnTransferSizeUpdated(
    std::move(transfer_size_diff)
    );
}
void URLLoaderClientInterceptorForTesting::OnComplete(const ::network::URLLoaderCompletionStatus& status) {
  GetForwardingInterface()->OnComplete(
    std::move(status)
    );
}
URLLoaderClientAsyncWaiter::URLLoaderClientAsyncWaiter(
    URLLoaderClient* proxy) : proxy_(proxy) {}

URLLoaderClientAsyncWaiter::~URLLoaderClientAsyncWaiter() = default;


void URLLoaderClientAsyncWaiter::OnUploadProgress(
    int64_t current_position, int64_t total_size) {
  base::RunLoop loop;
  proxy_->OnUploadProgress(
      std::move(current_position),
      std::move(total_size),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif