// services/network/public/mojom/url_request.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/url_request.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/url_request.mojom-params-data.h"
#include "services/network/public/mojom/url_request.mojom-shared-message-ids.h"

#include "services/network/public/mojom/url_request.mojom-blink-import-headers.h"
#include "services/network/public/mojom/url_request.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/device_bound_sessions.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom.h"


namespace network::mojom::blink {
EnabledClientHints::EnabledClientHints()
    : origin(),
      is_outermost_main_frame(),
      hints() {}

EnabledClientHints::EnabledClientHints(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& origin_in,
    bool is_outermost_main_frame_in,
    ::blink::Vector<::network::mojom::blink::WebClientHintsType> hints_in)
    : origin(std::move(origin_in)),
      is_outermost_main_frame(std::move(is_outermost_main_frame_in)),
      hints(std::move(hints_in)) {}

EnabledClientHints::~EnabledClientHints() = default;

void EnabledClientHints::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_outermost_main_frame"), this->is_outermost_main_frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hints"), this->hints,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::network::mojom::blink::WebClientHintsType>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EnabledClientHints::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TrustedUrlRequestParams::TrustedUrlRequestParams()
    : isolation_info(),
      disable_secure_dns(),
      has_user_activation(),
      allow_cookies_from_browser(),
      include_request_cookies_with_response(false),
      enabled_client_hints(),
      cookie_observer(),
      trust_token_observer(),
      url_loader_network_observer(),
      devtools_observer(),
      device_bound_session_observer(),
      client_security_state(),
      accept_ch_frame_observer(),
      shared_dictionary_observer() {}

TrustedUrlRequestParams::TrustedUrlRequestParams(
    const ::net::IsolationInfo& isolation_info_in,
    bool disable_secure_dns_in,
    bool has_user_activation_in,
    bool allow_cookies_from_browser_in,
    bool include_request_cookies_with_response_in,
    EnabledClientHintsPtr enabled_client_hints_in,
    ::mojo::PendingRemote<::network::mojom::blink::CookieAccessObserver> cookie_observer_in,
    ::mojo::PendingRemote<::network::mojom::blink::TrustTokenAccessObserver> trust_token_observer_in,
    ::mojo::PendingRemote<::network::mojom::blink::URLLoaderNetworkServiceObserver> url_loader_network_observer_in,
    ::mojo::PendingRemote<::network::mojom::blink::DevToolsObserver> devtools_observer_in,
    ::mojo::PendingRemote<::network::mojom::blink::DeviceBoundSessionAccessObserver> device_bound_session_observer_in,
    ::network::mojom::blink::ClientSecurityStatePtr client_security_state_in,
    ::mojo::PendingRemote<::network::mojom::blink::AcceptCHFrameObserver> accept_ch_frame_observer_in,
    ::mojo::PendingRemote<::network::mojom::blink::SharedDictionaryAccessObserver> shared_dictionary_observer_in)
    : isolation_info(std::move(isolation_info_in)),
      disable_secure_dns(std::move(disable_secure_dns_in)),
      has_user_activation(std::move(has_user_activation_in)),
      allow_cookies_from_browser(std::move(allow_cookies_from_browser_in)),
      include_request_cookies_with_response(std::move(include_request_cookies_with_response_in)),
      enabled_client_hints(std::move(enabled_client_hints_in)),
      cookie_observer(std::move(cookie_observer_in)),
      trust_token_observer(std::move(trust_token_observer_in)),
      url_loader_network_observer(std::move(url_loader_network_observer_in)),
      devtools_observer(std::move(devtools_observer_in)),
      device_bound_session_observer(std::move(device_bound_session_observer_in)),
      client_security_state(std::move(client_security_state_in)),
      accept_ch_frame_observer(std::move(accept_ch_frame_observer_in)),
      shared_dictionary_observer(std::move(shared_dictionary_observer_in)) {}

TrustedUrlRequestParams::~TrustedUrlRequestParams() = default;

void TrustedUrlRequestParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "isolation_info"), this->isolation_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::IsolationInfo&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_secure_dns"), this->disable_secure_dns,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_user_activation"), this->has_user_activation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_cookies_from_browser"), this->allow_cookies_from_browser,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_request_cookies_with_response"), this->include_request_cookies_with_response,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enabled_client_hints"), this->enabled_client_hints,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type EnabledClientHintsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_observer"), this->cookie_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::blink::CookieAccessObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_token_observer"), this->trust_token_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::blink::TrustTokenAccessObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_loader_network_observer"), this->url_loader_network_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::blink::URLLoaderNetworkServiceObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_observer"), this->devtools_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::blink::DevToolsObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_bound_session_observer"), this->device_bound_session_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::blink::DeviceBoundSessionAccessObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_security_state"), this->client_security_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::ClientSecurityStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accept_ch_frame_observer"), this->accept_ch_frame_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::blink::AcceptCHFrameObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_dictionary_observer"), this->shared_dictionary_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::blink::SharedDictionaryAccessObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrustedUrlRequestParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebBundleTokenParams::WebBundleTokenParams()
    : bundle_url(),
      token(),
      web_bundle_handle(),
      render_process_id() {}

WebBundleTokenParams::WebBundleTokenParams(
    const ::blink::KURL& bundle_url_in,
    const ::base::UnguessableToken& token_in,
    ::mojo::PendingRemote<::network::mojom::blink::WebBundleHandle> web_bundle_handle_in,
    int32_t render_process_id_in)
    : bundle_url(std::move(bundle_url_in)),
      token(std::move(token_in)),
      web_bundle_handle(std::move(web_bundle_handle_in)),
      render_process_id(std::move(render_process_id_in)) {}

WebBundleTokenParams::~WebBundleTokenParams() = default;

void WebBundleTokenParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bundle_url"), this->bundle_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_bundle_handle"), this->web_bundle_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::blink::WebBundleHandle>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "render_process_id"), this->render_process_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebBundleTokenParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
URLRequest::URLRequest()
    : method(),
      url(),
      site_for_cookies(),
      update_first_party_url_on_redirect(),
      request_initiator(),
      navigation_redirect_chain(),
      isolated_world_origin(),
      referrer(),
      referrer_policy(),
      headers(),
      cors_exempt_headers(),
      load_flags(),
      resource_type(),
      priority(),
      priority_incremental(),
      cors_preflight_policy(),
      originated_from_service_worker(),
      skip_service_worker(),
      mode(),
      credentials_mode(),
      redirect_mode(),
      fetch_integrity(),
      expected_public_keys(),
      destination(),
      request_body(),
      keepalive(),
      browsing_topics(),
      ad_auction_headers(),
      shared_storage_writable_eligible(),
      has_user_gesture(),
      enable_load_timing(),
      enable_upload_progress(),
      do_not_prompt_for_login(),
      is_outermost_main_frame(),
      transition_type(),
      previews_state(),
      upgrade_if_insecure(),
      is_revalidating(),
      throttling_profile_id(),
      fetch_window_id(),
      devtools_request_id(),
      devtools_stack_id(),
      is_fetch_like_api(),
      is_fetch_later_api(),
      is_favicon(),
      original_destination(),
      trusted_params(),
      recursive_prefetch_token(),
      trust_token_params(),
      web_bundle_token_params(),
      devtools_accepted_stream_types(),
      net_log_create_info(),
      net_log_reference_info(),
      target_ip_address_space(),
      required_ip_address_space(),
      storage_access_api_status(),
      attribution_reporting_support(),
      attribution_reporting_eligibility(::network::mojom::blink::AttributionReportingEligibility::kUnset),
      attribution_reporting_src_token(),
      keepalive_token(),
      is_ad_tagged(false),
      shared_dictionary_writer_enabled(false),
      client_side_content_decoding_enabled(false),
      socket_tag(),
      allows_device_bound_session_registration(),
      permissions_policy(),
      fetch_retry_options() {}

URLRequest::URLRequest(
    const ::blink::String& method_in,
    const ::blink::KURL& url_in,
    const ::net::SiteForCookies& site_for_cookies_in,
    bool update_first_party_url_on_redirect_in,
    const ::scoped_refptr<const ::blink::SecurityOrigin>& request_initiator_in,
    ::blink::Vector<::blink::KURL> navigation_redirect_chain_in,
    const ::scoped_refptr<const ::blink::SecurityOrigin>& isolated_world_origin_in,
    const ::blink::KURL& referrer_in,
    ::net::ReferrerPolicy referrer_policy_in,
    const ::net::HttpRequestHeaders& headers_in,
    const ::net::HttpRequestHeaders& cors_exempt_headers_in,
    int32_t load_flags_in,
    int32_t resource_type_in,
    ::net::RequestPriority priority_in,
    bool priority_incremental_in,
    ::network::mojom::blink::CorsPreflightPolicy cors_preflight_policy_in,
    bool originated_from_service_worker_in,
    bool skip_service_worker_in,
    ::network::mojom::blink::RequestMode mode_in,
    ::network::mojom::blink::CredentialsMode credentials_mode_in,
    ::network::mojom::blink::RedirectMode redirect_mode_in,
    const ::blink::String& fetch_integrity_in,
    ::blink::Vector<::blink::Vector<uint8_t>> expected_public_keys_in,
    ::network::mojom::blink::RequestDestination destination_in,
    ::scoped_refptr<::network::ResourceRequestBody> request_body_in,
    bool keepalive_in,
    bool browsing_topics_in,
    bool ad_auction_headers_in,
    bool shared_storage_writable_eligible_in,
    bool has_user_gesture_in,
    bool enable_load_timing_in,
    bool enable_upload_progress_in,
    bool do_not_prompt_for_login_in,
    bool is_outermost_main_frame_in,
    int32_t transition_type_in,
    int32_t previews_state_in,
    bool upgrade_if_insecure_in,
    bool is_revalidating_in,
    const std::optional<::base::UnguessableToken>& throttling_profile_id_in,
    const std::optional<::base::UnguessableToken>& fetch_window_id_in,
    const ::blink::String& devtools_request_id_in,
    const ::blink::String& devtools_stack_id_in,
    bool is_fetch_like_api_in,
    bool is_fetch_later_api_in,
    bool is_favicon_in,
    ::network::mojom::blink::RequestDestination original_destination_in,
    const std::optional<::network::ResourceRequest::TrustedParams>& trusted_params_in,
    const std::optional<::base::UnguessableToken>& recursive_prefetch_token_in,
    ::network::mojom::blink::TrustTokenParamsPtr trust_token_params_in,
    const std::optional<::network::ResourceRequest::WebBundleTokenParams>& web_bundle_token_params_in,
    std::optional<::blink::Vector<::net::SourceStreamType>> devtools_accepted_stream_types_in,
    const std::optional<::net::NetLogSource>& net_log_create_info_in,
    const std::optional<::net::NetLogSource>& net_log_reference_info_in,
    ::network::mojom::blink::IPAddressSpace target_ip_address_space_in,
    ::network::mojom::blink::IPAddressSpace required_ip_address_space_in,
    ::net::StorageAccessApiStatus storage_access_api_status_in,
    ::network::mojom::blink::AttributionSupport attribution_reporting_support_in,
    ::network::mojom::blink::AttributionReportingEligibility attribution_reporting_eligibility_in,
    const std::optional<::base::UnguessableToken>& attribution_reporting_src_token_in,
    const std::optional<::base::UnguessableToken>& keepalive_token_in,
    bool is_ad_tagged_in,
    bool shared_dictionary_writer_enabled_in,
    bool client_side_content_decoding_enabled_in,
    SocketTagPtr socket_tag_in,
    bool allows_device_bound_session_registration_in,
    std::optional<::network::PermissionsPolicy> permissions_policy_in,
    ::network::mojom::blink::FetchRetryOptionsPtr fetch_retry_options_in)
    : method(std::move(method_in)),
      url(std::move(url_in)),
      site_for_cookies(std::move(site_for_cookies_in)),
      update_first_party_url_on_redirect(std::move(update_first_party_url_on_redirect_in)),
      request_initiator(std::move(request_initiator_in)),
      navigation_redirect_chain(std::move(navigation_redirect_chain_in)),
      isolated_world_origin(std::move(isolated_world_origin_in)),
      referrer(std::move(referrer_in)),
      referrer_policy(std::move(referrer_policy_in)),
      headers(std::move(headers_in)),
      cors_exempt_headers(std::move(cors_exempt_headers_in)),
      load_flags(std::move(load_flags_in)),
      resource_type(std::move(resource_type_in)),
      priority(std::move(priority_in)),
      priority_incremental(std::move(priority_incremental_in)),
      cors_preflight_policy(std::move(cors_preflight_policy_in)),
      originated_from_service_worker(std::move(originated_from_service_worker_in)),
      skip_service_worker(std::move(skip_service_worker_in)),
      mode(std::move(mode_in)),
      credentials_mode(std::move(credentials_mode_in)),
      redirect_mode(std::move(redirect_mode_in)),
      fetch_integrity(std::move(fetch_integrity_in)),
      expected_public_keys(std::move(expected_public_keys_in)),
      destination(std::move(destination_in)),
      request_body(std::move(request_body_in)),
      keepalive(std::move(keepalive_in)),
      browsing_topics(std::move(browsing_topics_in)),
      ad_auction_headers(std::move(ad_auction_headers_in)),
      shared_storage_writable_eligible(std::move(shared_storage_writable_eligible_in)),
      has_user_gesture(std::move(has_user_gesture_in)),
      enable_load_timing(std::move(enable_load_timing_in)),
      enable_upload_progress(std::move(enable_upload_progress_in)),
      do_not_prompt_for_login(std::move(do_not_prompt_for_login_in)),
      is_outermost_main_frame(std::move(is_outermost_main_frame_in)),
      transition_type(std::move(transition_type_in)),
      previews_state(std::move(previews_state_in)),
      upgrade_if_insecure(std::move(upgrade_if_insecure_in)),
      is_revalidating(std::move(is_revalidating_in)),
      throttling_profile_id(std::move(throttling_profile_id_in)),
      fetch_window_id(std::move(fetch_window_id_in)),
      devtools_request_id(std::move(devtools_request_id_in)),
      devtools_stack_id(std::move(devtools_stack_id_in)),
      is_fetch_like_api(std::move(is_fetch_like_api_in)),
      is_fetch_later_api(std::move(is_fetch_later_api_in)),
      is_favicon(std::move(is_favicon_in)),
      original_destination(std::move(original_destination_in)),
      trusted_params(std::move(trusted_params_in)),
      recursive_prefetch_token(std::move(recursive_prefetch_token_in)),
      trust_token_params(std::move(trust_token_params_in)),
      web_bundle_token_params(std::move(web_bundle_token_params_in)),
      devtools_accepted_stream_types(std::move(devtools_accepted_stream_types_in)),
      net_log_create_info(std::move(net_log_create_info_in)),
      net_log_reference_info(std::move(net_log_reference_info_in)),
      target_ip_address_space(std::move(target_ip_address_space_in)),
      required_ip_address_space(std::move(required_ip_address_space_in)),
      storage_access_api_status(std::move(storage_access_api_status_in)),
      attribution_reporting_support(std::move(attribution_reporting_support_in)),
      attribution_reporting_eligibility(std::move(attribution_reporting_eligibility_in)),
      attribution_reporting_src_token(std::move(attribution_reporting_src_token_in)),
      keepalive_token(std::move(keepalive_token_in)),
      is_ad_tagged(std::move(is_ad_tagged_in)),
      shared_dictionary_writer_enabled(std::move(shared_dictionary_writer_enabled_in)),
      client_side_content_decoding_enabled(std::move(client_side_content_decoding_enabled_in)),
      socket_tag(std::move(socket_tag_in)),
      allows_device_bound_session_registration(std::move(allows_device_bound_session_registration_in)),
      permissions_policy(std::move(permissions_policy_in)),
      fetch_retry_options(std::move(fetch_retry_options_in)) {}

URLRequest::~URLRequest() = default;

void URLRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method"), this->method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site_for_cookies"), this->site_for_cookies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::SiteForCookies&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_first_party_url_on_redirect"), this->update_first_party_url_on_redirect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_initiator"), this->request_initiator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_redirect_chain"), this->navigation_redirect_chain,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::KURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "isolated_world_origin"), this->isolated_world_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer_policy"), this->referrer_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::ReferrerPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::HttpRequestHeaders&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cors_exempt_headers"), this->cors_exempt_headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::HttpRequestHeaders&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "load_flags"), this->load_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resource_type"), this->resource_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority"), this->priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::RequestPriority>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority_incremental"), this->priority_incremental,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cors_preflight_policy"), this->cors_preflight_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::CorsPreflightPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "originated_from_service_worker"), this->originated_from_service_worker,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "skip_service_worker"), this->skip_service_worker,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::RequestMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "credentials_mode"), this->credentials_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::CredentialsMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "redirect_mode"), this->redirect_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::RedirectMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fetch_integrity"), this->fetch_integrity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expected_public_keys"), this->expected_public_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "destination"), this->destination,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::RequestDestination>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_body"), this->request_body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::scoped_refptr<::network::ResourceRequestBody>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keepalive"), this->keepalive,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browsing_topics"), this->browsing_topics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ad_auction_headers"), this->ad_auction_headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_storage_writable_eligible"), this->shared_storage_writable_eligible,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_user_gesture"), this->has_user_gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_load_timing"), this->enable_load_timing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_upload_progress"), this->enable_upload_progress,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "do_not_prompt_for_login"), this->do_not_prompt_for_login,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_outermost_main_frame"), this->is_outermost_main_frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transition_type"), this->transition_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "previews_state"), this->previews_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upgrade_if_insecure"), this->upgrade_if_insecure,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_revalidating"), this->is_revalidating,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "throttling_profile_id"), this->throttling_profile_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fetch_window_id"), this->fetch_window_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_request_id"), this->devtools_request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_stack_id"), this->devtools_stack_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_fetch_like_api"), this->is_fetch_like_api,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_fetch_later_api"), this->is_fetch_later_api,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_favicon"), this->is_favicon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "original_destination"), this->original_destination,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::RequestDestination>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trusted_params"), this->trusted_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::network::ResourceRequest::TrustedParams>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recursive_prefetch_token"), this->recursive_prefetch_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_token_params"), this->trust_token_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::TrustTokenParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_bundle_token_params"), this->web_bundle_token_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::network::ResourceRequest::WebBundleTokenParams>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_accepted_stream_types"), this->devtools_accepted_stream_types,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<::net::SourceStreamType>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "net_log_create_info"), this->net_log_create_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::net::NetLogSource>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "net_log_reference_info"), this->net_log_reference_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::net::NetLogSource>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_ip_address_space"), this->target_ip_address_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::IPAddressSpace>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "required_ip_address_space"), this->required_ip_address_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::IPAddressSpace>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "storage_access_api_status"), this->storage_access_api_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::StorageAccessApiStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribution_reporting_support"), this->attribution_reporting_support,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::AttributionSupport>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribution_reporting_eligibility"), this->attribution_reporting_eligibility,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::AttributionReportingEligibility>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribution_reporting_src_token"), this->attribution_reporting_src_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keepalive_token"), this->keepalive_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_ad_tagged"), this->is_ad_tagged,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_dictionary_writer_enabled"), this->shared_dictionary_writer_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_side_content_decoding_enabled"), this->client_side_content_decoding_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "socket_tag"), this->socket_tag,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SocketTagPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allows_device_bound_session_registration"), this->allows_device_bound_session_registration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permissions_policy"), this->permissions_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::network::PermissionsPolicy>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fetch_retry_options"), this->fetch_retry_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::FetchRetryOptionsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool URLRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
URLRequestBody::URLRequestBody()
    : elements(),
      identifier(),
      contains_sensitive_info(),
      allow_http1_for_streaming_upload() {}

URLRequestBody::URLRequestBody(
    ::blink::Vector<::network::DataElement> elements_in,
    uint64_t identifier_in,
    bool contains_sensitive_info_in,
    bool allow_http1_for_streaming_upload_in)
    : elements(std::move(elements_in)),
      identifier(std::move(identifier_in)),
      contains_sensitive_info(std::move(contains_sensitive_info_in)),
      allow_http1_for_streaming_upload(std::move(allow_http1_for_streaming_upload_in)) {}

URLRequestBody::~URLRequestBody() = default;

void URLRequestBody::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "elements"), this->elements,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::network::DataElement>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "identifier"), this->identifier,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contains_sensitive_info"), this->contains_sensitive_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_http1_for_streaming_upload"), this->allow_http1_for_streaming_upload,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool URLRequestBody::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataElementBytes::DataElementBytes()
    : data() {}

DataElementBytes::DataElementBytes(
    ::mojo_base::BigBuffer data_in)
    : data(std::move(data_in)) {}

DataElementBytes::~DataElementBytes() = default;

void DataElementBytes::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo_base::BigBuffer>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DataElementBytes::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataElementFile::DataElementFile()
    : path(),
      offset(),
      length(),
      expected_modification_time() {}

DataElementFile::DataElementFile(
    const ::base::FilePath& path_in,
    uint64_t offset_in,
    uint64_t length_in,
    ::base::Time expected_modification_time_in)
    : path(std::move(path_in)),
      offset(std::move(offset_in)),
      length(std::move(length_in)),
      expected_modification_time(std::move(expected_modification_time_in)) {}

DataElementFile::~DataElementFile() = default;

void DataElementFile::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "length"), this->length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expected_modification_time"), this->expected_modification_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DataElementFile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataElementDataPipe::DataElementDataPipe()
    : data_pipe_getter() {}

DataElementDataPipe::DataElementDataPipe(
    ::mojo::PendingRemote<::network::mojom::blink::DataPipeGetter> data_pipe_getter_in)
    : data_pipe_getter(std::move(data_pipe_getter_in)) {}

DataElementDataPipe::~DataElementDataPipe() = default;

void DataElementDataPipe::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_pipe_getter"), this->data_pipe_getter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::blink::DataPipeGetter>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DataElementDataPipe::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataElementChunkedDataPipe::DataElementChunkedDataPipe()
    : data_pipe_getter(),
      read_only_once() {}

DataElementChunkedDataPipe::DataElementChunkedDataPipe(
    ::mojo::PendingRemote<::network::mojom::blink::ChunkedDataPipeGetter> data_pipe_getter_in,
    bool read_only_once_in)
    : data_pipe_getter(std::move(data_pipe_getter_in)),
      read_only_once(std::move(read_only_once_in)) {}

DataElementChunkedDataPipe::~DataElementChunkedDataPipe() = default;

void DataElementChunkedDataPipe::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_pipe_getter"), this->data_pipe_getter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::blink::ChunkedDataPipeGetter>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "read_only_once"), this->read_only_once,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DataElementChunkedDataPipe::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SocketTag::SocketTag() {}

SocketTag::~SocketTag() = default;
size_t SocketTag::Hash(size_t seed) const {
  return seed;
}

void SocketTag::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool SocketTag::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataElementPtr
DataElement::NewBytes(
    ::network::DataElementBytes value) {
  return DataElementPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBytes)>,
      std::move(value));
}

DataElementPtr
DataElement::NewFile(
    ::network::DataElementFile value) {
  return DataElementPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFile)>,
      std::move(value));
}

DataElementPtr
DataElement::NewDataPipe(
    ::network::DataElementDataPipe value) {
  return DataElementPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDataPipe)>,
      std::move(value));
}

DataElementPtr
DataElement::NewChunkedDataPipe(
    ::network::DataElementChunkedDataPipe value) {
  return DataElementPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kChunkedDataPipe)>,
      std::move(value));
}

DataElement::DataElement(
    std::in_place_index_t<static_cast<size_t>(Tag::kBytes)>,
    ::network::DataElementBytes value)
    : tag_(Tag::kBytes),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBytes)>,
            std::move(value)) {}

DataElement::DataElement(
    std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
    ::network::DataElementFile value)
    : tag_(Tag::kFile),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFile)>,
            std::move(value)) {}

DataElement::DataElement(
    std::in_place_index_t<static_cast<size_t>(Tag::kDataPipe)>,
    ::network::DataElementDataPipe value)
    : tag_(Tag::kDataPipe),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDataPipe)>,
            std::move(value)) {}

DataElement::DataElement(
    std::in_place_index_t<static_cast<size_t>(Tag::kChunkedDataPipe)>,
    ::network::DataElementChunkedDataPipe value)
    : tag_(Tag::kChunkedDataPipe),
      data_(std::in_place_index<static_cast<size_t>(Tag::kChunkedDataPipe)>,
            std::move(value)) {}
DataElement::~DataElement() {
  DestroyActive();
}

void DataElement::set_bytes(::network::DataElementBytes bytes) {
  if (tag_ == Tag::kBytes) {
    data_.bytes = std::move(bytes);
  } else {
    DestroyActive();
    tag_ = Tag::kBytes;
    new (&data_.bytes) ::network::DataElementBytes(
        std::move(bytes));
  }
}

void DataElement::set_file(::network::DataElementFile file) {
  if (tag_ == Tag::kFile) {
    data_.file = std::move(file);
  } else {
    DestroyActive();
    tag_ = Tag::kFile;
    new (&data_.file) ::network::DataElementFile(
        std::move(file));
  }
}

void DataElement::set_data_pipe(::network::DataElementDataPipe data_pipe) {
  if (tag_ == Tag::kDataPipe) {
    data_.data_pipe = std::move(data_pipe);
  } else {
    DestroyActive();
    tag_ = Tag::kDataPipe;
    new (&data_.data_pipe) ::network::DataElementDataPipe(
        std::move(data_pipe));
  }
}

void DataElement::set_chunked_data_pipe(::network::DataElementChunkedDataPipe chunked_data_pipe) {
  if (tag_ == Tag::kChunkedDataPipe) {
    data_.chunked_data_pipe = std::move(chunked_data_pipe);
  } else {
    DestroyActive();
    tag_ = Tag::kChunkedDataPipe;
    new (&data_.chunked_data_pipe) ::network::DataElementChunkedDataPipe(
        std::move(chunked_data_pipe));
  }
}


DataElement::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBytes)>,
    ::network::DataElementBytes value)
    : bytes(std::move(value)) {}

DataElement::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
    ::network::DataElementFile value)
    : file(std::move(value)) {}

DataElement::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDataPipe)>,
    ::network::DataElementDataPipe value)
    : data_pipe(std::move(value)) {}

DataElement::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kChunkedDataPipe)>,
    ::network::DataElementChunkedDataPipe value)
    : chunked_data_pipe(std::move(value)) {}

void DataElement::DestroyActive() {
  switch (tag_) {

    case Tag::kBytes:
      std::destroy_at(&data_.bytes);
      break;
    case Tag::kFile:
      std::destroy_at(&data_.file);
      break;
    case Tag::kDataPipe:
      std::destroy_at(&data_.data_pipe);
      break;
    case Tag::kChunkedDataPipe:
      std::destroy_at(&data_.chunked_data_pipe);
      break;
  }
}

bool DataElement::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::EnabledClientHints::DataView, ::network::mojom::blink::EnabledClientHintsPtr>::Read(
    ::network::mojom::blink::EnabledClientHints::DataView input,
    ::network::mojom::blink::EnabledClientHintsPtr* output) {
  bool success = true;
  ::network::mojom::blink::EnabledClientHintsPtr result(::network::mojom::blink::EnabledClientHints::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success)
        result->is_outermost_main_frame = input.is_outermost_main_frame();
      if (success && !input.ReadHints(&result->hints))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::TrustedUrlRequestParams::DataView, ::network::mojom::blink::TrustedUrlRequestParamsPtr>::Read(
    ::network::mojom::blink::TrustedUrlRequestParams::DataView input,
    ::network::mojom::blink::TrustedUrlRequestParamsPtr* output) {
  bool success = true;
  ::network::mojom::blink::TrustedUrlRequestParamsPtr result(::network::mojom::blink::TrustedUrlRequestParams::New());
  
      if (success && !input.ReadIsolationInfo(&result->isolation_info))
        success = false;
      if (success)
        result->disable_secure_dns = input.disable_secure_dns();
      if (success)
        result->has_user_activation = input.has_user_activation();
      if (success)
        result->allow_cookies_from_browser = input.allow_cookies_from_browser();
      if (success)
        result->include_request_cookies_with_response = input.include_request_cookies_with_response();
      if (success && !input.ReadEnabledClientHints(&result->enabled_client_hints))
        success = false;
      if (success) {
        result->cookie_observer =
            input.TakeCookieObserver<decltype(result->cookie_observer)>();
      }
      if (success) {
        result->trust_token_observer =
            input.TakeTrustTokenObserver<decltype(result->trust_token_observer)>();
      }
      if (success) {
        result->url_loader_network_observer =
            input.TakeUrlLoaderNetworkObserver<decltype(result->url_loader_network_observer)>();
      }
      if (success) {
        result->devtools_observer =
            input.TakeDevtoolsObserver<decltype(result->devtools_observer)>();
      }
      if (success) {
        result->device_bound_session_observer =
            input.TakeDeviceBoundSessionObserver<decltype(result->device_bound_session_observer)>();
      }
      if (success && !input.ReadClientSecurityState(&result->client_security_state))
        success = false;
      if (success) {
        result->accept_ch_frame_observer =
            input.TakeAcceptChFrameObserver<decltype(result->accept_ch_frame_observer)>();
      }
      if (success) {
        result->shared_dictionary_observer =
            input.TakeSharedDictionaryObserver<decltype(result->shared_dictionary_observer)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::WebBundleTokenParams::DataView, ::network::mojom::blink::WebBundleTokenParamsPtr>::Read(
    ::network::mojom::blink::WebBundleTokenParams::DataView input,
    ::network::mojom::blink::WebBundleTokenParamsPtr* output) {
  bool success = true;
  ::network::mojom::blink::WebBundleTokenParamsPtr result(::network::mojom::blink::WebBundleTokenParams::New());
  
      if (success && !input.ReadBundleUrl(&result->bundle_url))
        success = false;
      if (success && !input.ReadToken(&result->token))
        success = false;
      if (success) {
        result->web_bundle_handle =
            input.TakeWebBundleHandle<decltype(result->web_bundle_handle)>();
      }
      if (success)
        result->render_process_id = input.render_process_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::URLRequest::DataView, ::network::mojom::blink::URLRequestPtr>::Read(
    ::network::mojom::blink::URLRequest::DataView input,
    ::network::mojom::blink::URLRequestPtr* output) {
  bool success = true;
  ::network::mojom::blink::URLRequestPtr result(::network::mojom::blink::URLRequest::New());
  
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadSiteForCookies(&result->site_for_cookies))
        success = false;
      if (success)
        result->update_first_party_url_on_redirect = input.update_first_party_url_on_redirect();
      if (success && !input.ReadRequestInitiator(&result->request_initiator))
        success = false;
      if (success && !input.ReadNavigationRedirectChain(&result->navigation_redirect_chain))
        success = false;
      if (success && !input.ReadIsolatedWorldOrigin(&result->isolated_world_origin))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadReferrerPolicy(&result->referrer_policy))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadCorsExemptHeaders(&result->cors_exempt_headers))
        success = false;
      if (success)
        result->load_flags = input.load_flags();
      if (success)
        result->resource_type = input.resource_type();
      if (success && !input.ReadPriority(&result->priority))
        success = false;
      if (success)
        result->priority_incremental = input.priority_incremental();
      if (success && !input.ReadCorsPreflightPolicy(&result->cors_preflight_policy))
        success = false;
      if (success)
        result->originated_from_service_worker = input.originated_from_service_worker();
      if (success)
        result->skip_service_worker = input.skip_service_worker();
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadCredentialsMode(&result->credentials_mode))
        success = false;
      if (success && !input.ReadRedirectMode(&result->redirect_mode))
        success = false;
      if (success && !input.ReadFetchIntegrity(&result->fetch_integrity))
        success = false;
      if (success && !input.ReadExpectedPublicKeys(&result->expected_public_keys))
        success = false;
      if (success && !input.ReadDestination(&result->destination))
        success = false;
      if (success && !input.ReadRequestBody(&result->request_body))
        success = false;
      if (success)
        result->keepalive = input.keepalive();
      if (success)
        result->browsing_topics = input.browsing_topics();
      if (success)
        result->ad_auction_headers = input.ad_auction_headers();
      if (success)
        result->shared_storage_writable_eligible = input.shared_storage_writable_eligible();
      if (success)
        result->has_user_gesture = input.has_user_gesture();
      if (success)
        result->enable_load_timing = input.enable_load_timing();
      if (success)
        result->enable_upload_progress = input.enable_upload_progress();
      if (success)
        result->do_not_prompt_for_login = input.do_not_prompt_for_login();
      if (success)
        result->is_outermost_main_frame = input.is_outermost_main_frame();
      if (success)
        result->transition_type = input.transition_type();
      if (success)
        result->previews_state = input.previews_state();
      if (success)
        result->upgrade_if_insecure = input.upgrade_if_insecure();
      if (success)
        result->is_revalidating = input.is_revalidating();
      if (success && !input.ReadThrottlingProfileId(&result->throttling_profile_id))
        success = false;
      if (success && !input.ReadFetchWindowId(&result->fetch_window_id))
        success = false;
      if (success && !input.ReadDevtoolsRequestId(&result->devtools_request_id))
        success = false;
      if (success && !input.ReadDevtoolsStackId(&result->devtools_stack_id))
        success = false;
      if (success)
        result->is_fetch_like_api = input.is_fetch_like_api();
      if (success)
        result->is_fetch_later_api = input.is_fetch_later_api();
      if (success)
        result->is_favicon = input.is_favicon();
      if (success && !input.ReadOriginalDestination(&result->original_destination))
        success = false;
      if (success && !input.ReadTrustedParams(&result->trusted_params))
        success = false;
      if (success && !input.ReadRecursivePrefetchToken(&result->recursive_prefetch_token))
        success = false;
      if (success && !input.ReadTrustTokenParams(&result->trust_token_params))
        success = false;
      if (success && !input.ReadWebBundleTokenParams(&result->web_bundle_token_params))
        success = false;
      if (success && !input.ReadDevtoolsAcceptedStreamTypes(&result->devtools_accepted_stream_types))
        success = false;
      if (success && !input.ReadNetLogCreateInfo(&result->net_log_create_info))
        success = false;
      if (success && !input.ReadNetLogReferenceInfo(&result->net_log_reference_info))
        success = false;
      if (success && !input.ReadTargetIpAddressSpace(&result->target_ip_address_space))
        success = false;
      if (success && !input.ReadRequiredIpAddressSpace(&result->required_ip_address_space))
        success = false;
      if (success && !input.ReadStorageAccessApiStatus(&result->storage_access_api_status))
        success = false;
      if (success && !input.ReadAttributionReportingSupport(&result->attribution_reporting_support))
        success = false;
      if (success && !input.ReadAttributionReportingEligibility(&result->attribution_reporting_eligibility))
        success = false;
      if (success && !input.ReadAttributionReportingSrcToken(&result->attribution_reporting_src_token))
        success = false;
      if (success && !input.ReadKeepaliveToken(&result->keepalive_token))
        success = false;
      if (success)
        result->is_ad_tagged = input.is_ad_tagged();
      if (success)
        result->shared_dictionary_writer_enabled = input.shared_dictionary_writer_enabled();
      if (success)
        result->client_side_content_decoding_enabled = input.client_side_content_decoding_enabled();
      if (success && !input.ReadSocketTag(&result->socket_tag))
        success = false;
      if (success)
        result->allows_device_bound_session_registration = input.allows_device_bound_session_registration();
      if (success && !input.ReadPermissionsPolicy(&result->permissions_policy))
        success = false;
      if (success && !input.ReadFetchRetryOptions(&result->fetch_retry_options))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::URLRequestBody::DataView, ::network::mojom::blink::URLRequestBodyPtr>::Read(
    ::network::mojom::blink::URLRequestBody::DataView input,
    ::network::mojom::blink::URLRequestBodyPtr* output) {
  bool success = true;
  ::network::mojom::blink::URLRequestBodyPtr result(::network::mojom::blink::URLRequestBody::New());
  
      if (success && !input.ReadElements(&result->elements))
        success = false;
      if (success)
        result->identifier = input.identifier();
      if (success)
        result->contains_sensitive_info = input.contains_sensitive_info();
      if (success)
        result->allow_http1_for_streaming_upload = input.allow_http1_for_streaming_upload();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::DataElementBytes::DataView, ::network::mojom::blink::DataElementBytesPtr>::Read(
    ::network::mojom::blink::DataElementBytes::DataView input,
    ::network::mojom::blink::DataElementBytesPtr* output) {
  bool success = true;
  ::network::mojom::blink::DataElementBytesPtr result(::network::mojom::blink::DataElementBytes::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::DataElementFile::DataView, ::network::mojom::blink::DataElementFilePtr>::Read(
    ::network::mojom::blink::DataElementFile::DataView input,
    ::network::mojom::blink::DataElementFilePtr* output) {
  bool success = true;
  ::network::mojom::blink::DataElementFilePtr result(::network::mojom::blink::DataElementFile::New());
  
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success)
        result->offset = input.offset();
      if (success)
        result->length = input.length();
      if (success && !input.ReadExpectedModificationTime(&result->expected_modification_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::DataElementDataPipe::DataView, ::network::mojom::blink::DataElementDataPipePtr>::Read(
    ::network::mojom::blink::DataElementDataPipe::DataView input,
    ::network::mojom::blink::DataElementDataPipePtr* output) {
  bool success = true;
  ::network::mojom::blink::DataElementDataPipePtr result(::network::mojom::blink::DataElementDataPipe::New());
  
      if (success) {
        result->data_pipe_getter =
            input.TakeDataPipeGetter<decltype(result->data_pipe_getter)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::DataElementChunkedDataPipe::DataView, ::network::mojom::blink::DataElementChunkedDataPipePtr>::Read(
    ::network::mojom::blink::DataElementChunkedDataPipe::DataView input,
    ::network::mojom::blink::DataElementChunkedDataPipePtr* output) {
  bool success = true;
  ::network::mojom::blink::DataElementChunkedDataPipePtr result(::network::mojom::blink::DataElementChunkedDataPipe::New());
  
      if (success) {
        result->data_pipe_getter =
            input.TakeDataPipeGetter<decltype(result->data_pipe_getter)>();
      }
      if (success)
        result->read_only_once = input.read_only_once();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::SocketTag::DataView, ::network::mojom::blink::SocketTagPtr>::Read(
    ::network::mojom::blink::SocketTag::DataView input,
    ::network::mojom::blink::SocketTagPtr* output) {
  bool success = true;
  ::network::mojom::blink::SocketTagPtr result(::network::mojom::blink::SocketTag::New());
  
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::network::mojom::blink::DataElement::DataView, ::network::mojom::blink::DataElementPtr>::Read(
    ::network::mojom::blink::DataElement::DataView input,
    ::network::mojom::blink::DataElementPtr* output) {
  using UnionType = ::network::mojom::blink::DataElement;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kBytes: {
      ::network::DataElementBytes result_bytes{};
      if (!input.ReadBytes(&result_bytes))
        return false;

      *output = UnionType::NewBytes(
          std::move(result_bytes));
      break;
    }
    case Tag::kFile: {
      ::network::DataElementFile result_file{};
      if (!input.ReadFile(&result_file))
        return false;

      *output = UnionType::NewFile(
          std::move(result_file));
      break;
    }
    case Tag::kDataPipe: {
      ::network::DataElementDataPipe result_data_pipe{};
      if (!input.ReadDataPipe(&result_data_pipe))
        return false;

      *output = UnionType::NewDataPipe(
          std::move(result_data_pipe));
      break;
    }
    case Tag::kChunkedDataPipe: {
      ::network::DataElementChunkedDataPipe result_chunked_data_pipe{};
      if (!input.ReadChunkedDataPipe(&result_chunked_data_pipe))
        return false;

      *output = UnionType::NewChunkedDataPipe(
          std::move(result_chunked_data_pipe));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {




}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif