// services/network/public/mojom/url_response_head.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/url_response_head.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/url_response_head.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/url_response_head.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/network/public/mojom/alternate_protocol_usage.mojom.h"
#include "services/network/public/mojom/attribution.mojom-forward.h"
#include "services/network/public/mojom/cors.mojom-forward.h"
#include "services/network/public/mojom/device_bound_sessions.mojom-forward.h"
#include "services/network/public/mojom/encoded_body_length.mojom.h"
#include "services/network/public/mojom/fetch_api.mojom-forward.h"
#include "services/network/public/mojom/http_request_headers.mojom-forward.h"
#include "services/network/public/mojom/ip_address_space.mojom-forward.h"
#include "services/network/public/mojom/ip_endpoint.mojom.h"
#include "services/network/public/mojom/load_timing_info.mojom.h"
#include "services/network/public/mojom/load_timing_internal_info.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/network_types.mojom.h"
#include "services/network/public/mojom/parsed_headers.mojom.h"
#include "services/network/public/mojom/parsed_request_cookie.mojom.h"
#include "services/network/public/mojom/service_worker_router_info.mojom.h"
#include "services/network/public/mojom/source_type.mojom.h"
#include "services/network/public/mojom/unencoded_digest.mojom.h"
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>




#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"




namespace network::mojom {








class  URLResponseHead {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLResponseHead, T>::value>;
  using DataView = URLResponseHeadDataView;
  using Data_ = internal::URLResponseHead_Data;

  template <typename... Args>
  static URLResponseHeadPtr New(Args&&... args) {
    return URLResponseHeadPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLResponseHeadPtr From(const U& u) {
    return mojo::TypeConverter<URLResponseHeadPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLResponseHead>::Convert(*this);
  }


  URLResponseHead();

  URLResponseHead(
      ::base::Time request_time,
      ::base::Time response_time,
      ::base::Time original_response_time,
      const ::scoped_refptr<::net::HttpResponseHeaders>& headers,
      const std::string& mime_type,
      const std::string& charset,
      int64_t content_length,
      int64_t encoded_data_length,
      ::network::mojom::EncodedBodyLengthPtr encoded_body_length,
      bool network_accessed,
      const ::net::LoadTimingInfo& load_timing,
      const std::optional<::net::LoadTimingInternalInfo>& load_timing_internal_info,
      bool emitted_extra_info,
      bool was_fetched_via_spdy,
      bool was_alpn_negotiated,
      bool was_alternate_protocol_available,
      ::net::HttpConnectionInfo connection_info,
      const std::string& alpn_negotiated_protocol,
      ::net::AlternateProtocolUsage alternate_protocol_usage,
      const ::net::IPEndPoint& remote_endpoint,
      ::network::mojom::IPAddressSpace client_address_space,
      ::network::mojom::IPAddressSpace response_address_space,
      bool is_validated,
      bool was_fetched_via_cache,
      NavigationDeliveryType navigation_delivery_type,
      const ::net::ProxyChain& proxy_chain,
      bool was_fetched_via_service_worker,
      ::network::mojom::FetchResponseSource service_worker_response_source,
      std::vector<::GURL> url_list_via_service_worker,
      std::optional<::network::mojom::ServiceWorkerStatus> initial_service_worker_status,
      ::network::mojom::ServiceWorkerRouterInfoPtr service_worker_router_info,
      ::network::mojom::FetchResponseType response_type,
      int64_t padding,
      const std::string& cache_storage_cache_name,
      uint32_t cert_status,
      const std::optional<::net::SSLInfo>& ssl_info,
      std::vector<::net::cookie_util::ParsedRequestCookie> request_cookies,
      std::vector<std::string> cors_exposed_header_names,
      bool did_service_worker_navigation_preload,
      bool async_revalidation_requested,
      bool did_mime_sniff,
      bool is_signed_exchange_inner_response,
      bool is_web_bundle_inner_response,
      bool was_in_prefetch_cache,
      bool is_prefetch_with_cross_site_contamination,
      bool was_cookie_in_request,
      bool intercepted_by_plugin,
      bool has_range_requested,
      bool timing_allow_passed,
      const std::optional<::net::AuthChallengeInfo>& auth_challenge_info,
      ::base::TimeTicks request_start,
      ::base::TimeTicks response_start,
      ::network::mojom::ParsedHeadersPtr parsed_headers,
      const std::optional<::base::UnguessableToken>& recursive_prefetch_token,
      std::vector<std::string> dns_aliases,
      bool has_authorization_covered_by_wildcard_on_preflight,
      bool request_include_credentials,
      bool should_use_source_hash_for_js_code_cache,
      ::network::mojom::PrivateNetworkAccessPreflightResult private_network_access_preflight_result,
      bool did_use_shared_dictionary,
      bool load_with_storage_access,
      std::vector<::net::SourceStreamType> client_side_content_decoding_types,
      ::network::mojom::DeviceBoundSessionUsage device_bound_session_usage,
      bool from_synthetic_response,
      bool bypass_redirect_checks,
      ::network::mojom::UnencodedDigestsPtr unencoded_digests);

URLResponseHead(const URLResponseHead&) = delete;
URLResponseHead& operator=(const URLResponseHead&) = delete;

  ~URLResponseHead();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLResponseHeadPtr>
  URLResponseHeadPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLResponseHead::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, URLResponseHead::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, URLResponseHead::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLResponseHead::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLResponseHead::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLResponseHead::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLResponseHead_UnserializedMessageContext<
            UserType, URLResponseHead::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<URLResponseHead::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return URLResponseHead::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLResponseHead_UnserializedMessageContext<
            UserType, URLResponseHead::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLResponseHead::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Time request_time;
  
  ::base::Time response_time;
  
  ::base::Time original_response_time;
  
  ::scoped_refptr<::net::HttpResponseHeaders> headers;
  
  std::string mime_type;
  
  std::string charset;
  
  int64_t content_length;
  
  int64_t encoded_data_length;
  
  ::network::mojom::EncodedBodyLengthPtr encoded_body_length;
  
  bool network_accessed;
  
  ::net::LoadTimingInfo load_timing;
  
  std::optional<::net::LoadTimingInternalInfo> load_timing_internal_info;
  
  bool emitted_extra_info;
  
  bool was_fetched_via_spdy;
  
  bool was_alpn_negotiated;
  
  bool was_alternate_protocol_available;
  
  ::net::HttpConnectionInfo connection_info;
  
  std::string alpn_negotiated_protocol;
  
  ::net::AlternateProtocolUsage alternate_protocol_usage;
  
  ::net::IPEndPoint remote_endpoint;
  
  ::network::mojom::IPAddressSpace client_address_space;
  
  ::network::mojom::IPAddressSpace response_address_space;
  
  bool is_validated;
  
  bool was_fetched_via_cache;
  
  NavigationDeliveryType navigation_delivery_type;
  
  ::net::ProxyChain proxy_chain;
  
  bool was_fetched_via_service_worker;
  
  ::network::mojom::FetchResponseSource service_worker_response_source;
  
  std::vector<::GURL> url_list_via_service_worker;
  
  std::optional<::network::mojom::ServiceWorkerStatus> initial_service_worker_status;
  
  ::network::mojom::ServiceWorkerRouterInfoPtr service_worker_router_info;
  
  ::network::mojom::FetchResponseType response_type;
  
  int64_t padding;
  
  std::string cache_storage_cache_name;
  
  uint32_t cert_status;
  
  std::optional<::net::SSLInfo> ssl_info;
  
  std::vector<::net::cookie_util::ParsedRequestCookie> request_cookies;
  
  std::vector<std::string> cors_exposed_header_names;
  
  bool did_service_worker_navigation_preload;
  
  bool async_revalidation_requested;
  
  bool did_mime_sniff;
  
  bool is_signed_exchange_inner_response;
  
  bool is_web_bundle_inner_response;
  
  bool was_in_prefetch_cache;
  
  bool is_prefetch_with_cross_site_contamination;
  
  bool was_cookie_in_request;
  
  bool intercepted_by_plugin;
  
  bool has_range_requested;
  
  bool timing_allow_passed;
  
  std::optional<::net::AuthChallengeInfo> auth_challenge_info;
  
  ::base::TimeTicks request_start;
  
  ::base::TimeTicks response_start;
  
  ::network::mojom::ParsedHeadersPtr parsed_headers;
  
  std::optional<::base::UnguessableToken> recursive_prefetch_token;
  
  std::vector<std::string> dns_aliases;
  
  bool has_authorization_covered_by_wildcard_on_preflight;
  
  bool request_include_credentials;
  
  bool should_use_source_hash_for_js_code_cache;
  
  ::network::mojom::PrivateNetworkAccessPreflightResult private_network_access_preflight_result;
  
  bool did_use_shared_dictionary;
  
  bool load_with_storage_access;
  
  std::vector<::net::SourceStreamType> client_side_content_decoding_types;
  
  ::network::mojom::DeviceBoundSessionUsage device_bound_session_usage;
  
  bool from_synthetic_response;
  
  bool bypass_redirect_checks;
  
  ::network::mojom::UnencodedDigestsPtr unencoded_digests;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLResponseHead::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLResponseHead::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLResponseHead::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLResponseHead::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
URLResponseHeadPtr URLResponseHead::Clone() const {
  return New(
      mojo::Clone(request_time),
      mojo::Clone(response_time),
      mojo::Clone(original_response_time),
      mojo::Clone(headers),
      mojo::Clone(mime_type),
      mojo::Clone(charset),
      mojo::Clone(content_length),
      mojo::Clone(encoded_data_length),
      mojo::Clone(encoded_body_length),
      mojo::Clone(network_accessed),
      mojo::Clone(load_timing),
      mojo::Clone(load_timing_internal_info),
      mojo::Clone(emitted_extra_info),
      mojo::Clone(was_fetched_via_spdy),
      mojo::Clone(was_alpn_negotiated),
      mojo::Clone(was_alternate_protocol_available),
      mojo::Clone(connection_info),
      mojo::Clone(alpn_negotiated_protocol),
      mojo::Clone(alternate_protocol_usage),
      mojo::Clone(remote_endpoint),
      mojo::Clone(client_address_space),
      mojo::Clone(response_address_space),
      mojo::Clone(is_validated),
      mojo::Clone(was_fetched_via_cache),
      mojo::Clone(navigation_delivery_type),
      mojo::Clone(proxy_chain),
      mojo::Clone(was_fetched_via_service_worker),
      mojo::Clone(service_worker_response_source),
      mojo::Clone(url_list_via_service_worker),
      mojo::Clone(initial_service_worker_status),
      mojo::Clone(service_worker_router_info),
      mojo::Clone(response_type),
      mojo::Clone(padding),
      mojo::Clone(cache_storage_cache_name),
      mojo::Clone(cert_status),
      mojo::Clone(ssl_info),
      mojo::Clone(request_cookies),
      mojo::Clone(cors_exposed_header_names),
      mojo::Clone(did_service_worker_navigation_preload),
      mojo::Clone(async_revalidation_requested),
      mojo::Clone(did_mime_sniff),
      mojo::Clone(is_signed_exchange_inner_response),
      mojo::Clone(is_web_bundle_inner_response),
      mojo::Clone(was_in_prefetch_cache),
      mojo::Clone(is_prefetch_with_cross_site_contamination),
      mojo::Clone(was_cookie_in_request),
      mojo::Clone(intercepted_by_plugin),
      mojo::Clone(has_range_requested),
      mojo::Clone(timing_allow_passed),
      mojo::Clone(auth_challenge_info),
      mojo::Clone(request_start),
      mojo::Clone(response_start),
      mojo::Clone(parsed_headers),
      mojo::Clone(recursive_prefetch_token),
      mojo::Clone(dns_aliases),
      mojo::Clone(has_authorization_covered_by_wildcard_on_preflight),
      mojo::Clone(request_include_credentials),
      mojo::Clone(should_use_source_hash_for_js_code_cache),
      mojo::Clone(private_network_access_preflight_result),
      mojo::Clone(did_use_shared_dictionary),
      mojo::Clone(load_with_storage_access),
      mojo::Clone(client_side_content_decoding_types),
      mojo::Clone(device_bound_session_usage),
      mojo::Clone(from_synthetic_response),
      mojo::Clone(bypass_redirect_checks),
      mojo::Clone(unencoded_digests)
  );
}

template <typename T, URLResponseHead::EnableIfSame<T>*>
bool URLResponseHead::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_time, other_struct.request_time))
    return false;
  if (!mojo::Equals(this->response_time, other_struct.response_time))
    return false;
  if (!mojo::Equals(this->original_response_time, other_struct.original_response_time))
    return false;
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  if (!mojo::Equals(this->mime_type, other_struct.mime_type))
    return false;
  if (!mojo::Equals(this->charset, other_struct.charset))
    return false;
  if (!mojo::Equals(this->content_length, other_struct.content_length))
    return false;
  if (!mojo::Equals(this->encoded_data_length, other_struct.encoded_data_length))
    return false;
  if (!mojo::Equals(this->encoded_body_length, other_struct.encoded_body_length))
    return false;
  if (!mojo::Equals(this->network_accessed, other_struct.network_accessed))
    return false;
  if (!mojo::Equals(this->load_timing, other_struct.load_timing))
    return false;
  if (!mojo::Equals(this->load_timing_internal_info, other_struct.load_timing_internal_info))
    return false;
  if (!mojo::Equals(this->emitted_extra_info, other_struct.emitted_extra_info))
    return false;
  if (!mojo::Equals(this->was_fetched_via_spdy, other_struct.was_fetched_via_spdy))
    return false;
  if (!mojo::Equals(this->was_alpn_negotiated, other_struct.was_alpn_negotiated))
    return false;
  if (!mojo::Equals(this->was_alternate_protocol_available, other_struct.was_alternate_protocol_available))
    return false;
  if (!mojo::Equals(this->connection_info, other_struct.connection_info))
    return false;
  if (!mojo::Equals(this->alpn_negotiated_protocol, other_struct.alpn_negotiated_protocol))
    return false;
  if (!mojo::Equals(this->alternate_protocol_usage, other_struct.alternate_protocol_usage))
    return false;
  if (!mojo::Equals(this->remote_endpoint, other_struct.remote_endpoint))
    return false;
  if (!mojo::Equals(this->client_address_space, other_struct.client_address_space))
    return false;
  if (!mojo::Equals(this->response_address_space, other_struct.response_address_space))
    return false;
  if (!mojo::Equals(this->is_validated, other_struct.is_validated))
    return false;
  if (!mojo::Equals(this->was_fetched_via_cache, other_struct.was_fetched_via_cache))
    return false;
  if (!mojo::Equals(this->navigation_delivery_type, other_struct.navigation_delivery_type))
    return false;
  if (!mojo::Equals(this->proxy_chain, other_struct.proxy_chain))
    return false;
  if (!mojo::Equals(this->was_fetched_via_service_worker, other_struct.was_fetched_via_service_worker))
    return false;
  if (!mojo::Equals(this->service_worker_response_source, other_struct.service_worker_response_source))
    return false;
  if (!mojo::Equals(this->url_list_via_service_worker, other_struct.url_list_via_service_worker))
    return false;
  if (!mojo::Equals(this->initial_service_worker_status, other_struct.initial_service_worker_status))
    return false;
  if (!mojo::Equals(this->service_worker_router_info, other_struct.service_worker_router_info))
    return false;
  if (!mojo::Equals(this->response_type, other_struct.response_type))
    return false;
  if (!mojo::Equals(this->padding, other_struct.padding))
    return false;
  if (!mojo::Equals(this->cache_storage_cache_name, other_struct.cache_storage_cache_name))
    return false;
  if (!mojo::Equals(this->cert_status, other_struct.cert_status))
    return false;
  if (!mojo::Equals(this->ssl_info, other_struct.ssl_info))
    return false;
  if (!mojo::Equals(this->request_cookies, other_struct.request_cookies))
    return false;
  if (!mojo::Equals(this->cors_exposed_header_names, other_struct.cors_exposed_header_names))
    return false;
  if (!mojo::Equals(this->did_service_worker_navigation_preload, other_struct.did_service_worker_navigation_preload))
    return false;
  if (!mojo::Equals(this->async_revalidation_requested, other_struct.async_revalidation_requested))
    return false;
  if (!mojo::Equals(this->did_mime_sniff, other_struct.did_mime_sniff))
    return false;
  if (!mojo::Equals(this->is_signed_exchange_inner_response, other_struct.is_signed_exchange_inner_response))
    return false;
  if (!mojo::Equals(this->is_web_bundle_inner_response, other_struct.is_web_bundle_inner_response))
    return false;
  if (!mojo::Equals(this->was_in_prefetch_cache, other_struct.was_in_prefetch_cache))
    return false;
  if (!mojo::Equals(this->is_prefetch_with_cross_site_contamination, other_struct.is_prefetch_with_cross_site_contamination))
    return false;
  if (!mojo::Equals(this->was_cookie_in_request, other_struct.was_cookie_in_request))
    return false;
  if (!mojo::Equals(this->intercepted_by_plugin, other_struct.intercepted_by_plugin))
    return false;
  if (!mojo::Equals(this->has_range_requested, other_struct.has_range_requested))
    return false;
  if (!mojo::Equals(this->timing_allow_passed, other_struct.timing_allow_passed))
    return false;
  if (!mojo::Equals(this->auth_challenge_info, other_struct.auth_challenge_info))
    return false;
  if (!mojo::Equals(this->request_start, other_struct.request_start))
    return false;
  if (!mojo::Equals(this->response_start, other_struct.response_start))
    return false;
  if (!mojo::Equals(this->parsed_headers, other_struct.parsed_headers))
    return false;
  if (!mojo::Equals(this->recursive_prefetch_token, other_struct.recursive_prefetch_token))
    return false;
  if (!mojo::Equals(this->dns_aliases, other_struct.dns_aliases))
    return false;
  if (!mojo::Equals(this->has_authorization_covered_by_wildcard_on_preflight, other_struct.has_authorization_covered_by_wildcard_on_preflight))
    return false;
  if (!mojo::Equals(this->request_include_credentials, other_struct.request_include_credentials))
    return false;
  if (!mojo::Equals(this->should_use_source_hash_for_js_code_cache, other_struct.should_use_source_hash_for_js_code_cache))
    return false;
  if (!mojo::Equals(this->private_network_access_preflight_result, other_struct.private_network_access_preflight_result))
    return false;
  if (!mojo::Equals(this->did_use_shared_dictionary, other_struct.did_use_shared_dictionary))
    return false;
  if (!mojo::Equals(this->load_with_storage_access, other_struct.load_with_storage_access))
    return false;
  if (!mojo::Equals(this->client_side_content_decoding_types, other_struct.client_side_content_decoding_types))
    return false;
  if (!mojo::Equals(this->device_bound_session_usage, other_struct.device_bound_session_usage))
    return false;
  if (!mojo::Equals(this->from_synthetic_response, other_struct.from_synthetic_response))
    return false;
  if (!mojo::Equals(this->bypass_redirect_checks, other_struct.bypass_redirect_checks))
    return false;
  if (!mojo::Equals(this->unencoded_digests, other_struct.unencoded_digests))
    return false;
  return true;
}

template <typename T, URLResponseHead::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request_time < rhs.request_time)
    return true;
  if (rhs.request_time < lhs.request_time)
    return false;
  if (lhs.response_time < rhs.response_time)
    return true;
  if (rhs.response_time < lhs.response_time)
    return false;
  if (lhs.original_response_time < rhs.original_response_time)
    return true;
  if (rhs.original_response_time < lhs.original_response_time)
    return false;
  if (lhs.headers < rhs.headers)
    return true;
  if (rhs.headers < lhs.headers)
    return false;
  if (lhs.mime_type < rhs.mime_type)
    return true;
  if (rhs.mime_type < lhs.mime_type)
    return false;
  if (lhs.charset < rhs.charset)
    return true;
  if (rhs.charset < lhs.charset)
    return false;
  if (lhs.content_length < rhs.content_length)
    return true;
  if (rhs.content_length < lhs.content_length)
    return false;
  if (lhs.encoded_data_length < rhs.encoded_data_length)
    return true;
  if (rhs.encoded_data_length < lhs.encoded_data_length)
    return false;
  if (lhs.encoded_body_length < rhs.encoded_body_length)
    return true;
  if (rhs.encoded_body_length < lhs.encoded_body_length)
    return false;
  if (lhs.network_accessed < rhs.network_accessed)
    return true;
  if (rhs.network_accessed < lhs.network_accessed)
    return false;
  if (lhs.load_timing < rhs.load_timing)
    return true;
  if (rhs.load_timing < lhs.load_timing)
    return false;
  if (lhs.load_timing_internal_info < rhs.load_timing_internal_info)
    return true;
  if (rhs.load_timing_internal_info < lhs.load_timing_internal_info)
    return false;
  if (lhs.emitted_extra_info < rhs.emitted_extra_info)
    return true;
  if (rhs.emitted_extra_info < lhs.emitted_extra_info)
    return false;
  if (lhs.was_fetched_via_spdy < rhs.was_fetched_via_spdy)
    return true;
  if (rhs.was_fetched_via_spdy < lhs.was_fetched_via_spdy)
    return false;
  if (lhs.was_alpn_negotiated < rhs.was_alpn_negotiated)
    return true;
  if (rhs.was_alpn_negotiated < lhs.was_alpn_negotiated)
    return false;
  if (lhs.was_alternate_protocol_available < rhs.was_alternate_protocol_available)
    return true;
  if (rhs.was_alternate_protocol_available < lhs.was_alternate_protocol_available)
    return false;
  if (lhs.connection_info < rhs.connection_info)
    return true;
  if (rhs.connection_info < lhs.connection_info)
    return false;
  if (lhs.alpn_negotiated_protocol < rhs.alpn_negotiated_protocol)
    return true;
  if (rhs.alpn_negotiated_protocol < lhs.alpn_negotiated_protocol)
    return false;
  if (lhs.alternate_protocol_usage < rhs.alternate_protocol_usage)
    return true;
  if (rhs.alternate_protocol_usage < lhs.alternate_protocol_usage)
    return false;
  if (lhs.remote_endpoint < rhs.remote_endpoint)
    return true;
  if (rhs.remote_endpoint < lhs.remote_endpoint)
    return false;
  if (lhs.client_address_space < rhs.client_address_space)
    return true;
  if (rhs.client_address_space < lhs.client_address_space)
    return false;
  if (lhs.response_address_space < rhs.response_address_space)
    return true;
  if (rhs.response_address_space < lhs.response_address_space)
    return false;
  if (lhs.is_validated < rhs.is_validated)
    return true;
  if (rhs.is_validated < lhs.is_validated)
    return false;
  if (lhs.was_fetched_via_cache < rhs.was_fetched_via_cache)
    return true;
  if (rhs.was_fetched_via_cache < lhs.was_fetched_via_cache)
    return false;
  if (lhs.navigation_delivery_type < rhs.navigation_delivery_type)
    return true;
  if (rhs.navigation_delivery_type < lhs.navigation_delivery_type)
    return false;
  if (lhs.proxy_chain < rhs.proxy_chain)
    return true;
  if (rhs.proxy_chain < lhs.proxy_chain)
    return false;
  if (lhs.was_fetched_via_service_worker < rhs.was_fetched_via_service_worker)
    return true;
  if (rhs.was_fetched_via_service_worker < lhs.was_fetched_via_service_worker)
    return false;
  if (lhs.service_worker_response_source < rhs.service_worker_response_source)
    return true;
  if (rhs.service_worker_response_source < lhs.service_worker_response_source)
    return false;
  if (lhs.url_list_via_service_worker < rhs.url_list_via_service_worker)
    return true;
  if (rhs.url_list_via_service_worker < lhs.url_list_via_service_worker)
    return false;
  if (lhs.initial_service_worker_status < rhs.initial_service_worker_status)
    return true;
  if (rhs.initial_service_worker_status < lhs.initial_service_worker_status)
    return false;
  if (lhs.service_worker_router_info < rhs.service_worker_router_info)
    return true;
  if (rhs.service_worker_router_info < lhs.service_worker_router_info)
    return false;
  if (lhs.response_type < rhs.response_type)
    return true;
  if (rhs.response_type < lhs.response_type)
    return false;
  if (lhs.padding < rhs.padding)
    return true;
  if (rhs.padding < lhs.padding)
    return false;
  if (lhs.cache_storage_cache_name < rhs.cache_storage_cache_name)
    return true;
  if (rhs.cache_storage_cache_name < lhs.cache_storage_cache_name)
    return false;
  if (lhs.cert_status < rhs.cert_status)
    return true;
  if (rhs.cert_status < lhs.cert_status)
    return false;
  if (lhs.ssl_info < rhs.ssl_info)
    return true;
  if (rhs.ssl_info < lhs.ssl_info)
    return false;
  if (lhs.request_cookies < rhs.request_cookies)
    return true;
  if (rhs.request_cookies < lhs.request_cookies)
    return false;
  if (lhs.cors_exposed_header_names < rhs.cors_exposed_header_names)
    return true;
  if (rhs.cors_exposed_header_names < lhs.cors_exposed_header_names)
    return false;
  if (lhs.did_service_worker_navigation_preload < rhs.did_service_worker_navigation_preload)
    return true;
  if (rhs.did_service_worker_navigation_preload < lhs.did_service_worker_navigation_preload)
    return false;
  if (lhs.async_revalidation_requested < rhs.async_revalidation_requested)
    return true;
  if (rhs.async_revalidation_requested < lhs.async_revalidation_requested)
    return false;
  if (lhs.did_mime_sniff < rhs.did_mime_sniff)
    return true;
  if (rhs.did_mime_sniff < lhs.did_mime_sniff)
    return false;
  if (lhs.is_signed_exchange_inner_response < rhs.is_signed_exchange_inner_response)
    return true;
  if (rhs.is_signed_exchange_inner_response < lhs.is_signed_exchange_inner_response)
    return false;
  if (lhs.is_web_bundle_inner_response < rhs.is_web_bundle_inner_response)
    return true;
  if (rhs.is_web_bundle_inner_response < lhs.is_web_bundle_inner_response)
    return false;
  if (lhs.was_in_prefetch_cache < rhs.was_in_prefetch_cache)
    return true;
  if (rhs.was_in_prefetch_cache < lhs.was_in_prefetch_cache)
    return false;
  if (lhs.is_prefetch_with_cross_site_contamination < rhs.is_prefetch_with_cross_site_contamination)
    return true;
  if (rhs.is_prefetch_with_cross_site_contamination < lhs.is_prefetch_with_cross_site_contamination)
    return false;
  if (lhs.was_cookie_in_request < rhs.was_cookie_in_request)
    return true;
  if (rhs.was_cookie_in_request < lhs.was_cookie_in_request)
    return false;
  if (lhs.intercepted_by_plugin < rhs.intercepted_by_plugin)
    return true;
  if (rhs.intercepted_by_plugin < lhs.intercepted_by_plugin)
    return false;
  if (lhs.has_range_requested < rhs.has_range_requested)
    return true;
  if (rhs.has_range_requested < lhs.has_range_requested)
    return false;
  if (lhs.timing_allow_passed < rhs.timing_allow_passed)
    return true;
  if (rhs.timing_allow_passed < lhs.timing_allow_passed)
    return false;
  if (lhs.auth_challenge_info < rhs.auth_challenge_info)
    return true;
  if (rhs.auth_challenge_info < lhs.auth_challenge_info)
    return false;
  if (lhs.request_start < rhs.request_start)
    return true;
  if (rhs.request_start < lhs.request_start)
    return false;
  if (lhs.response_start < rhs.response_start)
    return true;
  if (rhs.response_start < lhs.response_start)
    return false;
  if (lhs.parsed_headers < rhs.parsed_headers)
    return true;
  if (rhs.parsed_headers < lhs.parsed_headers)
    return false;
  if (lhs.recursive_prefetch_token < rhs.recursive_prefetch_token)
    return true;
  if (rhs.recursive_prefetch_token < lhs.recursive_prefetch_token)
    return false;
  if (lhs.dns_aliases < rhs.dns_aliases)
    return true;
  if (rhs.dns_aliases < lhs.dns_aliases)
    return false;
  if (lhs.has_authorization_covered_by_wildcard_on_preflight < rhs.has_authorization_covered_by_wildcard_on_preflight)
    return true;
  if (rhs.has_authorization_covered_by_wildcard_on_preflight < lhs.has_authorization_covered_by_wildcard_on_preflight)
    return false;
  if (lhs.request_include_credentials < rhs.request_include_credentials)
    return true;
  if (rhs.request_include_credentials < lhs.request_include_credentials)
    return false;
  if (lhs.should_use_source_hash_for_js_code_cache < rhs.should_use_source_hash_for_js_code_cache)
    return true;
  if (rhs.should_use_source_hash_for_js_code_cache < lhs.should_use_source_hash_for_js_code_cache)
    return false;
  if (lhs.private_network_access_preflight_result < rhs.private_network_access_preflight_result)
    return true;
  if (rhs.private_network_access_preflight_result < lhs.private_network_access_preflight_result)
    return false;
  if (lhs.did_use_shared_dictionary < rhs.did_use_shared_dictionary)
    return true;
  if (rhs.did_use_shared_dictionary < lhs.did_use_shared_dictionary)
    return false;
  if (lhs.load_with_storage_access < rhs.load_with_storage_access)
    return true;
  if (rhs.load_with_storage_access < lhs.load_with_storage_access)
    return false;
  if (lhs.client_side_content_decoding_types < rhs.client_side_content_decoding_types)
    return true;
  if (rhs.client_side_content_decoding_types < lhs.client_side_content_decoding_types)
    return false;
  if (lhs.device_bound_session_usage < rhs.device_bound_session_usage)
    return true;
  if (rhs.device_bound_session_usage < lhs.device_bound_session_usage)
    return false;
  if (lhs.from_synthetic_response < rhs.from_synthetic_response)
    return true;
  if (rhs.from_synthetic_response < lhs.from_synthetic_response)
    return false;
  if (lhs.bypass_redirect_checks < rhs.bypass_redirect_checks)
    return true;
  if (rhs.bypass_redirect_checks < lhs.bypass_redirect_checks)
    return false;
  if (lhs.unencoded_digests < rhs.unencoded_digests)
    return true;
  if (rhs.unencoded_digests < lhs.unencoded_digests)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::URLResponseHead::DataView,
                                         ::network::mojom::URLResponseHeadPtr> {
  static bool IsNull(const ::network::mojom::URLResponseHeadPtr& input) { return !input; }
  static void SetToNull(::network::mojom::URLResponseHeadPtr* output) { output->reset(); }

  static const decltype(::network::mojom::URLResponseHead::request_time)& request_time(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->request_time;
  }

  static const decltype(::network::mojom::URLResponseHead::response_time)& response_time(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->response_time;
  }

  static const decltype(::network::mojom::URLResponseHead::original_response_time)& original_response_time(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->original_response_time;
  }

  static const decltype(::network::mojom::URLResponseHead::headers)& headers(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->headers;
  }

  static const decltype(::network::mojom::URLResponseHead::mime_type)& mime_type(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->mime_type;
  }

  static const decltype(::network::mojom::URLResponseHead::charset)& charset(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->charset;
  }

  static decltype(::network::mojom::URLResponseHead::content_length) content_length(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->content_length;
  }

  static decltype(::network::mojom::URLResponseHead::encoded_data_length) encoded_data_length(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->encoded_data_length;
  }

  static const decltype(::network::mojom::URLResponseHead::encoded_body_length)& encoded_body_length(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->encoded_body_length;
  }

  static decltype(::network::mojom::URLResponseHead::network_accessed) network_accessed(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->network_accessed;
  }

  static const decltype(::network::mojom::URLResponseHead::load_timing)& load_timing(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->load_timing;
  }

  static const decltype(::network::mojom::URLResponseHead::load_timing_internal_info)& load_timing_internal_info(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->load_timing_internal_info;
  }

  static decltype(::network::mojom::URLResponseHead::emitted_extra_info) emitted_extra_info(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->emitted_extra_info;
  }

  static decltype(::network::mojom::URLResponseHead::was_fetched_via_spdy) was_fetched_via_spdy(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->was_fetched_via_spdy;
  }

  static decltype(::network::mojom::URLResponseHead::was_alpn_negotiated) was_alpn_negotiated(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->was_alpn_negotiated;
  }

  static decltype(::network::mojom::URLResponseHead::was_alternate_protocol_available) was_alternate_protocol_available(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->was_alternate_protocol_available;
  }

  static decltype(::network::mojom::URLResponseHead::connection_info) connection_info(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->connection_info;
  }

  static const decltype(::network::mojom::URLResponseHead::alpn_negotiated_protocol)& alpn_negotiated_protocol(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->alpn_negotiated_protocol;
  }

  static decltype(::network::mojom::URLResponseHead::alternate_protocol_usage) alternate_protocol_usage(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->alternate_protocol_usage;
  }

  static const decltype(::network::mojom::URLResponseHead::remote_endpoint)& remote_endpoint(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->remote_endpoint;
  }

  static decltype(::network::mojom::URLResponseHead::client_address_space) client_address_space(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->client_address_space;
  }

  static decltype(::network::mojom::URLResponseHead::response_address_space) response_address_space(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->response_address_space;
  }

  static decltype(::network::mojom::URLResponseHead::is_validated) is_validated(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->is_validated;
  }

  static decltype(::network::mojom::URLResponseHead::was_fetched_via_cache) was_fetched_via_cache(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->was_fetched_via_cache;
  }

  static decltype(::network::mojom::URLResponseHead::navigation_delivery_type) navigation_delivery_type(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->navigation_delivery_type;
  }

  static const decltype(::network::mojom::URLResponseHead::proxy_chain)& proxy_chain(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->proxy_chain;
  }

  static decltype(::network::mojom::URLResponseHead::was_fetched_via_service_worker) was_fetched_via_service_worker(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->was_fetched_via_service_worker;
  }

  static decltype(::network::mojom::URLResponseHead::service_worker_response_source) service_worker_response_source(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->service_worker_response_source;
  }

  static const decltype(::network::mojom::URLResponseHead::url_list_via_service_worker)& url_list_via_service_worker(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->url_list_via_service_worker;
  }

  static decltype(::network::mojom::URLResponseHead::initial_service_worker_status) initial_service_worker_status(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->initial_service_worker_status;
  }

  static const decltype(::network::mojom::URLResponseHead::service_worker_router_info)& service_worker_router_info(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->service_worker_router_info;
  }

  static decltype(::network::mojom::URLResponseHead::response_type) response_type(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->response_type;
  }

  static decltype(::network::mojom::URLResponseHead::padding) padding(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->padding;
  }

  static const decltype(::network::mojom::URLResponseHead::cache_storage_cache_name)& cache_storage_cache_name(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->cache_storage_cache_name;
  }

  static decltype(::network::mojom::URLResponseHead::cert_status) cert_status(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->cert_status;
  }

  static const decltype(::network::mojom::URLResponseHead::ssl_info)& ssl_info(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->ssl_info;
  }

  static const decltype(::network::mojom::URLResponseHead::request_cookies)& request_cookies(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->request_cookies;
  }

  static const decltype(::network::mojom::URLResponseHead::cors_exposed_header_names)& cors_exposed_header_names(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->cors_exposed_header_names;
  }

  static decltype(::network::mojom::URLResponseHead::did_service_worker_navigation_preload) did_service_worker_navigation_preload(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->did_service_worker_navigation_preload;
  }

  static decltype(::network::mojom::URLResponseHead::async_revalidation_requested) async_revalidation_requested(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->async_revalidation_requested;
  }

  static decltype(::network::mojom::URLResponseHead::did_mime_sniff) did_mime_sniff(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->did_mime_sniff;
  }

  static decltype(::network::mojom::URLResponseHead::is_signed_exchange_inner_response) is_signed_exchange_inner_response(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->is_signed_exchange_inner_response;
  }

  static decltype(::network::mojom::URLResponseHead::is_web_bundle_inner_response) is_web_bundle_inner_response(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->is_web_bundle_inner_response;
  }

  static decltype(::network::mojom::URLResponseHead::was_in_prefetch_cache) was_in_prefetch_cache(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->was_in_prefetch_cache;
  }

  static decltype(::network::mojom::URLResponseHead::is_prefetch_with_cross_site_contamination) is_prefetch_with_cross_site_contamination(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->is_prefetch_with_cross_site_contamination;
  }

  static decltype(::network::mojom::URLResponseHead::was_cookie_in_request) was_cookie_in_request(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->was_cookie_in_request;
  }

  static decltype(::network::mojom::URLResponseHead::intercepted_by_plugin) intercepted_by_plugin(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->intercepted_by_plugin;
  }

  static decltype(::network::mojom::URLResponseHead::has_range_requested) has_range_requested(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->has_range_requested;
  }

  static decltype(::network::mojom::URLResponseHead::timing_allow_passed) timing_allow_passed(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->timing_allow_passed;
  }

  static const decltype(::network::mojom::URLResponseHead::auth_challenge_info)& auth_challenge_info(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->auth_challenge_info;
  }

  static const decltype(::network::mojom::URLResponseHead::request_start)& request_start(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->request_start;
  }

  static const decltype(::network::mojom::URLResponseHead::response_start)& response_start(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->response_start;
  }

  static const decltype(::network::mojom::URLResponseHead::parsed_headers)& parsed_headers(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->parsed_headers;
  }

  static const decltype(::network::mojom::URLResponseHead::recursive_prefetch_token)& recursive_prefetch_token(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->recursive_prefetch_token;
  }

  static const decltype(::network::mojom::URLResponseHead::dns_aliases)& dns_aliases(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->dns_aliases;
  }

  static decltype(::network::mojom::URLResponseHead::has_authorization_covered_by_wildcard_on_preflight) has_authorization_covered_by_wildcard_on_preflight(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->has_authorization_covered_by_wildcard_on_preflight;
  }

  static decltype(::network::mojom::URLResponseHead::request_include_credentials) request_include_credentials(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->request_include_credentials;
  }

  static decltype(::network::mojom::URLResponseHead::should_use_source_hash_for_js_code_cache) should_use_source_hash_for_js_code_cache(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->should_use_source_hash_for_js_code_cache;
  }

  static decltype(::network::mojom::URLResponseHead::private_network_access_preflight_result) private_network_access_preflight_result(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->private_network_access_preflight_result;
  }

  static decltype(::network::mojom::URLResponseHead::did_use_shared_dictionary) did_use_shared_dictionary(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->did_use_shared_dictionary;
  }

  static decltype(::network::mojom::URLResponseHead::load_with_storage_access) load_with_storage_access(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->load_with_storage_access;
  }

  static const decltype(::network::mojom::URLResponseHead::client_side_content_decoding_types)& client_side_content_decoding_types(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->client_side_content_decoding_types;
  }

  static decltype(::network::mojom::URLResponseHead::device_bound_session_usage) device_bound_session_usage(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->device_bound_session_usage;
  }

  static decltype(::network::mojom::URLResponseHead::from_synthetic_response) from_synthetic_response(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->from_synthetic_response;
  }

  static decltype(::network::mojom::URLResponseHead::bypass_redirect_checks) bypass_redirect_checks(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->bypass_redirect_checks;
  }

  static const decltype(::network::mojom::URLResponseHead::unencoded_digests)& unencoded_digests(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->unencoded_digests;
  }

  static bool Read(::network::mojom::URLResponseHead::DataView input, ::network::mojom::URLResponseHeadPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_H_