// services/shape_detection/public/mojom/barcodedetection.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_BARCODEDETECTION_MOJOM_DATA_VIEW_H_
#define SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_BARCODEDETECTION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/shape_detection/public/mojom/barcodedetection.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace shape_detection::mojom {
class BarcodeDetectionResultDataView;



}  // shape_detection::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::shape_detection::mojom::BarcodeDetectionResultDataView> {
  using Data = ::shape_detection::mojom::internal::BarcodeDetectionResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace shape_detection::mojom {


enum class BarcodeFormat : int32_t {
  
  AZTEC = 0,
  
  CODE_128 = 1,
  
  CODE_39 = 2,
  
  CODE_93 = 3,
  
  CODABAR = 4,
  
  DATA_MATRIX = 5,
  
  EAN_13 = 6,
  
  EAN_8 = 7,
  
  ITF = 8,
  
  PDF417 = 9,
  
  QR_CODE = 10,
  
  UNKNOWN = 11,
  
  UPC_A = 12,
  
  UPC_E = 13,
  kMinValue = 0,
  kMaxValue = 13,
};

 std::ostream& operator<<(std::ostream& os, BarcodeFormat value);
inline bool IsKnownEnumValue(BarcodeFormat value) {
  return internal::BarcodeFormat_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class BarcodeDetectionInterfaceBase {};

using BarcodeDetectionPtrDataView =
    mojo::InterfacePtrDataView<BarcodeDetectionInterfaceBase>;
using BarcodeDetectionRequestDataView =
    mojo::InterfaceRequestDataView<BarcodeDetectionInterfaceBase>;
using BarcodeDetectionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BarcodeDetectionInterfaceBase>;
using BarcodeDetectionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BarcodeDetectionInterfaceBase>;


class BarcodeDetectionResultDataView {
 public:
  BarcodeDetectionResultDataView() = default;

  BarcodeDetectionResultDataView(
      internal::BarcodeDetectionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRawValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRawValue(UserType* output) {
    
    auto* pointer = data_->raw_value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBoundingBoxDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBoundingBox(UserType* output) {
    
    auto* pointer = data_->bounding_box.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFormat(UserType* output) const {
    auto data_value = data_->format;
    return mojo::internal::Deserialize<::shape_detection::mojom::BarcodeFormat>(
        data_value, output);
  }
  BarcodeFormat format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::shape_detection::mojom::BarcodeFormat>(data_->format));
  }
  inline void GetCornerPointsDataView(
      mojo::ArrayDataView<::gfx::mojom::PointFDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCornerPoints(UserType* output) {
    
    auto* pointer = data_->corner_points.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::PointFDataView>>(
        pointer, output, message_);
  }
 private:
  internal::BarcodeDetectionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // shape_detection::mojom

#endif  // SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_BARCODEDETECTION_MOJOM_DATA_VIEW_H_