// services/video_capture/public/mojom/device.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_DEVICE_MOJOM_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_DEVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/video_capture/public/mojom/device.mojom-features.h"  // IWYU pragma: export
#include "services/video_capture/public/mojom/device.mojom-shared.h"  // IWYU pragma: export
#include "services/video_capture/public/mojom/device.mojom-forward.h"  // IWYU pragma: export
#include "media/capture/mojom/video_capture_types.mojom.h"
#include "media/capture/mojom/image_capture.mojom-forward.h"
#include "services/video_capture/public/mojom/video_frame_handler.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace video_capture::mojom {

class DeviceProxy;

template <typename ImplRefTraits>
class DeviceStub;

class DeviceRequestValidator;
class DeviceResponseValidator;


class Device
    : public DeviceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "video_capture.mojom.Device";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DeviceInterfaceBase;
  using Proxy_ = DeviceProxy;

  template <typename ImplRefTraits>
  using Stub_ = DeviceStub<ImplRefTraits>;

  using RequestValidator_ = DeviceRequestValidator;
  using ResponseValidator_ = DeviceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kStartMinVersion = 0,
    kMaybeSuspendMinVersion = 0,
    kResumeMinVersion = 0,
    kGetPhotoStateMinVersion = 0,
    kSetPhotoOptionsMinVersion = 0,
    kTakePhotoMinVersion = 0,
    kProcessFeedbackMinVersion = 0,
    kRequestRefreshFrameMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Start_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MaybeSuspend_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Resume_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPhotoState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPhotoOptions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TakePhoto_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ProcessFeedback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestRefreshFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Device() = default;

  virtual void Start(const ::media::VideoCaptureParams& requested_settings, ::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler> handler) = 0;

  virtual void MaybeSuspend() = 0;

  virtual void Resume() = 0;

  using GetPhotoStateCallback = base::OnceCallback<void(::media::mojom::PhotoStatePtr)>;
  using GetPhotoStateMojoCallback = base::OnceCallback<void(::media::mojom::PhotoStatePtr)>;

  virtual void GetPhotoState(GetPhotoStateCallback callback) = 0;

  using SetPhotoOptionsCallback = base::OnceCallback<void(bool)>;
  using SetPhotoOptionsMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetPhotoOptions(::media::mojom::PhotoSettingsPtr settings, SetPhotoOptionsCallback callback) = 0;

  using TakePhotoCallback = base::OnceCallback<void(::media::mojom::BlobPtr)>;
  using TakePhotoMojoCallback = base::OnceCallback<void(::media::mojom::BlobPtr)>;

  virtual void TakePhoto(TakePhotoCallback callback) = 0;

  virtual void ProcessFeedback(const ::media::VideoCaptureFeedback& feedback) = 0;

  virtual void RequestRefreshFrame() = 0;
};



class  DeviceProxy
    : public Device {
 public:
  using InterfaceType = Device;

  explicit DeviceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Start(const ::media::VideoCaptureParams& requested_settings, ::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler> handler) final;
  
  void MaybeSuspend() final;
  
  void Resume() final;
  
  void GetPhotoState(GetPhotoStateCallback callback) final;
  
  void SetPhotoOptions(::media::mojom::PhotoSettingsPtr settings, SetPhotoOptionsCallback callback) final;
  
  void TakePhoto(TakePhotoCallback callback) final;
  
  void ProcessFeedback(const ::media::VideoCaptureFeedback& feedback) final;
  
  void RequestRefreshFrame() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DeviceStubDispatch {
 public:
  static bool Accept(Device* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Device* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Device>>
class DeviceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DeviceStub() = default;
  ~DeviceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DeviceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DeviceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // video_capture::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_DEVICE_MOJOM_H_