// services/video_capture/public/mojom/virtual_device.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/video_capture/public/mojom/virtual_device.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/video_capture/public/mojom/virtual_device.mojom-params-data.h"
#include "services/video_capture/public/mojom/virtual_device.mojom-shared-message-ids.h"

#include "services/video_capture/public/mojom/virtual_device.mojom-import-headers.h"
#include "services/video_capture/public/mojom/virtual_device.mojom-test-utils.h"


namespace video_capture::mojom {
// The declaration includes the definition on other builds.

SharedMemoryVirtualDevice::IPCStableHashFunction SharedMemoryVirtualDevice::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SharedMemoryVirtualDevice>(message.name())) {
    case messages::SharedMemoryVirtualDevice::kRequestFrameBuffer: {
      return &SharedMemoryVirtualDevice::RequestFrameBuffer_Sym::IPCStableHash;
    }
    case messages::SharedMemoryVirtualDevice::kOnFrameReadyInBuffer: {
      return &SharedMemoryVirtualDevice::OnFrameReadyInBuffer_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SharedMemoryVirtualDevice::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SharedMemoryVirtualDevice>(message.name())) {
      case messages::SharedMemoryVirtualDevice::kRequestFrameBuffer:
            return "Receive video_capture::mojom::SharedMemoryVirtualDevice::RequestFrameBuffer";
      case messages::SharedMemoryVirtualDevice::kOnFrameReadyInBuffer:
            return "Receive video_capture::mojom::SharedMemoryVirtualDevice::OnFrameReadyInBuffer";
    }
  } else {
    switch (static_cast<messages::SharedMemoryVirtualDevice>(message.name())) {
      case messages::SharedMemoryVirtualDevice::kRequestFrameBuffer:
            return "Receive reply video_capture::mojom::SharedMemoryVirtualDevice::RequestFrameBuffer";
      case messages::SharedMemoryVirtualDevice::kOnFrameReadyInBuffer:
            return "Receive reply video_capture::mojom::SharedMemoryVirtualDevice::OnFrameReadyInBuffer";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SharedMemoryVirtualDevice::RequestFrameBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7b99302e;  // IPCStableHash for video_capture::mojom::SharedMemoryVirtualDevice::RequestFrameBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedMemoryVirtualDevice::OnFrameReadyInBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4020219b;  // IPCStableHash for video_capture::mojom::SharedMemoryVirtualDevice::OnFrameReadyInBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SharedMemoryVirtualDevice_RequestFrameBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SharedMemoryVirtualDevice_RequestFrameBuffer_ForwardToCallback(
      SharedMemoryVirtualDevice::RequestFrameBufferCallback callback
      ) : callback_(std::move(callback)) {
  }

  SharedMemoryVirtualDevice_RequestFrameBuffer_ForwardToCallback(const SharedMemoryVirtualDevice_RequestFrameBuffer_ForwardToCallback&) = delete;
  SharedMemoryVirtualDevice_RequestFrameBuffer_ForwardToCallback& operator=(const SharedMemoryVirtualDevice_RequestFrameBuffer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SharedMemoryVirtualDevice::RequestFrameBufferCallback callback_;
};

SharedMemoryVirtualDeviceProxy::SharedMemoryVirtualDeviceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedMemoryVirtualDeviceProxy::RequestFrameBuffer(
    const ::gfx::Size& in_dimension, ::media::VideoPixelFormat in_pixel_format, ::media::mojom::PlaneStridesPtr in_strides, RequestFrameBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::SharedMemoryVirtualDevice::RequestFrameBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dimension"), in_dimension,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pixel_format"), in_pixel_format,
                        "<value of type ::media::VideoPixelFormat>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("strides"), in_strides,
                        "<value of type ::media::mojom::PlaneStridesPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedMemoryVirtualDevice::kRequestFrameBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dimension)::BaseType> dimension_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_dimension,
    dimension_fragment);

  params->dimension.Set(
      dimension_fragment.is_null() ? nullptr : dimension_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dimension.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dimension in SharedMemoryVirtualDevice.RequestFrameBuffer request");

  
  mojo::internal::Serialize<::media::mojom::VideoCapturePixelFormat>(
    in_pixel_format,
    &params->pixel_format);
  mojo::internal::MessageFragment<
      typename decltype(params->strides)::BaseType> strides_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::PlaneStridesDataView>(
    in_strides,
    strides_fragment);

  params->strides.Set(
      strides_fragment.is_null() ? nullptr : strides_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedMemoryVirtualDevice::Name_);
  message.set_method_name("RequestFrameBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SharedMemoryVirtualDevice_RequestFrameBuffer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SharedMemoryVirtualDeviceProxy::OnFrameReadyInBuffer(
    int32_t in_buffer_id, ::media::mojom::VideoFrameInfoPtr in_frame_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::SharedMemoryVirtualDevice::OnFrameReadyInBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_info"), in_frame_info,
                        "<value of type ::media::mojom::VideoFrameInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedMemoryVirtualDevice::kOnFrameReadyInBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data> params(
          message);
  params.Allocate();

  params->buffer_id = in_buffer_id;
  mojo::internal::MessageFragment<
      typename decltype(params->frame_info)::BaseType> frame_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::VideoFrameInfoDataView>(
    in_frame_info,
    frame_info_fragment);

  params->frame_info.Set(
      frame_info_fragment.is_null() ? nullptr : frame_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_info in SharedMemoryVirtualDevice.OnFrameReadyInBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedMemoryVirtualDevice::Name_);
  message.set_method_name("OnFrameReadyInBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SharedMemoryVirtualDevice::RequestFrameBufferCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder> proxy(
        new SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SharedMemoryVirtualDevice::RequestFrameBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_buffer_id);
};

bool SharedMemoryVirtualDevice_RequestFrameBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SharedMemoryVirtualDevice.0
  bool success = true;
  int32_t p_buffer_id{};
  SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_buffer_id = input_data_view.buffer_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SharedMemoryVirtualDevice::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_buffer_id));
  }
  return true;
}

void SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder::Run(
    int32_t in_buffer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply video_capture::mojom::SharedMemoryVirtualDevice::RequestFrameBuffer", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedMemoryVirtualDevice::kRequestFrameBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->buffer_id = in_buffer_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedMemoryVirtualDevice::Name_);
  message.set_method_name("RequestFrameBuffer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SharedMemoryVirtualDeviceStubDispatch::Accept(
    SharedMemoryVirtualDevice* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SharedMemoryVirtualDevice>(message->header()->name)) {
    case messages::SharedMemoryVirtualDevice::kRequestFrameBuffer: {
      break;
    }
    case messages::SharedMemoryVirtualDevice::kOnFrameReadyInBuffer: {
      DCHECK(message->is_serialized());
      internal::SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data* params =
          reinterpret_cast<internal::SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedMemoryVirtualDevice.1
      bool success = true;
      int32_t p_buffer_id{};
      ::media::mojom::VideoFrameInfoPtr p_frame_info{};
      SharedMemoryVirtualDevice_OnFrameReadyInBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadFrameInfo(&p_frame_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedMemoryVirtualDevice::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameReadyInBuffer(        
        std::move(p_buffer_id), 
        std::move(p_frame_info));
      return true;
    }
  }
  return false;
}

// static
bool SharedMemoryVirtualDeviceStubDispatch::AcceptWithResponder(
    SharedMemoryVirtualDevice* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SharedMemoryVirtualDevice>(message->header()->name)) {
    case messages::SharedMemoryVirtualDevice::kRequestFrameBuffer: {
      internal::SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data* params =
          reinterpret_cast<
              internal::SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SharedMemoryVirtualDevice.0
      bool success = true;
      ::gfx::Size p_dimension{};
      ::media::VideoPixelFormat p_pixel_format{};
      ::media::mojom::PlaneStridesPtr p_strides{};
      SharedMemoryVirtualDevice_RequestFrameBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDimension(&p_dimension))
        success = false;
      if (success && !input_data_view.ReadPixelFormat(&p_pixel_format))
        success = false;
      if (success && !input_data_view.ReadStrides(&p_strides))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedMemoryVirtualDevice::Name_, 0, false);
        return false;
      }
      auto callback =
          SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestFrameBuffer(        
        std::move(p_dimension), 
        std::move(p_pixel_format), 
        std::move(p_strides), std::move(callback));
      return true;
    }
    case messages::SharedMemoryVirtualDevice::kOnFrameReadyInBuffer: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSharedMemoryVirtualDeviceValidationInfo[] = {
    {base::to_underlying(messages::SharedMemoryVirtualDevice::kRequestFrameBuffer),
     { &internal::SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data::Validate,
      &internal::SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SharedMemoryVirtualDevice::kOnFrameReadyInBuffer),
     { &internal::SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SharedMemoryVirtualDeviceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::video_capture::mojom::SharedMemoryVirtualDevice::Name_,
    kSharedMemoryVirtualDeviceValidationInfo);
}

bool SharedMemoryVirtualDeviceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::video_capture::mojom::SharedMemoryVirtualDevice::Name_,
    kSharedMemoryVirtualDeviceValidationInfo);

}
// The declaration includes the definition on other builds.

TextureVirtualDevice::IPCStableHashFunction TextureVirtualDevice::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TextureVirtualDevice>(message.name())) {
    case messages::TextureVirtualDevice::kOnNewSharedImageBufferHandle: {
      return &TextureVirtualDevice::OnNewSharedImageBufferHandle_Sym::IPCStableHash;
    }
    case messages::TextureVirtualDevice::kOnFrameAccessHandlerReady: {
      return &TextureVirtualDevice::OnFrameAccessHandlerReady_Sym::IPCStableHash;
    }
    case messages::TextureVirtualDevice::kOnFrameReadyInBuffer: {
      return &TextureVirtualDevice::OnFrameReadyInBuffer_Sym::IPCStableHash;
    }
    case messages::TextureVirtualDevice::kOnBufferRetired: {
      return &TextureVirtualDevice::OnBufferRetired_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TextureVirtualDevice::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TextureVirtualDevice>(message.name())) {
      case messages::TextureVirtualDevice::kOnNewSharedImageBufferHandle:
            return "Receive video_capture::mojom::TextureVirtualDevice::OnNewSharedImageBufferHandle";
      case messages::TextureVirtualDevice::kOnFrameAccessHandlerReady:
            return "Receive video_capture::mojom::TextureVirtualDevice::OnFrameAccessHandlerReady";
      case messages::TextureVirtualDevice::kOnFrameReadyInBuffer:
            return "Receive video_capture::mojom::TextureVirtualDevice::OnFrameReadyInBuffer";
      case messages::TextureVirtualDevice::kOnBufferRetired:
            return "Receive video_capture::mojom::TextureVirtualDevice::OnBufferRetired";
    }
  } else {
    switch (static_cast<messages::TextureVirtualDevice>(message.name())) {
      case messages::TextureVirtualDevice::kOnNewSharedImageBufferHandle:
            return "Receive reply video_capture::mojom::TextureVirtualDevice::OnNewSharedImageBufferHandle";
      case messages::TextureVirtualDevice::kOnFrameAccessHandlerReady:
            return "Receive reply video_capture::mojom::TextureVirtualDevice::OnFrameAccessHandlerReady";
      case messages::TextureVirtualDevice::kOnFrameReadyInBuffer:
            return "Receive reply video_capture::mojom::TextureVirtualDevice::OnFrameReadyInBuffer";
      case messages::TextureVirtualDevice::kOnBufferRetired:
            return "Receive reply video_capture::mojom::TextureVirtualDevice::OnBufferRetired";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TextureVirtualDevice::OnNewSharedImageBufferHandle_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9a2bd464;  // IPCStableHash for video_capture::mojom::TextureVirtualDevice::OnNewSharedImageBufferHandle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextureVirtualDevice::OnFrameAccessHandlerReady_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4f24ac2a;  // IPCStableHash for video_capture::mojom::TextureVirtualDevice::OnFrameAccessHandlerReady
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextureVirtualDevice::OnFrameReadyInBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xea18ea1e;  // IPCStableHash for video_capture::mojom::TextureVirtualDevice::OnFrameReadyInBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextureVirtualDevice::OnBufferRetired_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2e66d7ef;  // IPCStableHash for video_capture::mojom::TextureVirtualDevice::OnBufferRetired
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TextureVirtualDeviceProxy::TextureVirtualDeviceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TextureVirtualDeviceProxy::OnNewSharedImageBufferHandle(
    int32_t in_buffer_id, ::media::mojom::SharedImageBufferHandleSetPtr in_shared_image_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::TextureVirtualDevice::OnNewSharedImageBufferHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_image_handle"), in_shared_image_handle,
                        "<value of type ::media::mojom::SharedImageBufferHandleSetPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextureVirtualDevice::kOnNewSharedImageBufferHandle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::TextureVirtualDevice_OnNewSharedImageBufferHandle_Params_Data> params(
          message);
  params.Allocate();

  params->buffer_id = in_buffer_id;
  mojo::internal::MessageFragment<
      typename decltype(params->shared_image_handle)::BaseType> shared_image_handle_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::SharedImageBufferHandleSetDataView>(
    in_shared_image_handle,
    shared_image_handle_fragment);

  params->shared_image_handle.Set(
      shared_image_handle_fragment.is_null() ? nullptr : shared_image_handle_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->shared_image_handle.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null shared_image_handle in TextureVirtualDevice.OnNewSharedImageBufferHandle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextureVirtualDevice::Name_);
  message.set_method_name("OnNewSharedImageBufferHandle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TextureVirtualDeviceProxy::OnFrameAccessHandlerReady(
    ::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler> in_frame_access_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::TextureVirtualDevice::OnFrameAccessHandlerReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_access_handler"), in_frame_access_handler,
                        "<value of type ::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextureVirtualDevice::kOnFrameAccessHandlerReady), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::TextureVirtualDevice_OnFrameAccessHandlerReady_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::video_capture::mojom::VideoFrameAccessHandlerInterfaceBase>>(
    in_frame_access_handler,
    &params->frame_access_handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->frame_access_handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid frame_access_handler in TextureVirtualDevice.OnFrameAccessHandlerReady request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextureVirtualDevice::Name_);
  message.set_method_name("OnFrameAccessHandlerReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TextureVirtualDeviceProxy::OnFrameReadyInBuffer(
    int32_t in_buffer_id, ::media::mojom::VideoFrameInfoPtr in_frame_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::TextureVirtualDevice::OnFrameReadyInBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_info"), in_frame_info,
                        "<value of type ::media::mojom::VideoFrameInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextureVirtualDevice::kOnFrameReadyInBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data> params(
          message);
  params.Allocate();

  params->buffer_id = in_buffer_id;
  mojo::internal::MessageFragment<
      typename decltype(params->frame_info)::BaseType> frame_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::VideoFrameInfoDataView>(
    in_frame_info,
    frame_info_fragment);

  params->frame_info.Set(
      frame_info_fragment.is_null() ? nullptr : frame_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_info in TextureVirtualDevice.OnFrameReadyInBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextureVirtualDevice::Name_);
  message.set_method_name("OnFrameReadyInBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TextureVirtualDeviceProxy::OnBufferRetired(
    int32_t in_buffer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::TextureVirtualDevice::OnBufferRetired", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextureVirtualDevice::kOnBufferRetired), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::TextureVirtualDevice_OnBufferRetired_Params_Data> params(
          message);
  params.Allocate();

  params->buffer_id = in_buffer_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextureVirtualDevice::Name_);
  message.set_method_name("OnBufferRetired");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TextureVirtualDeviceStubDispatch::Accept(
    TextureVirtualDevice* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TextureVirtualDevice>(message->header()->name)) {
    case messages::TextureVirtualDevice::kOnNewSharedImageBufferHandle: {
      DCHECK(message->is_serialized());
      internal::TextureVirtualDevice_OnNewSharedImageBufferHandle_Params_Data* params =
          reinterpret_cast<internal::TextureVirtualDevice_OnNewSharedImageBufferHandle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextureVirtualDevice.0
      bool success = true;
      int32_t p_buffer_id{};
      ::media::mojom::SharedImageBufferHandleSetPtr p_shared_image_handle{};
      TextureVirtualDevice_OnNewSharedImageBufferHandle_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadSharedImageHandle(&p_shared_image_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextureVirtualDevice::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNewSharedImageBufferHandle(        
        std::move(p_buffer_id), 
        std::move(p_shared_image_handle));
      return true;
    }
    case messages::TextureVirtualDevice::kOnFrameAccessHandlerReady: {
      DCHECK(message->is_serialized());
      internal::TextureVirtualDevice_OnFrameAccessHandlerReady_Params_Data* params =
          reinterpret_cast<internal::TextureVirtualDevice_OnFrameAccessHandlerReady_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextureVirtualDevice.1
      bool success = true;
      ::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler> p_frame_access_handler{};
      TextureVirtualDevice_OnFrameAccessHandlerReady_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_frame_access_handler =
            input_data_view.TakeFrameAccessHandler<decltype(p_frame_access_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextureVirtualDevice::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameAccessHandlerReady(        
        std::move(p_frame_access_handler));
      return true;
    }
    case messages::TextureVirtualDevice::kOnFrameReadyInBuffer: {
      DCHECK(message->is_serialized());
      internal::TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data* params =
          reinterpret_cast<internal::TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextureVirtualDevice.2
      bool success = true;
      int32_t p_buffer_id{};
      ::media::mojom::VideoFrameInfoPtr p_frame_info{};
      TextureVirtualDevice_OnFrameReadyInBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadFrameInfo(&p_frame_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextureVirtualDevice::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameReadyInBuffer(        
        std::move(p_buffer_id), 
        std::move(p_frame_info));
      return true;
    }
    case messages::TextureVirtualDevice::kOnBufferRetired: {
      DCHECK(message->is_serialized());
      internal::TextureVirtualDevice_OnBufferRetired_Params_Data* params =
          reinterpret_cast<internal::TextureVirtualDevice_OnBufferRetired_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextureVirtualDevice.3
      bool success = true;
      int32_t p_buffer_id{};
      TextureVirtualDevice_OnBufferRetired_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextureVirtualDevice::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferRetired(        
        std::move(p_buffer_id));
      return true;
    }
  }
  return false;
}

// static
bool TextureVirtualDeviceStubDispatch::AcceptWithResponder(
    TextureVirtualDevice* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TextureVirtualDevice>(message->header()->name)) {
    case messages::TextureVirtualDevice::kOnNewSharedImageBufferHandle: {
      break;
    }
    case messages::TextureVirtualDevice::kOnFrameAccessHandlerReady: {
      break;
    }
    case messages::TextureVirtualDevice::kOnFrameReadyInBuffer: {
      break;
    }
    case messages::TextureVirtualDevice::kOnBufferRetired: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTextureVirtualDeviceValidationInfo[] = {
    {base::to_underlying(messages::TextureVirtualDevice::kOnNewSharedImageBufferHandle),
     { &internal::TextureVirtualDevice_OnNewSharedImageBufferHandle_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::TextureVirtualDevice::kOnFrameAccessHandlerReady),
     { &internal::TextureVirtualDevice_OnFrameAccessHandlerReady_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::TextureVirtualDevice::kOnFrameReadyInBuffer),
     { &internal::TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::TextureVirtualDevice::kOnBufferRetired),
     { &internal::TextureVirtualDevice_OnBufferRetired_Params_Data::Validate,
      nullptr /* no response */}},
};

bool TextureVirtualDeviceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::video_capture::mojom::TextureVirtualDevice::Name_,
    kTextureVirtualDeviceValidationInfo);
}

// The declaration includes the definition on other builds.

GpuMemoryBufferVirtualDevice::IPCStableHashFunction GpuMemoryBufferVirtualDevice::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GpuMemoryBufferVirtualDevice>(message.name())) {
    case messages::GpuMemoryBufferVirtualDevice::kOnNewGpuMemoryBufferHandle: {
      return &GpuMemoryBufferVirtualDevice::OnNewGpuMemoryBufferHandle_Sym::IPCStableHash;
    }
    case messages::GpuMemoryBufferVirtualDevice::kOnFrameAccessHandlerReady: {
      return &GpuMemoryBufferVirtualDevice::OnFrameAccessHandlerReady_Sym::IPCStableHash;
    }
    case messages::GpuMemoryBufferVirtualDevice::kOnFrameReadyInBuffer: {
      return &GpuMemoryBufferVirtualDevice::OnFrameReadyInBuffer_Sym::IPCStableHash;
    }
    case messages::GpuMemoryBufferVirtualDevice::kOnBufferRetired: {
      return &GpuMemoryBufferVirtualDevice::OnBufferRetired_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GpuMemoryBufferVirtualDevice::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GpuMemoryBufferVirtualDevice>(message.name())) {
      case messages::GpuMemoryBufferVirtualDevice::kOnNewGpuMemoryBufferHandle:
            return "Receive video_capture::mojom::GpuMemoryBufferVirtualDevice::OnNewGpuMemoryBufferHandle";
      case messages::GpuMemoryBufferVirtualDevice::kOnFrameAccessHandlerReady:
            return "Receive video_capture::mojom::GpuMemoryBufferVirtualDevice::OnFrameAccessHandlerReady";
      case messages::GpuMemoryBufferVirtualDevice::kOnFrameReadyInBuffer:
            return "Receive video_capture::mojom::GpuMemoryBufferVirtualDevice::OnFrameReadyInBuffer";
      case messages::GpuMemoryBufferVirtualDevice::kOnBufferRetired:
            return "Receive video_capture::mojom::GpuMemoryBufferVirtualDevice::OnBufferRetired";
    }
  } else {
    switch (static_cast<messages::GpuMemoryBufferVirtualDevice>(message.name())) {
      case messages::GpuMemoryBufferVirtualDevice::kOnNewGpuMemoryBufferHandle:
            return "Receive reply video_capture::mojom::GpuMemoryBufferVirtualDevice::OnNewGpuMemoryBufferHandle";
      case messages::GpuMemoryBufferVirtualDevice::kOnFrameAccessHandlerReady:
            return "Receive reply video_capture::mojom::GpuMemoryBufferVirtualDevice::OnFrameAccessHandlerReady";
      case messages::GpuMemoryBufferVirtualDevice::kOnFrameReadyInBuffer:
            return "Receive reply video_capture::mojom::GpuMemoryBufferVirtualDevice::OnFrameReadyInBuffer";
      case messages::GpuMemoryBufferVirtualDevice::kOnBufferRetired:
            return "Receive reply video_capture::mojom::GpuMemoryBufferVirtualDevice::OnBufferRetired";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GpuMemoryBufferVirtualDevice::OnNewGpuMemoryBufferHandle_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe6387b6b;  // IPCStableHash for video_capture::mojom::GpuMemoryBufferVirtualDevice::OnNewGpuMemoryBufferHandle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuMemoryBufferVirtualDevice::OnFrameAccessHandlerReady_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x33727417;  // IPCStableHash for video_capture::mojom::GpuMemoryBufferVirtualDevice::OnFrameAccessHandlerReady
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuMemoryBufferVirtualDevice::OnFrameReadyInBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa4d8aaea;  // IPCStableHash for video_capture::mojom::GpuMemoryBufferVirtualDevice::OnFrameReadyInBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuMemoryBufferVirtualDevice::OnBufferRetired_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc6c32c57;  // IPCStableHash for video_capture::mojom::GpuMemoryBufferVirtualDevice::OnBufferRetired
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

GpuMemoryBufferVirtualDeviceProxy::GpuMemoryBufferVirtualDeviceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GpuMemoryBufferVirtualDeviceProxy::OnNewGpuMemoryBufferHandle(
    int32_t in_buffer_id, ::gfx::GpuMemoryBufferHandle in_gmb_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::GpuMemoryBufferVirtualDevice::OnNewGpuMemoryBufferHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gmb_handle"), in_gmb_handle,
                        "<value of type ::gfx::GpuMemoryBufferHandle>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuMemoryBufferVirtualDevice::kOnNewGpuMemoryBufferHandle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data> params(
          message);
  params.Allocate();

  params->buffer_id = in_buffer_id;
  mojo::internal::MessageFragment<
      typename decltype(params->gmb_handle)::BaseType> gmb_handle_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
    in_gmb_handle,
    gmb_handle_fragment);

  params->gmb_handle.Set(
      gmb_handle_fragment.is_null() ? nullptr : gmb_handle_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->gmb_handle.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null gmb_handle in GpuMemoryBufferVirtualDevice.OnNewGpuMemoryBufferHandle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuMemoryBufferVirtualDevice::Name_);
  message.set_method_name("OnNewGpuMemoryBufferHandle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuMemoryBufferVirtualDeviceProxy::OnFrameAccessHandlerReady(
    ::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler> in_frame_access_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::GpuMemoryBufferVirtualDevice::OnFrameAccessHandlerReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_access_handler"), in_frame_access_handler,
                        "<value of type ::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuMemoryBufferVirtualDevice::kOnFrameAccessHandlerReady), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::video_capture::mojom::VideoFrameAccessHandlerInterfaceBase>>(
    in_frame_access_handler,
    &params->frame_access_handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->frame_access_handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid frame_access_handler in GpuMemoryBufferVirtualDevice.OnFrameAccessHandlerReady request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuMemoryBufferVirtualDevice::Name_);
  message.set_method_name("OnFrameAccessHandlerReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuMemoryBufferVirtualDeviceProxy::OnFrameReadyInBuffer(
    int32_t in_buffer_id, ::media::mojom::VideoFrameInfoPtr in_frame_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::GpuMemoryBufferVirtualDevice::OnFrameReadyInBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_info"), in_frame_info,
                        "<value of type ::media::mojom::VideoFrameInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuMemoryBufferVirtualDevice::kOnFrameReadyInBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data> params(
          message);
  params.Allocate();

  params->buffer_id = in_buffer_id;
  mojo::internal::MessageFragment<
      typename decltype(params->frame_info)::BaseType> frame_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::VideoFrameInfoDataView>(
    in_frame_info,
    frame_info_fragment);

  params->frame_info.Set(
      frame_info_fragment.is_null() ? nullptr : frame_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_info in GpuMemoryBufferVirtualDevice.OnFrameReadyInBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuMemoryBufferVirtualDevice::Name_);
  message.set_method_name("OnFrameReadyInBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuMemoryBufferVirtualDeviceProxy::OnBufferRetired(
    int32_t in_buffer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::GpuMemoryBufferVirtualDevice::OnBufferRetired", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuMemoryBufferVirtualDevice::kOnBufferRetired), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data> params(
          message);
  params.Allocate();

  params->buffer_id = in_buffer_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuMemoryBufferVirtualDevice::Name_);
  message.set_method_name("OnBufferRetired");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool GpuMemoryBufferVirtualDeviceStubDispatch::Accept(
    GpuMemoryBufferVirtualDevice* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GpuMemoryBufferVirtualDevice>(message->header()->name)) {
    case messages::GpuMemoryBufferVirtualDevice::kOnNewGpuMemoryBufferHandle: {
      DCHECK(message->is_serialized());
      internal::GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data* params =
          reinterpret_cast<internal::GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuMemoryBufferVirtualDevice.0
      bool success = true;
      int32_t p_buffer_id{};
      ::gfx::GpuMemoryBufferHandle p_gmb_handle{};
      GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadGmbHandle(&p_gmb_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuMemoryBufferVirtualDevice::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNewGpuMemoryBufferHandle(        
        std::move(p_buffer_id), 
        std::move(p_gmb_handle));
      return true;
    }
    case messages::GpuMemoryBufferVirtualDevice::kOnFrameAccessHandlerReady: {
      DCHECK(message->is_serialized());
      internal::GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Params_Data* params =
          reinterpret_cast<internal::GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuMemoryBufferVirtualDevice.1
      bool success = true;
      ::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler> p_frame_access_handler{};
      GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_frame_access_handler =
            input_data_view.TakeFrameAccessHandler<decltype(p_frame_access_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuMemoryBufferVirtualDevice::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameAccessHandlerReady(        
        std::move(p_frame_access_handler));
      return true;
    }
    case messages::GpuMemoryBufferVirtualDevice::kOnFrameReadyInBuffer: {
      DCHECK(message->is_serialized());
      internal::GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data* params =
          reinterpret_cast<internal::GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuMemoryBufferVirtualDevice.2
      bool success = true;
      int32_t p_buffer_id{};
      ::media::mojom::VideoFrameInfoPtr p_frame_info{};
      GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadFrameInfo(&p_frame_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuMemoryBufferVirtualDevice::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameReadyInBuffer(        
        std::move(p_buffer_id), 
        std::move(p_frame_info));
      return true;
    }
    case messages::GpuMemoryBufferVirtualDevice::kOnBufferRetired: {
      DCHECK(message->is_serialized());
      internal::GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data* params =
          reinterpret_cast<internal::GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuMemoryBufferVirtualDevice.3
      bool success = true;
      int32_t p_buffer_id{};
      GpuMemoryBufferVirtualDevice_OnBufferRetired_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuMemoryBufferVirtualDevice::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferRetired(        
        std::move(p_buffer_id));
      return true;
    }
  }
  return false;
}

// static
bool GpuMemoryBufferVirtualDeviceStubDispatch::AcceptWithResponder(
    GpuMemoryBufferVirtualDevice* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GpuMemoryBufferVirtualDevice>(message->header()->name)) {
    case messages::GpuMemoryBufferVirtualDevice::kOnNewGpuMemoryBufferHandle: {
      break;
    }
    case messages::GpuMemoryBufferVirtualDevice::kOnFrameAccessHandlerReady: {
      break;
    }
    case messages::GpuMemoryBufferVirtualDevice::kOnFrameReadyInBuffer: {
      break;
    }
    case messages::GpuMemoryBufferVirtualDevice::kOnBufferRetired: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGpuMemoryBufferVirtualDeviceValidationInfo[] = {
    {base::to_underlying(messages::GpuMemoryBufferVirtualDevice::kOnNewGpuMemoryBufferHandle),
     { &internal::GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuMemoryBufferVirtualDevice::kOnFrameAccessHandlerReady),
     { &internal::GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuMemoryBufferVirtualDevice::kOnFrameReadyInBuffer),
     { &internal::GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuMemoryBufferVirtualDevice::kOnBufferRetired),
     { &internal::GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data::Validate,
      nullptr /* no response */}},
};

bool GpuMemoryBufferVirtualDeviceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::video_capture::mojom::GpuMemoryBufferVirtualDevice::Name_,
    kGpuMemoryBufferVirtualDeviceValidationInfo);
}



}  // video_capture::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace video_capture::mojom {


void SharedMemoryVirtualDeviceInterceptorForTesting::RequestFrameBuffer(const ::gfx::Size& dimension, ::media::VideoPixelFormat pixel_format, ::media::mojom::PlaneStridesPtr strides, RequestFrameBufferCallback callback) {
  GetForwardingInterface()->RequestFrameBuffer(
    std::move(dimension)
    , 
    std::move(pixel_format)
    , 
    std::move(strides)
    , std::move(callback));
}
void SharedMemoryVirtualDeviceInterceptorForTesting::OnFrameReadyInBuffer(int32_t buffer_id, ::media::mojom::VideoFrameInfoPtr frame_info) {
  GetForwardingInterface()->OnFrameReadyInBuffer(
    std::move(buffer_id)
    , 
    std::move(frame_info)
    );
}
SharedMemoryVirtualDeviceAsyncWaiter::SharedMemoryVirtualDeviceAsyncWaiter(
    SharedMemoryVirtualDevice* proxy) : proxy_(proxy) {}

SharedMemoryVirtualDeviceAsyncWaiter::~SharedMemoryVirtualDeviceAsyncWaiter() = default;


void SharedMemoryVirtualDeviceAsyncWaiter::RequestFrameBuffer(
    const ::gfx::Size& dimension, ::media::VideoPixelFormat pixel_format, ::media::mojom::PlaneStridesPtr strides, int32_t* out_buffer_id) {
  base::RunLoop loop;
  proxy_->RequestFrameBuffer(
      std::move(dimension),
      std::move(pixel_format),
      std::move(strides),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_buffer_id
,
             int32_t buffer_id) {*out_buffer_id = std::move(buffer_id);
            loop->Quit();
          },
          &loop,
          out_buffer_id));
  loop.Run();
}

int32_t SharedMemoryVirtualDeviceAsyncWaiter::RequestFrameBuffer(
    const ::gfx::Size& dimension, ::media::VideoPixelFormat pixel_format, ::media::mojom::PlaneStridesPtr strides) {
  int32_t async_wait_result;
  RequestFrameBuffer(std::move(dimension),std::move(pixel_format),std::move(strides),&async_wait_result);
  return async_wait_result;
}




void TextureVirtualDeviceInterceptorForTesting::OnNewSharedImageBufferHandle(int32_t buffer_id, ::media::mojom::SharedImageBufferHandleSetPtr shared_image_handle) {
  GetForwardingInterface()->OnNewSharedImageBufferHandle(
    std::move(buffer_id)
    , 
    std::move(shared_image_handle)
    );
}
void TextureVirtualDeviceInterceptorForTesting::OnFrameAccessHandlerReady(::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler> frame_access_handler) {
  GetForwardingInterface()->OnFrameAccessHandlerReady(
    std::move(frame_access_handler)
    );
}
void TextureVirtualDeviceInterceptorForTesting::OnFrameReadyInBuffer(int32_t buffer_id, ::media::mojom::VideoFrameInfoPtr frame_info) {
  GetForwardingInterface()->OnFrameReadyInBuffer(
    std::move(buffer_id)
    , 
    std::move(frame_info)
    );
}
void TextureVirtualDeviceInterceptorForTesting::OnBufferRetired(int32_t buffer_id) {
  GetForwardingInterface()->OnBufferRetired(
    std::move(buffer_id)
    );
}
TextureVirtualDeviceAsyncWaiter::TextureVirtualDeviceAsyncWaiter(
    TextureVirtualDevice* proxy) : proxy_(proxy) {}

TextureVirtualDeviceAsyncWaiter::~TextureVirtualDeviceAsyncWaiter() = default;





void GpuMemoryBufferVirtualDeviceInterceptorForTesting::OnNewGpuMemoryBufferHandle(int32_t buffer_id, ::gfx::GpuMemoryBufferHandle gmb_handle) {
  GetForwardingInterface()->OnNewGpuMemoryBufferHandle(
    std::move(buffer_id)
    , 
    std::move(gmb_handle)
    );
}
void GpuMemoryBufferVirtualDeviceInterceptorForTesting::OnFrameAccessHandlerReady(::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler> frame_access_handler) {
  GetForwardingInterface()->OnFrameAccessHandlerReady(
    std::move(frame_access_handler)
    );
}
void GpuMemoryBufferVirtualDeviceInterceptorForTesting::OnFrameReadyInBuffer(int32_t buffer_id, ::media::mojom::VideoFrameInfoPtr frame_info) {
  GetForwardingInterface()->OnFrameReadyInBuffer(
    std::move(buffer_id)
    , 
    std::move(frame_info)
    );
}
void GpuMemoryBufferVirtualDeviceInterceptorForTesting::OnBufferRetired(int32_t buffer_id) {
  GetForwardingInterface()->OnBufferRetired(
    std::move(buffer_id)
    );
}
GpuMemoryBufferVirtualDeviceAsyncWaiter::GpuMemoryBufferVirtualDeviceAsyncWaiter(
    GpuMemoryBufferVirtualDevice* proxy) : proxy_(proxy) {}

GpuMemoryBufferVirtualDeviceAsyncWaiter::~GpuMemoryBufferVirtualDeviceAsyncWaiter() = default;







}  // video_capture::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif