// services/viz/privileged/mojom/viz_main.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/privileged/mojom/viz_main.mojom-features.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/viz_main.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/viz_main.mojom-forward.h"  // IWYU pragma: export
#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom-forward.h"
#include "components/viz/service/debugger/mojom/viz_debugger.mojom-forward.h"
#include "mojo/public/mojom/base/values.mojom-forward.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "services/viz/public/mojom/compositing/compositing_mode_watcher.mojom-forward.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-forward.h"
#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom.h"
#include "services/viz/privileged/mojom/gl/gpu_host.mojom-forward.h"
#include "services/viz/privileged/mojom/gl/gpu_logging.mojom-forward.h"
#include "services/viz/privileged/mojom/gl/gpu_service.mojom-forward.h"
#include "ui/gfx/mojom/font_render_params.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace viz::mojom {

class VizMainProxy;

template <typename ImplRefTraits>
class VizMainStub;

class VizMainRequestValidator;


class VizMain
    : public VizMainInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.VizMain";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VizMainInterfaceBase;
  using Proxy_ = VizMainProxy;

  template <typename ImplRefTraits>
  using Stub_ = VizMainStub<ImplRefTraits>;

  using RequestValidator_ = VizMainRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateFrameSinkManagerMinVersion = 0,
    kCreateGpuServiceMinVersion = 0,
    kSetRenderParamsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateFrameSinkManager_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateGpuService_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetRenderParams_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VizMain() = default;

  virtual void CreateFrameSinkManager(FrameSinkManagerParamsPtr params) = 0;

  virtual void CreateGpuService(::mojo::PendingReceiver<::viz::mojom::GpuService> gpu_service, ::mojo::PendingRemote<::viz::mojom::GpuHost> gpu_host, ::mojo::PendingRemote<::viz::mojom::GpuLogging> gpu_logging, ::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager> discardable_memory_manager, ::base::UnsafeSharedMemoryRegion use_shader_cache_shm_count, GpuServiceCreationParamsPtr params) = 0;

  virtual void SetRenderParams(::gfx::FontRenderParams::SubpixelRendering subpixel_rendering, float text_contrast, float text_gamma) = 0;
};



class  VizMainProxy
    : public VizMain {
 public:
  using InterfaceType = VizMain;

  explicit VizMainProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateFrameSinkManager(FrameSinkManagerParamsPtr params) final;
  
  void CreateGpuService(::mojo::PendingReceiver<::viz::mojom::GpuService> gpu_service, ::mojo::PendingRemote<::viz::mojom::GpuHost> gpu_host, ::mojo::PendingRemote<::viz::mojom::GpuLogging> gpu_logging, ::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager> discardable_memory_manager, ::base::UnsafeSharedMemoryRegion use_shader_cache_shm_count, GpuServiceCreationParamsPtr params) final;
  
  void SetRenderParams(::gfx::FontRenderParams::SubpixelRendering subpixel_rendering, float text_contrast, float text_gamma) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  VizMainStubDispatch {
 public:
  static bool Accept(VizMain* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VizMain* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VizMain>>
class VizMainStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VizMainStub() = default;
  ~VizMainStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VizMainStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VizMainStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VizMainRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  GpuServiceCreationParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GpuServiceCreationParams, T>::value>;
  using DataView = GpuServiceCreationParamsDataView;
  using Data_ = internal::GpuServiceCreationParams_Data;

  template <typename... Args>
  static GpuServiceCreationParamsPtr New(Args&&... args) {
    return GpuServiceCreationParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GpuServiceCreationParamsPtr From(const U& u) {
    return mojo::TypeConverter<GpuServiceCreationParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GpuServiceCreationParams>::Convert(*this);
  }


  GpuServiceCreationParams();

  explicit GpuServiceCreationParams(
      bool supports_overlays);


  ~GpuServiceCreationParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GpuServiceCreationParamsPtr>
  GpuServiceCreationParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GpuServiceCreationParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GpuServiceCreationParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GpuServiceCreationParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GpuServiceCreationParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GpuServiceCreationParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GpuServiceCreationParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GpuServiceCreationParams_UnserializedMessageContext<
            UserType, GpuServiceCreationParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GpuServiceCreationParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GpuServiceCreationParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GpuServiceCreationParams_UnserializedMessageContext<
            UserType, GpuServiceCreationParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GpuServiceCreationParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool supports_overlays;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GpuServiceCreationParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GpuServiceCreationParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GpuServiceCreationParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GpuServiceCreationParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  FrameSinkManagerParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameSinkManagerParams, T>::value>;
  using DataView = FrameSinkManagerParamsDataView;
  using Data_ = internal::FrameSinkManagerParams_Data;

  template <typename... Args>
  static FrameSinkManagerParamsPtr New(Args&&... args) {
    return FrameSinkManagerParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameSinkManagerParamsPtr From(const U& u) {
    return mojo::TypeConverter<FrameSinkManagerParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameSinkManagerParams>::Convert(*this);
  }


  FrameSinkManagerParams();

  FrameSinkManagerParams(
      uint32_t restart_id,
      bool use_activation_deadline,
      uint32_t activation_deadline_in_frames,
      ::mojo::PendingReceiver<::viz::mojom::FrameSinkManager> frame_sink_manager,
      ::mojo::PendingRemote<::viz::mojom::FrameSinkManagerClient> frame_sink_manager_client,
      const ::viz::DebugRendererSettings& debug_renderer_settings);

FrameSinkManagerParams(const FrameSinkManagerParams&) = delete;
FrameSinkManagerParams& operator=(const FrameSinkManagerParams&) = delete;

  ~FrameSinkManagerParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameSinkManagerParamsPtr>
  FrameSinkManagerParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameSinkManagerParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameSinkManagerParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameSinkManagerParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameSinkManagerParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameSinkManagerParams_UnserializedMessageContext<
            UserType, FrameSinkManagerParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameSinkManagerParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameSinkManagerParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameSinkManagerParams_UnserializedMessageContext<
            UserType, FrameSinkManagerParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameSinkManagerParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t restart_id;
  
  bool use_activation_deadline;
  
  uint32_t activation_deadline_in_frames;
  
  ::mojo::PendingReceiver<::viz::mojom::FrameSinkManager> frame_sink_manager;
  
  ::mojo::PendingRemote<::viz::mojom::FrameSinkManagerClient> frame_sink_manager_client;
  
  ::viz::DebugRendererSettings debug_renderer_settings;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameSinkManagerParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameSinkManagerParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameSinkManagerParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameSinkManagerParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
FrameSinkManagerParamsPtr FrameSinkManagerParams::Clone() const {
  return New(
      mojo::Clone(restart_id),
      mojo::Clone(use_activation_deadline),
      mojo::Clone(activation_deadline_in_frames),
      mojo::Clone(frame_sink_manager),
      mojo::Clone(frame_sink_manager_client),
      mojo::Clone(debug_renderer_settings)
  );
}

template <typename T, FrameSinkManagerParams::EnableIfSame<T>*>
bool FrameSinkManagerParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->restart_id, other_struct.restart_id))
    return false;
  if (!mojo::Equals(this->use_activation_deadline, other_struct.use_activation_deadline))
    return false;
  if (!mojo::Equals(this->activation_deadline_in_frames, other_struct.activation_deadline_in_frames))
    return false;
  if (!mojo::Equals(this->frame_sink_manager, other_struct.frame_sink_manager))
    return false;
  if (!mojo::Equals(this->frame_sink_manager_client, other_struct.frame_sink_manager_client))
    return false;
  if (!mojo::Equals(this->debug_renderer_settings, other_struct.debug_renderer_settings))
    return false;
  return true;
}

template <typename T, FrameSinkManagerParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.restart_id < rhs.restart_id)
    return true;
  if (rhs.restart_id < lhs.restart_id)
    return false;
  if (lhs.use_activation_deadline < rhs.use_activation_deadline)
    return true;
  if (rhs.use_activation_deadline < lhs.use_activation_deadline)
    return false;
  if (lhs.activation_deadline_in_frames < rhs.activation_deadline_in_frames)
    return true;
  if (rhs.activation_deadline_in_frames < lhs.activation_deadline_in_frames)
    return false;
  if (lhs.frame_sink_manager < rhs.frame_sink_manager)
    return true;
  if (rhs.frame_sink_manager < lhs.frame_sink_manager)
    return false;
  if (lhs.frame_sink_manager_client < rhs.frame_sink_manager_client)
    return true;
  if (rhs.frame_sink_manager_client < lhs.frame_sink_manager_client)
    return false;
  if (lhs.debug_renderer_settings < rhs.debug_renderer_settings)
    return true;
  if (rhs.debug_renderer_settings < lhs.debug_renderer_settings)
    return false;
  return false;
}
template <typename StructPtrType>
GpuServiceCreationParamsPtr GpuServiceCreationParams::Clone() const {
  return New(
      mojo::Clone(supports_overlays)
  );
}

template <typename T, GpuServiceCreationParams::EnableIfSame<T>*>
bool GpuServiceCreationParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->supports_overlays, other_struct.supports_overlays))
    return false;
  return true;
}

template <typename T, GpuServiceCreationParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.supports_overlays < rhs.supports_overlays)
    return true;
  if (rhs.supports_overlays < lhs.supports_overlays)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::FrameSinkManagerParams::DataView,
                                         ::viz::mojom::FrameSinkManagerParamsPtr> {
  static bool IsNull(const ::viz::mojom::FrameSinkManagerParamsPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::FrameSinkManagerParamsPtr* output) { output->reset(); }

  static decltype(::viz::mojom::FrameSinkManagerParams::restart_id) restart_id(
      const ::viz::mojom::FrameSinkManagerParamsPtr& input) {
    return input->restart_id;
  }

  static decltype(::viz::mojom::FrameSinkManagerParams::use_activation_deadline) use_activation_deadline(
      const ::viz::mojom::FrameSinkManagerParamsPtr& input) {
    return input->use_activation_deadline;
  }

  static decltype(::viz::mojom::FrameSinkManagerParams::activation_deadline_in_frames) activation_deadline_in_frames(
      const ::viz::mojom::FrameSinkManagerParamsPtr& input) {
    return input->activation_deadline_in_frames;
  }

  static  decltype(::viz::mojom::FrameSinkManagerParams::frame_sink_manager)& frame_sink_manager(
       ::viz::mojom::FrameSinkManagerParamsPtr& input) {
    return input->frame_sink_manager;
  }

  static  decltype(::viz::mojom::FrameSinkManagerParams::frame_sink_manager_client)& frame_sink_manager_client(
       ::viz::mojom::FrameSinkManagerParamsPtr& input) {
    return input->frame_sink_manager_client;
  }

  static const decltype(::viz::mojom::FrameSinkManagerParams::debug_renderer_settings)& debug_renderer_settings(
      const ::viz::mojom::FrameSinkManagerParamsPtr& input) {
    return input->debug_renderer_settings;
  }

  static bool Read(::viz::mojom::FrameSinkManagerParams::DataView input, ::viz::mojom::FrameSinkManagerParamsPtr* output);
};


template <>
struct  StructTraits<::viz::mojom::GpuServiceCreationParams::DataView,
                                         ::viz::mojom::GpuServiceCreationParamsPtr> {
  static bool IsNull(const ::viz::mojom::GpuServiceCreationParamsPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::GpuServiceCreationParamsPtr* output) { output->reset(); }

  static decltype(::viz::mojom::GpuServiceCreationParams::supports_overlays) supports_overlays(
      const ::viz::mojom::GpuServiceCreationParamsPtr& input) {
    return input->supports_overlays;
  }

  static bool Read(::viz::mojom::GpuServiceCreationParams::DataView input, ::viz::mojom::GpuServiceCreationParamsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_H_