// services/viz/public/mojom/compositing/compositor_frame_sink.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-forward.h"
#include "mojo/public/mojom/base/shared_memory.mojom-forward.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom.h"
#include "services/viz/public/mojom/compositing/compositor_frame.mojom-forward.h"
#include "services/viz/public/mojom/compositing/layer_context.mojom-forward.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom.h"
#include "services/viz/public/mojom/compositing/frame_timing_details.mojom.h"
#include "services/viz/public/mojom/compositing/returned_resource.mojom.h"
#include "services/viz/public/mojom/compositing/thread.mojom-forward.h"
#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"




namespace viz { class CompositorFrame; }


namespace viz::mojom {

class CompositorFrameSinkProxy;

template <typename ImplRefTraits>
class CompositorFrameSinkStub;

class CompositorFrameSinkRequestValidator;


class CompositorFrameSink
    : public CompositorFrameSinkInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.CompositorFrameSink";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CompositorFrameSinkInterfaceBase;
  using Proxy_ = CompositorFrameSinkProxy;

  template <typename ImplRefTraits>
  using Stub_ = CompositorFrameSinkStub<ImplRefTraits>;

  using RequestValidator_ = CompositorFrameSinkRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetNeedsBeginFrameMinVersion = 0,
    kSetWantsAnimateOnlyBeginFramesMinVersion = 0,
    kSetAutoNeedsBeginFrameMinVersion = 0,
    kSubmitCompositorFrameMinVersion = 0,
    kDidNotProduceFrameMinVersion = 0,
    kNotifyNewLocalSurfaceIdExpectedWhilePausedMinVersion = 0,
    kBindLayerContextMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetNeedsBeginFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetWantsAnimateOnlyBeginFrames_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAutoNeedsBeginFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SubmitCompositorFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidNotProduceFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyNewLocalSurfaceIdExpectedWhilePaused_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindLayerContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CompositorFrameSink() = default;

  virtual void SetNeedsBeginFrame(bool needs_begin_frame) = 0;

  virtual void SetWantsAnimateOnlyBeginFrames() = 0;

  virtual void SetAutoNeedsBeginFrame() = 0;

  virtual void SubmitCompositorFrame(const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, std::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time) = 0;

  virtual void DidNotProduceFrame(const ::viz::BeginFrameAck& ack) = 0;

  virtual void NotifyNewLocalSurfaceIdExpectedWhilePaused() = 0;

  virtual void BindLayerContext(::viz::mojom::PendingLayerContextPtr context, LayerContextSettingsPtr settings) = 0;
};

class CompositorFrameSinkClientProxy;

template <typename ImplRefTraits>
class CompositorFrameSinkClientStub;

class CompositorFrameSinkClientRequestValidator;


class CompositorFrameSinkClient
    : public CompositorFrameSinkClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.CompositorFrameSinkClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CompositorFrameSinkClientInterfaceBase;
  using Proxy_ = CompositorFrameSinkClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = CompositorFrameSinkClientStub<ImplRefTraits>;

  using RequestValidator_ = CompositorFrameSinkClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDidReceiveCompositorFrameAckMinVersion = 0,
    kOnBeginFrameMinVersion = 0,
    kOnBeginFramePausedChangedMinVersion = 0,
    kReclaimResourcesMinVersion = 0,
    kOnCompositorFrameTransitionDirectiveProcessedMinVersion = 0,
    kOnSurfaceEvictedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DidReceiveCompositorFrameAck_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBeginFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBeginFramePausedChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReclaimResources_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCompositorFrameTransitionDirectiveProcessed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSurfaceEvicted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CompositorFrameSinkClient() = default;

  virtual void DidReceiveCompositorFrameAck(std::vector<::viz::ReturnedResource> resources) = 0;

  virtual void OnBeginFrame(const ::viz::BeginFrameArgs& args, const base::flat_map<uint32_t, ::viz::FrameTimingDetails>& details, std::vector<::viz::ReturnedResource> resources) = 0;

  virtual void OnBeginFramePausedChanged(bool paused) = 0;

  virtual void ReclaimResources(std::vector<::viz::ReturnedResource> resources) = 0;

  virtual void OnCompositorFrameTransitionDirectiveProcessed(uint32_t sequence_id) = 0;

  virtual void OnSurfaceEvicted(const ::viz::LocalSurfaceId& local_surface_id) = 0;
};



class  CompositorFrameSinkProxy
    : public CompositorFrameSink {
 public:
  using InterfaceType = CompositorFrameSink;

  explicit CompositorFrameSinkProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetNeedsBeginFrame(bool needs_begin_frame) final;
  
  void SetWantsAnimateOnlyBeginFrames() final;
  
  void SetAutoNeedsBeginFrame() final;
  
  void SubmitCompositorFrame(const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, std::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time) final;
  
  void DidNotProduceFrame(const ::viz::BeginFrameAck& ack) final;
  
  void NotifyNewLocalSurfaceIdExpectedWhilePaused() final;
  
  void BindLayerContext(::viz::mojom::PendingLayerContextPtr context, LayerContextSettingsPtr settings) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
  mojo::internal::MessageSizeEstimator size_estimator_;
};



class  CompositorFrameSinkClientProxy
    : public CompositorFrameSinkClient {
 public:
  using InterfaceType = CompositorFrameSinkClient;

  explicit CompositorFrameSinkClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidReceiveCompositorFrameAck(std::vector<::viz::ReturnedResource> resources) final;
  
  void OnBeginFrame(const ::viz::BeginFrameArgs& args, const base::flat_map<uint32_t, ::viz::FrameTimingDetails>& details, std::vector<::viz::ReturnedResource> resources) final;
  
  void OnBeginFramePausedChanged(bool paused) final;
  
  void ReclaimResources(std::vector<::viz::ReturnedResource> resources) final;
  
  void OnCompositorFrameTransitionDirectiveProcessed(uint32_t sequence_id) final;
  
  void OnSurfaceEvicted(const ::viz::LocalSurfaceId& local_surface_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CompositorFrameSinkStubDispatch {
 public:
  static bool Accept(CompositorFrameSink* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CompositorFrameSink* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CompositorFrameSink>>
class CompositorFrameSinkStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CompositorFrameSinkStub() = default;
  ~CompositorFrameSinkStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CompositorFrameSinkStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CompositorFrameSinkStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CompositorFrameSinkClientStubDispatch {
 public:
  static bool Accept(CompositorFrameSinkClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CompositorFrameSinkClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CompositorFrameSinkClient>>
class CompositorFrameSinkClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CompositorFrameSinkClientStub() = default;
  ~CompositorFrameSinkClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CompositorFrameSinkClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CompositorFrameSinkClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CompositorFrameSinkRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CompositorFrameSinkClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  LayerContextSettings {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LayerContextSettings, T>::value>;
  using DataView = LayerContextSettingsDataView;
  using Data_ = internal::LayerContextSettings_Data;

  template <typename... Args>
  static LayerContextSettingsPtr New(Args&&... args) {
    return LayerContextSettingsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LayerContextSettingsPtr From(const U& u) {
    return mojo::TypeConverter<LayerContextSettingsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LayerContextSettings>::Convert(*this);
  }


  LayerContextSettings();

  LayerContextSettings(
      bool draw_mode_is_gpu,
      bool enable_edge_anti_aliasing);


  ~LayerContextSettings();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LayerContextSettingsPtr>
  LayerContextSettingsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LayerContextSettings::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LayerContextSettings::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LayerContextSettings::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayerContextSettings::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayerContextSettings::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LayerContextSettings::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LayerContextSettings_UnserializedMessageContext<
            UserType, LayerContextSettings::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LayerContextSettings::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LayerContextSettings::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LayerContextSettings_UnserializedMessageContext<
            UserType, LayerContextSettings::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LayerContextSettings::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool draw_mode_is_gpu;
  
  bool enable_edge_anti_aliasing;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LayerContextSettings::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LayerContextSettings::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LayerContextSettings::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LayerContextSettings::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
LayerContextSettingsPtr LayerContextSettings::Clone() const {
  return New(
      mojo::Clone(draw_mode_is_gpu),
      mojo::Clone(enable_edge_anti_aliasing)
  );
}

template <typename T, LayerContextSettings::EnableIfSame<T>*>
bool LayerContextSettings::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->draw_mode_is_gpu, other_struct.draw_mode_is_gpu))
    return false;
  if (!mojo::Equals(this->enable_edge_anti_aliasing, other_struct.enable_edge_anti_aliasing))
    return false;
  return true;
}

template <typename T, LayerContextSettings::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.draw_mode_is_gpu < rhs.draw_mode_is_gpu)
    return true;
  if (rhs.draw_mode_is_gpu < lhs.draw_mode_is_gpu)
    return false;
  if (lhs.enable_edge_anti_aliasing < rhs.enable_edge_anti_aliasing)
    return true;
  if (rhs.enable_edge_anti_aliasing < lhs.enable_edge_anti_aliasing)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::LayerContextSettings::DataView,
                                         ::viz::mojom::LayerContextSettingsPtr> {
  static bool IsNull(const ::viz::mojom::LayerContextSettingsPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::LayerContextSettingsPtr* output) { output->reset(); }

  static decltype(::viz::mojom::LayerContextSettings::draw_mode_is_gpu) draw_mode_is_gpu(
      const ::viz::mojom::LayerContextSettingsPtr& input) {
    return input->draw_mode_is_gpu;
  }

  static decltype(::viz::mojom::LayerContextSettings::enable_edge_anti_aliasing) enable_edge_anti_aliasing(
      const ::viz::mojom::LayerContextSettingsPtr& input) {
    return input->enable_edge_anti_aliasing;
  }

  static bool Read(::viz::mojom::LayerContextSettings::DataView input, ::viz::mojom::LayerContextSettingsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_H_