// services/viz/public/mojom/compositing/filter_operation.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FILTER_OPERATION_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FILTER_OPERATION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/viz/public/mojom/compositing/filter_operation.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/paint_filter.mojom-shared.h"
#include "skia/public/mojom/tile_mode.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace viz::mojom {
class FilterOperationDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::FilterOperationDataView> {
  using Data = ::viz::mojom::internal::FilterOperation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class FilterType : int32_t {
  
  GRAYSCALE = 0,
  
  SEPIA = 1,
  
  SATURATE = 2,
  
  HUE_ROTATE = 3,
  
  INVERT = 4,
  
  BRIGHTNESS = 5,
  
  CONTRAST = 6,
  
  OPACITY = 7,
  
  BLUR = 8,
  
  DROP_SHADOW = 9,
  
  COLOR_MATRIX = 10,
  
  ZOOM = 11,
  
  REFERENCE = 12,
  
  SATURATING_BRIGHTNESS = 13,
  
  ALPHA_THRESHOLD = 14,
  
  OFFSET = 15,
  
  FILTER_TYPE_LAST = 15,
  kMinValue = 0,
  kMaxValue = 15,
};

 std::ostream& operator<<(std::ostream& os, FilterType value);
inline bool IsKnownEnumValue(FilterType value) {
  return internal::FilterType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class FilterOperationDataView {
 public:
  FilterOperationDataView() = default;

  FilterOperationDataView(
      internal::FilterOperation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::viz::mojom::FilterType>(
        data_value, output);
  }
  FilterType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::FilterType>(data_->type));
  }
  float amount() const {
    return data_->amount;
  }
  inline void GetOffsetDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOffset(UserType* output) {
    
    auto* pointer = data_->offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  inline void GetDropShadowColorDataView(
      ::skia::mojom::SkColor4fDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDropShadowColor(UserType* output) {
    
    auto* pointer = data_->drop_shadow_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        pointer, output, message_);
  }
  inline void GetImageFilterDataView(
      ::viz::mojom::PaintFilterDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageFilter(UserType* output) {
    
    auto* pointer = data_->image_filter.Get();
    return mojo::internal::Deserialize<::viz::mojom::PaintFilterDataView>(
        pointer, output, message_);
  }
  inline void GetMatrixDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMatrix(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<float>, UserType>(),
    "Attempting to read the optional `matrix` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMatrix` instead "
    "of `ReadMatrix if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->matrix.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
  int32_t zoom_inset() const {
    return data_->zoom_inset;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadBlurTileMode(UserType* output) const {
    auto data_value = data_->blur_tile_mode;
    return mojo::internal::Deserialize<::skia::mojom::TileMode>(
        data_value, output);
  }
  ::skia::mojom::TileMode blur_tile_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::skia::mojom::TileMode>(data_->blur_tile_mode));
  }
  inline void GetShapeDataView(
      mojo::ArrayDataView<::gfx::mojom::RectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShape(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::gfx::mojom::RectDataView>, UserType>(),
    "Attempting to read the optional `shape` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShape` instead "
    "of `ReadShape if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shape.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
        pointer, output, message_);
  }
 private:
  internal::FilterOperation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FILTER_OPERATION_MOJOM_DATA_VIEW_H_