// services/viz/public/mojom/compositing/filter_operation.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FILTER_OPERATION_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FILTER_OPERATION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/filter_operation.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/filter_operation.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/filter_operation.mojom-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/paint_filter.mojom.h"
#include "skia/public/mojom/tile_mode.mojom.h"
#include "skia/public/mojom/skcolor4f.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>




#include "services/viz/public/cpp/compositing/filter_operation_mojom_traits.h"




namespace viz::mojom {








class  FilterOperation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FilterOperation, T>::value>;
  using DataView = FilterOperationDataView;
  using Data_ = internal::FilterOperation_Data;

  template <typename... Args>
  static FilterOperationPtr New(Args&&... args) {
    return FilterOperationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FilterOperationPtr From(const U& u) {
    return mojo::TypeConverter<FilterOperationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FilterOperation>::Convert(*this);
  }


  FilterOperation();

  FilterOperation(
      FilterType type,
      float amount,
      const ::gfx::Point& offset,
      const ::SkColor4f& drop_shadow_color,
      const ::sk_sp<::cc::PaintFilter>& image_filter,
      std::optional<std::vector<float>> matrix,
      int32_t zoom_inset,
      ::SkTileMode blur_tile_mode,
      std::optional<std::vector<::gfx::Rect>> shape);


  ~FilterOperation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FilterOperationPtr>
  FilterOperationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FilterOperation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FilterOperation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FilterOperation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FilterOperation::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FilterOperation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FilterOperation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FilterOperation_UnserializedMessageContext<
            UserType, FilterOperation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FilterOperation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FilterOperation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FilterOperation_UnserializedMessageContext<
            UserType, FilterOperation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FilterOperation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  FilterType type;
  
  float amount;
  
  ::gfx::Point offset;
  
  ::SkColor4f drop_shadow_color;
  
  ::sk_sp<::cc::PaintFilter> image_filter;
  
  std::optional<std::vector<float>> matrix;
  
  int32_t zoom_inset;
  
  ::SkTileMode blur_tile_mode;
  
  std::optional<std::vector<::gfx::Rect>> shape;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FilterOperation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FilterOperation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FilterOperation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FilterOperation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FilterOperationPtr FilterOperation::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(amount),
      mojo::Clone(offset),
      mojo::Clone(drop_shadow_color),
      mojo::Clone(image_filter),
      mojo::Clone(matrix),
      mojo::Clone(zoom_inset),
      mojo::Clone(blur_tile_mode),
      mojo::Clone(shape)
  );
}

template <typename T, FilterOperation::EnableIfSame<T>*>
bool FilterOperation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->amount, other_struct.amount))
    return false;
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->drop_shadow_color, other_struct.drop_shadow_color))
    return false;
  if (!mojo::Equals(this->image_filter, other_struct.image_filter))
    return false;
  if (!mojo::Equals(this->matrix, other_struct.matrix))
    return false;
  if (!mojo::Equals(this->zoom_inset, other_struct.zoom_inset))
    return false;
  if (!mojo::Equals(this->blur_tile_mode, other_struct.blur_tile_mode))
    return false;
  if (!mojo::Equals(this->shape, other_struct.shape))
    return false;
  return true;
}

template <typename T, FilterOperation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.amount < rhs.amount)
    return true;
  if (rhs.amount < lhs.amount)
    return false;
  if (lhs.offset < rhs.offset)
    return true;
  if (rhs.offset < lhs.offset)
    return false;
  if (lhs.drop_shadow_color < rhs.drop_shadow_color)
    return true;
  if (rhs.drop_shadow_color < lhs.drop_shadow_color)
    return false;
  if (lhs.image_filter < rhs.image_filter)
    return true;
  if (rhs.image_filter < lhs.image_filter)
    return false;
  if (lhs.matrix < rhs.matrix)
    return true;
  if (rhs.matrix < lhs.matrix)
    return false;
  if (lhs.zoom_inset < rhs.zoom_inset)
    return true;
  if (rhs.zoom_inset < lhs.zoom_inset)
    return false;
  if (lhs.blur_tile_mode < rhs.blur_tile_mode)
    return true;
  if (rhs.blur_tile_mode < lhs.blur_tile_mode)
    return false;
  if (lhs.shape < rhs.shape)
    return true;
  if (rhs.shape < lhs.shape)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::FilterOperation::DataView,
                                         ::viz::mojom::FilterOperationPtr> {
  static bool IsNull(const ::viz::mojom::FilterOperationPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::FilterOperationPtr* output) { output->reset(); }

  static decltype(::viz::mojom::FilterOperation::type) type(
      const ::viz::mojom::FilterOperationPtr& input) {
    return input->type;
  }

  static decltype(::viz::mojom::FilterOperation::amount) amount(
      const ::viz::mojom::FilterOperationPtr& input) {
    return input->amount;
  }

  static const decltype(::viz::mojom::FilterOperation::offset)& offset(
      const ::viz::mojom::FilterOperationPtr& input) {
    return input->offset;
  }

  static const decltype(::viz::mojom::FilterOperation::drop_shadow_color)& drop_shadow_color(
      const ::viz::mojom::FilterOperationPtr& input) {
    return input->drop_shadow_color;
  }

  static const decltype(::viz::mojom::FilterOperation::image_filter)& image_filter(
      const ::viz::mojom::FilterOperationPtr& input) {
    return input->image_filter;
  }

  static const decltype(::viz::mojom::FilterOperation::matrix)& matrix(
      const ::viz::mojom::FilterOperationPtr& input) {
    return input->matrix;
  }

  static decltype(::viz::mojom::FilterOperation::zoom_inset) zoom_inset(
      const ::viz::mojom::FilterOperationPtr& input) {
    return input->zoom_inset;
  }

  static decltype(::viz::mojom::FilterOperation::blur_tile_mode) blur_tile_mode(
      const ::viz::mojom::FilterOperationPtr& input) {
    return input->blur_tile_mode;
  }

  static const decltype(::viz::mojom::FilterOperation::shape)& shape(
      const ::viz::mojom::FilterOperationPtr& input) {
    return input->shape;
  }

  static bool Read(::viz::mojom::FilterOperation::DataView input, ::viz::mojom::FilterOperationPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FILTER_OPERATION_MOJOM_H_