// services/viz/public/mojom/compositing/local_surface_id.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LOCAL_SURFACE_ID_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LOCAL_SURFACE_ID_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/local_surface_id.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include <string>
#include <vector>




#include "services/viz/public/cpp/compositing/local_surface_id_mojom_traits.h"




namespace viz::mojom {








class  LocalSurfaceId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LocalSurfaceId, T>::value>;
  using DataView = LocalSurfaceIdDataView;
  using Data_ = internal::LocalSurfaceId_Data;

  template <typename... Args>
  static LocalSurfaceIdPtr New(Args&&... args) {
    return LocalSurfaceIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LocalSurfaceIdPtr From(const U& u) {
    return mojo::TypeConverter<LocalSurfaceIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LocalSurfaceId>::Convert(*this);
  }


  LocalSurfaceId();

  LocalSurfaceId(
      uint32_t parent_sequence_number,
      uint32_t child_sequence_number,
      const ::base::UnguessableToken& embed_token);


  ~LocalSurfaceId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LocalSurfaceIdPtr>
  LocalSurfaceIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LocalSurfaceId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LocalSurfaceId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LocalSurfaceId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LocalSurfaceId::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LocalSurfaceId::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LocalSurfaceId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LocalSurfaceId_UnserializedMessageContext<
            UserType, LocalSurfaceId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LocalSurfaceId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LocalSurfaceId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LocalSurfaceId_UnserializedMessageContext<
            UserType, LocalSurfaceId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LocalSurfaceId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t parent_sequence_number;
  
  uint32_t child_sequence_number;
  
  ::base::UnguessableToken embed_token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LocalSurfaceId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LocalSurfaceId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LocalSurfaceId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LocalSurfaceId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LocalSurfaceIdPtr LocalSurfaceId::Clone() const {
  return New(
      mojo::Clone(parent_sequence_number),
      mojo::Clone(child_sequence_number),
      mojo::Clone(embed_token)
  );
}

template <typename T, LocalSurfaceId::EnableIfSame<T>*>
bool LocalSurfaceId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->parent_sequence_number, other_struct.parent_sequence_number))
    return false;
  if (!mojo::Equals(this->child_sequence_number, other_struct.child_sequence_number))
    return false;
  if (!mojo::Equals(this->embed_token, other_struct.embed_token))
    return false;
  return true;
}

template <typename T, LocalSurfaceId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.parent_sequence_number < rhs.parent_sequence_number)
    return true;
  if (rhs.parent_sequence_number < lhs.parent_sequence_number)
    return false;
  if (lhs.child_sequence_number < rhs.child_sequence_number)
    return true;
  if (rhs.child_sequence_number < lhs.child_sequence_number)
    return false;
  if (lhs.embed_token < rhs.embed_token)
    return true;
  if (rhs.embed_token < lhs.embed_token)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::LocalSurfaceId::DataView,
                                         ::viz::mojom::LocalSurfaceIdPtr> {
  static bool IsNull(const ::viz::mojom::LocalSurfaceIdPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::LocalSurfaceIdPtr* output) { output->reset(); }

  static decltype(::viz::mojom::LocalSurfaceId::parent_sequence_number) parent_sequence_number(
      const ::viz::mojom::LocalSurfaceIdPtr& input) {
    return input->parent_sequence_number;
  }

  static decltype(::viz::mojom::LocalSurfaceId::child_sequence_number) child_sequence_number(
      const ::viz::mojom::LocalSurfaceIdPtr& input) {
    return input->child_sequence_number;
  }

  static const decltype(::viz::mojom::LocalSurfaceId::embed_token)& embed_token(
      const ::viz::mojom::LocalSurfaceIdPtr& input) {
    return input->embed_token;
  }

  static bool Read(::viz::mojom::LocalSurfaceId::DataView input, ::viz::mojom::LocalSurfaceIdPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LOCAL_SURFACE_ID_MOJOM_H_