// services/viz/public/mojom/compositing/tiling.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TILING_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TILING_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/tiling.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/tiling.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/tiling.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-blink.h"
#include "skia/public/mojom/skcolor4f.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "cc/mojom/missing_tile_reason.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {








class BLINK_PLATFORM_EXPORT TileContents {
 public:
  using DataView = TileContentsDataView;
  using Data_ = internal::TileContents_Data;
  using Tag = Data_::TileContents_Tag;

  template <typename... Args>
  static TileContentsPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |missing_reason|.
  static TileContentsPtr NewMissingReason(
      ::cc::mojom::blink::MissingTileReason value);
  // Construct an instance holding |resource|.
  static TileContentsPtr NewResource(
      TileResourcePtr value);
  // Construct an instance holding |solid_color|.
  static TileContentsPtr NewSolidColor(
      const ::SkColor4f& value);

  template <typename U>
  static TileContentsPtr From(const U& u) {
    return mojo::TypeConverter<TileContentsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TileContents>::Convert(*this);
  }
  ~TileContents();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  TileContents(const TileContents& other) = delete;
  TileContents& operator=(const TileContents& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = TileContentsPtr>
  TileContentsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, TileContents>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, TileContents>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_missing_reason() const { return tag_ == Tag::kMissingReason; }
  ::cc::mojom::blink::MissingTileReason get_missing_reason() const {
    CHECK(tag_ == Tag::kMissingReason);
    return data_.missing_reason;
  }
  void set_missing_reason(::cc::mojom::blink::MissingTileReason missing_reason);

  bool is_resource() const { return tag_ == Tag::kResource; }
  const TileResourcePtr& get_resource() const {
    CHECK(tag_ == Tag::kResource);
    return data_.resource;
  }
  TileResourcePtr& get_resource() {
    CHECK(tag_ == Tag::kResource);
    return data_.resource;
  }
  void set_resource(TileResourcePtr resource);

  bool is_solid_color() const { return tag_ == Tag::kSolidColor; }
  const ::SkColor4f& get_solid_color() const {
    CHECK(tag_ == Tag::kSolidColor);
    return data_.solid_color;
  }
  ::SkColor4f& get_solid_color() {
    CHECK(tag_ == Tag::kSolidColor);
    return data_.solid_color;
  }
  void set_solid_color(const ::SkColor4f& solid_color);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TileContents::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<TileContents::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kMissingReason)>,
        ::cc::mojom::blink::MissingTileReason value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kResource)>,
        TileResourcePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSolidColor)>,
        const ::SkColor4f& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::cc::mojom::blink::MissingTileReason missing_reason;
    TileResourcePtr resource;
    ::SkColor4f solid_color;
  };

  TileContents(
      std::in_place_index_t<static_cast<size_t>(Tag::kMissingReason)>,
      ::cc::mojom::blink::MissingTileReason value);
  TileContents(
      std::in_place_index_t<static_cast<size_t>(Tag::kResource)>,
      TileResourcePtr value);
  TileContents(
      std::in_place_index_t<static_cast<size_t>(Tag::kSolidColor)>,
      const ::SkColor4f& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_PLATFORM_EXPORT TileResource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TileResource, T>::value>;
  using DataView = TileResourceDataView;
  using Data_ = internal::TileResource_Data;

  template <typename... Args>
  static TileResourcePtr New(Args&&... args) {
    return TileResourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TileResourcePtr From(const U& u) {
    return mojo::TypeConverter<TileResourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TileResource>::Convert(*this);
  }


  TileResource();

  TileResource(
      ::viz::mojom::blink::TransferableResourcePtr resource,
      bool is_checkered);

TileResource(const TileResource&) = delete;
TileResource& operator=(const TileResource&) = delete;

  ~TileResource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TileResourcePtr>
  TileResourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TileResource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TileResource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TileResource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TileResource::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TileResource::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TileResource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TileResource_UnserializedMessageContext<
            UserType, TileResource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TileResource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TileResource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TileResource_UnserializedMessageContext<
            UserType, TileResource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TileResource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::mojom::blink::TransferableResourcePtr resource;
  
  bool is_checkered;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TileResource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TileResource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TileResource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TileResource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT Tile {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Tile, T>::value>;
  using DataView = TileDataView;
  using Data_ = internal::Tile_Data;

  template <typename... Args>
  static TilePtr New(Args&&... args) {
    return TilePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TilePtr From(const U& u) {
    return mojo::TypeConverter<TilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Tile>::Convert(*this);
  }


  Tile();

  Tile(
      uint32_t column_index,
      uint32_t row_index,
      TileContentsPtr contents);

Tile(const Tile&) = delete;
Tile& operator=(const Tile&) = delete;

  ~Tile();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TilePtr>
  TilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Tile::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Tile::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Tile::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tile::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tile::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Tile::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Tile_UnserializedMessageContext<
            UserType, Tile::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Tile::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Tile::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Tile_UnserializedMessageContext<
            UserType, Tile::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Tile::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t column_index;
  
  uint32_t row_index;
  
  TileContentsPtr contents;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Tile::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Tile::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Tile::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Tile::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT Tiling {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Tiling, T>::value>;
  using DataView = TilingDataView;
  using Data_ = internal::Tiling_Data;

  template <typename... Args>
  static TilingPtr New(Args&&... args) {
    return TilingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TilingPtr From(const U& u) {
    return mojo::TypeConverter<TilingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Tiling>::Convert(*this);
  }


  Tiling();

  Tiling(
      int64_t layer_id,
      const ::gfx::Vector2dF& raster_translation,
      const ::gfx::Vector2dF& raster_scale,
      const ::gfx::Size& tile_size,
      const ::gfx::Rect& tiling_rect,
      ::blink::Vector<TilePtr> tiles,
      float scale_key,
      bool is_deleted);

Tiling(const Tiling&) = delete;
Tiling& operator=(const Tiling&) = delete;

  ~Tiling();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TilingPtr>
  TilingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Tiling::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Tiling::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Tiling::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tiling::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tiling::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Tiling::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Tiling_UnserializedMessageContext<
            UserType, Tiling::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Tiling::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Tiling::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Tiling_UnserializedMessageContext<
            UserType, Tiling::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Tiling::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t layer_id;
  
  ::gfx::Vector2dF raster_translation;
  
  ::gfx::Vector2dF raster_scale;
  
  ::gfx::Size tile_size;
  
  ::gfx::Rect tiling_rect;
  
  ::blink::Vector<TilePtr> tiles;
  
  float scale_key;
  
  bool is_deleted;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Tiling::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Tiling::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Tiling::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Tiling::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
TileContentsPtr TileContents::Clone() const {
  switch (tag_) {
    case Tag::kMissingReason:
      return NewMissingReason(
          mojo::Clone(data_.missing_reason));
    case Tag::kResource:
      return NewResource(
          mojo::Clone(data_.resource));
    case Tag::kSolidColor:
      return NewSolidColor(
          mojo::Clone(data_.solid_color));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, TileContents>::value>::type*>
bool TileContents::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kMissingReason:
      return mojo::Equals(data_.missing_reason, other.data_.missing_reason);
    case Tag::kResource:
      return mojo::Equals(data_.resource, other.data_.resource);
    case Tag::kSolidColor:
      return mojo::Equals(data_.solid_color, other.data_.solid_color);
  }

  return false;
}
template <typename StructPtrType>
TileResourcePtr TileResource::Clone() const {
  return New(
      mojo::Clone(resource),
      mojo::Clone(is_checkered)
  );
}

template <typename T, TileResource::EnableIfSame<T>*>
bool TileResource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->resource, other_struct.resource))
    return false;
  if (!mojo::Equals(this->is_checkered, other_struct.is_checkered))
    return false;
  return true;
}

template <typename T, TileResource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.resource < rhs.resource)
    return true;
  if (rhs.resource < lhs.resource)
    return false;
  if (lhs.is_checkered < rhs.is_checkered)
    return true;
  if (rhs.is_checkered < lhs.is_checkered)
    return false;
  return false;
}
template <typename StructPtrType>
TilePtr Tile::Clone() const {
  return New(
      mojo::Clone(column_index),
      mojo::Clone(row_index),
      mojo::Clone(contents)
  );
}

template <typename T, Tile::EnableIfSame<T>*>
bool Tile::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->column_index, other_struct.column_index))
    return false;
  if (!mojo::Equals(this->row_index, other_struct.row_index))
    return false;
  if (!mojo::Equals(this->contents, other_struct.contents))
    return false;
  return true;
}

template <typename T, Tile::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.column_index < rhs.column_index)
    return true;
  if (rhs.column_index < lhs.column_index)
    return false;
  if (lhs.row_index < rhs.row_index)
    return true;
  if (rhs.row_index < lhs.row_index)
    return false;
  if (lhs.contents < rhs.contents)
    return true;
  if (rhs.contents < lhs.contents)
    return false;
  return false;
}
template <typename StructPtrType>
TilingPtr Tiling::Clone() const {
  return New(
      mojo::Clone(layer_id),
      mojo::Clone(raster_translation),
      mojo::Clone(raster_scale),
      mojo::Clone(tile_size),
      mojo::Clone(tiling_rect),
      mojo::Clone(tiles),
      mojo::Clone(scale_key),
      mojo::Clone(is_deleted)
  );
}

template <typename T, Tiling::EnableIfSame<T>*>
bool Tiling::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->layer_id, other_struct.layer_id))
    return false;
  if (!mojo::Equals(this->raster_translation, other_struct.raster_translation))
    return false;
  if (!mojo::Equals(this->raster_scale, other_struct.raster_scale))
    return false;
  if (!mojo::Equals(this->tile_size, other_struct.tile_size))
    return false;
  if (!mojo::Equals(this->tiling_rect, other_struct.tiling_rect))
    return false;
  if (!mojo::Equals(this->tiles, other_struct.tiles))
    return false;
  if (!mojo::Equals(this->scale_key, other_struct.scale_key))
    return false;
  if (!mojo::Equals(this->is_deleted, other_struct.is_deleted))
    return false;
  return true;
}

template <typename T, Tiling::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.layer_id < rhs.layer_id)
    return true;
  if (rhs.layer_id < lhs.layer_id)
    return false;
  if (lhs.raster_translation < rhs.raster_translation)
    return true;
  if (rhs.raster_translation < lhs.raster_translation)
    return false;
  if (lhs.raster_scale < rhs.raster_scale)
    return true;
  if (rhs.raster_scale < lhs.raster_scale)
    return false;
  if (lhs.tile_size < rhs.tile_size)
    return true;
  if (rhs.tile_size < lhs.tile_size)
    return false;
  if (lhs.tiling_rect < rhs.tiling_rect)
    return true;
  if (rhs.tiling_rect < lhs.tiling_rect)
    return false;
  if (lhs.tiles < rhs.tiles)
    return true;
  if (rhs.tiles < lhs.tiles)
    return false;
  if (lhs.scale_key < rhs.scale_key)
    return true;
  if (rhs.scale_key < lhs.scale_key)
    return false;
  if (lhs.is_deleted < rhs.is_deleted)
    return true;
  if (rhs.is_deleted < lhs.is_deleted)
    return false;
  return false;
}


}  // viz::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::TileResource::DataView,
                                         ::viz::mojom::blink::TileResourcePtr> {
  static bool IsNull(const ::viz::mojom::blink::TileResourcePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::TileResourcePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::TileResource::resource)& resource(
      const ::viz::mojom::blink::TileResourcePtr& input) {
    return input->resource;
  }

  static decltype(::viz::mojom::blink::TileResource::is_checkered) is_checkered(
      const ::viz::mojom::blink::TileResourcePtr& input) {
    return input->is_checkered;
  }

  static bool Read(::viz::mojom::blink::TileResource::DataView input, ::viz::mojom::blink::TileResourcePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::Tile::DataView,
                                         ::viz::mojom::blink::TilePtr> {
  static bool IsNull(const ::viz::mojom::blink::TilePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::TilePtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::Tile::column_index) column_index(
      const ::viz::mojom::blink::TilePtr& input) {
    return input->column_index;
  }

  static decltype(::viz::mojom::blink::Tile::row_index) row_index(
      const ::viz::mojom::blink::TilePtr& input) {
    return input->row_index;
  }

  static const decltype(::viz::mojom::blink::Tile::contents)& contents(
      const ::viz::mojom::blink::TilePtr& input) {
    return input->contents;
  }

  static bool Read(::viz::mojom::blink::Tile::DataView input, ::viz::mojom::blink::TilePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::Tiling::DataView,
                                         ::viz::mojom::blink::TilingPtr> {
  static bool IsNull(const ::viz::mojom::blink::TilingPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::TilingPtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::Tiling::layer_id) layer_id(
      const ::viz::mojom::blink::TilingPtr& input) {
    return input->layer_id;
  }

  static const decltype(::viz::mojom::blink::Tiling::raster_translation)& raster_translation(
      const ::viz::mojom::blink::TilingPtr& input) {
    return input->raster_translation;
  }

  static const decltype(::viz::mojom::blink::Tiling::raster_scale)& raster_scale(
      const ::viz::mojom::blink::TilingPtr& input) {
    return input->raster_scale;
  }

  static const decltype(::viz::mojom::blink::Tiling::tile_size)& tile_size(
      const ::viz::mojom::blink::TilingPtr& input) {
    return input->tile_size;
  }

  static const decltype(::viz::mojom::blink::Tiling::tiling_rect)& tiling_rect(
      const ::viz::mojom::blink::TilingPtr& input) {
    return input->tiling_rect;
  }

  static const decltype(::viz::mojom::blink::Tiling::tiles)& tiles(
      const ::viz::mojom::blink::TilingPtr& input) {
    return input->tiles;
  }

  static decltype(::viz::mojom::blink::Tiling::scale_key) scale_key(
      const ::viz::mojom::blink::TilingPtr& input) {
    return input->scale_key;
  }

  static decltype(::viz::mojom::blink::Tiling::is_deleted) is_deleted(
      const ::viz::mojom::blink::TilingPtr& input) {
    return input->is_deleted;
  }

  static bool Read(::viz::mojom::blink::Tiling::DataView input, ::viz::mojom::blink::TilingPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::viz::mojom::blink::TileContents::DataView,
                                        ::viz::mojom::blink::TileContentsPtr> {
  static bool IsNull(const ::viz::mojom::blink::TileContentsPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::TileContentsPtr* output) { output->reset(); }

  static ::viz::mojom::blink::TileContents::Tag GetTag(const ::viz::mojom::blink::TileContentsPtr& input) {
    return input->which();
  }

  static  ::cc::mojom::blink::MissingTileReason missing_reason(const ::viz::mojom::blink::TileContentsPtr& input) {
    return input->get_missing_reason();
  }

  static const ::viz::mojom::blink::TileResourcePtr& resource(const ::viz::mojom::blink::TileContentsPtr& input) {
    return input->get_resource();
  }

  static const ::SkColor4f& solid_color(const ::viz::mojom::blink::TileContentsPtr& input) {
    return input->get_solid_color();
  }

  static bool Read(::viz::mojom::blink::TileContents::DataView input, ::viz::mojom::blink::TileContentsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TILING_MOJOM_BLINK_H_