// storage/browser/quota/quota_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef STORAGE_BROWSER_QUOTA_QUOTA_INTERNALS_MOJOM_SHARED_H_
#define STORAGE_BROWSER_QUOTA_QUOTA_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "storage/browser/quota/quota_internals.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "third_party/blink/public/mojom/quota/quota_types.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "storage/browser/quota/quota_internals.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::BucketTableEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::BucketTableEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::BucketTableEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->bucket_id = Traits::bucket_id(input);

    decltype(Traits::storage_key(input)) in_storage_key = Traits::storage_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->storage_key)::BaseType> storage_key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_storage_key,
      storage_key_fragment);

    fragment->storage_key.Set(
        storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->storage_key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in BucketTableEntry struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in BucketTableEntry struct");

    fragment->usage = Traits::usage(input);

    fragment->use_count = Traits::use_count(input);

    decltype(Traits::last_accessed(input)) in_last_accessed = Traits::last_accessed(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_accessed)::BaseType> last_accessed_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_accessed,
      last_accessed_fragment);

    fragment->last_accessed.Set(
        last_accessed_fragment.is_null() ? nullptr : last_accessed_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_accessed.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_accessed in BucketTableEntry struct");

    decltype(Traits::last_modified(input)) in_last_modified = Traits::last_modified(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_modified)::BaseType> last_modified_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_modified,
      last_modified_fragment);

    fragment->last_modified.Set(
        last_modified_fragment.is_null() ? nullptr : last_modified_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_modified.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_modified in BucketTableEntry struct");
  }

  static bool Deserialize(::storage::mojom::internal::BucketTableEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::BucketTableEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace storage::mojom {

inline void BucketTableEntryDataView::GetStorageKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->storage_key.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BucketTableEntryDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BucketTableEntryDataView::GetLastAccessedDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_accessed.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void BucketTableEntryDataView::GetLastModifiedDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_modified.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}



}  // storage::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // STORAGE_BROWSER_QUOTA_QUOTA_INTERNALS_MOJOM_SHARED_H_