// third_party/blink/public/mojom/mediasession/media_session.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/mediasession/media_session.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/mediasession/media_session.mojom-params-data.h"
#include "third_party/blink/public/mojom/mediasession/media_session.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/mediasession/media_session.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/mediasession/media_session.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
MediaSessionSeekToDetails::MediaSessionSeekToDetails()
    : seek_time(),
      fast_seek() {}

MediaSessionSeekToDetails::MediaSessionSeekToDetails(
    ::base::TimeDelta seek_time_in,
    bool fast_seek_in)
    : seek_time(std::move(seek_time_in)),
      fast_seek(std::move(fast_seek_in)) {}

MediaSessionSeekToDetails::~MediaSessionSeekToDetails() = default;

void MediaSessionSeekToDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seek_time"), this->seek_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fast_seek"), this->fast_seek,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaSessionSeekToDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SpecMediaMetadata::SpecMediaMetadata()
    : title(),
      artist(),
      album(),
      artwork(),
      chapterInfo() {}

SpecMediaMetadata::SpecMediaMetadata(
    const ::blink::String& title_in,
    const ::blink::String& artist_in,
    const ::blink::String& album_in,
    ::blink::Vector<::media_session::mojom::blink::MediaImagePtr> artwork_in,
    ::blink::Vector<::media_session::mojom::blink::ChapterInformationPtr> chapterInfo_in)
    : title(std::move(title_in)),
      artist(std::move(artist_in)),
      album(std::move(album_in)),
      artwork(std::move(artwork_in)),
      chapterInfo(std::move(chapterInfo_in)) {}

SpecMediaMetadata::~SpecMediaMetadata() = default;

void SpecMediaMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "artist"), this->artist,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "album"), this->album,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "artwork"), this->artwork,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::media_session::mojom::blink::MediaImagePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "chapterInfo"), this->chapterInfo,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::media_session::mojom::blink::ChapterInformationPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SpecMediaMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaSessionActionDetailsPtr
MediaSessionActionDetails::NewSeekTo(
    MediaSessionSeekToDetailsPtr value) {
  return MediaSessionActionDetailsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSeekTo)>,
      std::move(value));
}

MediaSessionActionDetails::MediaSessionActionDetails(
    std::in_place_index_t<static_cast<size_t>(Tag::kSeekTo)>,
    MediaSessionSeekToDetailsPtr value)
    : tag_(Tag::kSeekTo),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSeekTo)>,
            std::move(value)) {}
MediaSessionActionDetails::~MediaSessionActionDetails() {
  DestroyActive();
}

void MediaSessionActionDetails::set_seek_to(MediaSessionSeekToDetailsPtr seek_to) {
  if (tag_ == Tag::kSeekTo) {
    data_.seek_to = std::move(seek_to);
  } else {
    DestroyActive();
    tag_ = Tag::kSeekTo;
    new (&data_.seek_to) MediaSessionSeekToDetailsPtr(
        std::move(seek_to));
  }
}


MediaSessionActionDetails::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSeekTo)>,
    MediaSessionSeekToDetailsPtr value)
    : seek_to(std::move(value)) {}

void MediaSessionActionDetails::DestroyActive() {
  switch (tag_) {

    case Tag::kSeekTo:
      std::destroy_at(&data_.seek_to);
      break;
  }
}

bool MediaSessionActionDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

MediaSessionClient::IPCStableHashFunction MediaSessionClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaSessionClient>(message.name())) {
    case messages::MediaSessionClient::kDidReceiveAction: {
      return &MediaSessionClient::DidReceiveAction_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaSessionClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaSessionClient>(message.name())) {
      case messages::MediaSessionClient::kDidReceiveAction:
            return "Receive blink::mojom::MediaSessionClient::DidReceiveAction";
    }
  } else {
    switch (static_cast<messages::MediaSessionClient>(message.name())) {
      case messages::MediaSessionClient::kDidReceiveAction:
            return "Receive reply blink::mojom::MediaSessionClient::DidReceiveAction";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaSessionClient::DidReceiveAction_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3869c56d;  // IPCStableHash for blink::mojom::MediaSessionClient::DidReceiveAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaSessionClientProxy::MediaSessionClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaSessionClientProxy::DidReceiveAction(
    ::media_session::mojom::blink::MediaSessionAction in_action, MediaSessionActionDetailsPtr in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaSessionClient::DidReceiveAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type ::media_session::mojom::blink::MediaSessionAction>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type MediaSessionActionDetailsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSessionClient::kDidReceiveAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaSessionClient_DidReceiveAction_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media_session::mojom::MediaSessionAction>(
    in_action,
    &params->action);
  mojo::internal::MessageFragment<decltype(params->details)>
      details_fragment(params.message());
  details_fragment.Claim(&params->details);
  
  mojo::internal::Serialize<::blink::mojom::MediaSessionActionDetailsDataView>(
    in_details,
    details_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionClient::Name_);
  message.set_method_name("DidReceiveAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaSessionClientStubDispatch::Accept(
    MediaSessionClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaSessionClient>(message->header()->name)) {
    case messages::MediaSessionClient::kDidReceiveAction: {
      DCHECK(message->is_serialized());
      internal::MediaSessionClient_DidReceiveAction_Params_Data* params =
          reinterpret_cast<internal::MediaSessionClient_DidReceiveAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSessionClient.0
      bool success = true;
      ::media_session::mojom::blink::MediaSessionAction p_action{};
      MediaSessionActionDetailsPtr p_details{};
      MediaSessionClient_DidReceiveAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidReceiveAction(        
        std::move(p_action), 
        std::move(p_details));
      return true;
    }
  }
  return false;
}

// static
bool MediaSessionClientStubDispatch::AcceptWithResponder(
    MediaSessionClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaSessionClient>(message->header()->name)) {
    case messages::MediaSessionClient::kDidReceiveAction: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaSessionClientValidationInfo[] = {
    { &internal::MediaSessionClient_DidReceiveAction_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaSessionClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::MediaSessionClient::Name_,
    kMediaSessionClientValidationInfo);
}

// The declaration includes the definition on other builds.

MediaSessionService::IPCStableHashFunction MediaSessionService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaSessionService>(message.name())) {
    case messages::MediaSessionService::kSetClient: {
      return &MediaSessionService::SetClient_Sym::IPCStableHash;
    }
    case messages::MediaSessionService::kSetPlaybackState: {
      return &MediaSessionService::SetPlaybackState_Sym::IPCStableHash;
    }
    case messages::MediaSessionService::kSetPositionState: {
      return &MediaSessionService::SetPositionState_Sym::IPCStableHash;
    }
    case messages::MediaSessionService::kSetMetadata: {
      return &MediaSessionService::SetMetadata_Sym::IPCStableHash;
    }
    case messages::MediaSessionService::kSetMicrophoneState: {
      return &MediaSessionService::SetMicrophoneState_Sym::IPCStableHash;
    }
    case messages::MediaSessionService::kSetCameraState: {
      return &MediaSessionService::SetCameraState_Sym::IPCStableHash;
    }
    case messages::MediaSessionService::kEnableAction: {
      return &MediaSessionService::EnableAction_Sym::IPCStableHash;
    }
    case messages::MediaSessionService::kDisableAction: {
      return &MediaSessionService::DisableAction_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaSessionService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaSessionService>(message.name())) {
      case messages::MediaSessionService::kSetClient:
            return "Receive blink::mojom::MediaSessionService::SetClient";
      case messages::MediaSessionService::kSetPlaybackState:
            return "Receive blink::mojom::MediaSessionService::SetPlaybackState";
      case messages::MediaSessionService::kSetPositionState:
            return "Receive blink::mojom::MediaSessionService::SetPositionState";
      case messages::MediaSessionService::kSetMetadata:
            return "Receive blink::mojom::MediaSessionService::SetMetadata";
      case messages::MediaSessionService::kSetMicrophoneState:
            return "Receive blink::mojom::MediaSessionService::SetMicrophoneState";
      case messages::MediaSessionService::kSetCameraState:
            return "Receive blink::mojom::MediaSessionService::SetCameraState";
      case messages::MediaSessionService::kEnableAction:
            return "Receive blink::mojom::MediaSessionService::EnableAction";
      case messages::MediaSessionService::kDisableAction:
            return "Receive blink::mojom::MediaSessionService::DisableAction";
    }
  } else {
    switch (static_cast<messages::MediaSessionService>(message.name())) {
      case messages::MediaSessionService::kSetClient:
            return "Receive reply blink::mojom::MediaSessionService::SetClient";
      case messages::MediaSessionService::kSetPlaybackState:
            return "Receive reply blink::mojom::MediaSessionService::SetPlaybackState";
      case messages::MediaSessionService::kSetPositionState:
            return "Receive reply blink::mojom::MediaSessionService::SetPositionState";
      case messages::MediaSessionService::kSetMetadata:
            return "Receive reply blink::mojom::MediaSessionService::SetMetadata";
      case messages::MediaSessionService::kSetMicrophoneState:
            return "Receive reply blink::mojom::MediaSessionService::SetMicrophoneState";
      case messages::MediaSessionService::kSetCameraState:
            return "Receive reply blink::mojom::MediaSessionService::SetCameraState";
      case messages::MediaSessionService::kEnableAction:
            return "Receive reply blink::mojom::MediaSessionService::EnableAction";
      case messages::MediaSessionService::kDisableAction:
            return "Receive reply blink::mojom::MediaSessionService::DisableAction";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaSessionService::SetClient_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf04c95bc;  // IPCStableHash for blink::mojom::MediaSessionService::SetClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSessionService::SetPlaybackState_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdd576061;  // IPCStableHash for blink::mojom::MediaSessionService::SetPlaybackState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSessionService::SetPositionState_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x81106595;  // IPCStableHash for blink::mojom::MediaSessionService::SetPositionState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSessionService::SetMetadata_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd39349e0;  // IPCStableHash for blink::mojom::MediaSessionService::SetMetadata
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSessionService::SetMicrophoneState_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfe9299fd;  // IPCStableHash for blink::mojom::MediaSessionService::SetMicrophoneState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSessionService::SetCameraState_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0b66cf9e;  // IPCStableHash for blink::mojom::MediaSessionService::SetCameraState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSessionService::EnableAction_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf590fff2;  // IPCStableHash for blink::mojom::MediaSessionService::EnableAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSessionService::DisableAction_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4b2f6dad;  // IPCStableHash for blink::mojom::MediaSessionService::DisableAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaSessionServiceProxy::MediaSessionServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaSessionServiceProxy::SetClient(
    ::mojo::PendingRemote<MediaSessionClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaSessionService::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<MediaSessionClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSessionService::kSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaSessionService_SetClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::MediaSessionClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in MediaSessionService.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionServiceProxy::SetPlaybackState(
    MediaSessionPlaybackState in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaSessionService::SetPlaybackState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type MediaSessionPlaybackState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSessionService::kSetPlaybackState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaSessionService_SetPlaybackState_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::MediaSessionPlaybackState>(
    in_state,
    &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("SetPlaybackState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionServiceProxy::SetPositionState(
    ::media_session::mojom::blink::MediaPositionPtr in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaSessionService::SetPositionState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type ::media_session::mojom::blink::MediaPositionPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSessionService::kSetPositionState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaSessionService_SetPositionState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->position)::BaseType> position_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaPositionDataView>(
    in_position,
    position_fragment);

  params->position.Set(
      position_fragment.is_null() ? nullptr : position_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("SetPositionState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionServiceProxy::SetMetadata(
    SpecMediaMetadataPtr in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaSessionService::SetMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type SpecMediaMetadataPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSessionService::kSetMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaSessionService_SetMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SpecMediaMetadataDataView>(
    in_metadata,
    metadata_fragment);

  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("SetMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionServiceProxy::SetMicrophoneState(
    ::media_session::mojom::blink::MicrophoneState in_microphone_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaSessionService::SetMicrophoneState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("microphone_state"), in_microphone_state,
                        "<value of type ::media_session::mojom::blink::MicrophoneState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSessionService::kSetMicrophoneState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaSessionService_SetMicrophoneState_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media_session::mojom::MicrophoneState>(
    in_microphone_state,
    &params->microphone_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("SetMicrophoneState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionServiceProxy::SetCameraState(
    ::media_session::mojom::blink::CameraState in_camera_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaSessionService::SetCameraState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("camera_state"), in_camera_state,
                        "<value of type ::media_session::mojom::blink::CameraState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSessionService::kSetCameraState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaSessionService_SetCameraState_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media_session::mojom::CameraState>(
    in_camera_state,
    &params->camera_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("SetCameraState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionServiceProxy::EnableAction(
    ::media_session::mojom::blink::MediaSessionAction in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaSessionService::EnableAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type ::media_session::mojom::blink::MediaSessionAction>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSessionService::kEnableAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaSessionService_EnableAction_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media_session::mojom::MediaSessionAction>(
    in_action,
    &params->action);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("EnableAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionServiceProxy::DisableAction(
    ::media_session::mojom::blink::MediaSessionAction in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaSessionService::DisableAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type ::media_session::mojom::blink::MediaSessionAction>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSessionService::kDisableAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaSessionService_DisableAction_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media_session::mojom::MediaSessionAction>(
    in_action,
    &params->action);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("DisableAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaSessionServiceStubDispatch::Accept(
    MediaSessionService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaSessionService>(message->header()->name)) {
    case messages::MediaSessionService::kSetClient: {
      DCHECK(message->is_serialized());
      internal::MediaSessionService_SetClient_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_SetClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSessionService.0
      bool success = true;
      ::mojo::PendingRemote<MediaSessionClient> p_client{};
      MediaSessionService_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(        
        std::move(p_client));
      return true;
    }
    case messages::MediaSessionService::kSetPlaybackState: {
      DCHECK(message->is_serialized());
      internal::MediaSessionService_SetPlaybackState_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_SetPlaybackState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSessionService.1
      bool success = true;
      MediaSessionPlaybackState p_state{};
      MediaSessionService_SetPlaybackState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPlaybackState(        
        std::move(p_state));
      return true;
    }
    case messages::MediaSessionService::kSetPositionState: {
      DCHECK(message->is_serialized());
      internal::MediaSessionService_SetPositionState_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_SetPositionState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSessionService.2
      bool success = true;
      ::media_session::mojom::blink::MediaPositionPtr p_position{};
      MediaSessionService_SetPositionState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPositionState(        
        std::move(p_position));
      return true;
    }
    case messages::MediaSessionService::kSetMetadata: {
      DCHECK(message->is_serialized());
      internal::MediaSessionService_SetMetadata_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_SetMetadata_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSessionService.3
      bool success = true;
      SpecMediaMetadataPtr p_metadata{};
      MediaSessionService_SetMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMetadata(        
        std::move(p_metadata));
      return true;
    }
    case messages::MediaSessionService::kSetMicrophoneState: {
      DCHECK(message->is_serialized());
      internal::MediaSessionService_SetMicrophoneState_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_SetMicrophoneState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSessionService.4
      bool success = true;
      ::media_session::mojom::blink::MicrophoneState p_microphone_state{};
      MediaSessionService_SetMicrophoneState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMicrophoneState(&p_microphone_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMicrophoneState(        
        std::move(p_microphone_state));
      return true;
    }
    case messages::MediaSessionService::kSetCameraState: {
      DCHECK(message->is_serialized());
      internal::MediaSessionService_SetCameraState_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_SetCameraState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSessionService.5
      bool success = true;
      ::media_session::mojom::blink::CameraState p_camera_state{};
      MediaSessionService_SetCameraState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCameraState(&p_camera_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCameraState(        
        std::move(p_camera_state));
      return true;
    }
    case messages::MediaSessionService::kEnableAction: {
      DCHECK(message->is_serialized());
      internal::MediaSessionService_EnableAction_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_EnableAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSessionService.6
      bool success = true;
      ::media_session::mojom::blink::MediaSessionAction p_action{};
      MediaSessionService_EnableAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableAction(        
        std::move(p_action));
      return true;
    }
    case messages::MediaSessionService::kDisableAction: {
      DCHECK(message->is_serialized());
      internal::MediaSessionService_DisableAction_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_DisableAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSessionService.7
      bool success = true;
      ::media_session::mojom::blink::MediaSessionAction p_action{};
      MediaSessionService_DisableAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableAction(        
        std::move(p_action));
      return true;
    }
  }
  return false;
}

// static
bool MediaSessionServiceStubDispatch::AcceptWithResponder(
    MediaSessionService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaSessionService>(message->header()->name)) {
    case messages::MediaSessionService::kSetClient: {
      break;
    }
    case messages::MediaSessionService::kSetPlaybackState: {
      break;
    }
    case messages::MediaSessionService::kSetPositionState: {
      break;
    }
    case messages::MediaSessionService::kSetMetadata: {
      break;
    }
    case messages::MediaSessionService::kSetMicrophoneState: {
      break;
    }
    case messages::MediaSessionService::kSetCameraState: {
      break;
    }
    case messages::MediaSessionService::kEnableAction: {
      break;
    }
    case messages::MediaSessionService::kDisableAction: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaSessionServiceValidationInfo[] = {
    { &internal::MediaSessionService_SetClient_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSessionService_SetPlaybackState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSessionService_SetPositionState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSessionService_SetMetadata_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSessionService_SetMicrophoneState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSessionService_SetCameraState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSessionService_EnableAction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSessionService_DisableAction_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaSessionServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::MediaSessionService::Name_,
    kMediaSessionServiceValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::MediaSessionSeekToDetails::DataView, ::blink::mojom::blink::MediaSessionSeekToDetailsPtr>::Read(
    ::blink::mojom::blink::MediaSessionSeekToDetails::DataView input,
    ::blink::mojom::blink::MediaSessionSeekToDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::MediaSessionSeekToDetailsPtr result(::blink::mojom::blink::MediaSessionSeekToDetails::New());
  
      if (success && !input.ReadSeekTime(&result->seek_time))
        success = false;
      if (success)
        result->fast_seek = input.fast_seek();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::SpecMediaMetadata::DataView, ::blink::mojom::blink::SpecMediaMetadataPtr>::Read(
    ::blink::mojom::blink::SpecMediaMetadata::DataView input,
    ::blink::mojom::blink::SpecMediaMetadataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SpecMediaMetadataPtr result(::blink::mojom::blink::SpecMediaMetadata::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadArtist(&result->artist))
        success = false;
      if (success && !input.ReadAlbum(&result->album))
        success = false;
      if (success && !input.ReadArtwork(&result->artwork))
        success = false;
      if (success && !input.ReadChapterInfo(&result->chapterInfo))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::MediaSessionActionDetails::DataView, ::blink::mojom::blink::MediaSessionActionDetailsPtr>::Read(
    ::blink::mojom::blink::MediaSessionActionDetails::DataView input,
    ::blink::mojom::blink::MediaSessionActionDetailsPtr* output) {
  using UnionType = ::blink::mojom::blink::MediaSessionActionDetails;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSeekTo: {
      ::blink::mojom::blink::MediaSessionSeekToDetailsPtr result_seek_to{};
      if (!input.ReadSeekTo(&result_seek_to))
        return false;

      *output = UnionType::NewSeekTo(
          std::move(result_seek_to));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void MediaSessionClientInterceptorForTesting::DidReceiveAction(::media_session::mojom::blink::MediaSessionAction action, MediaSessionActionDetailsPtr details) {
  GetForwardingInterface()->DidReceiveAction(
    std::move(action)
    , 
    std::move(details)
    );
}
MediaSessionClientAsyncWaiter::MediaSessionClientAsyncWaiter(
    MediaSessionClient* proxy) : proxy_(proxy) {}

MediaSessionClientAsyncWaiter::~MediaSessionClientAsyncWaiter() = default;





void MediaSessionServiceInterceptorForTesting::SetClient(::mojo::PendingRemote<MediaSessionClient> client) {
  GetForwardingInterface()->SetClient(
    std::move(client)
    );
}
void MediaSessionServiceInterceptorForTesting::SetPlaybackState(MediaSessionPlaybackState state) {
  GetForwardingInterface()->SetPlaybackState(
    std::move(state)
    );
}
void MediaSessionServiceInterceptorForTesting::SetPositionState(::media_session::mojom::blink::MediaPositionPtr position) {
  GetForwardingInterface()->SetPositionState(
    std::move(position)
    );
}
void MediaSessionServiceInterceptorForTesting::SetMetadata(SpecMediaMetadataPtr metadata) {
  GetForwardingInterface()->SetMetadata(
    std::move(metadata)
    );
}
void MediaSessionServiceInterceptorForTesting::SetMicrophoneState(::media_session::mojom::blink::MicrophoneState microphone_state) {
  GetForwardingInterface()->SetMicrophoneState(
    std::move(microphone_state)
    );
}
void MediaSessionServiceInterceptorForTesting::SetCameraState(::media_session::mojom::blink::CameraState camera_state) {
  GetForwardingInterface()->SetCameraState(
    std::move(camera_state)
    );
}
void MediaSessionServiceInterceptorForTesting::EnableAction(::media_session::mojom::blink::MediaSessionAction action) {
  GetForwardingInterface()->EnableAction(
    std::move(action)
    );
}
void MediaSessionServiceInterceptorForTesting::DisableAction(::media_session::mojom::blink::MediaSessionAction action) {
  GetForwardingInterface()->DisableAction(
    std::move(action)
    );
}
MediaSessionServiceAsyncWaiter::MediaSessionServiceAsyncWaiter(
    MediaSessionService* proxy) : proxy_(proxy) {}

MediaSessionServiceAsyncWaiter::~MediaSessionServiceAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif