// third_party/blink/public/mojom/payments/payment_handler_host.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace payments::mojom::blink {
PaymentHandlerMethodData::PaymentHandlerMethodData()
    : method_name(),
      stringified_data() {}

PaymentHandlerMethodData::PaymentHandlerMethodData(
    const ::blink::String& method_name_in,
    const ::blink::String& stringified_data_in)
    : method_name(std::move(method_name_in)),
      stringified_data(std::move(stringified_data_in)) {}

PaymentHandlerMethodData::~PaymentHandlerMethodData() = default;

void PaymentHandlerMethodData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method_name"), this->method_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stringified_data"), this->stringified_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaymentHandlerMethodData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentHandlerModifier::PaymentHandlerModifier()
    : total(),
      method_data() {}

PaymentHandlerModifier::PaymentHandlerModifier(
    ::payments::mojom::blink::PaymentCurrencyAmountPtr total_in,
    PaymentHandlerMethodDataPtr method_data_in)
    : total(std::move(total_in)),
      method_data(std::move(method_data_in)) {}

PaymentHandlerModifier::~PaymentHandlerModifier() = default;

void PaymentHandlerModifier::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total"), this->total,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::payments::mojom::blink::PaymentCurrencyAmountPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method_data"), this->method_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PaymentHandlerMethodDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaymentHandlerModifier::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentRequestDetailsUpdate::PaymentRequestDetailsUpdate()
    : total(),
      shipping_options(),
      modifiers(),
      error(""),
      stringified_payment_method_errors(),
      shipping_address_errors() {}

PaymentRequestDetailsUpdate::PaymentRequestDetailsUpdate(
    ::payments::mojom::blink::PaymentCurrencyAmountPtr total_in,
    std::optional<::blink::Vector<::payments::mojom::blink::PaymentShippingOptionPtr>> shipping_options_in,
    std::optional<::blink::Vector<PaymentHandlerModifierPtr>> modifiers_in,
    const ::blink::String& error_in,
    const ::blink::String& stringified_payment_method_errors_in,
    ::payments::mojom::blink::AddressErrorsPtr shipping_address_errors_in)
    : total(std::move(total_in)),
      shipping_options(std::move(shipping_options_in)),
      modifiers(std::move(modifiers_in)),
      error(std::move(error_in)),
      stringified_payment_method_errors(std::move(stringified_payment_method_errors_in)),
      shipping_address_errors(std::move(shipping_address_errors_in)) {}

PaymentRequestDetailsUpdate::~PaymentRequestDetailsUpdate() = default;

void PaymentRequestDetailsUpdate::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total"), this->total,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::payments::mojom::blink::PaymentCurrencyAmountPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shipping_options"), this->shipping_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::blink::Vector<::payments::mojom::blink::PaymentShippingOptionPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modifiers"), this->modifiers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::blink::Vector<PaymentHandlerModifierPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error"), this->error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stringified_payment_method_errors"), this->stringified_payment_method_errors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shipping_address_errors"), this->shipping_address_errors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::payments::mojom::blink::AddressErrorsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaymentRequestDetailsUpdate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PaymentHandlerHost::IPCStableHashFunction PaymentHandlerHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PaymentHandlerHost>(message.name())) {
    case messages::PaymentHandlerHost::kChangePaymentMethod: {
      return &PaymentHandlerHost::ChangePaymentMethod_Sym::IPCStableHash;
    }
    case messages::PaymentHandlerHost::kChangeShippingOption: {
      return &PaymentHandlerHost::ChangeShippingOption_Sym::IPCStableHash;
    }
    case messages::PaymentHandlerHost::kChangeShippingAddress: {
      return &PaymentHandlerHost::ChangeShippingAddress_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PaymentHandlerHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PaymentHandlerHost>(message.name())) {
      case messages::PaymentHandlerHost::kChangePaymentMethod:
            return "Receive payments::mojom::PaymentHandlerHost::ChangePaymentMethod";
      case messages::PaymentHandlerHost::kChangeShippingOption:
            return "Receive payments::mojom::PaymentHandlerHost::ChangeShippingOption";
      case messages::PaymentHandlerHost::kChangeShippingAddress:
            return "Receive payments::mojom::PaymentHandlerHost::ChangeShippingAddress";
    }
  } else {
    switch (static_cast<messages::PaymentHandlerHost>(message.name())) {
      case messages::PaymentHandlerHost::kChangePaymentMethod:
            return "Receive reply payments::mojom::PaymentHandlerHost::ChangePaymentMethod";
      case messages::PaymentHandlerHost::kChangeShippingOption:
            return "Receive reply payments::mojom::PaymentHandlerHost::ChangeShippingOption";
      case messages::PaymentHandlerHost::kChangeShippingAddress:
            return "Receive reply payments::mojom::PaymentHandlerHost::ChangeShippingAddress";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PaymentHandlerHost::ChangePaymentMethod_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x318bf77b;  // IPCStableHash for payments::mojom::PaymentHandlerHost::ChangePaymentMethod
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentHandlerHost::ChangeShippingOption_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xac07cc76;  // IPCStableHash for payments::mojom::PaymentHandlerHost::ChangeShippingOption
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentHandlerHost::ChangeShippingAddress_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3f069c9a;  // IPCStableHash for payments::mojom::PaymentHandlerHost::ChangeShippingAddress
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PaymentHandlerHost_ChangePaymentMethod_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaymentHandlerHost_ChangePaymentMethod_ForwardToCallback(
      PaymentHandlerHost::ChangePaymentMethodCallback callback
      ) : callback_(std::move(callback)) {
  }

  PaymentHandlerHost_ChangePaymentMethod_ForwardToCallback(const PaymentHandlerHost_ChangePaymentMethod_ForwardToCallback&) = delete;
  PaymentHandlerHost_ChangePaymentMethod_ForwardToCallback& operator=(const PaymentHandlerHost_ChangePaymentMethod_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PaymentHandlerHost::ChangePaymentMethodCallback callback_;
};

class PaymentHandlerHost_ChangeShippingOption_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaymentHandlerHost_ChangeShippingOption_ForwardToCallback(
      PaymentHandlerHost::ChangeShippingOptionCallback callback
      ) : callback_(std::move(callback)) {
  }

  PaymentHandlerHost_ChangeShippingOption_ForwardToCallback(const PaymentHandlerHost_ChangeShippingOption_ForwardToCallback&) = delete;
  PaymentHandlerHost_ChangeShippingOption_ForwardToCallback& operator=(const PaymentHandlerHost_ChangeShippingOption_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PaymentHandlerHost::ChangeShippingOptionCallback callback_;
};

class PaymentHandlerHost_ChangeShippingAddress_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaymentHandlerHost_ChangeShippingAddress_ForwardToCallback(
      PaymentHandlerHost::ChangeShippingAddressCallback callback
      ) : callback_(std::move(callback)) {
  }

  PaymentHandlerHost_ChangeShippingAddress_ForwardToCallback(const PaymentHandlerHost_ChangeShippingAddress_ForwardToCallback&) = delete;
  PaymentHandlerHost_ChangeShippingAddress_ForwardToCallback& operator=(const PaymentHandlerHost_ChangeShippingAddress_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PaymentHandlerHost::ChangeShippingAddressCallback callback_;
};

PaymentHandlerHostProxy::PaymentHandlerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PaymentHandlerHostProxy::ChangePaymentMethod(
    PaymentHandlerMethodDataPtr in_method_data, ChangePaymentMethodCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::PaymentHandlerHost::ChangePaymentMethod", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("method_data"), in_method_data,
                        "<value of type PaymentHandlerMethodDataPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentHandlerHost::kChangePaymentMethod), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentHandlerHost_ChangePaymentMethod_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->method_data)::BaseType> method_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::payments::mojom::PaymentHandlerMethodDataDataView>(
    in_method_data,
    method_data_fragment);

  params->method_data.Set(
      method_data_fragment.is_null() ? nullptr : method_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->method_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null method_data in PaymentHandlerHost.ChangePaymentMethod request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentHandlerHost::Name_);
  message.set_method_name("ChangePaymentMethod");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaymentHandlerHost_ChangePaymentMethod_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PaymentHandlerHostProxy::ChangeShippingOption(
    const ::blink::String& in_shipping_option_id, ChangeShippingOptionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::PaymentHandlerHost::ChangeShippingOption", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shipping_option_id"), in_shipping_option_id,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentHandlerHost::kChangeShippingOption), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentHandlerHost_ChangeShippingOption_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->shipping_option_id)::BaseType> shipping_option_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_shipping_option_id,
    shipping_option_id_fragment);

  params->shipping_option_id.Set(
      shipping_option_id_fragment.is_null() ? nullptr : shipping_option_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->shipping_option_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null shipping_option_id in PaymentHandlerHost.ChangeShippingOption request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentHandlerHost::Name_);
  message.set_method_name("ChangeShippingOption");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaymentHandlerHost_ChangeShippingOption_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PaymentHandlerHostProxy::ChangeShippingAddress(
    ::payments::mojom::blink::PaymentAddressPtr in_shipping_address, ChangeShippingAddressCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::PaymentHandlerHost::ChangeShippingAddress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shipping_address"), in_shipping_address,
                        "<value of type ::payments::mojom::blink::PaymentAddressPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentHandlerHost::kChangeShippingAddress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentHandlerHost_ChangeShippingAddress_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->shipping_address)::BaseType> shipping_address_fragment(
          params.message());
  
  mojo::internal::Serialize<::payments::mojom::PaymentAddressDataView>(
    in_shipping_address,
    shipping_address_fragment);

  params->shipping_address.Set(
      shipping_address_fragment.is_null() ? nullptr : shipping_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->shipping_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null shipping_address in PaymentHandlerHost.ChangeShippingAddress request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentHandlerHost::Name_);
  message.set_method_name("ChangeShippingAddress");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaymentHandlerHost_ChangeShippingAddress_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PaymentHandlerHost_ChangePaymentMethod_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PaymentHandlerHost::ChangePaymentMethodCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PaymentHandlerHost_ChangePaymentMethod_ProxyToResponder> proxy(
        new PaymentHandlerHost_ChangePaymentMethod_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PaymentHandlerHost_ChangePaymentMethod_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaymentHandlerHost_ChangePaymentMethod_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PaymentHandlerHost_ChangePaymentMethod_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaymentHandlerHost::ChangePaymentMethodCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaymentRequestDetailsUpdatePtr in_response_data);
};

bool PaymentHandlerHost_ChangePaymentMethod_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PaymentHandlerHost_ChangePaymentMethod_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaymentHandlerHost_ChangePaymentMethod_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PaymentHandlerHost.0
  bool success = true;
  PaymentRequestDetailsUpdatePtr p_response_data{};
  PaymentHandlerHost_ChangePaymentMethod_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResponseData(&p_response_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaymentHandlerHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_response_data));
  }
  return true;
}

void PaymentHandlerHost_ChangePaymentMethod_ProxyToResponder::Run(
    PaymentRequestDetailsUpdatePtr in_response_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply payments::mojom::PaymentHandlerHost::ChangePaymentMethod", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_data"), in_response_data,
                        "<value of type PaymentRequestDetailsUpdatePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentHandlerHost::kChangePaymentMethod), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentHandlerHost_ChangePaymentMethod_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response_data)::BaseType> response_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::payments::mojom::PaymentRequestDetailsUpdateDataView>(
    in_response_data,
    response_data_fragment);

  params->response_data.Set(
      response_data_fragment.is_null() ? nullptr : response_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response_data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentHandlerHost::Name_);
  message.set_method_name("ChangePaymentMethod");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PaymentHandlerHost_ChangeShippingOption_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PaymentHandlerHost::ChangeShippingOptionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PaymentHandlerHost_ChangeShippingOption_ProxyToResponder> proxy(
        new PaymentHandlerHost_ChangeShippingOption_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PaymentHandlerHost_ChangeShippingOption_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaymentHandlerHost_ChangeShippingOption_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PaymentHandlerHost_ChangeShippingOption_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaymentHandlerHost::ChangeShippingOptionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaymentRequestDetailsUpdatePtr in_response_data);
};

bool PaymentHandlerHost_ChangeShippingOption_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PaymentHandlerHost_ChangeShippingOption_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaymentHandlerHost_ChangeShippingOption_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PaymentHandlerHost.1
  bool success = true;
  PaymentRequestDetailsUpdatePtr p_response_data{};
  PaymentHandlerHost_ChangeShippingOption_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResponseData(&p_response_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaymentHandlerHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_response_data));
  }
  return true;
}

void PaymentHandlerHost_ChangeShippingOption_ProxyToResponder::Run(
    PaymentRequestDetailsUpdatePtr in_response_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply payments::mojom::PaymentHandlerHost::ChangeShippingOption", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_data"), in_response_data,
                        "<value of type PaymentRequestDetailsUpdatePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentHandlerHost::kChangeShippingOption), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentHandlerHost_ChangeShippingOption_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response_data)::BaseType> response_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::payments::mojom::PaymentRequestDetailsUpdateDataView>(
    in_response_data,
    response_data_fragment);

  params->response_data.Set(
      response_data_fragment.is_null() ? nullptr : response_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response_data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentHandlerHost::Name_);
  message.set_method_name("ChangeShippingOption");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PaymentHandlerHost_ChangeShippingAddress_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PaymentHandlerHost::ChangeShippingAddressCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PaymentHandlerHost_ChangeShippingAddress_ProxyToResponder> proxy(
        new PaymentHandlerHost_ChangeShippingAddress_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PaymentHandlerHost_ChangeShippingAddress_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaymentHandlerHost_ChangeShippingAddress_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PaymentHandlerHost_ChangeShippingAddress_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaymentHandlerHost::ChangeShippingAddressCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaymentRequestDetailsUpdatePtr in_response_data);
};

bool PaymentHandlerHost_ChangeShippingAddress_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PaymentHandlerHost_ChangeShippingAddress_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaymentHandlerHost_ChangeShippingAddress_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PaymentHandlerHost.2
  bool success = true;
  PaymentRequestDetailsUpdatePtr p_response_data{};
  PaymentHandlerHost_ChangeShippingAddress_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResponseData(&p_response_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaymentHandlerHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_response_data));
  }
  return true;
}

void PaymentHandlerHost_ChangeShippingAddress_ProxyToResponder::Run(
    PaymentRequestDetailsUpdatePtr in_response_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply payments::mojom::PaymentHandlerHost::ChangeShippingAddress", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_data"), in_response_data,
                        "<value of type PaymentRequestDetailsUpdatePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentHandlerHost::kChangeShippingAddress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentHandlerHost_ChangeShippingAddress_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response_data)::BaseType> response_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::payments::mojom::PaymentRequestDetailsUpdateDataView>(
    in_response_data,
    response_data_fragment);

  params->response_data.Set(
      response_data_fragment.is_null() ? nullptr : response_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response_data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentHandlerHost::Name_);
  message.set_method_name("ChangeShippingAddress");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PaymentHandlerHostStubDispatch::Accept(
    PaymentHandlerHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PaymentHandlerHost>(message->header()->name)) {
    case messages::PaymentHandlerHost::kChangePaymentMethod: {
      break;
    }
    case messages::PaymentHandlerHost::kChangeShippingOption: {
      break;
    }
    case messages::PaymentHandlerHost::kChangeShippingAddress: {
      break;
    }
  }
  return false;
}

// static
bool PaymentHandlerHostStubDispatch::AcceptWithResponder(
    PaymentHandlerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PaymentHandlerHost>(message->header()->name)) {
    case messages::PaymentHandlerHost::kChangePaymentMethod: {
      internal::PaymentHandlerHost_ChangePaymentMethod_Params_Data* params =
          reinterpret_cast<
              internal::PaymentHandlerHost_ChangePaymentMethod_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PaymentHandlerHost.0
      bool success = true;
      PaymentHandlerMethodDataPtr p_method_data{};
      PaymentHandlerHost_ChangePaymentMethod_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMethodData(&p_method_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentHandlerHost::Name_, 0, false);
        return false;
      }
      auto callback =
          PaymentHandlerHost_ChangePaymentMethod_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChangePaymentMethod(        
        std::move(p_method_data), std::move(callback));
      return true;
    }
    case messages::PaymentHandlerHost::kChangeShippingOption: {
      internal::PaymentHandlerHost_ChangeShippingOption_Params_Data* params =
          reinterpret_cast<
              internal::PaymentHandlerHost_ChangeShippingOption_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PaymentHandlerHost.1
      bool success = true;
      ::blink::String p_shipping_option_id{};
      PaymentHandlerHost_ChangeShippingOption_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadShippingOptionId(&p_shipping_option_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentHandlerHost::Name_, 1, false);
        return false;
      }
      auto callback =
          PaymentHandlerHost_ChangeShippingOption_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChangeShippingOption(        
        std::move(p_shipping_option_id), std::move(callback));
      return true;
    }
    case messages::PaymentHandlerHost::kChangeShippingAddress: {
      internal::PaymentHandlerHost_ChangeShippingAddress_Params_Data* params =
          reinterpret_cast<
              internal::PaymentHandlerHost_ChangeShippingAddress_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PaymentHandlerHost.2
      bool success = true;
      ::payments::mojom::blink::PaymentAddressPtr p_shipping_address{};
      PaymentHandlerHost_ChangeShippingAddress_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadShippingAddress(&p_shipping_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentHandlerHost::Name_, 2, false);
        return false;
      }
      auto callback =
          PaymentHandlerHost_ChangeShippingAddress_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChangeShippingAddress(        
        std::move(p_shipping_address), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPaymentHandlerHostValidationInfo[] = {
    { &internal::PaymentHandlerHost_ChangePaymentMethod_Params_Data::Validate,
     &internal::PaymentHandlerHost_ChangePaymentMethod_ResponseParams_Data::Validate},
    { &internal::PaymentHandlerHost_ChangeShippingOption_Params_Data::Validate,
     &internal::PaymentHandlerHost_ChangeShippingOption_ResponseParams_Data::Validate},
    { &internal::PaymentHandlerHost_ChangeShippingAddress_Params_Data::Validate,
     &internal::PaymentHandlerHost_ChangeShippingAddress_ResponseParams_Data::Validate},
};

bool PaymentHandlerHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::payments::mojom::blink::PaymentHandlerHost::Name_,
    kPaymentHandlerHostValidationInfo);
}

bool PaymentHandlerHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::payments::mojom::blink::PaymentHandlerHost::Name_,
    kPaymentHandlerHostValidationInfo);
}


}  // payments::mojom::blink


namespace mojo {


// static
bool StructTraits<::payments::mojom::blink::PaymentHandlerMethodData::DataView, ::payments::mojom::blink::PaymentHandlerMethodDataPtr>::Read(
    ::payments::mojom::blink::PaymentHandlerMethodData::DataView input,
    ::payments::mojom::blink::PaymentHandlerMethodDataPtr* output) {
  bool success = true;
  ::payments::mojom::blink::PaymentHandlerMethodDataPtr result(::payments::mojom::blink::PaymentHandlerMethodData::New());
  
      if (success && !input.ReadMethodName(&result->method_name))
        success = false;
      if (success && !input.ReadStringifiedData(&result->stringified_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::blink::PaymentHandlerModifier::DataView, ::payments::mojom::blink::PaymentHandlerModifierPtr>::Read(
    ::payments::mojom::blink::PaymentHandlerModifier::DataView input,
    ::payments::mojom::blink::PaymentHandlerModifierPtr* output) {
  bool success = true;
  ::payments::mojom::blink::PaymentHandlerModifierPtr result(::payments::mojom::blink::PaymentHandlerModifier::New());
  
      if (success && !input.ReadTotal(&result->total))
        success = false;
      if (success && !input.ReadMethodData(&result->method_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::blink::PaymentRequestDetailsUpdate::DataView, ::payments::mojom::blink::PaymentRequestDetailsUpdatePtr>::Read(
    ::payments::mojom::blink::PaymentRequestDetailsUpdate::DataView input,
    ::payments::mojom::blink::PaymentRequestDetailsUpdatePtr* output) {
  bool success = true;
  ::payments::mojom::blink::PaymentRequestDetailsUpdatePtr result(::payments::mojom::blink::PaymentRequestDetailsUpdate::New());
  
      if (success && !input.ReadTotal(&result->total))
        success = false;
      if (success && !input.ReadShippingOptions(&result->shipping_options))
        success = false;
      if (success && !input.ReadModifiers(&result->modifiers))
        success = false;
      if (success && !input.ReadError(&result->error))
        success = false;
      if (success && !input.ReadStringifiedPaymentMethodErrors(&result->stringified_payment_method_errors))
        success = false;
      if (success && !input.ReadShippingAddressErrors(&result->shipping_address_errors))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace payments::mojom::blink {


void PaymentHandlerHostInterceptorForTesting::ChangePaymentMethod(PaymentHandlerMethodDataPtr method_data, ChangePaymentMethodCallback callback) {
  GetForwardingInterface()->ChangePaymentMethod(
    std::move(method_data)
    , std::move(callback));
}
void PaymentHandlerHostInterceptorForTesting::ChangeShippingOption(const ::blink::String& shipping_option_id, ChangeShippingOptionCallback callback) {
  GetForwardingInterface()->ChangeShippingOption(
    std::move(shipping_option_id)
    , std::move(callback));
}
void PaymentHandlerHostInterceptorForTesting::ChangeShippingAddress(::payments::mojom::blink::PaymentAddressPtr shipping_address, ChangeShippingAddressCallback callback) {
  GetForwardingInterface()->ChangeShippingAddress(
    std::move(shipping_address)
    , std::move(callback));
}
PaymentHandlerHostAsyncWaiter::PaymentHandlerHostAsyncWaiter(
    PaymentHandlerHost* proxy) : proxy_(proxy) {}

PaymentHandlerHostAsyncWaiter::~PaymentHandlerHostAsyncWaiter() = default;


void PaymentHandlerHostAsyncWaiter::ChangePaymentMethod(
    PaymentHandlerMethodDataPtr method_data, PaymentRequestDetailsUpdatePtr* out_response_data) {
  base::RunLoop loop;
  proxy_->ChangePaymentMethod(
      std::move(method_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             PaymentRequestDetailsUpdatePtr* out_response_data
,
             PaymentRequestDetailsUpdatePtr response_data) {*out_response_data = std::move(response_data);
            loop->Quit();
          },
          &loop,
          out_response_data));
  loop.Run();
}

PaymentRequestDetailsUpdatePtr PaymentHandlerHostAsyncWaiter::ChangePaymentMethod(
    PaymentHandlerMethodDataPtr method_data) {
  PaymentRequestDetailsUpdatePtr async_wait_result;
  ChangePaymentMethod(std::move(method_data),&async_wait_result);
  return async_wait_result;
}

void PaymentHandlerHostAsyncWaiter::ChangeShippingOption(
    const ::blink::String& shipping_option_id, PaymentRequestDetailsUpdatePtr* out_response_data) {
  base::RunLoop loop;
  proxy_->ChangeShippingOption(
      std::move(shipping_option_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             PaymentRequestDetailsUpdatePtr* out_response_data
,
             PaymentRequestDetailsUpdatePtr response_data) {*out_response_data = std::move(response_data);
            loop->Quit();
          },
          &loop,
          out_response_data));
  loop.Run();
}

PaymentRequestDetailsUpdatePtr PaymentHandlerHostAsyncWaiter::ChangeShippingOption(
    const ::blink::String& shipping_option_id) {
  PaymentRequestDetailsUpdatePtr async_wait_result;
  ChangeShippingOption(std::move(shipping_option_id),&async_wait_result);
  return async_wait_result;
}

void PaymentHandlerHostAsyncWaiter::ChangeShippingAddress(
    ::payments::mojom::blink::PaymentAddressPtr shipping_address, PaymentRequestDetailsUpdatePtr* out_response_data) {
  base::RunLoop loop;
  proxy_->ChangeShippingAddress(
      std::move(shipping_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             PaymentRequestDetailsUpdatePtr* out_response_data
,
             PaymentRequestDetailsUpdatePtr response_data) {*out_response_data = std::move(response_data);
            loop->Quit();
          },
          &loop,
          out_response_data));
  loop.Run();
}

PaymentRequestDetailsUpdatePtr PaymentHandlerHostAsyncWaiter::ChangeShippingAddress(
    ::payments::mojom::blink::PaymentAddressPtr shipping_address) {
  PaymentRequestDetailsUpdatePtr async_wait_result;
  ChangeShippingAddress(std::move(shipping_address),&async_wait_result);
  return async_wait_result;
}






}  // payments::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif