// third_party/blink/public/mojom/reporting/reporting.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_REPORTING_REPORTING_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_REPORTING_REPORTING_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/reporting/reporting.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/reporting/reporting.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/reporting/reporting.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class ReportingServiceProxyProxy;

template <typename ImplRefTraits>
class ReportingServiceProxyStub;

class ReportingServiceProxyRequestValidator;


class BLINK_COMMON_EXPORT ReportingServiceProxy
    : public ReportingServiceProxyInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ReportingServiceProxy";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ReportingServiceProxyInterfaceBase;
  using Proxy_ = ReportingServiceProxyProxy;

  template <typename ImplRefTraits>
  using Stub_ = ReportingServiceProxyStub<ImplRefTraits>;

  using RequestValidator_ = ReportingServiceProxyRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kQueueInterventionReportMinVersion = 0,
    kQueueDeprecationReportMinVersion = 0,
    kQueueCspViolationReportMinVersion = 0,
    kQueueIntegrityViolationReportMinVersion = 0,
    kQueuePermissionsPolicyViolationReportMinVersion = 0,
    kQueuePotentialPermissionsPolicyViolationReportMinVersion = 0,
    kQueueDocumentPolicyViolationReportMinVersion = 0,
    kQueueCSPHashReportMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct QueueInterventionReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueueDeprecationReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueueCspViolationReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueueIntegrityViolationReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueuePermissionsPolicyViolationReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueuePotentialPermissionsPolicyViolationReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueueDocumentPolicyViolationReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueueCSPHashReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ReportingServiceProxy() = default;

  virtual void QueueInterventionReport(const ::GURL& url, const std::string& id, const std::string& message, const std::optional<std::string>& source_file, int32_t line_number, int32_t column_number) = 0;

  virtual void QueueDeprecationReport(const ::GURL& url, const std::string& id, std::optional<::base::Time> anticipatedRemoval, const std::string& message, const std::optional<std::string>& source_file, int32_t line_number, int32_t column_number) = 0;

  virtual void QueueCspViolationReport(const ::GURL& url, const std::string& group, const std::string& document_url, const std::optional<std::string>& referrer, const std::optional<std::string>& blocked_url, const std::string& effective_directive, const std::string& original_policy, const std::optional<std::string>& source_file, const std::optional<std::string>& script_sample, const std::string& disposition, uint16_t status_code, int32_t line_number, int32_t column_number) = 0;

  virtual void QueueIntegrityViolationReport(const ::GURL& url, const std::string& endpoint, const std::string& document_url, const std::string& blocked_url, const std::string& destination, bool report_only) = 0;

  virtual void QueuePermissionsPolicyViolationReport(const ::GURL& url, const std::string& endpoint, const std::string& policy_id, const std::string& disposition, const std::optional<std::string>& message, const std::optional<std::string>& source_file, int32_t line_number, int32_t column_number) = 0;

  virtual void QueuePotentialPermissionsPolicyViolationReport(const ::GURL& url, const std::string& endpoint, const std::string& policy_id, const std::string& disposition, const std::optional<std::string>& message, const std::optional<std::string>& allow_attribute, const std::optional<std::string>& src_attribute, const std::optional<std::string>& source_file, int32_t line_number, int32_t column_number) = 0;

  virtual void QueueDocumentPolicyViolationReport(const ::GURL& url, const std::string& group, const std::string& policy_id, const std::string& disposition, const std::optional<std::string>& message, const std::optional<std::string>& source_file, int32_t line_number, int32_t column_number) = 0;

  virtual void QueueCSPHashReport(const ::GURL& url, const std::string& endpoint, const std::string& subresource_url, const std::string& integrity_hash, const std::string& type, const std::string& destination) = 0;
};



class BLINK_COMMON_EXPORT ReportingServiceProxyProxy
    : public ReportingServiceProxy {
 public:
  using InterfaceType = ReportingServiceProxy;

  explicit ReportingServiceProxyProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void QueueInterventionReport(const ::GURL& url, const std::string& id, const std::string& message, const std::optional<std::string>& source_file, int32_t line_number, int32_t column_number) final;
  
  void QueueDeprecationReport(const ::GURL& url, const std::string& id, std::optional<::base::Time> anticipatedRemoval, const std::string& message, const std::optional<std::string>& source_file, int32_t line_number, int32_t column_number) final;
  
  void QueueCspViolationReport(const ::GURL& url, const std::string& group, const std::string& document_url, const std::optional<std::string>& referrer, const std::optional<std::string>& blocked_url, const std::string& effective_directive, const std::string& original_policy, const std::optional<std::string>& source_file, const std::optional<std::string>& script_sample, const std::string& disposition, uint16_t status_code, int32_t line_number, int32_t column_number) final;
  
  void QueueIntegrityViolationReport(const ::GURL& url, const std::string& endpoint, const std::string& document_url, const std::string& blocked_url, const std::string& destination, bool report_only) final;
  
  void QueuePermissionsPolicyViolationReport(const ::GURL& url, const std::string& endpoint, const std::string& policy_id, const std::string& disposition, const std::optional<std::string>& message, const std::optional<std::string>& source_file, int32_t line_number, int32_t column_number) final;
  
  void QueuePotentialPermissionsPolicyViolationReport(const ::GURL& url, const std::string& endpoint, const std::string& policy_id, const std::string& disposition, const std::optional<std::string>& message, const std::optional<std::string>& allow_attribute, const std::optional<std::string>& src_attribute, const std::optional<std::string>& source_file, int32_t line_number, int32_t column_number) final;
  
  void QueueDocumentPolicyViolationReport(const ::GURL& url, const std::string& group, const std::string& policy_id, const std::string& disposition, const std::optional<std::string>& message, const std::optional<std::string>& source_file, int32_t line_number, int32_t column_number) final;
  
  void QueueCSPHashReport(const ::GURL& url, const std::string& endpoint, const std::string& subresource_url, const std::string& integrity_hash, const std::string& type, const std::string& destination) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT ReportingServiceProxyStubDispatch {
 public:
  static bool Accept(ReportingServiceProxy* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ReportingServiceProxy* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ReportingServiceProxy>>
class ReportingServiceProxyStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ReportingServiceProxyStub() = default;
  ~ReportingServiceProxyStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ReportingServiceProxyStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ReportingServiceProxyStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ReportingServiceProxyRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_REPORTING_REPORTING_MOJOM_H_