// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated from template:
//   templates/web_runtime_features_base.h.tmpl
// and input files:
//   ../../../../../qtwebengine/src/3rdparty/chromium/third_party/blink/renderer/platform/runtime_enabled_features.json5


#ifndef THIRD_PARTY_BLINK_PUBLIC_PLATFORM_WEB_RUNTIME_FEATURES_BASE_H_
#define THIRD_PARTY_BLINK_PUBLIC_PLATFORM_WEB_RUNTIME_FEATURES_BASE_H_

#include "third_party/blink/public/platform/web_common.h"

namespace blink {

class BLINK_PLATFORM_EXPORT WebRuntimeFeaturesBase {
 public:
  static void EnableAccessibilityAriaVirtualContent(bool);
  static bool IsAccessibilityAriaVirtualContentEnabled();
  static void EnableAccessibilityCustomElementRoleNone(bool);
  static bool IsAccessibilityCustomElementRoleNoneEnabled();
  static void EnableAccessibilityOSLevelBoldText(bool);
  static bool IsAccessibilityOSLevelBoldTextEnabled();
  static void EnableAccessibilityUseAXPositionForDocumentMarkers(bool);
  static bool IsAccessibilityUseAXPositionForDocumentMarkersEnabled();
  static void EnableAdInterestGroupAPI(bool);
  static bool IsAdInterestGroupAPIEnabledByRuntimeFlag();
  static void EnableAdTagging(bool);
  static bool IsAdTaggingEnabled();
  static void EnableAIPromptAPI(bool);
  static bool IsAIPromptAPIEnabledByRuntimeFlag();
  static void EnableAIPromptAPIForExtension(bool);
  static bool IsAIPromptAPIForExtensionEnabled();
  static void EnableAIPromptAPIForWorkers(bool);
  static bool IsAIPromptAPIForWorkersEnabled();
  static void EnableAIRewriterAPIForWorkers(bool);
  static bool IsAIRewriterAPIForWorkersEnabled();
  static void EnableAISummarizationAPIForWorkers(bool);
  static bool IsAISummarizationAPIForWorkersEnabled();
  static void EnableAIWriterAPIForWorkers(bool);
  static bool IsAIWriterAPIForWorkersEnabled();
  static void EnableAndroidDownloadableFontsMatching(bool);
  static bool IsAndroidDownloadableFontsMatchingEnabled();
  static void EnableAOMAriaRelationshipProperties(bool);
  static bool IsAOMAriaRelationshipPropertiesEnabled();
  static void EnableAOMAriaRelationshipPropertiesAriaOwns(bool);
  static bool IsAOMAriaRelationshipPropertiesAriaOwnsEnabled();
  static void EnableAttributionReporting(bool);
  static bool IsAttributionReportingEnabled();
  static void EnableAudioOutputDevices(bool);
  static bool IsAudioOutputDevicesEnabled();
  static void EnableAutomationControlled(bool);
  static bool IsAutomationControlledEnabled();
  static void EnableBackForwardCache(bool);
  static bool IsBackForwardCacheEnabled();
  static void EnableBackgroundFetch(bool);
  static bool IsBackgroundFetchEnabled();
  static void EnableBlinkExtensionWebView(bool);
  static bool IsBlinkExtensionWebViewEnabled();
  static void EnableBlinkExtensionWebViewMediaIntegrity(bool);
  static bool IsBlinkExtensionWebViewMediaIntegrityEnabled();
  static void EnableBoundaryEventDispatchTracksNodeRemoval(bool);
  static bool IsBoundaryEventDispatchTracksNodeRemovalEnabled();
  static void EnableBrowserInitiatedAutomaticPictureInPicture(bool);
  static bool IsBrowserInitiatedAutomaticPictureInPictureEnabled();
  static void EnableBrowserVerifiedUserActivationKeyboard(bool);
  static bool IsBrowserVerifiedUserActivationKeyboardEnabled();
  static void EnableBrowserVerifiedUserActivationMouse(bool);
  static bool IsBrowserVerifiedUserActivationMouseEnabled();
  static void EnableCanvas2dImageChromium(bool);
  static bool IsCanvas2dImageChromiumEnabled();
  static void EnableCompositeBGColorAnimation(bool);
  static bool IsCompositeBGColorAnimationEnabled();
  static void EnableCompositeClipPathAnimation(bool);
  static bool IsCompositeClipPathAnimationEnabled();
  static void EnableCompositedSelectionUpdate(bool);
  static bool IsCompositedSelectionUpdateEnabled();
  static void EnableCompressionDictionaryTransport(bool);
  static bool IsCompressionDictionaryTransportEnabled();
  static void EnableCompressionDictionaryTransportBackend(bool);
  static bool IsCompressionDictionaryTransportBackendEnabled();
  static void EnableControlledFrame(bool);
  static bool IsControlledFrameEnabled();
  static void EnableCSSMasonryLayout(bool);
  static bool IsCSSMasonryLayoutEnabled();
  static void EnableDigitalGoods(bool);
  static bool IsDigitalGoodsEnabledByRuntimeFlag();
  static void EnableDirectSockets(bool);
  static bool IsDirectSocketsEnabled();
  static void EnableDisplayCutoutAPI(bool);
  static bool IsDisplayCutoutAPIEnabled();
  static void EnableDocumentPolicyNegotiation(bool);
  static bool IsDocumentPolicyNegotiationEnabledByRuntimeFlag();
  static void EnableEyeDropperAPI(bool);
  static bool IsEyeDropperAPIEnabled();
  static void EnableFedCm(bool);
  static bool IsFedCmEnabled();
  static void EnableFedCmAutofill(bool);
  static bool IsFedCmAutofillEnabled();
  static void EnableFedCmDelegation(bool);
  static bool IsFedCmDelegationEnabled();
  static void EnableFedCmIdPRegistration(bool);
  static bool IsFedCmIdPRegistrationEnabled();
  static void EnableFedCmLightweightMode(bool);
  static bool IsFedCmLightweightModeEnabled();
  static void EnableFedCmMultipleIdentityProviders(bool);
  static bool IsFedCmMultipleIdentityProvidersEnabledByRuntimeFlag();
  static void EnableFencedFrames(bool);
  static bool IsFencedFramesEnabled();
  static void EnableFencedFramesDefaultMode(bool);
  static bool IsFencedFramesDefaultModeEnabled();
  static void EnableFencedFramesLocalUnpartitionedDataAccess(bool);
  static bool IsFencedFramesLocalUnpartitionedDataAccessEnabled();
  static void EnableFileSystem(bool);
  static bool IsFileSystemEnabled();
  static void EnableFledge(bool);
  static bool IsFledgeEnabled();
  static void EnableFledgeDeprecatedRenderURLReplacements(bool);
  static bool IsFledgeDeprecatedRenderURLReplacementsEnabled();
  static void EnableFledgeMultiBid(bool);
  static bool IsFledgeMultiBidEnabled();
  static void EnableFledgeRealTimeReporting(bool);
  static bool IsFledgeRealTimeReportingEnabled();
  static void EnableForcedColors(bool);
  static bool IsForcedColorsEnabled();
  static void EnableFractionalScrollOffsets(bool);
  static bool IsFractionalScrollOffsetsEnabled();
  static void EnableGamepadMultitouch(bool);
  static bool IsGamepadMultitouchEnabled();
  static void EnableGeolocationElement(bool);
  static bool IsGeolocationElementEnabled();
  static void EnableGetAllScreensMedia(bool);
  static bool IsGetAllScreensMediaEnabled();
  static void EnableGetDisplayMedia(bool);
  static bool IsGetDisplayMediaEnabled();
  static void EnableImplicitRootScroller(bool);
  static bool IsImplicitRootScrollerEnabled();
  static void EnableInstalledApp(bool);
  static bool IsInstalledAppEnabled();
  static void EnableIntegrityPolicyScript(bool);
  static bool IsIntegrityPolicyScriptEnabled();
  static void EnableInterestGroupsInSharedStorageWorklet(bool);
  static bool IsInterestGroupsInSharedStorageWorkletEnabled();
  static void EnableLanguageDetectionAPIForWorkers(bool);
  static bool IsLanguageDetectionAPIForWorkersEnabled();
  static void EnableLazyInitializeMediaControls(bool);
  static bool IsLazyInitializeMediaControlsEnabled();
  static void EnableLockedMode(bool);
  static bool IsLockedModeEnabled();
  static void EnableMediaCastOverlayButton(bool);
  static bool IsMediaCastOverlayButtonEnabled();
  static void EnableMediaControlsExpandGesture(bool);
  static bool IsMediaControlsExpandGestureEnabled();
  static void EnableMediaControlsOverlayPlayButton(bool);
  static bool IsMediaControlsOverlayPlayButtonEnabled();
  static void EnableMediaEngagementBypassAutoplayPolicies(bool);
  static bool IsMediaEngagementBypassAutoplayPoliciesEnabled();
  static void EnableMediaSession(bool);
  static bool IsMediaSessionEnabled();
  static void EnableMediaSessionEnterPictureInPicture(bool);
  static bool IsMediaSessionEnterPictureInPictureEnabled();
  static void EnableNetInfoDownlinkMax(bool);
  static bool IsNetInfoDownlinkMaxEnabled();
  static void EnableNotificationContentImage(bool);
  static bool IsNotificationContentImageEnabled();
  static void EnableNotifications(bool);
  static bool IsNotificationsEnabled();
  static void EnableOriginTrialsSampleAPI(bool);
  static bool IsOriginTrialsSampleAPIEnabledByRuntimeFlag();
  static void EnableOriginTrialsSampleAPIDeprecation(bool);
  static bool IsOriginTrialsSampleAPIDeprecationEnabledByRuntimeFlag();
  static void EnablePaymentApp(bool);
  static bool IsPaymentAppEnabled();
  static void EnablePaymentRequest(bool);
  static bool IsPaymentRequestEnabled();
  static void EnablePerformanceManagerInstrumentation(bool);
  static bool IsPerformanceManagerInstrumentationEnabled();
  static void EnablePeriodicBackgroundSync(bool);
  static bool IsPeriodicBackgroundSyncEnabled();
  static void EnablePermissionElement(bool);
  static bool IsPermissionElementEnabledByRuntimeFlag();
  static void EnablePermissions(bool);
  static bool IsPermissionsEnabled();
  static void EnablePNaCl(bool);
  static bool IsPNaClEnabledByRuntimeFlag();
  static void EnablePreciseMemoryInfo(bool);
  static bool IsPreciseMemoryInfoEnabled();
  static void EnablePreferredAudioOutputDevices(bool);
  static bool IsPreferredAudioOutputDevicesEnabledByRuntimeFlag();
  static void EnablePrerenderUntilScript(bool);
  static bool IsPrerenderUntilScriptEnabled();
  static void EnablePresentation(bool);
  static bool IsPresentationEnabled();
  static void EnablePrivateStateTokens(bool);
  static bool IsPrivateStateTokensEnabled();
  static void EnablePrivateStateTokensAlwaysAllowIssuance(bool);
  static bool IsPrivateStateTokensAlwaysAllowIssuanceEnabled();
  static void EnablePushMessaging(bool);
  static bool IsPushMessagingEnabled();
  static void EnablePushMessagingSubscriptionChange(bool);
  static bool IsPushMessagingSubscriptionChangeEnabled();
  static void EnableRemotePlayback(bool);
  static bool IsRemotePlaybackEnabled();
  static void EnableRestrictGamepadAccess(bool);
  static bool IsRestrictGamepadAccessEnabled();
  static void EnableScriptedSpeechRecognition(bool);
  static bool IsScriptedSpeechRecognitionEnabled();
  static void EnableScriptedSpeechSynthesis(bool);
  static bool IsScriptedSpeechSynthesisEnabled();
  static void EnableSecurePaymentConfirmation(bool);
  static bool IsSecurePaymentConfirmationEnabled();
  static void EnableSecurePaymentConfirmationDebug(bool);
  static bool IsSecurePaymentConfirmationDebugEnabled();
  static void EnableSelectParserRelaxation(bool);
  static bool IsSelectParserRelaxationEnabled();
  static void EnableSelectParserRelaxationOptOut(bool);
  static bool IsSelectParserRelaxationOptOutEnabledByRuntimeFlag();
  static void EnableSendBeaconThrowForBlobWithNonSimpleType(bool);
  static bool IsSendBeaconThrowForBlobWithNonSimpleTypeEnabled();
  static void EnableSensorExtraClasses(bool);
  static bool IsSensorExtraClassesEnabled();
  static void EnableSharedArrayBuffer(bool);
  static bool IsSharedArrayBufferEnabled();
  static void EnableSharedArrayBufferUnrestrictedAccessAllowed(bool);
  static bool IsSharedArrayBufferUnrestrictedAccessAllowedEnabled();
  static void EnableSharedAutofill(bool);
  static bool IsSharedAutofillEnabled();
  static void EnableSharedStorageAPI(bool);
  static bool IsSharedStorageAPIEnabled();
  static void EnableSharedWorker(bool);
  static bool IsSharedWorkerEnabledByRuntimeFlag();
  static void EnableSmartZoom(bool);
  static bool IsSmartZoomEnabled();
  static void EnableStandardizedBrowserZoom(bool);
  static bool IsStandardizedBrowserZoomEnabled();
  static void EnableTextFragmentIdentifiers(bool);
  static bool IsTextFragmentIdentifiersEnabledByRuntimeFlag();
  static void EnableTimerThrottlingForBackgroundTabs(bool);
  static bool IsTimerThrottlingForBackgroundTabsEnabled();
  static void EnableTopicsAPI(bool);
  static bool IsTopicsAPIEnabled();
  static void EnableTopicsDocumentAPI(bool);
  static bool IsTopicsDocumentAPIEnabled();
  static void EnableTopicsImgAPI(bool);
  static bool IsTopicsImgAPIEnabled();
  static void EnableTouchDragAndContextMenu(bool);
  static bool IsTouchDragAndContextMenuEnabled();
  static void EnableTouchDragAndDrop(bool);
  static bool IsTouchDragAndDropEnabled();
  static void EnableTouchEventFeatureDetection(bool);
  static bool IsTouchEventFeatureDetectionEnabledByRuntimeFlag();
  static void EnableTranslationAPIForWorkers(bool);
  static bool IsTranslationAPIForWorkersEnabled();
  static void EnableV8IdleTasks(bool);
  static bool IsV8IdleTasksEnabled();
  static void EnableWebAudioBypassOutputBufferingOptOut(bool);
  static bool IsWebAudioBypassOutputBufferingOptOutEnabled();
  static void EnableWebAuthenticationAmbient(bool);
  static bool IsWebAuthenticationAmbientEnabled();
  static void EnableWebAuthenticationConditionalCreate(bool);
  static bool IsWebAuthenticationConditionalCreateEnabled();
  static void EnableWebAuthenticationImmediateGet(bool);
  static bool IsWebAuthenticationImmediateGetEnabledByRuntimeFlag();
  static void EnableWebAuthenticationRemoteDesktopSupport(bool);
  static bool IsWebAuthenticationRemoteDesktopSupportEnabled();
  static void EnableWebBluetooth(bool);
  static bool IsWebBluetoothEnabled();
  static void EnableWebBluetoothGetDevices(bool);
  static bool IsWebBluetoothGetDevicesEnabled();
  static void EnableWebBluetoothWatchAdvertisements(bool);
  static bool IsWebBluetoothWatchAdvertisementsEnabled();
  static void EnableWebGLDeveloperExtensions(bool);
  static bool IsWebGLDeveloperExtensionsEnabled();
  static void EnableWebGLDraftExtensions(bool);
  static bool IsWebGLDraftExtensionsEnabled();
  static void EnableWebGLImageChromium(bool);
  static bool IsWebGLImageChromiumEnabled();
  static void EnableWebGPUDeveloperFeatures(bool);
  static bool IsWebGPUDeveloperFeaturesEnabled();
  static void EnableWebGPUExperimentalFeatures(bool);
  static bool IsWebGPUExperimentalFeaturesEnabled();
  static void EnableWebHIDOnServiceWorkers(bool);
  static bool IsWebHIDOnServiceWorkersEnabled();
  static void EnableWebIdentityDigitalCredentials(bool);
  static bool IsWebIdentityDigitalCredentialsEnabledByRuntimeFlag();
  static void EnableWebIdentityDigitalCredentialsCreation(bool);
  static bool IsWebIdentityDigitalCredentialsCreationEnabled();
  static void EnableWebNFC(bool);
  static bool IsWebNFCEnabled();
  static void EnableWebOTP(bool);
  static bool IsWebOTPEnabled();
  static void EnableWebOTPAssertionFeaturePolicy(bool);
  static bool IsWebOTPAssertionFeaturePolicyEnabled();
  static void EnableWebShare(bool);
  static bool IsWebShareEnabled();
  static void EnableWebUSB(bool);
  static bool IsWebUSBEnabled();
  static void EnableWebUSBOnServiceWorkers(bool);
  static bool IsWebUSBOnServiceWorkersEnabled();
  static void EnableWebXR(bool);
  static bool IsWebXREnabled();
  static void EnableWebXRDepthPerformance(bool);
  static bool IsWebXRDepthPerformanceEnabled();
  static void EnableWebXRFrameRate(bool);
  static bool IsWebXRFrameRateEnabled();
  static void EnableWebXRFrontFacing(bool);
  static bool IsWebXRFrontFacingEnabled();
  static void EnableWebXRGPUBinding(bool);
  static bool IsWebXRGPUBindingEnabled();
  static void EnableWebXRImageTracking(bool);
  static bool IsWebXRImageTrackingEnabledByRuntimeFlag();
  static void EnableWebXRLayers(bool);
  static bool IsWebXRLayersEnabled();
  static void EnableWebXRLayersCommon(bool);
  static bool IsWebXRLayersCommonEnabled();
  static void EnableWebXRPlaneDetection(bool);
  static bool IsWebXRPlaneDetectionEnabledByRuntimeFlag();
  static void EnableWebXRPoseMotionData(bool);
  static bool IsWebXRPoseMotionDataEnabled();
  static void EnableWebXRSpecParity(bool);
  static bool IsWebXRSpecParityEnabled();

  WebRuntimeFeaturesBase() = delete;
};

}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_PLATFORM_WEB_RUNTIME_FEATURES_BASE_H_
