// ui/accessibility/mojom/ax_tree_data.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_TREE_DATA_MOJOM_DATA_VIEW_H_
#define UI_ACCESSIBILITY_MOJOM_AX_TREE_DATA_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/accessibility/mojom/ax_tree_data.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"


namespace ax::mojom {
class AXTreeDataDataView;



}  // ax::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ax::mojom::AXTreeDataDataView> {
  using Data = ::ax::mojom::internal::AXTreeData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ax::mojom {


class AXTreeDataDataView {
 public:
  AXTreeDataDataView() = default;

  AXTreeDataDataView(
      internal::AXTreeData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTreeIdDataView(
      ::ax::mojom::AXTreeIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTreeId(UserType* output) {
    
    auto* pointer = !data_->tree_id.is_null() ? &data_->tree_id : nullptr;
    return mojo::internal::Deserialize<::ax::mojom::AXTreeIDDataView>(
        pointer, output, message_);
  }
  inline void GetParentTreeIdDataView(
      ::ax::mojom::AXTreeIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParentTreeId(UserType* output) {
    
    auto* pointer = !data_->parent_tree_id.is_null() ? &data_->parent_tree_id : nullptr;
    return mojo::internal::Deserialize<::ax::mojom::AXTreeIDDataView>(
        pointer, output, message_);
  }
  inline void GetFocusedTreeIdDataView(
      ::ax::mojom::AXTreeIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFocusedTreeId(UserType* output) {
    
    auto* pointer = !data_->focused_tree_id.is_null() ? &data_->focused_tree_id : nullptr;
    return mojo::internal::Deserialize<::ax::mojom::AXTreeIDDataView>(
        pointer, output, message_);
  }
  inline void GetDoctypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDoctype(UserType* output) {
    
    auto* pointer = data_->doctype.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool loaded() const {
    return data_->loaded;
  }
  float loading_progress() const {
    return data_->loading_progress;
  }
  inline void GetMimetypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimetype(UserType* output) {
    
    auto* pointer = data_->mimetype.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t focus_id() const {
    return data_->focus_id;
  }
  bool sel_is_backward() const {
    return data_->sel_is_backward;
  }
  int32_t sel_anchor_object_id() const {
    return data_->sel_anchor_object_id;
  }
  int32_t sel_anchor_offset() const {
    return data_->sel_anchor_offset;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSelAnchorAffinity(UserType* output) const {
    auto data_value = data_->sel_anchor_affinity;
    return mojo::internal::Deserialize<::ax::mojom::TextAffinity>(
        data_value, output);
  }
  ::ax::mojom::TextAffinity sel_anchor_affinity() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::TextAffinity>(data_->sel_anchor_affinity));
  }
  int32_t sel_focus_object_id() const {
    return data_->sel_focus_object_id;
  }
  int32_t sel_focus_offset() const {
    return data_->sel_focus_offset;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSelFocusAffinity(UserType* output) const {
    auto data_value = data_->sel_focus_affinity;
    return mojo::internal::Deserialize<::ax::mojom::TextAffinity>(
        data_value, output);
  }
  ::ax::mojom::TextAffinity sel_focus_affinity() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::TextAffinity>(data_->sel_focus_affinity));
  }
  int32_t root_scroller_id() const {
    return data_->root_scroller_id;
  }
  inline void GetMetadataDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMetadata` instead "
    "of `ReadMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 2
                    ? data_->metadata.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AXTreeData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ax::mojom

#endif  // UI_ACCESSIBILITY_MOJOM_AX_TREE_DATA_MOJOM_DATA_VIEW_H_