// ui/gfx/mojom/mask_filter_info.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/gfx/mojom/mask_filter_info.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gfx/mojom/mask_filter_info.mojom-params-data.h"
#include "ui/gfx/mojom/mask_filter_info.mojom-shared-message-ids.h"

#include "ui/gfx/mojom/mask_filter_info.mojom-import-headers.h"
#include "ui/gfx/mojom/mask_filter_info.mojom-test-utils.h"


namespace gfx::mojom {
MaskFilterInfo::MaskFilterInfo()
    : rounded_corner_bounds(),
      gradient_mask() {}

MaskFilterInfo::MaskFilterInfo(
    const ::gfx::RRectF& rounded_corner_bounds_in,
    const std::optional<::gfx::LinearGradient>& gradient_mask_in)
    : rounded_corner_bounds(std::move(rounded_corner_bounds_in)),
      gradient_mask(std::move(gradient_mask_in)) {}

MaskFilterInfo::~MaskFilterInfo() = default;

void MaskFilterInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rounded_corner_bounds"), this->rounded_corner_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RRectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gradient_mask"), this->gradient_mask,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::LinearGradient>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MaskFilterInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // gfx::mojom


namespace mojo {


// static
bool StructTraits<::gfx::mojom::MaskFilterInfo::DataView, ::gfx::mojom::MaskFilterInfoPtr>::Read(
    ::gfx::mojom::MaskFilterInfo::DataView input,
    ::gfx::mojom::MaskFilterInfoPtr* output) {
  bool success = true;
  ::gfx::mojom::MaskFilterInfoPtr result(::gfx::mojom::MaskFilterInfo::New());
  
      if (success && !input.ReadRoundedCornerBounds(&result->rounded_corner_bounds))
        success = false;
      if (success && !input.ReadGradientMask(&result->gradient_mask))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace gfx::mojom {




}  // gfx::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif