// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes one or more route server endpoints.
//
// A route server endpoint is an Amazon Web Services-managed component inside a
// subnet that facilitates [BGP (Border Gateway Protocol)]connections between your route server and your BGP
// peers.
//
// For more information see [Dynamic routing in your VPC with VPC Route Server] in the Amazon VPC User Guide.
//
// [Dynamic routing in your VPC with VPC Route Server]: https://docs.aws.amazon.com/vpc/latest/userguide/dynamic-routing-route-server.html
// [BGP (Border Gateway Protocol)]: https://en.wikipedia.org/wiki/Border_Gateway_Protocol
func (c *Client) DescribeRouteServerEndpoints(ctx context.Context, params *DescribeRouteServerEndpointsInput, optFns ...func(*Options)) (*DescribeRouteServerEndpointsOutput, error) {
	if params == nil {
		params = &DescribeRouteServerEndpointsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeRouteServerEndpoints", params, optFns, c.addOperationDescribeRouteServerEndpointsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeRouteServerEndpointsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeRouteServerEndpointsInput struct {

	// A check for whether you have the required permissions for the action without
	// actually making the request and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// One or more filters to apply to the describe request.
	Filters []types.Filter

	// The maximum number of results to return with a single call.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	// The IDs of the route server endpoints to describe.
	RouteServerEndpointIds []string

	noSmithyDocumentSerde
}

type DescribeRouteServerEndpointsOutput struct {

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Information about the described route server endpoints.
	RouteServerEndpoints []types.RouteServerEndpoint

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeRouteServerEndpointsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeRouteServerEndpoints{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeRouteServerEndpoints{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeRouteServerEndpoints"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeRouteServerEndpoints(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeRouteServerEndpointsPaginatorOptions is the paginator options for
// DescribeRouteServerEndpoints
type DescribeRouteServerEndpointsPaginatorOptions struct {
	// The maximum number of results to return with a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeRouteServerEndpointsPaginator is a paginator for
// DescribeRouteServerEndpoints
type DescribeRouteServerEndpointsPaginator struct {
	options   DescribeRouteServerEndpointsPaginatorOptions
	client    DescribeRouteServerEndpointsAPIClient
	params    *DescribeRouteServerEndpointsInput
	nextToken *string
	firstPage bool
}

// NewDescribeRouteServerEndpointsPaginator returns a new
// DescribeRouteServerEndpointsPaginator
func NewDescribeRouteServerEndpointsPaginator(client DescribeRouteServerEndpointsAPIClient, params *DescribeRouteServerEndpointsInput, optFns ...func(*DescribeRouteServerEndpointsPaginatorOptions)) *DescribeRouteServerEndpointsPaginator {
	if params == nil {
		params = &DescribeRouteServerEndpointsInput{}
	}

	options := DescribeRouteServerEndpointsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeRouteServerEndpointsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeRouteServerEndpointsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeRouteServerEndpoints page.
func (p *DescribeRouteServerEndpointsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeRouteServerEndpointsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeRouteServerEndpoints(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeRouteServerEndpointsAPIClient is a client that implements the
// DescribeRouteServerEndpoints operation.
type DescribeRouteServerEndpointsAPIClient interface {
	DescribeRouteServerEndpoints(context.Context, *DescribeRouteServerEndpointsInput, ...func(*Options)) (*DescribeRouteServerEndpointsOutput, error)
}

var _ DescribeRouteServerEndpointsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeRouteServerEndpoints(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeRouteServerEndpoints",
	}
}
