// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The access configuration for the cluster.
type AccessConfigResponse struct {

	// The current authentication mode of the cluster.
	AuthenticationMode AuthenticationMode

	// Specifies whether or not the cluster creator IAM principal was set as a cluster
	// admin access entry during cluster creation time.
	BootstrapClusterCreatorAdminPermissions *bool

	noSmithyDocumentSerde
}

// An access entry allows an IAM principal (user or role) to access your cluster.
// Access entries can replace the need to maintain the aws-auth ConfigMap for
// authentication. For more information about access entries, see [Access entries]in the Amazon
// EKS User Guide.
//
// [Access entries]: https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html
type AccessEntry struct {

	// The ARN of the access entry.
	AccessEntryArn *string

	// The name of your cluster.
	ClusterName *string

	// The Unix epoch timestamp at object creation.
	CreatedAt *time.Time

	// A name that you've specified in a Kubernetes RoleBinding or ClusterRoleBinding
	// object so that Kubernetes authorizes the principalARN access to cluster objects.
	KubernetesGroups []string

	// The Unix epoch timestamp for the last modification to the object.
	ModifiedAt *time.Time

	// The ARN of the IAM principal for the access entry. If you ever delete the IAM
	// principal with this ARN, the access entry isn't automatically deleted. We
	// recommend that you delete the access entry with an ARN for an IAM principal that
	// you delete. If you don't delete the access entry and ever recreate the IAM
	// principal, even if it has the same ARN, the access entry won't work. This is
	// because even though the ARN is the same for the recreated IAM principal, the
	// roleID or userID (you can see this with the Security Token Service
	// GetCallerIdentity API) is different for the recreated IAM principal than it was
	// for the original IAM principal. Even though you don't see the IAM principal's
	// roleID or userID for an access entry, Amazon EKS stores it with the access
	// entry.
	PrincipalArn *string

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to any
	// other cluster or Amazon Web Services resources.
	Tags map[string]string

	// The type of the access entry.
	Type *string

	// The name of a user that can authenticate to your cluster.
	Username *string

	noSmithyDocumentSerde
}

// An access policy includes permissions that allow Amazon EKS to authorize an IAM
// principal to work with Kubernetes objects on your cluster. The policies are
// managed by Amazon EKS, but they're not IAM policies. You can't view the
// permissions in the policies using the API. The permissions for many of the
// policies are similar to the Kubernetes cluster-admin , admin , edit , and view
// cluster roles. For more information about these cluster roles, see [User-facing roles]in the
// Kubernetes documentation. To view the contents of the policies, see [Access policy permissions]in the
// Amazon EKS User Guide.
//
// [User-facing roles]: https://kubernetes.io/docs/reference/access-authn-authz/rbac/#user-facing-roles
// [Access policy permissions]: https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions
type AccessPolicy struct {

	// The ARN of the access policy.
	Arn *string

	// The name of the access policy.
	Name *string

	noSmithyDocumentSerde
}

// The scope of an AccessPolicy that's associated to an AccessEntry .
type AccessScope struct {

	// A Kubernetes namespace that an access policy is scoped to. A value is required
	// if you specified namespace for Type .
	Namespaces []string

	// The scope type of an access policy.
	Type AccessScopeType

	noSmithyDocumentSerde
}

// An Amazon EKS add-on. For more information, see [Amazon EKS add-ons] in the Amazon EKS User Guide.
//
// [Amazon EKS add-ons]: https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html
type Addon struct {

	// The Amazon Resource Name (ARN) of the add-on.
	AddonArn *string

	// The name of the add-on.
	AddonName *string

	// The version of the add-on.
	AddonVersion *string

	// The name of your cluster.
	ClusterName *string

	// The configuration values that you provided.
	ConfigurationValues *string

	// The Unix epoch timestamp at object creation.
	CreatedAt *time.Time

	// An object that represents the health of the add-on.
	Health *AddonHealth

	// Information about an Amazon EKS add-on from the Amazon Web Services Marketplace.
	MarketplaceInformation *MarketplaceInformation

	// The Unix epoch timestamp for the last modification to the object.
	ModifiedAt *time.Time

	// The namespace configuration for the addon. This specifies the Kubernetes
	// namespace where the addon is installed.
	NamespaceConfig *AddonNamespaceConfigResponse

	// The owner of the add-on.
	Owner *string

	// An array of EKS Pod Identity associations owned by the add-on. Each association
	// maps a role to a service account in a namespace in the cluster.
	//
	// For more information, see [Attach an IAM Role to an Amazon EKS add-on using EKS Pod Identity] in the Amazon EKS User Guide.
	//
	// [Attach an IAM Role to an Amazon EKS add-on using EKS Pod Identity]: https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html
	PodIdentityAssociations []string

	// The publisher of the add-on.
	Publisher *string

	// The Amazon Resource Name (ARN) of the IAM role that's bound to the Kubernetes
	// ServiceAccount object that the add-on uses.
	ServiceAccountRoleArn *string

	// The status of the add-on.
	Status AddonStatus

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to any
	// other cluster or Amazon Web Services resources.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The summary information about the Amazon EKS add-on compatibility for the next
// Kubernetes version for an insight check in the UPGRADE_READINESS category.
type AddonCompatibilityDetail struct {

	// The list of compatible Amazon EKS add-on versions for the next Kubernetes
	// version.
	CompatibleVersions []string

	// The name of the Amazon EKS add-on.
	Name *string

	noSmithyDocumentSerde
}

// The health of the add-on.
type AddonHealth struct {

	// An object representing the health issues for an add-on.
	Issues []AddonIssue

	noSmithyDocumentSerde
}

// Information about an add-on.
type AddonInfo struct {

	// The name of the add-on.
	AddonName *string

	// An object representing information about available add-on versions and
	// compatible Kubernetes versions.
	AddonVersions []AddonVersionInfo

	// The default Kubernetes namespace where this addon is typically installed if no
	// custom namespace is specified.
	DefaultNamespace *string

	// Information about the add-on from the Amazon Web Services Marketplace.
	MarketplaceInformation *MarketplaceInformation

	// The owner of the add-on.
	Owner *string

	// The publisher of the add-on.
	Publisher *string

	// The type of the add-on.
	Type *string

	noSmithyDocumentSerde
}

// An issue related to an add-on.
type AddonIssue struct {

	// A code that describes the type of issue.
	Code AddonIssueCode

	// A message that provides details about the issue and what might cause it.
	Message *string

	// The resource IDs of the issue.
	ResourceIds []string

	noSmithyDocumentSerde
}

// The namespace configuration request object for specifying a custom namespace
// when creating an addon.
type AddonNamespaceConfigRequest struct {

	// The name of the Kubernetes namespace to install the addon in. Must be a valid
	// RFC 1123 DNS label.
	Namespace *string

	noSmithyDocumentSerde
}

// The namespace configuration response object containing information about the
// namespace where an addon is installed.
type AddonNamespaceConfigResponse struct {

	// The name of the Kubernetes namespace where the addon is installed.
	Namespace *string

	noSmithyDocumentSerde
}

// A type of EKS Pod Identity association owned by an Amazon EKS add-on.
//
// Each association maps a role to a service account in a namespace in the cluster.
//
// For more information, see [Attach an IAM Role to an Amazon EKS add-on using EKS Pod Identity] in the Amazon EKS User Guide.
//
// [Attach an IAM Role to an Amazon EKS add-on using EKS Pod Identity]: https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html
type AddonPodIdentityAssociations struct {

	// The ARN of an IAM Role.
	//
	// This member is required.
	RoleArn *string

	// The name of a Kubernetes Service Account.
	//
	// This member is required.
	ServiceAccount *string

	noSmithyDocumentSerde
}

// Information about how to configure IAM for an add-on.
type AddonPodIdentityConfiguration struct {

	// A suggested IAM Policy for the add-on.
	RecommendedManagedPolicies []string

	// The Kubernetes Service Account name used by the add-on.
	ServiceAccount *string

	noSmithyDocumentSerde
}

// Information about an add-on version.
type AddonVersionInfo struct {

	// The version of the add-on.
	AddonVersion *string

	// The architectures that the version supports.
	Architecture []string

	// An object representing the compatibilities of a version.
	Compatibilities []Compatibility

	// Indicates the compute type of the add-on version.
	ComputeTypes []string

	// Whether the add-on requires configuration.
	RequiresConfiguration bool

	// Indicates if the add-on requires IAM Permissions to operate, such as networking
	// permissions.
	RequiresIamPermissions bool

	noSmithyDocumentSerde
}

// Configuration for integrating Argo CD with IAM Identity CenterIAM; Identity
// Center. This allows you to use your organization's identity provider for
// authentication to Argo CD.
type ArgoCdAwsIdcConfigRequest struct {

	// The Amazon Resource Name (ARN) of the IAM Identity CenterIAM; Identity Center
	// instance to use for authentication.
	//
	// This member is required.
	IdcInstanceArn *string

	// The Region where your IAM Identity CenterIAM; Identity Center instance is
	// located.
	IdcRegion *string

	noSmithyDocumentSerde
}

// The response object containing IAM Identity CenterIAM; Identity Center
// configuration details for an Argo CD capability.
type ArgoCdAwsIdcConfigResponse struct {

	// The Amazon Resource Name (ARN) of the IAM Identity CenterIAM; Identity Center
	// instance used for authentication.
	IdcInstanceArn *string

	// The Amazon Resource Name (ARN) of the managed application created in IAM
	// Identity CenterIAM; Identity Center for this Argo CD capability. This
	// application is automatically created and managed by Amazon EKS.
	IdcManagedApplicationArn *string

	// The Region where the IAM Identity CenterIAM; Identity Center instance is
	// located.
	IdcRegion *string

	noSmithyDocumentSerde
}

// Configuration settings for an Argo CD capability. This includes the Kubernetes
// namespace, IAM Identity CenterIAM; Identity Center integration, RBAC role
// mappings, and network access configuration.
type ArgoCdConfigRequest struct {

	// Configuration for IAM Identity CenterIAM; Identity Center integration. When
	// configured, users can authenticate to Argo CD using their IAM Identity
	// CenterIAM; Identity Center credentials.
	//
	// This member is required.
	AwsIdc *ArgoCdAwsIdcConfigRequest

	// The Kubernetes namespace where Argo CD resources will be created. If not
	// specified, the default namespace is used.
	Namespace *string

	// Configuration for network access to the Argo CD capability's managed API server
	// endpoint. By default, the Argo CD server is accessible via a public endpoint.
	// You can optionally specify one or more VPC endpoint IDs to enable private
	// connectivity from your VPCs. When VPC endpoints are configured, public access is
	// blocked and the Argo CD server is only accessible through the specified VPC
	// endpoints.
	NetworkAccess *ArgoCdNetworkAccessConfigRequest

	// A list of role mappings that define which IAM Identity CenterIAM; Identity
	// Center users or groups have which Argo CD roles. Each mapping associates an Argo
	// CD role ( ADMIN , EDITOR , or VIEWER ) with one or more IAM Identity CenterIAM;
	// Identity Center identities.
	RbacRoleMappings []ArgoCdRoleMapping

	noSmithyDocumentSerde
}

// The response object containing Argo CD configuration details, including the
// server URL that you use to access the Argo CD web interface and API.
type ArgoCdConfigResponse struct {

	// The IAM Identity CenterIAM; Identity Center integration configuration.
	AwsIdc *ArgoCdAwsIdcConfigResponse

	// The Kubernetes namespace where Argo CD resources are monitored by your Argo CD
	// Capability.
	Namespace *string

	// The network access configuration for the Argo CD capability's managed API
	// server endpoint. If VPC endpoint IDs are specified, public access is blocked and
	// the Argo CD server is only accessible through the specified VPC endpoints.
	NetworkAccess *ArgoCdNetworkAccessConfigResponse

	// The list of role mappings that define which IAM Identity CenterIAM; Identity
	// Center users or groups have which Argo CD roles.
	RbacRoleMappings []ArgoCdRoleMapping

	// The URL of the Argo CD server. Use this URL to access the Argo CD web interface
	// and API.
	ServerUrl *string

	noSmithyDocumentSerde
}

// Configuration for network access to the Argo CD capability's managed API server
// endpoint. When VPC endpoint IDs are specified, public access is blocked and the
// Argo CD server is only accessible through the specified VPC endpoints.
type ArgoCdNetworkAccessConfigRequest struct {

	// A list of VPC endpoint IDs to associate with the managed Argo CD API server
	// endpoint. Each VPC endpoint provides private connectivity from a specific VPC to
	// the Argo CD server. You can specify multiple VPC endpoint IDs to enable access
	// from multiple VPCs.
	VpceIds []string

	noSmithyDocumentSerde
}

// The response object containing network access configuration for the Argo CD
// capability's managed API server endpoint. If VPC endpoint IDs are present,
// public access is blocked and the Argo CD server is only accessible through the
// specified VPC endpoints.
type ArgoCdNetworkAccessConfigResponse struct {

	// The list of VPC endpoint IDs associated with the managed Argo CD API server
	// endpoint. Each VPC endpoint provides private connectivity from a specific VPC to
	// the Argo CD server.
	VpceIds []string

	noSmithyDocumentSerde
}

// A mapping between an Argo CD role and IAM Identity CenterIAM; Identity Center
// identities. This defines which users or groups have specific permissions in Argo
// CD.
type ArgoCdRoleMapping struct {

	// A list of IAM Identity CenterIAM; Identity Center identities (users or groups)
	// that should be assigned this Argo CD role.
	//
	// This member is required.
	Identities []SsoIdentity

	// The Argo CD role to assign. Valid values are:
	//
	//   - ADMIN – Full administrative access to Argo CD.
	//
	//   - EDITOR – Edit access to Argo CD resources.
	//
	//   - VIEWER – Read-only access to Argo CD resources.
	//
	// This member is required.
	Role ArgoCdRole

	noSmithyDocumentSerde
}

// An access policy association.
type AssociatedAccessPolicy struct {

	// The scope of the access policy.
	AccessScope *AccessScope

	// The date and time the AccessPolicy was associated with an AccessEntry .
	AssociatedAt *time.Time

	// The Unix epoch timestamp for the last modification to the object.
	ModifiedAt *time.Time

	// The ARN of the AccessPolicy .
	PolicyArn *string

	noSmithyDocumentSerde
}

// An Auto Scaling group that is associated with an Amazon EKS managed node group.
type AutoScalingGroup struct {

	// The name of the Auto Scaling group associated with an Amazon EKS managed node
	// group.
	Name *string

	noSmithyDocumentSerde
}

// Indicates the current configuration of the block storage capability on your EKS
// Auto Mode cluster. For example, if the capability is enabled or disabled. If the
// block storage capability is enabled, EKS Auto Mode will create and delete EBS
// volumes in your Amazon Web Services account. For more information, see EKS Auto
// Mode block storage capability in the Amazon EKS User Guide.
type BlockStorage struct {

	// Indicates if the block storage capability is enabled on your EKS Auto Mode
	// cluster. If the block storage capability is enabled, EKS Auto Mode will create
	// and delete EBS volumes in your Amazon Web Services account.
	Enabled *bool

	noSmithyDocumentSerde
}

// An object representing a managed capability in an Amazon EKS cluster. This
// includes all configuration, status, and health information for the capability.
type Capability struct {

	// The Amazon Resource Name (ARN) of the capability.
	Arn *string

	// The unique name of the capability within the cluster.
	CapabilityName *string

	// The name of the Amazon EKS cluster that contains this capability.
	ClusterName *string

	// The configuration settings for the capability. The structure varies depending
	// on the capability type.
	Configuration *CapabilityConfigurationResponse

	// The Unix epoch timestamp in seconds for when the capability was created.
	CreatedAt *time.Time

	// The delete propagation policy for the capability. Currently, the only supported
	// value is RETAIN , which keeps all resources managed by the capability when the
	// capability is deleted.
	DeletePropagationPolicy CapabilityDeletePropagationPolicy

	// Health information for the capability, including any issues that may be
	// affecting its operation.
	Health *CapabilityHealth

	// The Unix epoch timestamp in seconds for when the capability was last modified.
	ModifiedAt *time.Time

	// The Amazon Resource Name (ARN) of the IAM role that the capability uses to
	// interact with Amazon Web Services services.
	RoleArn *string

	// The current status of the capability. Valid values include:
	//
	//   - CREATING – The capability is being created.
	//
	//   - ACTIVE – The capability is running and available.
	//
	//   - UPDATING – The capability is being updated.
	//
	//   - DELETING – The capability is being deleted.
	//
	//   - CREATE_FAILED – The capability creation failed.
	//
	//   - UPDATE_FAILED – The capability update failed.
	//
	//   - DELETE_FAILED – The capability deletion failed.
	Status CapabilityStatus

	// The metadata that you apply to a resource to help you categorize and organize
	// them. Each tag consists of a key and an optional value. You define them.
	//
	// The following basic restrictions apply to tags:
	//
	//   - Maximum number of tags per resource – 50
	//
	//   - For each resource, each tag key must be unique, and each tag key can have
	//   only one value.
	//
	//   - Maximum key length – 128 Unicode characters in UTF-8
	//
	//   - Maximum value length – 256 Unicode characters in UTF-8
	//
	//   - If your tagging schema is used across multiple services and resources,
	//   remember that other services may have restrictions on allowed characters.
	//   Generally allowed characters are: letters, numbers, and spaces representable in
	//   UTF-8, and the following characters: + - = . _ : / @.
	//
	//   - Tag keys and values are case-sensitive.
	//
	//   - Do not use aws: , AWS: , or any upper or lowercase combination of such as a
	//   prefix for either keys or values as it is reserved for Amazon Web Services use.
	//   You cannot edit or delete tag keys or values with this prefix. Tags with this
	//   prefix do not count against your tags per resource limit.
	Tags map[string]string

	// The type of capability. Valid values are ACK , ARGOCD , or KRO .
	Type CapabilityType

	// The version of the capability software that is currently running.
	Version *string

	noSmithyDocumentSerde
}

// Configuration settings for a capability. The structure of this object varies
// depending on the capability type.
type CapabilityConfigurationRequest struct {

	// Configuration settings specific to Argo CD capabilities. This field is only
	// used when creating or updating an Argo CD capability.
	ArgoCd *ArgoCdConfigRequest

	noSmithyDocumentSerde
}

// The response object containing capability configuration details.
type CapabilityConfigurationResponse struct {

	// Configuration settings for an Argo CD capability, including the server URL and
	// other Argo CD-specific settings.
	ArgoCd *ArgoCdConfigResponse

	noSmithyDocumentSerde
}

// Health information for a capability, including any issues that may be affecting
// its operation.
type CapabilityHealth struct {

	// A list of issues affecting the capability. If this list is empty, the
	// capability is healthy.
	Issues []CapabilityIssue

	noSmithyDocumentSerde
}

// An issue affecting a capability's health or operation.
type CapabilityIssue struct {

	// A code identifying the type of issue. This can be used to programmatically
	// handle specific issue types.
	Code CapabilityIssueCode

	// A human-readable message describing the issue and potential remediation steps.
	Message *string

	noSmithyDocumentSerde
}

// A summary of a capability, containing basic information without the full
// configuration details. This is returned by the ListCapabilities operation.
type CapabilitySummary struct {

	// The Amazon Resource Name (ARN) of the capability.
	Arn *string

	// The unique name of the capability within the cluster.
	CapabilityName *string

	// The Unix epoch timestamp in seconds for when the capability was created.
	CreatedAt *time.Time

	// The Unix epoch timestamp in seconds for when the capability was last modified.
	ModifiedAt *time.Time

	// The current status of the capability.
	Status CapabilityStatus

	// The type of capability. Valid values are ACK , ARGOCD , or KRO .
	Type CapabilityType

	// The version of the capability software that is currently running.
	Version *string

	noSmithyDocumentSerde
}

// An object representing the certificate-authority-data for your cluster.
type Certificate struct {

	// The Base64-encoded certificate data required to communicate with your cluster.
	// Add this to the certificate-authority-data section of the kubeconfig file for
	// your cluster.
	Data *string

	noSmithyDocumentSerde
}

// Details about clients using the deprecated resources.
type ClientStat struct {

	// The timestamp of the last request seen from the Kubernetes client.
	LastRequestTime *time.Time

	// The number of requests from the Kubernetes client seen over the last 30 days.
	NumberOfRequestsLast30Days int32

	// The user agent of the Kubernetes client using the deprecated resource.
	UserAgent *string

	noSmithyDocumentSerde
}

// An object representing an Amazon EKS cluster.
type Cluster struct {

	// The access configuration for the cluster.
	AccessConfig *AccessConfigResponse

	// The Amazon Resource Name (ARN) of the cluster.
	Arn *string

	// The certificate-authority-data for your cluster.
	CertificateAuthority *Certificate

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string

	// Indicates the current configuration of the compute capability on your EKS Auto
	// Mode cluster. For example, if the capability is enabled or disabled. If the
	// compute capability is enabled, EKS Auto Mode will create and delete EC2 Managed
	// Instances in your Amazon Web Services account. For more information, see EKS
	// Auto Mode compute capability in the Amazon EKS User Guide.
	ComputeConfig *ComputeConfigResponse

	// The configuration used to connect to a cluster for registration.
	ConnectorConfig *ConnectorConfigResponse

	// The control plane scaling tier configuration. For more information, see EKS
	// Provisioned Control Plane in the Amazon EKS User Guide.
	ControlPlaneScalingConfig *ControlPlaneScalingConfig

	// The Unix epoch timestamp at object creation.
	CreatedAt *time.Time

	// The current deletion protection setting for the cluster. When true , deletion
	// protection is enabled and the cluster cannot be deleted until protection is
	// disabled. When false , the cluster can be deleted normally. This setting only
	// applies to clusters in an active state.
	DeletionProtection *bool

	// The encryption configuration for the cluster.
	EncryptionConfig []EncryptionConfig

	// The endpoint for your Kubernetes API server.
	Endpoint *string

	// An object representing the health of your Amazon EKS cluster.
	Health *ClusterHealth

	// The ID of your local Amazon EKS cluster on an Amazon Web Services Outpost. This
	// property isn't available for an Amazon EKS cluster on the Amazon Web Services
	// cloud.
	Id *string

	// The identity provider information for the cluster.
	Identity *Identity

	// The Kubernetes network configuration for the cluster.
	KubernetesNetworkConfig *KubernetesNetworkConfigResponse

	// The logging configuration for your cluster.
	Logging *Logging

	// The name of your cluster.
	Name *string

	// An object representing the configuration of your local Amazon EKS cluster on an
	// Amazon Web Services Outpost. This object isn't available for clusters on the
	// Amazon Web Services cloud.
	OutpostConfig *OutpostConfigResponse

	// The platform version of your Amazon EKS cluster. For more information about
	// clusters deployed on the Amazon Web Services Cloud, see [Platform versions]in the Amazon EKS User
	// Guide . For more information about local clusters deployed on an Outpost, see [Amazon EKS local cluster platform versions]
	// in the Amazon EKS User Guide .
	//
	// [Platform versions]: https://docs.aws.amazon.com/eks/latest/userguide/platform-versions.html
	// [Amazon EKS local cluster platform versions]: https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-platform-versions.html
	PlatformVersion *string

	// The configuration in the cluster for EKS Hybrid Nodes. You can add, change, or
	// remove this configuration after the cluster is created.
	RemoteNetworkConfig *RemoteNetworkConfigResponse

	// The VPC configuration used by the cluster control plane. Amazon EKS VPC
	// resources have specific requirements to work properly with Kubernetes. For more
	// information, see [Cluster VPC considerations]and [Cluster security group considerations] in the Amazon EKS User Guide.
	//
	// [Cluster security group considerations]: https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html
	// [Cluster VPC considerations]: https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html
	ResourcesVpcConfig *VpcConfigResponse

	// The Amazon Resource Name (ARN) of the IAM role that provides permissions for
	// the Kubernetes control plane to make calls to Amazon Web Services API operations
	// on your behalf.
	RoleArn *string

	// The current status of the cluster.
	Status ClusterStatus

	// Indicates the current configuration of the block storage capability on your EKS
	// Auto Mode cluster. For example, if the capability is enabled or disabled. If the
	// block storage capability is enabled, EKS Auto Mode will create and delete EBS
	// volumes in your Amazon Web Services account. For more information, see EKS Auto
	// Mode block storage capability in the Amazon EKS User Guide.
	StorageConfig *StorageConfigResponse

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to any
	// other cluster or Amazon Web Services resources.
	Tags map[string]string

	// This value indicates if extended support is enabled or disabled for the cluster.
	//
	// [Learn more about EKS Extended Support in the Amazon EKS User Guide.]
	//
	// [Learn more about EKS Extended Support in the Amazon EKS User Guide.]: https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html
	UpgradePolicy *UpgradePolicyResponse

	// The Kubernetes server version for the cluster.
	Version *string

	// The configuration for zonal shift for the cluster.
	ZonalShiftConfig *ZonalShiftConfigResponse

	noSmithyDocumentSerde
}

// An object representing the health of your Amazon EKS cluster.
type ClusterHealth struct {

	// An object representing the health issues of your Amazon EKS cluster.
	Issues []ClusterIssue

	noSmithyDocumentSerde
}

// An issue with your Amazon EKS cluster.
type ClusterIssue struct {

	// The error code of the issue.
	Code ClusterIssueCode

	// A description of the issue.
	Message *string

	// The resource IDs that the issue relates to.
	ResourceIds []string

	noSmithyDocumentSerde
}

// Contains details about a specific EKS cluster version.
type ClusterVersionInformation struct {

	// The type of cluster this version is for.
	ClusterType *string

	// The Kubernetes version for the cluster.
	ClusterVersion *string

	// Default platform version for this Kubernetes version.
	DefaultPlatformVersion *string

	// Indicates if this is a default version.
	DefaultVersion bool

	// Date when extended support ends for this version.
	EndOfExtendedSupportDate *time.Time

	// Date when standard support ends for this version.
	EndOfStandardSupportDate *time.Time

	// The patch version of Kubernetes for this cluster version.
	KubernetesPatchVersion *string

	// The release date of this cluster version.
	ReleaseDate *time.Time

	// This field is deprecated. Use versionStatus instead, as that field matches for
	// input and output of this action.
	//
	// Current status of this cluster version.
	Status ClusterVersionStatus

	// Current status of this cluster version.
	VersionStatus VersionStatus

	noSmithyDocumentSerde
}

// Compatibility information.
type Compatibility struct {

	// The supported Kubernetes version of the cluster.
	ClusterVersion *string

	// The supported default version.
	DefaultVersion bool

	// The supported compute platform.
	PlatformVersions []string

	noSmithyDocumentSerde
}

// Request to update the configuration of the compute capability of your EKS Auto
// Mode cluster. For example, enable the capability. For more information, see EKS
// Auto Mode compute capability in the Amazon EKS User Guide.
type ComputeConfigRequest struct {

	// Request to enable or disable the compute capability on your EKS Auto Mode
	// cluster. If the compute capability is enabled, EKS Auto Mode will create and
	// delete EC2 Managed Instances in your Amazon Web Services account.
	Enabled *bool

	// Configuration for node pools that defines the compute resources for your EKS
	// Auto Mode cluster. For more information, see EKS Auto Mode Node Pools in the
	// Amazon EKS User Guide.
	NodePools []string

	// The ARN of the IAM Role EKS will assign to EC2 Managed Instances in your EKS
	// Auto Mode cluster. This value cannot be changed after the compute capability of
	// EKS Auto Mode is enabled. For more information, see the IAM Reference in the
	// Amazon EKS User Guide.
	NodeRoleArn *string

	noSmithyDocumentSerde
}

// Indicates the status of the request to update the compute capability of your
// EKS Auto Mode cluster.
type ComputeConfigResponse struct {

	// Indicates if the compute capability is enabled on your EKS Auto Mode cluster.
	// If the compute capability is enabled, EKS Auto Mode will create and delete EC2
	// Managed Instances in your Amazon Web Services account.
	Enabled *bool

	// Indicates the current configuration of node pools in your EKS Auto Mode
	// cluster. For more information, see EKS Auto Mode Node Pools in the Amazon EKS
	// User Guide.
	NodePools []string

	// The ARN of the IAM Role EKS will assign to EC2 Managed Instances in your EKS
	// Auto Mode cluster.
	NodeRoleArn *string

	noSmithyDocumentSerde
}

// The configuration sent to a cluster for configuration.
type ConnectorConfigRequest struct {

	// The cloud provider for the target cluster to connect.
	//
	// This member is required.
	Provider ConnectorConfigProvider

	// The Amazon Resource Name (ARN) of the role that is authorized to request the
	// connector configuration.
	//
	// This member is required.
	RoleArn *string

	noSmithyDocumentSerde
}

// The full description of your connected cluster.
type ConnectorConfigResponse struct {

	// A unique code associated with the cluster for registration purposes.
	ActivationCode *string

	// The expiration time of the connected cluster. The cluster's YAML file must be
	// applied through the native provider.
	ActivationExpiry *time.Time

	// A unique ID associated with the cluster for registration purposes.
	ActivationId *string

	// The cluster's cloud service provider.
	Provider *string

	// The Amazon Resource Name (ARN) of the role to communicate with services from
	// the connected Kubernetes cluster.
	RoleArn *string

	noSmithyDocumentSerde
}

// The placement configuration for all the control plane instances of your local
// Amazon EKS cluster on an Amazon Web Services Outpost. For more information, see [Capacity considerations]
// in the Amazon EKS User Guide.
//
// [Capacity considerations]: https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html
type ControlPlanePlacementRequest struct {

	// The name of the placement group for the Kubernetes control plane instances.
	// This setting can't be changed after cluster creation.
	GroupName *string

	noSmithyDocumentSerde
}

// The placement configuration for all the control plane instances of your local
// Amazon EKS cluster on an Amazon Web Services Outpost. For more information, see [Capacity considerations]
// in the Amazon EKS User Guide.
//
// [Capacity considerations]: https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html
type ControlPlanePlacementResponse struct {

	// The name of the placement group for the Kubernetes control plane instances.
	GroupName *string

	noSmithyDocumentSerde
}

// The control plane scaling tier configuration. For more information, see EKS
// Provisioned Control Plane in the Amazon EKS User Guide.
type ControlPlaneScalingConfig struct {

	// The control plane scaling tier configuration. Available options are standard ,
	// tier-xl , tier-2xl , or tier-4xl . For more information, see EKS Provisioned
	// Control Plane in the Amazon EKS User Guide.
	Tier ProvisionedControlPlaneTier

	noSmithyDocumentSerde
}

// The access configuration information for the cluster.
type CreateAccessConfigRequest struct {

	// The desired authentication mode for the cluster. If you create a cluster by
	// using the EKS API, Amazon Web Services SDKs, or CloudFormation, the default is
	// CONFIG_MAP . If you create the cluster by using the Amazon Web Services
	// Management Console, the default value is API_AND_CONFIG_MAP .
	AuthenticationMode AuthenticationMode

	// Specifies whether or not the cluster creator IAM principal was set as a cluster
	// admin access entry during cluster creation time. The default value is true .
	BootstrapClusterCreatorAdminPermissions *bool

	noSmithyDocumentSerde
}

// The summary information about deprecated resource usage for an insight check in
// the UPGRADE_READINESS category.
type DeprecationDetail struct {

	// Details about Kubernetes clients using the deprecated resources.
	ClientStats []ClientStat

	// The newer version of the resource to migrate to if applicable.
	ReplacedWith *string

	// The version of the software where the newer resource version became available
	// to migrate to if applicable.
	StartServingReplacementVersion *string

	// The version of the software where the deprecated resource version will stop
	// being served.
	StopServingVersion *string

	// The deprecated version of the resource.
	Usage *string

	noSmithyDocumentSerde
}

// An EKS Anywhere subscription authorizing the customer to support for licensed
// clusters and access to EKS Anywhere Curated Packages.
type EksAnywhereSubscription struct {

	// The Amazon Resource Name (ARN) for the subscription.
	Arn *string

	// A boolean indicating whether or not a subscription will auto renew when it
	// expires.
	AutoRenew bool

	// The Unix timestamp in seconds for when the subscription was created.
	CreatedAt *time.Time

	// The Unix timestamp in seconds for when the subscription is effective.
	EffectiveDate *time.Time

	// The Unix timestamp in seconds for when the subscription will expire or auto
	// renew, depending on the auto renew configuration of the subscription object.
	ExpirationDate *time.Time

	// UUID identifying a subscription.
	Id *string

	// Amazon Web Services License Manager ARN associated with the subscription.
	LicenseArns []string

	// The number of licenses included in a subscription. Valid values are between 1
	// and 100.
	LicenseQuantity int32

	// The type of licenses included in the subscription. Valid value is CLUSTER. With
	// the CLUSTER license type, each license covers support for a single EKS Anywhere
	// cluster.
	LicenseType EksAnywhereSubscriptionLicenseType

	// Includes all of the claims in the license token necessary to validate the
	// license for extended support.
	Licenses []License

	// The status of a subscription.
	Status *string

	// The metadata for a subscription to assist with categorization and organization.
	// Each tag consists of a key and an optional value. Subscription tags do not
	// propagate to any other resources associated with the subscription.
	Tags map[string]string

	// An EksAnywhereSubscriptionTerm object.
	Term *EksAnywhereSubscriptionTerm

	noSmithyDocumentSerde
}

// An object representing the term duration and term unit type of your
// subscription. This determines the term length of your subscription. Valid values
// are MONTHS for term unit and 12 or 36 for term duration, indicating a 12 month
// or 36 month subscription.
type EksAnywhereSubscriptionTerm struct {

	// The duration of the subscription term. Valid values are 12 and 36, indicating a
	// 12 month or 36 month subscription.
	Duration int32

	// The term unit of the subscription. Valid value is MONTHS .
	Unit EksAnywhereSubscriptionTermUnit

	noSmithyDocumentSerde
}

// Indicates the current configuration of the load balancing capability on your
// EKS Auto Mode cluster. For example, if the capability is enabled or disabled.
// For more information, see EKS Auto Mode load balancing capability in the Amazon
// EKS User Guide.
type ElasticLoadBalancing struct {

	// Indicates if the load balancing capability is enabled on your EKS Auto Mode
	// cluster. If the load balancing capability is enabled, EKS Auto Mode will create
	// and delete load balancers in your Amazon Web Services account.
	Enabled *bool

	noSmithyDocumentSerde
}

// The encryption configuration for the cluster.
type EncryptionConfig struct {

	// Key Management Service (KMS) key. Either the ARN or the alias can be used.
	Provider *Provider

	// Specifies the resources to be encrypted. The only supported value is secrets .
	Resources []string

	noSmithyDocumentSerde
}

// An object representing an error when an asynchronous operation fails.
type ErrorDetail struct {

	// A brief description of the error.
	//
	//   - SubnetNotFound: We couldn't find one of the subnets associated with the
	//   cluster.
	//
	//   - SecurityGroupNotFound: We couldn't find one of the security groups
	//   associated with the cluster.
	//
	//   - EniLimitReached: You have reached the elastic network interface limit for
	//   your account.
	//
	//   - IpNotAvailable: A subnet associated with the cluster doesn't have any
	//   available IP addresses.
	//
	//   - AccessDenied: You don't have permissions to perform the specified operation.
	//
	//   - OperationNotPermitted: The service role associated with the cluster doesn't
	//   have the required access permissions for Amazon EKS.
	//
	//   - VpcIdNotFound: We couldn't find the VPC associated with the cluster.
	ErrorCode ErrorCode

	// A more complete description of the error.
	ErrorMessage *string

	// An optional field that contains the resource IDs associated with the error.
	ResourceIds []string

	noSmithyDocumentSerde
}

// An object representing an Fargate profile.
type FargateProfile struct {

	// The name of your cluster.
	ClusterName *string

	// The Unix epoch timestamp at object creation.
	CreatedAt *time.Time

	// The full Amazon Resource Name (ARN) of the Fargate profile.
	FargateProfileArn *string

	// The name of the Fargate profile.
	FargateProfileName *string

	// The health status of the Fargate profile. If there are issues with your Fargate
	// profile's health, they are listed here.
	Health *FargateProfileHealth

	// The Amazon Resource Name (ARN) of the Pod execution role to use for any Pod
	// that matches the selectors in the Fargate profile. For more information, see [Pod execution role]Pod
	// in the Amazon EKS User Guide.
	//
	// [Pod execution role]: https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html
	PodExecutionRoleArn *string

	// The selectors to match for a Pod to use this Fargate profile.
	Selectors []FargateProfileSelector

	// The current status of the Fargate profile.
	Status FargateProfileStatus

	// The IDs of subnets to launch a Pod into.
	Subnets []string

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to any
	// other cluster or Amazon Web Services resources.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The health status of the Fargate profile. If there are issues with your Fargate
// profile's health, they are listed here.
type FargateProfileHealth struct {

	// Any issues that are associated with the Fargate profile.
	Issues []FargateProfileIssue

	noSmithyDocumentSerde
}

// An issue that is associated with the Fargate profile.
type FargateProfileIssue struct {

	// A brief description of the error.
	Code FargateProfileIssueCode

	// The error message associated with the issue.
	Message *string

	// The Amazon Web Services resources that are affected by this issue.
	ResourceIds []string

	noSmithyDocumentSerde
}

// An object representing an Fargate profile selector.
type FargateProfileSelector struct {

	// The Kubernetes labels that the selector should match. A pod must contain all of
	// the labels that are specified in the selector for it to be considered a match.
	Labels map[string]string

	// The Kubernetes namespace that the selector should match.
	Namespace *string

	noSmithyDocumentSerde
}

// An object representing an identity provider.
type Identity struct {

	// An object representing the [OpenID Connect] identity provider information.
	//
	// [OpenID Connect]: https://openid.net/connect/
	Oidc *OIDC

	noSmithyDocumentSerde
}

// An object representing an identity provider configuration.
type IdentityProviderConfig struct {

	// The name of the identity provider configuration.
	//
	// This member is required.
	Name *string

	// The type of the identity provider configuration. The only type available is oidc
	// .
	//
	// This member is required.
	Type *string

	noSmithyDocumentSerde
}

// The full description of your identity configuration.
type IdentityProviderConfigResponse struct {

	// An object representing an OpenID Connect (OIDC) identity provider configuration.
	Oidc *OidcIdentityProviderConfig

	noSmithyDocumentSerde
}

// A check that provides recommendations to remedy potential upgrade-impacting
// issues.
type Insight struct {

	// Links to sources that provide additional context on the insight.
	AdditionalInfo map[string]string

	// The category of the insight.
	Category Category

	// Summary information that relates to the category of the insight. Currently only
	// returned with certain insights having category UPGRADE_READINESS .
	CategorySpecificSummary *InsightCategorySpecificSummary

	// The description of the insight which includes alert criteria, remediation
	// recommendation, and additional resources (contains Markdown).
	Description *string

	// The ID of the insight.
	Id *string

	// An object containing more detail on the status of the insight resource.
	InsightStatus *InsightStatus

	// The Kubernetes minor version associated with an insight if applicable.
	KubernetesVersion *string

	// The time Amazon EKS last successfully completed a refresh of this insight check
	// on the cluster.
	LastRefreshTime *time.Time

	// The time the status of the insight last changed.
	LastTransitionTime *time.Time

	// The name of the insight.
	Name *string

	// A summary of how to remediate the finding of this insight if applicable.
	Recommendation *string

	// The details about each resource listed in the insight check result.
	Resources []InsightResourceDetail

	noSmithyDocumentSerde
}

// Summary information that relates to the category of the insight. Currently only
// returned with certain insights having category UPGRADE_READINESS .
type InsightCategorySpecificSummary struct {

	// A list of AddonCompatibilityDetail objects for Amazon EKS add-ons.
	AddonCompatibilityDetails []AddonCompatibilityDetail

	// The summary information about deprecated resource usage for an insight check in
	// the UPGRADE_READINESS category.
	DeprecationDetails []DeprecationDetail

	noSmithyDocumentSerde
}

// Returns information about the resource being evaluated.
type InsightResourceDetail struct {

	// The Amazon Resource Name (ARN) if applicable.
	Arn *string

	// An object containing more detail on the status of the insight resource.
	InsightStatus *InsightStatus

	// The Kubernetes resource URI if applicable.
	KubernetesResourceUri *string

	noSmithyDocumentSerde
}

// The criteria to use for the insights.
type InsightsFilter struct {

	// The categories to use to filter insights. The following lists the available
	// categories:
	//
	//   - UPGRADE_READINESS : Amazon EKS identifies issues that could impact your
	//   ability to upgrade to new versions of Kubernetes. These are called upgrade
	//   insights.
	//
	//   - MISCONFIGURATION : Amazon EKS identifies misconfiguration in your EKS Hybrid
	//   Nodes setup that could impair functionality of your cluster or workloads. These
	//   are called configuration insights.
	Categories []Category

	// The Kubernetes versions to use to filter the insights.
	KubernetesVersions []string

	// The statuses to use to filter the insights.
	Statuses []InsightStatusValue

	noSmithyDocumentSerde
}

// The status of the insight.
type InsightStatus struct {

	// Explanation on the reasoning for the status of the resource.
	Reason *string

	// The status of the resource.
	Status InsightStatusValue

	noSmithyDocumentSerde
}

// The summarized description of the insight.
type InsightSummary struct {

	// The category of the insight.
	Category Category

	// The description of the insight which includes alert criteria, remediation
	// recommendation, and additional resources (contains Markdown).
	Description *string

	// The ID of the insight.
	Id *string

	// An object containing more detail on the status of the insight.
	InsightStatus *InsightStatus

	// The Kubernetes minor version associated with an insight if applicable.
	KubernetesVersion *string

	// The time Amazon EKS last successfully completed a refresh of this insight check
	// on the cluster.
	LastRefreshTime *time.Time

	// The time the status of the insight last changed.
	LastTransitionTime *time.Time

	// The name of the insight.
	Name *string

	noSmithyDocumentSerde
}

// An object representing an issue with an Amazon EKS resource.
type Issue struct {

	// A brief description of the error.
	//
	//   - AccessDenied: Amazon EKS or one or more of your managed nodes is failing to
	//   authenticate or authorize with your Kubernetes cluster API server.
	//
	//   - AsgInstanceLaunchFailures: Your Auto Scaling group is experiencing failures
	//   while attempting to launch instances.
	//
	//   - AutoScalingGroupNotFound: We couldn't find the Auto Scaling group
	//   associated with the managed node group. You may be able to recreate an Auto
	//   Scaling group with the same settings to recover.
	//
	//   - ClusterUnreachable: Amazon EKS or one or more of your managed nodes is
	//   unable to to communicate with your Kubernetes cluster API server. This can
	//   happen if there are network disruptions or if API servers are timing out
	//   processing requests.
	//
	//   - Ec2InstanceTypeDoesNotExist: One or more of the supplied Amazon EC2
	//   instance types do not exist. Amazon EKS checked for the instance types that you
	//   provided in this Amazon Web Services Region, and one or more aren't available.
	//
	//   - Ec2LaunchTemplateNotFound: We couldn't find the Amazon EC2 launch template
	//   for your managed node group. You may be able to recreate a launch template with
	//   the same settings to recover.
	//
	//   - Ec2LaunchTemplateVersionMismatch: The Amazon EC2 launch template version
	//   for your managed node group does not match the version that Amazon EKS created.
	//   You may be able to revert to the version that Amazon EKS created to recover.
	//
	//   - Ec2SecurityGroupDeletionFailure: We could not delete the remote access
	//   security group for your managed node group. Remove any dependencies from the
	//   security group.
	//
	//   - Ec2SecurityGroupNotFound: We couldn't find the cluster security group for
	//   the cluster. You must recreate your cluster.
	//
	//   - Ec2SubnetInvalidConfiguration: One or more Amazon EC2 subnets specified for
	//   a node group do not automatically assign public IP addresses to instances
	//   launched into it. If you want your instances to be assigned a public IP address,
	//   then you need to enable the auto-assign public IP address setting for the
	//   subnet. See [Modifying the public IPv4 addressing attribute for your subnet]IPv4 in the Amazon VPC User Guide.
	//
	//   - IamInstanceProfileNotFound: We couldn't find the IAM instance profile for
	//   your managed node group. You may be able to recreate an instance profile with
	//   the same settings to recover.
	//
	//   - IamNodeRoleNotFound: We couldn't find the IAM role for your managed node
	//   group. You may be able to recreate an IAM role with the same settings to
	//   recover.
	//
	//   - InstanceLimitExceeded: Your Amazon Web Services account is unable to launch
	//   any more instances of the specified instance type. You may be able to request an
	//   Amazon EC2 instance limit increase to recover.
	//
	//   - InsufficientFreeAddresses: One or more of the subnets associated with your
	//   managed node group does not have enough available IP addresses for new nodes.
	//
	//   - InternalFailure: These errors are usually caused by an Amazon EKS
	//   server-side issue.
	//
	//   - NodeCreationFailure: Your launched instances are unable to register with
	//   your Amazon EKS cluster. Common causes of this failure are insufficient [node IAM role]
	//   permissions or lack of outbound internet access for the nodes.
	//
	// [Modifying the public IPv4 addressing attribute for your subnet]: https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html#subnet-public-ip
	// [node IAM role]: https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html
	Code NodegroupIssueCode

	// The error message associated with the issue.
	Message *string

	// The Amazon Web Services resources that are afflicted by this issue.
	ResourceIds []string

	noSmithyDocumentSerde
}

// The Kubernetes network configuration for the cluster.
type KubernetesNetworkConfigRequest struct {

	// Request to enable or disable the load balancing capability on your EKS Auto
	// Mode cluster. For more information, see EKS Auto Mode load balancing capability
	// in the Amazon EKS User Guide.
	ElasticLoadBalancing *ElasticLoadBalancing

	// Specify which IP family is used to assign Kubernetes pod and service IP
	// addresses. If you don't specify a value, ipv4 is used by default. You can only
	// specify an IP family when you create a cluster and can't change this value once
	// the cluster is created. If you specify ipv6 , the VPC and subnets that you
	// specify for cluster creation must have both IPv4 and IPv6 CIDR blocks assigned
	// to them. You can't specify ipv6 for clusters in China Regions.
	//
	// You can only specify ipv6 for 1.21 and later clusters that use version 1.10.1
	// or later of the Amazon VPC CNI add-on. If you specify ipv6 , then ensure that
	// your VPC meets the requirements listed in the considerations listed in [Assigning IPv6 addresses to pods and services]in the
	// Amazon EKS User Guide. Kubernetes assigns services IPv6 addresses from the
	// unique local address range (fc00::/7) . You can't specify a custom IPv6 CIDR
	// block. Pod addresses are assigned from the subnet's IPv6 CIDR.
	//
	// [Assigning IPv6 addresses to pods and services]: https://docs.aws.amazon.com/eks/latest/userguide/cni-ipv6.html
	IpFamily IpFamily

	// Don't specify a value if you select ipv6 for ipFamily. The CIDR block to assign
	// Kubernetes service IP addresses from. If you don't specify a block, Kubernetes
	// assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks.
	// We recommend that you specify a block that does not overlap with resources in
	// other networks that are peered or connected to your VPC. The block must meet the
	// following requirements:
	//
	//   - Within one of the following private IP address blocks: 10.0.0.0/8 ,
	//   172.16.0.0/12 , or 192.168.0.0/16 .
	//
	//   - Doesn't overlap with any CIDR block assigned to the VPC that you selected
	//   for VPC.
	//
	//   - Between /24 and /12 .
	//
	// You can only specify a custom CIDR block when you create a cluster. You can't
	// change this value after the cluster is created.
	ServiceIpv4Cidr *string

	noSmithyDocumentSerde
}

// The Kubernetes network configuration for the cluster. The response contains a
// value for serviceIpv6Cidr or serviceIpv4Cidr, but not both.
type KubernetesNetworkConfigResponse struct {

	// Indicates the current configuration of the load balancing capability on your
	// EKS Auto Mode cluster. For example, if the capability is enabled or disabled.
	ElasticLoadBalancing *ElasticLoadBalancing

	// The IP family used to assign Kubernetes Pod and Service objects IP addresses.
	// The IP family is always ipv4 , unless you have a 1.21 or later cluster running
	// version 1.10.1 or later of the Amazon VPC CNI plugin for Kubernetes and
	// specified ipv6 when you created the cluster.
	IpFamily IpFamily

	// The CIDR block that Kubernetes Pod and Service object IP addresses are assigned
	// from. Kubernetes assigns addresses from an IPv4 CIDR block assigned to a subnet
	// that the node is in. If you didn't specify a CIDR block when you created the
	// cluster, then Kubernetes assigns addresses from either the 10.100.0.0/16 or
	// 172.20.0.0/16 CIDR blocks. If this was specified, then it was specified when the
	// cluster was created and it can't be changed.
	ServiceIpv4Cidr *string

	// The CIDR block that Kubernetes pod and service IP addresses are assigned from
	// if you created a 1.21 or later cluster with version 1.10.1 or later of the
	// Amazon VPC CNI add-on and specified ipv6 for ipFamily when you created the
	// cluster. Kubernetes assigns service addresses from the unique local address
	// range ( fc00::/7 ) because you can't specify a custom IPv6 CIDR block when you
	// create the cluster.
	ServiceIpv6Cidr *string

	noSmithyDocumentSerde
}

// An object representing a node group launch template specification. The launch
// template can't include [SubnetId]SubnetId , [IamInstanceProfile]IamInstanceProfile , [RequestSpotInstances]RequestSpotInstances , [HibernationOptions]
// HibernationOptions , or [TerminateInstances]TerminateInstances , or the node group deployment or
// update will fail. For more information about launch templates, see [CreateLaunchTemplate]
// CreateLaunchTemplate in the Amazon EC2 API Reference. For more information about
// using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates]in the Amazon EKS User Guide.
//
// You must specify either the launch template ID or the launch template name in
// the request, but not both.
//
// [HibernationOptions]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_HibernationOptionsRequest.html
// [Customizing managed nodes with launch templates]: https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html
// [CreateLaunchTemplate]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html
// [RequestSpotInstances]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html
// [IamInstanceProfile]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html
// [SubnetId]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html
// [TerminateInstances]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TerminateInstances.html
type LaunchTemplateSpecification struct {

	// The ID of the launch template.
	//
	// You must specify either the launch template ID or the launch template name in
	// the request, but not both. After node group creation, you cannot use a different
	// ID.
	Id *string

	// The name of the launch template.
	//
	// You must specify either the launch template name or the launch template ID in
	// the request, but not both. After node group creation, you cannot use a different
	// name.
	Name *string

	// The version number of the launch template to use. If no version is specified,
	// then the template's default version is used. You can use a different version for
	// node group updates.
	Version *string

	noSmithyDocumentSerde
}

// An EKS Anywhere license associated with a subscription.
type License struct {

	// An id associated with an EKS Anywhere subscription license.
	Id *string

	// An optional license token that can be used for extended support verification.
	Token *string

	noSmithyDocumentSerde
}

// An object representing the logging configuration for resources in your cluster.
type Logging struct {

	// The cluster control plane logging configuration for your cluster.
	ClusterLogging []LogSetup

	noSmithyDocumentSerde
}

// An object representing the enabled or disabled Kubernetes control plane logs
// for your cluster.
type LogSetup struct {

	// If a log type is enabled, that log type exports its control plane logs to
	// CloudWatch Logs . If a log type isn't enabled, that log type doesn't export its
	// control plane logs. Each individual log type can be enabled or disabled
	// independently.
	Enabled *bool

	// The available cluster control plane log types.
	Types []LogType

	noSmithyDocumentSerde
}

// Information about an Amazon EKS add-on from the Amazon Web Services Marketplace.
type MarketplaceInformation struct {

	// The product ID from the Amazon Web Services Marketplace.
	ProductId *string

	// The product URL from the Amazon Web Services Marketplace.
	ProductUrl *string

	noSmithyDocumentSerde
}

// An object representing an Amazon EKS managed node group.
type Nodegroup struct {

	// If the node group was deployed using a launch template with a custom AMI, then
	// this is CUSTOM . For node groups that weren't deployed using a launch template,
	// this is the AMI type that was specified in the node group configuration.
	AmiType AMITypes

	// The capacity type of your managed node group.
	CapacityType CapacityTypes

	// The name of your cluster.
	ClusterName *string

	// The Unix epoch timestamp at object creation.
	CreatedAt *time.Time

	// If the node group wasn't deployed with a launch template, then this is the disk
	// size in the node group configuration. If the node group was deployed with a
	// launch template, then this is null .
	DiskSize *int32

	// The health status of the node group. If there are issues with your node group's
	// health, they are listed here.
	Health *NodegroupHealth

	// If the node group wasn't deployed with a launch template, then this is the
	// instance type that is associated with the node group. If the node group was
	// deployed with a launch template, then this is null .
	InstanceTypes []string

	// The Kubernetes labels applied to the nodes in the node group.
	//
	// Only labels that are applied with the Amazon EKS API are shown here. There may
	// be other Kubernetes labels applied to the nodes in this group.
	Labels map[string]string

	// If a launch template was used to create the node group, then this is the launch
	// template that was used.
	LaunchTemplate *LaunchTemplateSpecification

	// The Unix epoch timestamp for the last modification to the object.
	ModifiedAt *time.Time

	// The node auto repair configuration for the node group.
	NodeRepairConfig *NodeRepairConfig

	// The IAM role associated with your node group. The Amazon EKS node kubelet
	// daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive
	// permissions for these API calls through an IAM instance profile and associated
	// policies.
	NodeRole *string

	// The Amazon Resource Name (ARN) associated with the managed node group.
	NodegroupArn *string

	// The name associated with an Amazon EKS managed node group.
	NodegroupName *string

	// If the node group was deployed using a launch template with a custom AMI, then
	// this is the AMI ID that was specified in the launch template. For node groups
	// that weren't deployed using a launch template, this is the version of the Amazon
	// EKS optimized AMI that the node group was deployed with.
	ReleaseVersion *string

	// If the node group wasn't deployed with a launch template, then this is the
	// remote access configuration that is associated with the node group. If the node
	// group was deployed with a launch template, then this is null .
	RemoteAccess *RemoteAccessConfig

	// The resources associated with the node group, such as Auto Scaling groups and
	// security groups for remote access.
	Resources *NodegroupResources

	// The scaling configuration details for the Auto Scaling group that is associated
	// with your node group.
	ScalingConfig *NodegroupScalingConfig

	// The current status of the managed node group.
	Status NodegroupStatus

	// The subnets that were specified for the Auto Scaling group that is associated
	// with your node group.
	Subnets []string

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to any
	// other cluster or Amazon Web Services resources.
	Tags map[string]string

	// The Kubernetes taints to be applied to the nodes in the node group when they
	// are created. Effect is one of No_Schedule , Prefer_No_Schedule , or No_Execute .
	// Kubernetes taints can be used together with tolerations to control how workloads
	// are scheduled to your nodes. For more information, see [Node taints on managed node groups].
	//
	// [Node taints on managed node groups]: https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html
	Taints []Taint

	// The node group update configuration.
	UpdateConfig *NodegroupUpdateConfig

	// The Kubernetes version of the managed node group.
	Version *string

	noSmithyDocumentSerde
}

// An object representing the health status of the node group.
type NodegroupHealth struct {

	// Any issues that are associated with the node group.
	Issues []Issue

	noSmithyDocumentSerde
}

// An object representing the resources associated with the node group, such as
// Auto Scaling groups and security groups for remote access.
type NodegroupResources struct {

	// The Auto Scaling groups associated with the node group.
	AutoScalingGroups []AutoScalingGroup

	// The remote access security group associated with the node group. This security
	// group controls SSH access to the nodes.
	RemoteAccessSecurityGroup *string

	noSmithyDocumentSerde
}

// An object representing the scaling configuration details for the Auto Scaling
// group that is associated with your node group. When creating a node group, you
// must specify all or none of the properties. When updating a node group, you can
// specify any or none of the properties.
type NodegroupScalingConfig struct {

	// The current number of nodes that the managed node group should maintain.
	//
	// If you use the Kubernetes [Cluster Autoscaler], you shouldn't change the desiredSize value
	// directly, as this can cause the Cluster Autoscaler to suddenly scale up or scale
	// down.
	//
	// Whenever this parameter changes, the number of worker nodes in the node group
	// is updated to the specified size. If this parameter is given a value that is
	// smaller than the current number of running worker nodes, the necessary number of
	// worker nodes are terminated to match the given value.
	//
	// When using CloudFormation, no action occurs if you remove this parameter from
	// your CFN template.
	//
	// This parameter can be different from minSize in some cases, such as when
	// starting with extra hosts for testing. This parameter can also be different when
	// you want to start with an estimated number of needed hosts, but let the Cluster
	// Autoscaler reduce the number if there are too many. When the Cluster Autoscaler
	// is used, the desiredSize parameter is altered by the Cluster Autoscaler (but
	// can be out-of-date for short periods of time). the Cluster Autoscaler doesn't
	// scale a managed node group lower than minSize or higher than maxSize .
	//
	// [Cluster Autoscaler]: https://github.com/kubernetes/autoscaler#kubernetes-autoscaler
	DesiredSize *int32

	// The maximum number of nodes that the managed node group can scale out to. For
	// information about the maximum number that you can specify, see [Amazon EKS service quotas]in the Amazon
	// EKS User Guide.
	//
	// [Amazon EKS service quotas]: https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html
	MaxSize *int32

	// The minimum number of nodes that the managed node group can scale in to.
	MinSize *int32

	noSmithyDocumentSerde
}

// The node group update configuration. An Amazon EKS managed node group updates
// by replacing nodes with new nodes of newer AMI versions in parallel. You choose
// the maximum unavailable and the update strategy.
type NodegroupUpdateConfig struct {

	// The maximum number of nodes unavailable at once during a version update. Nodes
	// are updated in parallel. This value or maxUnavailablePercentage is required to
	// have a value.The maximum number is 100.
	MaxUnavailable *int32

	// The maximum percentage of nodes unavailable during a version update. This
	// percentage of nodes are updated in parallel, up to 100 nodes at once. This value
	// or maxUnavailable is required to have a value.
	MaxUnavailablePercentage *int32

	// The configuration for the behavior to follow during a node group version update
	// of this managed node group. You choose between two possible strategies for
	// replacing nodes during an [UpdateNodegroupVersion]UpdateNodegroupVersion action.
	//
	// An Amazon EKS managed node group updates by replacing nodes with new nodes of
	// newer AMI versions in parallel. The update strategy changes the managed node
	// update behavior of the managed node group for each quantity. The default
	// strategy has guardrails to protect you from misconfiguration and launches the
	// new instances first, before terminating the old instances. The minimal strategy
	// removes the guardrails and terminates the old instances before launching the new
	// instances. This minimal strategy is useful in scenarios where you are
	// constrained to resources or costs (for example, with hardware accelerators such
	// as GPUs).
	//
	// [UpdateNodegroupVersion]: https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateNodegroupVersion.html
	UpdateStrategy NodegroupUpdateStrategies

	noSmithyDocumentSerde
}

// The node auto repair configuration for the node group.
type NodeRepairConfig struct {

	// Specifies whether to enable node auto repair for the node group. Node auto
	// repair is disabled by default.
	Enabled *bool

	// Specify the maximum number of nodes that can be repaired concurrently or in
	// parallel, expressed as a count of unhealthy nodes. This gives you finer-grained
	// control over the pace of node replacements. When using this, you cannot also set
	// maxParallelNodesRepairedPercentage at the same time.
	MaxParallelNodesRepairedCount *int32

	// Specify the maximum number of nodes that can be repaired concurrently or in
	// parallel, expressed as a percentage of unhealthy nodes. This gives you
	// finer-grained control over the pace of node replacements. When using this, you
	// cannot also set maxParallelNodesRepairedCount at the same time.
	MaxParallelNodesRepairedPercentage *int32

	// Specify a count threshold of unhealthy nodes, above which node auto repair
	// actions will stop. When using this, you cannot also set
	// maxUnhealthyNodeThresholdPercentage at the same time.
	MaxUnhealthyNodeThresholdCount *int32

	// Specify a percentage threshold of unhealthy nodes, above which node auto repair
	// actions will stop. When using this, you cannot also set
	// maxUnhealthyNodeThresholdCount at the same time.
	MaxUnhealthyNodeThresholdPercentage *int32

	// Specify granular overrides for specific repair actions. These overrides control
	// the repair action and the repair delay time before a node is considered eligible
	// for repair. If you use this, you must specify all the values.
	NodeRepairConfigOverrides []NodeRepairConfigOverrides

	noSmithyDocumentSerde
}

// Specify granular overrides for specific repair actions. These overrides control
// the repair action and the repair delay time before a node is considered eligible
// for repair. If you use this, you must specify all the values.
type NodeRepairConfigOverrides struct {

	// Specify the minimum time in minutes to wait before attempting to repair a node
	// with this specific nodeMonitoringCondition and nodeUnhealthyReason .
	MinRepairWaitTimeMins *int32

	// Specify an unhealthy condition reported by the node monitoring agent that this
	// override would apply to.
	NodeMonitoringCondition *string

	// Specify a reason reported by the node monitoring agent that this override would
	// apply to.
	NodeUnhealthyReason *string

	// Specify the repair action to take for nodes when all of the specified
	// conditions are met.
	RepairAction RepairAction

	noSmithyDocumentSerde
}

// An object representing the [OpenID Connect] (OIDC) identity provider information for the
// cluster.
//
// [OpenID Connect]: https://openid.net/connect/
type OIDC struct {

	// The issuer URL for the OIDC identity provider.
	Issuer *string

	noSmithyDocumentSerde
}

// An object representing the configuration for an OpenID Connect (OIDC) identity
// provider.
type OidcIdentityProviderConfig struct {

	// This is also known as audience. The ID of the client application that makes
	// authentication requests to the OIDC identity provider.
	ClientId *string

	// The name of your cluster.
	ClusterName *string

	// The JSON web token (JWT) claim that the provider uses to return your groups.
	GroupsClaim *string

	// The prefix that is prepended to group claims to prevent clashes with existing
	// names (such as system: groups). For example, the value oidc: creates group
	// names like oidc:engineering and oidc:infra . The prefix can't contain system:
	GroupsPrefix *string

	// The ARN of the configuration.
	IdentityProviderConfigArn *string

	// The name of the configuration.
	IdentityProviderConfigName *string

	// The URL of the OIDC identity provider that allows the API server to discover
	// public signing keys for verifying tokens.
	IssuerUrl *string

	// The key-value pairs that describe required claims in the identity token. If
	// set, each claim is verified to be present in the token with a matching value.
	RequiredClaims map[string]string

	// The status of the OIDC identity provider.
	Status ConfigStatus

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to any
	// other cluster or Amazon Web Services resources.
	Tags map[string]string

	// The JSON Web token (JWT) claim that is used as the username.
	UsernameClaim *string

	// The prefix that is prepended to username claims to prevent clashes with
	// existing names. The prefix can't contain system:
	UsernamePrefix *string

	noSmithyDocumentSerde
}

// An object representing an OpenID Connect (OIDC) configuration. Before
// associating an OIDC identity provider to your cluster, review the considerations
// in [Authenticating users for your cluster from an OIDC identity provider]in the Amazon EKS User Guide.
//
// [Authenticating users for your cluster from an OIDC identity provider]: https://docs.aws.amazon.com/eks/latest/userguide/authenticate-oidc-identity-provider.html
type OidcIdentityProviderConfigRequest struct {

	// This is also known as audience. The ID for the client application that makes
	// authentication requests to the OIDC identity provider.
	//
	// This member is required.
	ClientId *string

	// The name of the OIDC provider configuration.
	//
	// This member is required.
	IdentityProviderConfigName *string

	// The URL of the OIDC identity provider that allows the API server to discover
	// public signing keys for verifying tokens. The URL must begin with https:// and
	// should correspond to the iss claim in the provider's OIDC ID tokens. Based on
	// the OIDC standard, path components are allowed but query parameters are not.
	// Typically the URL consists of only a hostname, like https://server.example.org
	// or https://example.com . This URL should point to the level below
	// .well-known/openid-configuration and must be publicly accessible over the
	// internet.
	//
	// This member is required.
	IssuerUrl *string

	// The JWT claim that the provider uses to return your groups.
	GroupsClaim *string

	// The prefix that is prepended to group claims to prevent clashes with existing
	// names (such as system: groups). For example, the value oidc: will create group
	// names like oidc:engineering and oidc:infra .
	GroupsPrefix *string

	// The key value pairs that describe required claims in the identity token. If
	// set, each claim is verified to be present in the token with a matching value.
	// For the maximum number of claims that you can require, see [Amazon EKS service quotas]in the Amazon EKS
	// User Guide.
	//
	// [Amazon EKS service quotas]: https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html
	RequiredClaims map[string]string

	// The JSON Web Token (JWT) claim to use as the username. The default is sub ,
	// which is expected to be a unique identifier of the end user. You can choose
	// other claims, such as email or name , depending on the OIDC identity provider.
	// Claims other than email are prefixed with the issuer URL to prevent naming
	// clashes with other plug-ins.
	UsernameClaim *string

	// The prefix that is prepended to username claims to prevent clashes with
	// existing names. If you do not provide this field, and username is a value other
	// than email , the prefix defaults to issuerurl# . You can use the value - to
	// disable all prefixing.
	UsernamePrefix *string

	noSmithyDocumentSerde
}

// The configuration of your local Amazon EKS cluster on an Amazon Web Services
// Outpost. Before creating a cluster on an Outpost, review [Creating a local cluster on an Outpost]in the Amazon EKS User
// Guide. This API isn't available for Amazon EKS clusters on the Amazon Web
// Services cloud.
//
// [Creating a local cluster on an Outpost]: https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-local-cluster-create.html
type OutpostConfigRequest struct {

	// The Amazon EC2 instance type that you want to use for your local Amazon EKS
	// cluster on Outposts. Choose an instance type based on the number of nodes that
	// your cluster will have. For more information, see [Capacity considerations]in the Amazon EKS User Guide.
	//
	// The instance type that you specify is used for all Kubernetes control plane
	// instances. The instance type can't be changed after cluster creation. The
	// control plane is not automatically scaled by Amazon EKS.
	//
	// [Capacity considerations]: https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html
	//
	// This member is required.
	ControlPlaneInstanceType *string

	// The ARN of the Outpost that you want to use for your local Amazon EKS cluster
	// on Outposts. Only a single Outpost ARN is supported.
	//
	// This member is required.
	OutpostArns []string

	// An object representing the placement configuration for all the control plane
	// instances of your local Amazon EKS cluster on an Amazon Web Services Outpost.
	// For more information, see [Capacity considerations]in the Amazon EKS User Guide.
	//
	// [Capacity considerations]: https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html
	ControlPlanePlacement *ControlPlanePlacementRequest

	noSmithyDocumentSerde
}

// An object representing the configuration of your local Amazon EKS cluster on an
// Amazon Web Services Outpost. This API isn't available for Amazon EKS clusters on
// the Amazon Web Services cloud.
type OutpostConfigResponse struct {

	// The Amazon EC2 instance type used for the control plane. The instance type is
	// the same for all control plane instances.
	//
	// This member is required.
	ControlPlaneInstanceType *string

	// The ARN of the Outpost that you specified for use with your local Amazon EKS
	// cluster on Outposts.
	//
	// This member is required.
	OutpostArns []string

	// An object representing the placement configuration for all the control plane
	// instances of your local Amazon EKS cluster on an Amazon Web Services Outpost.
	// For more information, see [Capacity considerations]in the Amazon EKS User Guide.
	//
	// [Capacity considerations]: https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html
	ControlPlanePlacement *ControlPlanePlacementResponse

	noSmithyDocumentSerde
}

// Amazon EKS Pod Identity associations provide the ability to manage credentials
// for your applications, similar to the way that Amazon EC2 instance profiles
// provide credentials to Amazon EC2 instances.
type PodIdentityAssociation struct {

	// The Amazon Resource Name (ARN) of the association.
	AssociationArn *string

	// The ID of the association.
	AssociationId *string

	// The name of the cluster that the association is in.
	ClusterName *string

	// The timestamp that the association was created at.
	CreatedAt *time.Time

	// The state of the automatic sessions tags. The value of true disables these tags.
	//
	// EKS Pod Identity adds a pre-defined set of session tags when it assumes the
	// role. You can use these tags to author a single role that can work across
	// resources by allowing access to Amazon Web Services resources based on matching
	// tags. By default, EKS Pod Identity attaches six tags, including tags for cluster
	// name, namespace, and service account name. For the list of tags added by EKS Pod
	// Identity, see [List of session tags added by EKS Pod Identity]in the Amazon EKS User Guide.
	//
	// [List of session tags added by EKS Pod Identity]: https://docs.aws.amazon.com/eks/latest/userguide/pod-id-abac.html#pod-id-abac-tags
	DisableSessionTags *bool

	// The unique identifier for this EKS Pod Identity association for a target IAM
	// role. You put this value in the trust policy of the target role, in a Condition
	// to match the sts.ExternalId . This ensures that the target role can only be
	// assumed by this association. This prevents the confused deputy problem. For more
	// information about the confused deputy problem, see [The confused deputy problem]in the IAM User Guide.
	//
	// If you want to use the same target role with multiple associations or other
	// roles, use independent statements in the trust policy to allow sts:AssumeRole
	// access from each role.
	//
	// [The confused deputy problem]: https://docs.aws.amazon.com/IAM/latest/UserGuide/confused-deputy.html
	ExternalId *string

	// The most recent timestamp that the association was modified at.
	ModifiedAt *time.Time

	// The name of the Kubernetes namespace inside the cluster to create the
	// association in. The service account and the Pods that use the service account
	// must be in this namespace.
	Namespace *string

	// If defined, the EKS Pod Identity association is owned by an Amazon EKS add-on.
	OwnerArn *string

	// An optional IAM policy in JSON format (as an escaped string) that applies
	// additional restrictions to this pod identity association beyond the IAM policies
	// attached to the IAM role. This policy is applied as the intersection of the
	// role's policies and this policy, allowing you to reduce the permissions that
	// applications in the pods can use. Use this policy to enforce least privilege
	// access while still leveraging a shared IAM role across multiple applications.
	Policy *string

	// The Amazon Resource Name (ARN) of the IAM role to associate with the service
	// account. The EKS Pod Identity agent manages credentials to assume this role for
	// applications in the containers in the Pods that use this service account.
	RoleArn *string

	// The name of the Kubernetes service account inside the cluster to associate the
	// IAM credentials with.
	ServiceAccount *string

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to any
	// other cluster or Amazon Web Services resources.
	//
	// The following basic restrictions apply to tags:
	//
	//   - Maximum number of tags per resource – 50
	//
	//   - For each resource, each tag key must be unique, and each tag key can have
	//   only one value.
	//
	//   - Maximum key length – 128 Unicode characters in UTF-8
	//
	//   - Maximum value length – 256 Unicode characters in UTF-8
	//
	//   - If your tagging schema is used across multiple services and resources,
	//   remember that other services may have restrictions on allowed characters.
	//   Generally allowed characters are: letters, numbers, and spaces representable in
	//   UTF-8, and the following characters: + - = . _ : / @.
	//
	//   - Tag keys and values are case-sensitive.
	//
	//   - Do not use aws: , AWS: , or any upper or lowercase combination of such as a
	//   prefix for either keys or values as it is reserved for Amazon Web Services use.
	//   You cannot edit or delete tag keys or values with this prefix. Tags with this
	//   prefix do not count against your tags per resource limit.
	Tags map[string]string

	// The Amazon Resource Name (ARN) of the target IAM role to associate with the
	// service account. This role is assumed by using the EKS Pod Identity association
	// role, then the credentials for this role are injected into the Pod.
	TargetRoleArn *string

	noSmithyDocumentSerde
}

// The summarized description of the association.
//
// Each summary is simplified by removing these fields compared to the full [PodIdentityAssociation]
// PodIdentityAssociation :
//
//   - The IAM role: roleArn
//
//   - The timestamp that the association was created at: createdAt
//
//   - The most recent timestamp that the association was modified at:. modifiedAt
//
//   - The tags on the association: tags
//
// [PodIdentityAssociation]: https://docs.aws.amazon.com/eks/latest/APIReference/API_PodIdentityAssociation.html
type PodIdentityAssociationSummary struct {

	// The Amazon Resource Name (ARN) of the association.
	AssociationArn *string

	// The ID of the association.
	AssociationId *string

	// The name of the cluster that the association is in.
	ClusterName *string

	// The name of the Kubernetes namespace inside the cluster to create the
	// association in. The service account and the Pods that use the service account
	// must be in this namespace.
	Namespace *string

	// If defined, the association is owned by an Amazon EKS add-on.
	OwnerArn *string

	// The name of the Kubernetes service account inside the cluster to associate the
	// IAM credentials with.
	ServiceAccount *string

	noSmithyDocumentSerde
}

// Identifies the Key Management Service (KMS) key used to encrypt the secrets.
type Provider struct {

	// Amazon Resource Name (ARN) or alias of the KMS key. The KMS key must be
	// symmetric and created in the same Amazon Web Services Region as the cluster. If
	// the KMS key was created in a different account, the [IAM principal]must have access to the KMS
	// key. For more information, see [Allowing users in other accounts to use a KMS key]in the Key Management Service Developer Guide.
	//
	// [IAM principal]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html
	// [Allowing users in other accounts to use a KMS key]: https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html
	KeyArn *string

	noSmithyDocumentSerde
}

// An object representing the remote access configuration for the managed node
// group.
type RemoteAccessConfig struct {

	// The Amazon EC2 SSH key name that provides access for SSH communication with the
	// nodes in the managed node group. For more information, see [Amazon EC2 key pairs and Linux instances]in the Amazon
	// Elastic Compute Cloud User Guide for Linux Instances. For Windows, an Amazon EC2
	// SSH key is used to obtain the RDP password. For more information, see [Amazon EC2 key pairs and Windows instances]in the
	// Amazon Elastic Compute Cloud User Guide for Windows Instances.
	//
	// [Amazon EC2 key pairs and Windows instances]: https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-key-pairs.html
	// [Amazon EC2 key pairs and Linux instances]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
	Ec2SshKey *string

	// The security group IDs that are allowed SSH access (port 22) to the nodes. For
	// Windows, the port is 3389. If you specify an Amazon EC2 SSH key but don't
	// specify a source security group when you create a managed node group, then the
	// port on the nodes is opened to the internet ( 0.0.0.0/0 ). For more information,
	// see [Security Groups for Your VPC]in the Amazon Virtual Private Cloud User Guide.
	//
	// [Security Groups for Your VPC]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html
	SourceSecurityGroups []string

	noSmithyDocumentSerde
}

// The configuration in the cluster for EKS Hybrid Nodes. You can add, change, or
// remove this configuration after the cluster is created.
type RemoteNetworkConfigRequest struct {

	// The list of network CIDRs that can contain hybrid nodes.
	//
	// These CIDR blocks define the expected IP address range of the hybrid nodes that
	// join the cluster. These blocks are typically determined by your network
	// administrator.
	//
	// Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for
	// example, 10.2.0.0/16 ).
	//
	// It must satisfy the following requirements:
	//
	//   - Each block must be within an IPv4 RFC-1918 network range. Minimum allowed
	//   size is /32, maximum allowed size is /8. Publicly-routable addresses aren't
	//   supported.
	//
	//   - Each block cannot overlap with the range of the VPC CIDR blocks for your
	//   EKS resources, or the block of the Kubernetes service IP range.
	//
	//   - Each block must have a route to the VPC that uses the VPC CIDR blocks, not
	//   public IPs or Elastic IPs. There are many options including Transit Gateway,
	//   Site-to-Site VPN, or Direct Connect.
	//
	//   - Each host must allow outbound connection to the EKS cluster control plane
	//   on TCP ports 443 and 10250 .
	//
	//   - Each host must allow inbound connection from the EKS cluster control plane
	//   on TCP port 10250 for logs, exec and port-forward operations.
	//
	//   - Each host must allow TCP and UDP network connectivity to and from other
	//   hosts that are running CoreDNS on UDP port 53 for service and pod DNS names.
	RemoteNodeNetworks []RemoteNodeNetwork

	// The list of network CIDRs that can contain pods that run Kubernetes webhooks on
	// hybrid nodes.
	//
	// These CIDR blocks are determined by configuring your Container Network
	// Interface (CNI) plugin. We recommend the Calico CNI or Cilium CNI. Note that the
	// Amazon VPC CNI plugin for Kubernetes isn't available for on-premises and edge
	// locations.
	//
	// Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for
	// example, 10.2.0.0/16 ).
	//
	// It must satisfy the following requirements:
	//
	//   - Each block must be within an IPv4 RFC-1918 network range. Minimum allowed
	//   size is /32, maximum allowed size is /8. Publicly-routable addresses aren't
	//   supported.
	//
	//   - Each block cannot overlap with the range of the VPC CIDR blocks for your
	//   EKS resources, or the block of the Kubernetes service IP range.
	RemotePodNetworks []RemotePodNetwork

	noSmithyDocumentSerde
}

// The configuration in the cluster for EKS Hybrid Nodes. You can add, change, or
// remove this configuration after the cluster is created.
type RemoteNetworkConfigResponse struct {

	// The list of network CIDRs that can contain hybrid nodes.
	RemoteNodeNetworks []RemoteNodeNetwork

	// The list of network CIDRs that can contain pods that run Kubernetes webhooks on
	// hybrid nodes.
	RemotePodNetworks []RemotePodNetwork

	noSmithyDocumentSerde
}

// A network CIDR that can contain hybrid nodes.
//
// These CIDR blocks define the expected IP address range of the hybrid nodes that
// join the cluster. These blocks are typically determined by your network
// administrator.
//
// Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for
// example, 10.2.0.0/16 ).
//
// It must satisfy the following requirements:
//
//   - Each block must be within an IPv4 RFC-1918 network range. Minimum allowed
//     size is /32, maximum allowed size is /8. Publicly-routable addresses aren't
//     supported.
//
//   - Each block cannot overlap with the range of the VPC CIDR blocks for your
//     EKS resources, or the block of the Kubernetes service IP range.
//
//   - Each block must have a route to the VPC that uses the VPC CIDR blocks, not
//     public IPs or Elastic IPs. There are many options including Transit Gateway,
//     Site-to-Site VPN, or Direct Connect.
//
//   - Each host must allow outbound connection to the EKS cluster control plane
//     on TCP ports 443 and 10250 .
//
//   - Each host must allow inbound connection from the EKS cluster control plane
//     on TCP port 10250 for logs, exec and port-forward operations.
//
//   - Each host must allow TCP and UDP network connectivity to and from other
//     hosts that are running CoreDNS on UDP port 53 for service and pod DNS names.
type RemoteNodeNetwork struct {

	// A network CIDR that can contain hybrid nodes.
	//
	// These CIDR blocks define the expected IP address range of the hybrid nodes that
	// join the cluster. These blocks are typically determined by your network
	// administrator.
	//
	// Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for
	// example, 10.2.0.0/16 ).
	//
	// It must satisfy the following requirements:
	//
	//   - Each block must be within an IPv4 RFC-1918 network range. Minimum allowed
	//   size is /32, maximum allowed size is /8. Publicly-routable addresses aren't
	//   supported.
	//
	//   - Each block cannot overlap with the range of the VPC CIDR blocks for your
	//   EKS resources, or the block of the Kubernetes service IP range.
	//
	//   - Each block must have a route to the VPC that uses the VPC CIDR blocks, not
	//   public IPs or Elastic IPs. There are many options including Transit Gateway,
	//   Site-to-Site VPN, or Direct Connect.
	//
	//   - Each host must allow outbound connection to the EKS cluster control plane
	//   on TCP ports 443 and 10250 .
	//
	//   - Each host must allow inbound connection from the EKS cluster control plane
	//   on TCP port 10250 for logs, exec and port-forward operations.
	//
	//   - Each host must allow TCP and UDP network connectivity to and from other
	//   hosts that are running CoreDNS on UDP port 53 for service and pod DNS names.
	Cidrs []string

	noSmithyDocumentSerde
}

// A network CIDR that can contain pods that run Kubernetes webhooks on hybrid
// nodes.
//
// These CIDR blocks are determined by configuring your Container Network
// Interface (CNI) plugin. We recommend the Calico CNI or Cilium CNI. Note that the
// Amazon VPC CNI plugin for Kubernetes isn't available for on-premises and edge
// locations.
//
// Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for
// example, 10.2.0.0/16 ).
//
// It must satisfy the following requirements:
//
//   - Each block must be within an IPv4 RFC-1918 network range. Minimum allowed
//     size is /32, maximum allowed size is /8. Publicly-routable addresses aren't
//     supported.
//
//   - Each block cannot overlap with the range of the VPC CIDR blocks for your
//     EKS resources, or the block of the Kubernetes service IP range.
type RemotePodNetwork struct {

	// A network CIDR that can contain pods that run Kubernetes webhooks on hybrid
	// nodes.
	//
	// These CIDR blocks are determined by configuring your Container Network
	// Interface (CNI) plugin. We recommend the Calico CNI or Cilium CNI. Note that the
	// Amazon VPC CNI plugin for Kubernetes isn't available for on-premises and edge
	// locations.
	//
	// Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for
	// example, 10.2.0.0/16 ).
	//
	// It must satisfy the following requirements:
	//
	//   - Each block must be within an IPv4 RFC-1918 network range. Minimum allowed
	//   size is /32, maximum allowed size is /8. Publicly-routable addresses aren't
	//   supported.
	//
	//   - Each block cannot overlap with the range of the VPC CIDR blocks for your
	//   EKS resources, or the block of the Kubernetes service IP range.
	Cidrs []string

	noSmithyDocumentSerde
}

// An IAM Identity CenterIAM; Identity Center identity (user or group) that can be
// assigned permissions in a capability.
type SsoIdentity struct {

	// The unique identifier of the IAM Identity CenterIAM; Identity Center user or
	// group.
	//
	// This member is required.
	Id *string

	// The type of identity. Valid values are SSO_USER or SSO_GROUP .
	//
	// This member is required.
	Type SsoIdentityType

	noSmithyDocumentSerde
}

// Request to update the configuration of the storage capability of your EKS Auto
// Mode cluster. For example, enable the capability. For more information, see EKS
// Auto Mode block storage capability in the Amazon EKS User Guide.
type StorageConfigRequest struct {

	// Request to configure EBS Block Storage settings for your EKS Auto Mode cluster.
	BlockStorage *BlockStorage

	noSmithyDocumentSerde
}

// Indicates the status of the request to update the block storage capability of
// your EKS Auto Mode cluster.
type StorageConfigResponse struct {

	// Indicates the current configuration of the block storage capability on your EKS
	// Auto Mode cluster. For example, if the capability is enabled or disabled.
	BlockStorage *BlockStorage

	noSmithyDocumentSerde
}

// A property that allows a node to repel a Pod . For more information, see [Node taints on managed node groups] in
// the Amazon EKS User Guide.
//
// [Node taints on managed node groups]: https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html
type Taint struct {

	// The effect of the taint.
	Effect TaintEffect

	// The key of the taint.
	Key *string

	// The value of the taint.
	Value *string

	noSmithyDocumentSerde
}

// An object representing an asynchronous update.
type Update struct {

	// The Unix epoch timestamp at object creation.
	CreatedAt *time.Time

	// Any errors associated with a Failed update.
	Errors []ErrorDetail

	// A UUID that is used to track the update.
	Id *string

	// A key-value map that contains the parameters associated with the update.
	Params []UpdateParam

	// The current status of the update.
	Status UpdateStatus

	// The type of the update.
	Type UpdateType

	noSmithyDocumentSerde
}

// The access configuration information for the cluster.
type UpdateAccessConfigRequest struct {

	// The desired authentication mode for the cluster.
	AuthenticationMode AuthenticationMode

	noSmithyDocumentSerde
}

// Configuration updates for an Argo CD capability. You only need to specify the
// fields you want to update.
type UpdateArgoCdConfig struct {

	// Updated network access configuration for the Argo CD capability's managed API
	// server endpoint. You can add or remove VPC endpoint associations to control
	// which VPCs have private access to the Argo CD server.
	NetworkAccess *ArgoCdNetworkAccessConfigRequest

	// Updated RBAC role mappings for the Argo CD capability. You can add, update, or
	// remove role mappings.
	RbacRoleMappings *UpdateRoleMappings

	noSmithyDocumentSerde
}

// Configuration updates for a capability. The structure varies depending on the
// capability type.
type UpdateCapabilityConfiguration struct {

	// Configuration updates specific to Argo CD capabilities.
	ArgoCd *UpdateArgoCdConfig

	noSmithyDocumentSerde
}

// An object representing a Kubernetes label change for a managed node group.
type UpdateLabelsPayload struct {

	// The Kubernetes labels to add or update.
	AddOrUpdateLabels map[string]string

	// The Kubernetes labels to remove.
	RemoveLabels []string

	noSmithyDocumentSerde
}

// An object representing the details of an update request.
type UpdateParam struct {

	// The keys associated with an update request.
	Type UpdateParamType

	// The value of the keys submitted as part of an update request.
	Value *string

	noSmithyDocumentSerde
}

// Updates to RBAC role mappings for an Argo CD capability. You can add, update,
// or remove role mappings in a single operation.
type UpdateRoleMappings struct {

	// A list of role mappings to add or update. If a mapping for the specified role
	// already exists, it will be updated with the new identities. If it doesn't exist,
	// a new mapping will be created.
	AddOrUpdateRoleMappings []ArgoCdRoleMapping

	// A list of role mappings to remove from the RBAC configuration. Each mapping
	// specifies an Argo CD role ( ADMIN , EDITOR , or VIEWER ) and the identities to
	// remove from that role.
	RemoveRoleMappings []ArgoCdRoleMapping

	noSmithyDocumentSerde
}

// An object representing the details of an update to a taints payload. For more
// information, see [Node taints on managed node groups]in the Amazon EKS User Guide.
//
// [Node taints on managed node groups]: https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html
type UpdateTaintsPayload struct {

	// Kubernetes taints to be added or updated.
	AddOrUpdateTaints []Taint

	// Kubernetes taints to remove.
	RemoveTaints []Taint

	noSmithyDocumentSerde
}

// The support policy to use for the cluster. Extended support allows you to
// remain on specific Kubernetes versions for longer. Clusters in extended support
// have higher costs. The default value is EXTENDED . Use STANDARD to disable
// extended support.
//
// [Learn more about EKS Extended Support in the Amazon EKS User Guide.]
//
// [Learn more about EKS Extended Support in the Amazon EKS User Guide.]: https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html
type UpgradePolicyRequest struct {

	// If the cluster is set to EXTENDED , it will enter extended support at the end of
	// standard support. If the cluster is set to STANDARD , it will be automatically
	// upgraded at the end of standard support.
	//
	// [Learn more about EKS Extended Support in the Amazon EKS User Guide.]
	//
	// [Learn more about EKS Extended Support in the Amazon EKS User Guide.]: https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html
	SupportType SupportType

	noSmithyDocumentSerde
}

// This value indicates if extended support is enabled or disabled for the cluster.
//
// [Learn more about EKS Extended Support in the Amazon EKS User Guide.]
//
// [Learn more about EKS Extended Support in the Amazon EKS User Guide.]: https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html
type UpgradePolicyResponse struct {

	// If the cluster is set to EXTENDED , it will enter extended support at the end of
	// standard support. If the cluster is set to STANDARD , it will be automatically
	// upgraded at the end of standard support.
	//
	// [Learn more about EKS Extended Support in the Amazon EKS User Guide.]
	//
	// [Learn more about EKS Extended Support in the Amazon EKS User Guide.]: https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html
	SupportType SupportType

	noSmithyDocumentSerde
}

// An object representing the VPC configuration to use for an Amazon EKS cluster.
type VpcConfigRequest struct {

	// Set this value to true to enable private access for your cluster's Kubernetes
	// API server endpoint. If you enable private access, Kubernetes API requests from
	// within your cluster's VPC use the private VPC endpoint. The default value for
	// this parameter is false , which disables private access for your Kubernetes API
	// server. If you disable private access and you have nodes or Fargate pods in the
	// cluster, then ensure that publicAccessCidrs includes the necessary CIDR blocks
	// for communication with the nodes or Fargate pods. For more information, see [Cluster API server endpoint]in
	// the Amazon EKS User Guide .
	//
	// [Cluster API server endpoint]: https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html
	EndpointPrivateAccess *bool

	// Set this value to false to disable public access to your cluster's Kubernetes
	// API server endpoint. If you disable public access, your cluster's Kubernetes API
	// server can only receive requests from within the cluster VPC. The default value
	// for this parameter is true , which enables public access for your Kubernetes API
	// server. The endpoint domain name and IP address family depends on the value of
	// the ipFamily for the cluster. For more information, see [Cluster API server endpoint] in the Amazon EKS User
	// Guide .
	//
	// [Cluster API server endpoint]: https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html
	EndpointPublicAccess *bool

	// The CIDR blocks that are allowed access to your cluster's public Kubernetes API
	// server endpoint. Communication to the endpoint from addresses outside of the
	// CIDR blocks that you specify is denied. The default value is 0.0.0.0/0 and
	// additionally ::/0 for dual-stack `IPv6` clusters. If you've disabled private
	// endpoint access, make sure that you specify the necessary CIDR blocks for every
	// node and Fargate Pod in the cluster. For more information, see [Cluster API server endpoint] in the Amazon
	// EKS User Guide .
	//
	// Note that the public endpoints are dual-stack for only IPv6 clusters that are
	// made after October 2024. You can't add IPv6 CIDR blocks to IPv4 clusters or IPv6
	// clusters that were made before October 2024.
	//
	// [Cluster API server endpoint]: https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html
	PublicAccessCidrs []string

	// Specify one or more security groups for the cross-account elastic network
	// interfaces that Amazon EKS creates to use that allow communication between your
	// nodes and the Kubernetes control plane. If you don't specify any security
	// groups, then familiarize yourself with the difference between Amazon EKS
	// defaults for clusters deployed with Kubernetes. For more information, see [Amazon EKS security group considerations]in
	// the Amazon EKS User Guide .
	//
	// [Amazon EKS security group considerations]: https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html
	SecurityGroupIds []string

	// Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account
	// elastic network interfaces in these subnets to allow communication between your
	// nodes and the Kubernetes control plane.
	SubnetIds []string

	noSmithyDocumentSerde
}

// An object representing an Amazon EKS cluster VPC configuration response.
type VpcConfigResponse struct {

	// The cluster security group that was created by Amazon EKS for the cluster.
	// Managed node groups use this security group for control-plane-to-data-plane
	// communication.
	ClusterSecurityGroupId *string

	// This parameter indicates whether the Amazon EKS private API server endpoint is
	// enabled. If the Amazon EKS private API server endpoint is enabled, Kubernetes
	// API requests that originate from within your cluster's VPC use the private VPC
	// endpoint instead of traversing the internet. If this value is disabled and you
	// have nodes or Fargate pods in the cluster, then ensure that publicAccessCidrs
	// includes the necessary CIDR blocks for communication with the nodes or Fargate
	// pods. For more information, see [Cluster API server endpoint]in the Amazon EKS User Guide .
	//
	// [Cluster API server endpoint]: https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html
	EndpointPrivateAccess bool

	// Whether the public API server endpoint is enabled.
	EndpointPublicAccess bool

	// The CIDR blocks that are allowed access to your cluster's public Kubernetes API
	// server endpoint. Communication to the endpoint from addresses outside of the
	// CIDR blocks that you specify is denied. The default value is 0.0.0.0/0 and
	// additionally ::/0 for dual-stack `IPv6` clusters. If you've disabled private
	// endpoint access, make sure that you specify the necessary CIDR blocks for every
	// node and Fargate Pod in the cluster. For more information, see [Cluster API server endpoint] in the Amazon
	// EKS User Guide .
	//
	// Note that the public endpoints are dual-stack for only IPv6 clusters that are
	// made after October 2024. You can't add IPv6 CIDR blocks to IPv4 clusters or IPv6
	// clusters that were made before October 2024.
	//
	// [Cluster API server endpoint]: https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html
	PublicAccessCidrs []string

	// The security groups associated with the cross-account elastic network
	// interfaces that are used to allow communication between your nodes and the
	// Kubernetes control plane.
	SecurityGroupIds []string

	// The subnets associated with your cluster.
	SubnetIds []string

	// The VPC associated with your cluster.
	VpcId *string

	noSmithyDocumentSerde
}

// The configuration for zonal shift for the cluster.
type ZonalShiftConfigRequest struct {

	// If zonal shift is enabled, Amazon Web Services configures zonal autoshift for
	// the cluster.
	Enabled *bool

	noSmithyDocumentSerde
}

// The status of zonal shift configuration for the cluster
type ZonalShiftConfigResponse struct {

	// Whether the zonal shift is enabled.
	Enabled *bool

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
